/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.imp.utilidades.Formatear;
import es.aeat.pftw.mtrc.imp.utilidades.Validaciones;
import java.io.Serializable;
import java.math.BigDecimal;

public final class ValidacionesGUIExtra
implements Serializable {
    private static final long serialVersionUID = -6155044060294297293L;
    public static final int CTE_CORRECTO = 0;
    public static final int CTE_ERROR_CHRS_NO_VALIDOS = 1;
    public static final int CTE_LONGITUD_INCORRECTA = 2;
    private static ValidacionesGUIExtra instanciaValidacionesGUIExtra = null;

    private ValidacionesGUIExtra() {
    }

    public static ValidacionesGUIExtra getValidaciones() {
        if (instanciaValidacionesGUIExtra == null) {
            instanciaValidacionesGUIExtra = new ValidacionesGUIExtra();
        }
        return instanciaValidacionesGUIExtra;
    }

    public int validarCampoAlfabetico(String string, int n) throws ExceptionMotor {
        try {
            if (n < string.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esAlfabeticoAEAT(string)) {
                return 1;
            }
            if (Validaciones.getValidaciones().cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(string)) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int validarCampoAlfanum\u00e9rico(String string, int n) throws ExceptionMotor {
        try {
            if (n < string.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esAlfanumericaAEAT(string)) {
                return 1;
            }
            if (Validaciones.getValidaciones().cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(string)) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int validarCampoTelefonoEuropeo(String string, int n) throws ExceptionMotor {
        try {
            if (n < string.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esTelefonoEuropeo(string)) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int validarCampoCadNum(String string, int n) throws ExceptionMotor {
        try {
            if (n < string.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esNumerica(string)) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int validarCampoCadNum2(String string, int n) throws ExceptionMotor {
        try {
            if (n < string.length()) {
                return 2;
            }
            if (!Validaciones.getValidaciones().esNumerica(string) && string.trim().length() > 0) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int validarCampoEmail(String string, int n) throws ExceptionMotor {
        try {
            if (n < string.length()) {
                return 2;
            }
            if (string.trim().length() > 0 && string.startsWith(" ")) {
                return 1;
            }
            char[] cArray = string.toUpperCase().toCharArray();
            for (int i = 0; i < string.length(); ++i) {
                if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._@\u00d1\u00c7\u00b4\\:;&/()'".indexOf(cArray[i]) != -1) continue;
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int validarCampoLogico(String string) throws ExceptionMotor {
        try {
            if (string.trim().length() > 0 && !string.equalsIgnoreCase("TRUE") && !string.equalsIgnoreCase("FALSE")) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int validarCampoFecha(String string) throws ExceptionMotor {
        try {
            int n = 10;
            if (string.trim().length() > 0) {
                if (n != string.length()) {
                    return 2;
                }
                if (string.charAt(2) != '-' && string.charAt(2) != '/') {
                    return 1;
                }
                if (string.charAt(5) != '-' && string.charAt(5) != '/') {
                    return 1;
                }
                if (string.charAt(2) != string.charAt(5)) {
                    return 1;
                }
                if (!Validaciones.getValidaciones().esNumerica(string.substring(0, 2) + string.substring(3, 5) + string.substring(6, 10))) {
                    return 1;
                }
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int validarCampoEntero(String string, int n) throws ExceptionMotor {
        try {
            if (string.length() == 0) {
                return 0;
            }
            try {
                new Integer(string).intValue();
            }
            catch (Exception exception) {
                return 1;
            }
            if (string.startsWith("-")) {
                string = string.substring(1);
            }
            if (n < string.length()) {
                return 2;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int validarCampoDoble(String string, int n, int n2) throws ExceptionMotor {
        try {
            int n3;
            if (string.length() == 0) {
                return 0;
            }
            try {
                new BigDecimal(string);
            }
            catch (Exception exception) {
                return 1;
            }
            if (string.toUpperCase().contains("E")) {
                string = Formatear.getFormatear().doubleToString(string);
            }
            if (string.startsWith("-")) {
                string = string.substring(1);
            }
            if ((n3 = string.indexOf(44)) == -1) {
                n3 = string.indexOf(46);
            }
            int n4 = 0;
            int n5 = 0;
            if (n3 == -1) {
                n4 = string.length();
            } else {
                n4 = n3;
                n5 = string.length() - n3 - 1;
            }
            if (n < n4 || n2 < n5) {
                return 2;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

