/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.utilidades.IValidaciones;
import java.io.Serializable;

public final class Validaciones
implements Serializable,
IValidaciones {
    private static final long serialVersionUID = 8781787392591660208L;
    private static IValidaciones instanciaValidaciones = null;

    private Validaciones() {
    }

    public static IValidaciones getValidaciones() {
        if (instanciaValidaciones == null) {
            instanciaValidaciones = new Validaciones();
        }
        return instanciaValidaciones;
    }

    private boolean ascii65a90(char c) {
        return (byte)c >= 65 && (byte)c <= 90;
    }

    private boolean ascii48a57(char c) {
        return (byte)c >= 48 && (byte)c <= 57;
    }

    @Override
    public boolean esNumerica(char c) {
        return this.ascii48a57(c);
    }

    @Override
    public boolean esAlfabetico(char c) {
        return this.ascii65a90(c);
    }

    @Override
    public boolean esAlfabeticoAEAT(char c) {
        try {
            if (this.esAlfabetico(c)) {
                return true;
            }
            if (c == '\u00d1') {
                return true;
            }
            if (c == '\u00c7') {
                return true;
            }
            if (c == '-') {
                return true;
            }
            if (c == ' ') {
                return true;
            }
            if (c == '\'') {
                return true;
            }
            if (c == '.') {
                return true;
            }
            if (c == ',') {
                return true;
            }
            if (c == ':') {
                return true;
            }
            if (c == '_') {
                return true;
            }
            if (c == '(') {
                return true;
            }
            return c == ')';
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(String string) {
        String string2 = string;
        try {
            if (string2.trim().length() > 0 && string2.startsWith(" ")) {
                return true;
            }
            return (string2 = string2.trim()).indexOf("  ") > -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esNumerica(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (this.esNumerica(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean esAlfabetico(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.esAlfabetico(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean esAlfabeticoAEAT(String string) {
        try {
            for (int i = 0; i < string.length(); ++i) {
                if (this.esAlfabeticoAEAT(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esTelefonoEuropeo(String string) {
        try {
            for (int i = 0; i < string.length(); ++i) {
                if (this.esNumerica(string.charAt(i)) || string.charAt(i) == '+' || string.charAt(i) == '-') continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esAlfanumericaAEAT(String string) {
        try {
            for (int i = 0; i < string.length(); ++i) {
                if (this.esAlfanumericaAEAT(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esAlfanumericaAEAT(char c) {
        try {
            if (this.esAlfabeticoAEAT(c)) {
                return true;
            }
            if (this.esNumerica(c)) {
                return true;
            }
            if (c == ':') {
                return true;
            }
            if (c == ';') {
                return true;
            }
            if (c == '_') {
                return true;
            }
            if (c == '&') {
                return true;
            }
            return c == '/';
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esNumericaAEAT(String string) {
        try {
            if (!this.esnumericaConSignoAEAT(string)) {
                return false;
            }
            Double d = new Double(string);
            return d >= 0.0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esnumericaConSignoAEAT(String string) {
        try {
            Double.valueOf(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esLetraONumeroAEAT(char c) {
        try {
            if (this.esAlfabetico(c)) {
                return true;
            }
            return this.esNumerica(c);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

