/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.imp.utilidades.BufferedReaderEx;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;

public final class LectorFicherosPlanos
implements Serializable {
    private static final long serialVersionUID = -9083357980799776570L;
    private String nombreFichero = "";
    private boolean ficheroAbierto = false;
    private boolean eof = false;
    private boolean leercllf = false;
    private FileInputStream fis = null;
    private DataInputStream dis = null;
    private BufferedReaderEx brd = null;
    private int numLinea = 0;

    public LectorFicherosPlanos() {
    }

    public LectorFicherosPlanos(String string) {
        this.nombreFichero = string;
    }

    public boolean abrirFichero() throws ExceptionMotor {
        try {
            if (this.ficheroAbierto) {
                throw new ExceptionMotor("Ya existe un fichero abierto cierrelo primero");
            }
            if (this.nombreFichero.length() == 0) {
                throw new ExceptionMotor("Indique que fichero hay que abrir");
            }
            this.fis = new FileInputStream(new File(this.nombreFichero));
            this.dis = new DataInputStream(this.fis);
            this.brd = new BufferedReaderEx(new InputStreamReader((InputStream)this.dis, Charset.forName("ISO-8859-1")));
            this.ficheroAbierto = true;
            this.eof = false;
            this.numLinea = 0;
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean abrirFichero(String string) throws ExceptionMotor {
        try {
            if (this.ficheroAbierto) {
                throw new ExceptionMotor("Ya existe un fichero abierto cierrelo primero");
            }
            this.nombreFichero = string;
            return this.abrirFichero();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean cerrarFichero() throws ExceptionMotor {
        try {
            if (!this.ficheroAbierto) {
                throw new ExceptionMotor("No hay ningun fichero abierto");
            }
            this.brd.close();
            this.dis.close();
            this.fis.close();
            this.brd = null;
            this.dis = null;
            this.fis = null;
            this.ficheroAbierto = false;
            this.numLinea = 0;
            this.eof = false;
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw (ExceptionMotor)exception;
        }
    }

    public int getLineaFichero() {
        return this.numLinea;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public boolean getleercllf() {
        return this.leercllf;
    }

    public void setleercllf(boolean bl) {
        this.leercllf = bl;
        if (this.brd != null) {
            this.brd.setIncludeCrLf(this.leercllf);
        }
    }

    public String lineaSiguiente() throws ExceptionMotor, IOException {
        if (!this.ficheroAbierto) {
            throw new ExceptionMotor("No hay ningun fichero abierto");
        }
        if (this.eof) {
            return null;
        }
        String string = null;
        String string2 = null;
        while ((string2 = this.brd.readLine()) != null) {
            if (string == null) {
                string = "";
            }
            string = string + string2;
            ++this.numLinea;
        }
        this.eof = true;
        return string;
    }

    public void setFileReader(FileInputStream fileInputStream) {
        this.fis = fileInputStream;
    }
}

