/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.xml.sax.InputSource;

public final class JarResources
implements Serializable {
    private static final long serialVersionUID = 9120992082983490053L;
    private boolean debugOn = false;
    private Map<String, Integer> htSizes = new Hashtable<String, Integer>();
    private Map<String, byte[]> htJarContents = new Hashtable<String, byte[]>();
    private String jarFileName;

    public JarResources(String string) {
        this.jarFileName = string;
        this.init();
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public byte[] getResource(String string) {
        return this.htJarContents.get(this.getResourceNameWithoutCase(string));
    }

    public InputStream getResourceInputStream(String string) {
        return new ByteArrayInputStream(this.getResource(this.getResourceNameWithoutCase(string)));
    }

    public InputSource getResourceInputSource(String string, String string2) {
        return new InputSource(new InputStreamReader(this.getResourceInputStream(this.getResourceNameWithoutCase(string)), Charset.forName("ISO-8859-1")));
    }

    public InputSource getResourceInputSource(String string) {
        return this.getResourceInputSource(this.getResourceNameWithoutCase(string), "ISO-8859-1");
    }

    public String getResourceNameWithoutCase(String string) {
        try {
            String string2 = "";
            Set<String> set = this.htJarContents.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                string2 = iterator.next().toString();
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private void init() {
        try {
            Object object;
            ZipFile zipFile = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                this.htSizes.put(((ZipEntry)object).getName(), (int)((ZipEntry)object).getSize());
            }
            zipFile.close();
            object = new FileInputStream(this.jarFileName);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                int n = (int)zipEntry.getSize();
                if (n == -1) {
                    n = this.htSizes.get(zipEntry.getName());
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n - n2 > 0 && (n3 = zipInputStream.read(byArray, n2, n - n2)) != -1) {
                    n2 += n3;
                }
                String string = zipEntry.getName();
                if (string.lastIndexOf(47) > -1) {
                    string = string.substring(string.lastIndexOf(47) + 1);
                }
                this.htJarContents.put(string, byArray);
            }
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {}
        }
        catch (NullPointerException nullPointerException) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso("JarResources::init : " + nullPointerException.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(fileNotFoundException);
        }
        catch (IOException iOException) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(iOException);
        }
        catch (Exception exception) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(exception);
        }
    }

    public void setDebugOn(boolean bl) {
        this.debugOn = bl;
    }

    public boolean isDebugOn() {
        return this.debugOn;
    }
}

