/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader
extends SecureClassLoader
implements Serializable {
    private static final long serialVersionUID = -1419754521147574760L;
    private final String jar;

    public JarClassLoader(ClassLoader classLoader, String string) {
        super(classLoader);
        this.jar = string;
    }

    @Override
    protected final Class<?> findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.startsWith(".") || string.indexOf("..") != -1 || string.endsWith(".")) {
                throw new ClassNotFoundException(string, classNotFoundException);
            }
            try {
                byte[] byArray = this.getClassBytes(string);
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string, iOException);
            }
        }
        return clazz;
    }

    private byte[] getClassBytes(String string) throws IOException {
        return this.getRecurso(string.replace('.', '/').concat(".class"));
    }

    private byte[] getRecurso(String string) throws IOException {
        JarFile jarFile = new JarFile(this.jar);
        JarEntry jarEntry = jarFile.getJarEntry(string);
        if (jarEntry == null) {
            jarFile.close();
            throw new IOException(string);
        }
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        byteArrayOutputStream.flush();
        inputStream.close();
        jarFile.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (uRL == null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(this.jar);
                JarEntry jarEntry = jarFile.getJarEntry(string);
                if (jarEntry != null) {
                    StringBuffer stringBuffer = new StringBuffer("jar:");
                    stringBuffer.append(new URL("file", "", this.jar).toExternalForm());
                    stringBuffer.append("!/");
                    stringBuffer.append(string);
                    uRL = new URL(stringBuffer.toString());
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return uRL;
    }

    @Override
    public final InputStream getResourceAsStream(String string) {
        byte[] byArray = null;
        try {
            byArray = this.getRecurso(string);
            return new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

