/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class JarBytesClassLoader
extends ClassLoader
implements Serializable {
    private static final long serialVersionUID = 7230133038271113042L;
    private static JarBytesClassLoader jarBytesClassLoader = new JarBytesClassLoader();
    private Map<String, byte[]> classesMap = new ConcurrentHashMap<String, byte[]>();

    private JarBytesClassLoader() {
    }

    public static JarBytesClassLoader getInstance() {
        return jarBytesClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJarBytes(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        ZipInputStream zipInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            zipInputStream = new JarInputStream(byteArrayInputStream);
            bufferedInputStream = new BufferedInputStream(zipInputStream);
            JarEntry jarEntry = null;
            while ((jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry()) != null) {
                String string;
                if (!jarEntry.isDirectory() && (string = jarEntry.getName()).toLowerCase().endsWith(".class")) {
                    String string2 = string.replaceAll("/", ".").substring(0, string.length() - 6);
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    BufferedOutputStream bufferedOutputStream = null;
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                        int n = -1;
                        while ((n = bufferedInputStream.read()) != -1) {
                            bufferedOutputStream.write(n);
                        }
                        bufferedOutputStream.flush();
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        this.classesMap.put(string2, byArray2);
                    }
                    finally {
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (bufferedOutputStream != null) {
                            try {
                                bufferedOutputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void reset() {
        JarBytesClassLoader.jarBytesClassLoader.classesMap.clear();
        jarBytesClassLoader = new JarBytesClassLoader();
    }

    @Override
    protected Class<?> findClass(String string) {
        byte[] byArray = this.loadClassData(string);
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    private byte[] loadClassData(String string) {
        return this.classesMap.get(string);
    }
}

