/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class HugeSerializer
implements Serializable {
    private static final long serialVersionUID = -8443653657043526982L;
    private ObjectOutputStream writer = null;
    private ObjectInputStream reader = null;
    private int contadorDescendente = 0;
    private int contadorAscendente = 0;
    private int indexFicheroActual = -1;
    private List<String> listaFicheros = new ArrayList<String>();
    private int maxFileRecords = 500;
    private int paginaActual = 0;

    public boolean setmaxFileRecords(int n) {
        if (this.listaFicheros.size() > 0 || n < 1) {
            return false;
        }
        this.maxFileRecords = n;
        return true;
    }

    public boolean guardaObjeto(Object object) throws ExceptionMotor {
        try {
            if (this.reader != null) {
                this.finalizaClase();
                this.inicializaClase();
            } else if (this.writer == null) {
                this.inicializaClase();
            }
            ++this.contadorDescendente;
            if (this.paginaActual * this.maxFileRecords < this.contadorDescendente) {
                this.newFile();
            }
            this.writer.writeObject(object);
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Object recuperaObjetoInverso() throws ExceptionMotor {
        try {
            if (this.listaFicheros.size() == 0) {
                throw new ExceptionMotor("No existen datos a recuperar");
            }
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            if (this.contadorDescendente == 0) {
                return null;
            }
            this.indexFicheroActual = (this.contadorDescendente - 1) / this.maxFileRecords;
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            File file = new File(this.listaFicheros.get(this.indexFicheroActual).toString());
            FileInputStream fileInputStream = new FileInputStream(file);
            file = null;
            this.reader = new ObjectInputStream(fileInputStream);
            fileInputStream = null;
            for (int i = 1; i < this.contadorDescendente - this.indexFicheroActual * this.maxFileRecords; ++i) {
                this.reader.readObject();
            }
            --this.contadorDescendente;
            return this.reader.readObject();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Object recuperaObjeto() throws ExceptionMotor {
        try {
            if (this.listaFicheros.size() == 0) {
                throw new ExceptionMotor("No existen datos a recuperar");
            }
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            if (this.contadorAscendente > this.contadorDescendente) {
                return null;
            }
            if (this.indexFicheroActual != this.contadorAscendente / this.maxFileRecords) {
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
                this.indexFicheroActual = this.contadorAscendente / this.maxFileRecords;
                File file = new File(this.listaFicheros.get(this.indexFicheroActual).toString());
                FileInputStream fileInputStream = new FileInputStream(file);
                file = null;
                this.reader = new ObjectInputStream(fileInputStream);
                fileInputStream = null;
            }
            ++this.contadorAscendente;
            return this.reader.readObject();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private boolean newFile() throws ExceptionMotor {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            File file = null;
            file = FuncionesUtiles.getFuncionesUtiles().creaArchivoTemporal("HSer", ".Tmp");
            this.listaFicheros.add(file.getPath());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.writer = new ObjectOutputStream(fileOutputStream);
            fileOutputStream = null;
            file = null;
            ++this.paginaActual;
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private boolean inicializaClase() throws ExceptionMotor {
        try {
            this.finalizaClase();
            this.contadorDescendente = 0;
            this.contadorAscendente = 0;
            this.indexFicheroActual = -1;
            this.paginaActual = 0;
            return this.newFile();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean finalizaClase() throws ExceptionMotor {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            for (int i = 0; i < this.listaFicheros.size(); ++i) {
                File file = new File(this.listaFicheros.get(i).toString());
                file.delete();
                file = null;
            }
            this.contadorDescendente = 0;
            this.contadorAscendente = 0;
            this.indexFicheroActual = -1;
            this.listaFicheros.clear();
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

