/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.utilidades.IGestorDatosAuxiliares;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.imp.utilidades.GestorDatosAuxiliaresGenerado;
import es.aeat.pftw.mtrc.imp.utilidades.GestorDatosBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GestorDatosXml
extends GestorDatosBase
implements IGestorDatosAuxiliares {
    private static final long serialVersionUID = 3311790594037020737L;
    private Map<String, List<ITipoDatosCampoValor>> coleccionGenerica = new HashMap<String, List<ITipoDatosCampoValor>>();
    private Map<String, List<ITipoDatosCampoValor>> coleccionEspecifica = new HashMap<String, List<ITipoDatosCampoValor>>();
    private List<ITipoDatosCampoValor> arrayListTemporal = null;
    protected IGestorDatosAuxiliares gestorDatosAuxiliaresGenerado = null;

    @Override
    public IGestorDatosAuxiliares getGestorDatosAuxiliaresGeneradoSinDependencias() {
        return this.gestorDatosAuxiliaresGenerado;
    }

    @Override
    public String getRegistro(String string, String string2) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> list = null;
            int n = 1;
            while (true) {
                switch (n) {
                    case 1: {
                        list = this.getColeccionEspecifica().get(string.toUpperCase());
                        break;
                    }
                    case 2: {
                        list = this.getColeccionGenerica().get(string.toUpperCase());
                        break;
                    }
                    default: {
                        return "";
                    }
                }
                if (list != null) {
                    int n2 = TipoDatosCampoValor.indiceListaContieneCampo(list, string2);
                    if (n2 != -1) {
                        return list.get(n2).getValor();
                    }
                    return "";
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccion(boolean bl) throws ExceptionMotor {
        try {
            if (this.getGestorDatosAuxiliaresGeneradoSinDependencias() != null) {
                if (bl) {
                    return ((GestorDatosAuxiliaresGenerado)this.getGestorDatosAuxiliaresGeneradoSinDependencias()).getColeccionGenerica();
                }
                return ((GestorDatosAuxiliaresGenerado)this.getGestorDatosAuxiliaresGeneradoSinDependencias()).getColeccionEspecifica();
            }
            if (bl) {
                return this.getColeccionGenerica();
            }
            return this.getColeccionGenerica();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    protected boolean cargarDocument(Document document, boolean bl) throws ExceptionMotor {
        try {
            int n;
            if (document == null) {
                boolean bl2 = false;
                return bl2;
            }
            Map<String, List<ITipoDatosCampoValor>> map = this.getColeccion(bl);
            NodeList nodeList = document.getChildNodes();
            NodeList nodeList2 = null;
            NodeList nodeList3 = null;
            NodeList nodeList4 = null;
            String string = "";
            String string2 = "";
            map.clear();
            nodeList = nodeList.item(0).getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                if (nodeList.item(n).getNodeType() != 1) continue;
                String string3 = nodeList.item(n).getNodeName().toUpperCase();
                if (nodeList.item(n).hasAttributes()) {
                    try {
                        string3 = nodeList.item(n).getAttributes().getNamedItem("id").getNodeValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.setArrayListTemporal(null);
                this.setArrayListTemporal(new ArrayList<ITipoDatosCampoValor>());
                nodeList2 = nodeList.item(n).getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    if (!nodeList2.item(i).getNodeName().equalsIgnoreCase("Entrada")) continue;
                    nodeList3 = nodeList2.item(i).getChildNodes();
                    for (int j = 0; j < nodeList3.getLength(); ++j) {
                        if (nodeList3.item(j).getNodeName().equalsIgnoreCase("Relacionada")) {
                            nodeList4 = nodeList3.item(j).getChildNodes();
                            for (int k = 0; k < nodeList4.getLength(); ++k) {
                                if (nodeList4.item(k).getNodeType() != 3) continue;
                                if (string.length() > 0) {
                                    string = string + ";";
                                }
                                string = string + nodeList4.item(k).getNodeValue();
                            }
                        }
                        if (string.length() != 0 || nodeList3.item(j).getNodeType() != 3) continue;
                        string = nodeList3.item(j).getNodeValue();
                    }
                    string2 = FuncionesUtiles.getFuncionesUtiles().dameValorAtributo(nodeList2.item(i).getAttributes(), "Clave");
                    this.getArrayListTemporal().add(new TipoDatosCampoValor(string2, string));
                    string = "";
                }
                map.put(string3, this.getArrayListTemporal());
            }
            n = 1;
            return n != 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTabla(String string, boolean bl) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> list = null;
            int n = 1;
            while (true) {
                switch (n) {
                    case 1: {
                        list = this.getColeccionEspecifica().get(string.toUpperCase());
                        break;
                    }
                    case 2: {
                        list = this.getColeccionGenerica().get(string.toUpperCase());
                        break;
                    }
                    default: {
                        return new ArrayList<ITipoDatosCampoValor>();
                    }
                }
                if (list != null) {
                    return list;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTabla(String string) throws ExceptionMotor {
        return this.getTabla(string, false);
    }

    @Override
    public Map<String, String> getTablaHashMap(String string) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> list = null;
            int n = 1;
            while (true) {
                switch (n) {
                    case 1: {
                        list = this.getColeccionEspecifica().get(string.toUpperCase());
                        break;
                    }
                    case 2: {
                        list = this.getColeccionGenerica().get(string.toUpperCase());
                        break;
                    }
                    default: {
                        return new HashMap<String, String>();
                    }
                }
                if (list != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (ITipoDatosCampoValor iTipoDatosCampoValor : list) {
                        hashMap.put(iTipoDatosCampoValor.getNombreCampo(), iTipoDatosCampoValor.getValor());
                    }
                    return hashMap;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTablaFiltrada(String string, String string2, String string3, boolean bl) throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosCampoValor> arrayList = new ArrayList<ITipoDatosCampoValor>();
            String[] stringArray = null;
            List<ITipoDatosCampoValor> list = null;
            int n = 1;
            while (true) {
                switch (n) {
                    case 1: {
                        list = this.getColeccionEspecifica().get("RELACION_" + string.toUpperCase() + "_" + string2.toUpperCase());
                        break;
                    }
                    case 2: {
                        list = this.getColeccionGenerica().get("RELACION_" + string.toUpperCase() + "_" + string2.toUpperCase());
                        break;
                    }
                    default: {
                        return new ArrayList<ITipoDatosCampoValor>();
                    }
                }
                if (list != null) {
                    int n2 = TipoDatosCampoValor.indiceListaContieneCampo(list, string3);
                    if (n2 != -1) {
                        stringArray = list.get(n2).getValor().split(";");
                        for (int i = 0; i < stringArray.length; ++i) {
                            arrayList.add(new TipoDatosCampoValor(stringArray[i], this.getRegistro(string2, stringArray[i])));
                        }
                        return arrayList;
                    }
                    return arrayList;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTablaFiltrada(String string, String string2, String string3) throws ExceptionMotor {
        return this.getTablaFiltrada(string, string2, string3, true);
    }

    protected void setColeccionGenerica(Map<String, List<ITipoDatosCampoValor>> map) {
        this.coleccionGenerica = map;
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccionGenerica() {
        return this.coleccionGenerica;
    }

    protected void setColeccionEspecifica(Map<String, List<ITipoDatosCampoValor>> map) {
        this.coleccionEspecifica = map;
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccionEspecifica() {
        return this.coleccionEspecifica;
    }

    protected void setArrayListTemporal(List<ITipoDatosCampoValor> list) {
        this.arrayListTemporal = list;
    }

    protected List<ITipoDatosCampoValor> getArrayListTemporal() {
        return this.arrayListTemporal;
    }

    @Override
    public void cargaFicheros(List<ITipoDatosCampoValor> list) throws ExceptionMotor {
    }
}

