/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.utilidades.IGestorDatosAuxiliares;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GestorDatosAuxiliaresGenerado
implements IGestorDatosAuxiliares,
Serializable {
    private static final long serialVersionUID = 7258903699781775592L;
    protected Map<String, List<ITipoDatosCampoValor>> coleccionGenerica = new HashMap<String, List<ITipoDatosCampoValor>>();
    protected Map<String, List<ITipoDatosCampoValor>> coleccionEspecifica = new HashMap<String, List<ITipoDatosCampoValor>>();
    protected List<ITipoDatosCampoValor> arrayListTemporal = null;

    protected void setColeccionGenerica(Map<String, List<ITipoDatosCampoValor>> map) {
        this.coleccionGenerica = map;
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccionGenerica() {
        return this.coleccionGenerica;
    }

    protected void setColeccionEspecifica(Map<String, List<ITipoDatosCampoValor>> map) {
        this.coleccionEspecifica = map;
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccionEspecifica() {
        return this.coleccionEspecifica;
    }

    protected void setArrayListTemporal(List<ITipoDatosCampoValor> list) {
        this.arrayListTemporal = list;
    }

    protected List<ITipoDatosCampoValor> getArrayListTemporal() {
        return this.arrayListTemporal;
    }

    @Override
    public IGestorDatosAuxiliares getGestorDatosAuxiliaresGeneradoSinDependencias() {
        return this;
    }

    @Override
    public String getRegistro(String string, String string2) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> list = null;
            int n = 1;
            while (true) {
                switch (n) {
                    case 1: {
                        list = this.getColeccionEspecifica().get(string.toUpperCase());
                        break;
                    }
                    case 2: {
                        list = this.getColeccionGenerica().get(string.toUpperCase());
                        break;
                    }
                    default: {
                        return "";
                    }
                }
                if (list != null) {
                    int n2 = TipoDatosCampoValor.indiceListaContieneCampo(list, string2);
                    if (n2 != -1) {
                        return list.get(n2).getValor();
                    }
                    return "";
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTabla(String string, boolean bl) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> list = null;
            int n = 1;
            while (true) {
                switch (n) {
                    case 1: {
                        list = this.getColeccionEspecifica().get(string.toUpperCase());
                        break;
                    }
                    case 2: {
                        list = this.getColeccionGenerica().get(string.toUpperCase());
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (list != null) {
                    return list;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTabla(String string) throws ExceptionMotor {
        return this.getTabla(string, false);
    }

    @Override
    public Map<String, String> getTablaHashMap(String string) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> list = null;
            int n = 1;
            while (true) {
                switch (n) {
                    case 1: {
                        list = this.getColeccionEspecifica().get(string.toUpperCase());
                        break;
                    }
                    case 2: {
                        list = this.getColeccionGenerica().get(string.toUpperCase());
                        break;
                    }
                    default: {
                        return new HashMap<String, String>();
                    }
                }
                if (list != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (ITipoDatosCampoValor iTipoDatosCampoValor : list) {
                        hashMap.put(iTipoDatosCampoValor.getNombreCampo(), iTipoDatosCampoValor.getValor());
                    }
                    return hashMap;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTablaFiltrada(String string, String string2, String string3, boolean bl) throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosCampoValor> arrayList = new ArrayList<ITipoDatosCampoValor>();
            String[] stringArray = null;
            List<ITipoDatosCampoValor> list = null;
            int n = 1;
            while (true) {
                switch (n) {
                    case 1: {
                        list = this.getColeccionEspecifica().get("RELACION_" + string.toUpperCase() + "_" + string2.toUpperCase());
                        break;
                    }
                    case 2: {
                        list = this.getColeccionGenerica().get("RELACION_" + string.toUpperCase() + "_" + string2.toUpperCase());
                        break;
                    }
                    default: {
                        return new ArrayList<ITipoDatosCampoValor>();
                    }
                }
                if (list != null) {
                    int n2 = TipoDatosCampoValor.indiceListaContieneCampo(list, string3);
                    if (n2 != -1) {
                        stringArray = list.get(n2).getValor().split(";");
                        for (int i = 0; i < stringArray.length; ++i) {
                            arrayList.add(new TipoDatosCampoValor(stringArray[i], this.getRegistro(string2, stringArray[i])));
                        }
                        return arrayList;
                    }
                    return arrayList;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTablaFiltrada(String string, String string2, String string3) throws ExceptionMotor {
        return this.getTablaFiltrada(string, string2, string3, true);
    }

    @Override
    public boolean setEntityManager(Object object) throws ExceptionMotor {
        return false;
    }

    @Override
    public void cargaFicheros(List<ITipoDatosCampoValor> list) throws ExceptionMotor {
    }
}

