/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.utilidades.IGeneradorDinamicoClases;
import es.aeat.pftw.mtrc.imp.motor.FactoriaMotor;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.imp.utilidades.LectorFicheroJar;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class GeneradorDinamicoClases
implements Serializable,
IGeneradorDinamicoClases {
    private static final long serialVersionUID = -3002879792243322387L;
    private String propiedad = "";
    private String rutaFicheroJar = "";
    private Properties propiedades;
    private transient ClassLoader cargadorAEmplear = null;

    public GeneradorDinamicoClases(String string) throws ExceptionMotor {
        this(string, null);
    }

    public GeneradorDinamicoClases(String string, ClassLoader classLoader) throws ExceptionMotor {
        try {
            this.rutaFicheroJar = string;
            this.cargadorAEmplear = classLoader;
            this.propiedades = new Properties();
            if (this.rutaFicheroJar.trim().length() > 0) {
                LectorFicheroJar lectorFicheroJar = new LectorFicheroJar(this.rutaFicheroJar);
                InputStream inputStream = lectorFicheroJar.getInputStream("Clases.properties");
                this.propiedades.load(inputStream);
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public GeneradorDinamicoClases(Properties properties) {
        this.propiedades = properties;
    }

    @Override
    public Object crearInstanciaClase(String string) throws ExceptionMotor {
        try {
            this.propiedad = string;
            String string2 = this.propiedades.getProperty(this.propiedad);
            return Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, this.propiedad);
        }
    }

    @Override
    public String getPropiedad() {
        return this.propiedad;
    }

    @Override
    public void setPropiedad(String string) {
        this.propiedad = string;
    }

    @Override
    public String getRutaFicheroJar() {
        return this.rutaFicheroJar;
    }

    @Override
    public void setRutaFicheroJar(String string) {
        this.rutaFicheroJar = string;
    }

    @Override
    public boolean setClassLoader(ClassLoader classLoader) {
        this.cargadorAEmplear = classLoader;
        return true;
    }

    @Override
    public Class<?>[] clasesConstructor(Class<?> clazz, Object[] objectArray) {
        try {
            Class<?>[] classArray = null;
            boolean bl = false;
            for (int i = 0; i < clazz.getConstructors().length; ++i) {
                classArray = clazz.getConstructors()[i].getParameterTypes();
                if (classArray.length != objectArray.length) continue;
                bl = true;
                for (int j = 0; j < classArray.length; ++j) {
                    if (objectArray[j] == null || FuncionesUtiles.getFuncionesUtiles().clasesIguales(objectArray[j].getClass(), classArray[j])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return classArray;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object loadClassFromJarFile(String string, Object[] objectArray, ClassLoader classLoader) {
        try {
            String string2;
            if (classLoader == null) {
                classLoader = FactoriaMotor.class.getClassLoader();
            }
            if ((string2 = this.rutaFicheroJar).length() == 0) {
                return null;
            }
            if (string2.indexOf("File:/") != 0) {
                string2 = "File:/" + string2;
            }
            ArrayList<URL> arrayList = new ArrayList<URL>();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("jar:");
            stringBuffer.append(string2);
            stringBuffer.append("!/");
            arrayList.add(new URL(stringBuffer.toString()));
            Object object = this.loadClassFromJarFile(string, objectArray, classLoader, arrayList);
            if (object != null) {
                return object;
            }
            File file = new File(this.rutaFicheroJar);
            if (file.exists()) {
                URL[] uRLArray = new URL[]{file.toURI().toURL()};
                return this.loadClassFromJarFile(string, objectArray, classLoader, uRLArray);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Object loadClassFromJarFile(String string, Object[] objectArray, ClassLoader classLoader, List<URL> list) {
        URL[] uRLArray = (URL[])Array.newInstance(URL.class, list.size());
        return this.loadClassFromJarFile(string, objectArray, classLoader, uRLArray);
    }

    protected Object loadClassFromJarFile(String string, Object[] objectArray, ClassLoader classLoader, URL[] uRLArray) {
        try {
            Object object;
            ClassLoader classLoader2 = this.cargadorAEmplear;
            URLClassLoader uRLClassLoader = null;
            if (this.cargadorAEmplear == null) {
                uRLClassLoader = classLoader == null ? URLClassLoader.newInstance(uRLArray) : URLClassLoader.newInstance(uRLArray, classLoader);
                object = null;
                try {
                    object = FuncionesUtiles.getFuncionesUtiles().getInstancia(uRLClassLoader.loadClass(string), objectArray);
                }
                catch (Exception exception) {
                    FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("Clase " + string + " : " + exception.toString());
                }
                if (object != null) {
                    FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("Clase " + string + " cargada");
                    uRLClassLoader = null;
                    return object;
                }
                classLoader2 = uRLClassLoader;
            }
            if (classLoader2 != null) {
                if (objectArray == null) {
                    return FuncionesUtiles.getFuncionesUtiles().getInstancia(Class.forName(string), null);
                }
                object = classLoader2.loadClass(string);
                Object object2 = FuncionesUtiles.getFuncionesUtiles().getInstancia((Class<?>)object, objectArray);
                if (object2 == null) {
                    throw new ExceptionMotor("El constructor de la clase " + string + " retorno nulo");
                }
                FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("Clase " + string + " cargada");
                return object2;
            }
            return null;
        }
        catch (Exception exception) {
            FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("Clase : " + string + " : " + exception.toString());
            return null;
        }
    }

    @Override
    public Object loadClassFromJarFile(String string, ClassLoader classLoader) {
        return this.loadClassFromJarFile(string, null, classLoader);
    }

    @Override
    public Object loadClassFromJarFile(String string, Object[] objectArray) {
        return this.loadClassFromJarFile(string, objectArray, null);
    }

    @Override
    public Object loadClassFromJarFile(String string) {
        try {
            return this.loadClassFromJarFile(string, null, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object loadClassFromPath(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<Object> ejecutaMetodoDeClase(Object object, String string, Class<?>[] classArray, Object[] objectArray) {
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(Boolean.TRUE);
            Class<?> clazz = object.getClass();
            Method method = clazz.getMethod(string, classArray);
            arrayList.add(method.invoke(object, objectArray));
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

