/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.IAop;
import es.aeat.pftw.mtrc.api.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import es.aeat.pftw.mtrc.api.configuracion.IRegError;
import es.aeat.pftw.mtrc.api.configuracion.IRegTabla;
import es.aeat.pftw.mtrc.api.configuracion.RegError;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.IEventosMensajes;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatoRetornoProceso;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampos;
import es.aeat.pftw.mtrc.api.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.utilidades.IFuncionesUtiles;
import es.aeat.pftw.mtrc.imp.configuracion.GestorConfiguracionLooper;
import es.aeat.pftw.mtrc.imp.digest.Sello;
import es.aeat.pftw.mtrc.imp.tipos.TipoDatoRetornoProceso;
import es.aeat.pftw.mtrc.imp.utilidades.ByteWriterAEAT;
import es.aeat.pftw.mtrc.imp.utilidades.LectorFicheroJar;
import es.aeat.pftw.mtrc.imp.utilidades.ObjectInputStreamAEAT;
import es.aeat.pftw.mtrc.imp.utilidades.StringAEAT;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class FuncionesUtiles
implements Serializable,
IFuncionesUtiles {
    private static final long serialVersionUID = 4441855377736090575L;
    private final String __OBFUSCATE = "OBFAEAT";
    private Map<String, Long> conjuntoDeContadoresMilisegundos = new HashMap<String, Long>();
    private PrintStream errAnterior = null;
    private PrintStream outAnterior = null;
    private boolean puedoRestaurar = false;
    private final String LITERAL_TERMINACION_FICHERO_TEMPORAL = "~tmp";
    public final int TAM_BUFFER_CADENA = 0x2000000;
    private List<IEventosMensajes> listenersEventosMensajes = null;
    private static FuncionesUtiles instanciaFuncionesUtiles = null;
    private static boolean aopInyectorAOPDisponible = true;

    private FuncionesUtiles() {
    }

    public static FuncionesUtiles getFuncionesUtiles() {
        if (instanciaFuncionesUtiles == null) {
            instanciaFuncionesUtiles = new FuncionesUtiles();
        }
        return instanciaFuncionesUtiles;
    }

    public static void dispose() {
        instanciaFuncionesUtiles = null;
    }

    @Override
    public String obtenerDirectorioBaseDeClase(Class<?> clazz) {
        try {
            String string = clazz.toString();
            string = string.substring(string.lastIndexOf(46) + 1) + ".class";
            String string2 = clazz.getResource(string).getPath();
            String string3 = System.getProperty("os.name").toUpperCase();
            if (string2.startsWith("file:")) {
                string2 = string2.substring(5);
                string2 = string2.substring(0, string2.lastIndexOf(33));
            }
            if (string3.contains("WINDOWS") && string2.contains(":")) {
                string2 = string2.substring(1);
            }
            string2 = string2.replaceAll("%20", " ");
            string2 = string2.substring(0, string2.lastIndexOf(47));
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyFile(InputStream inputStream, String string) {
        File file = null;
        try {
            file = new File(string);
            boolean bl = this.copyFile(inputStream, file);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyFile(String string, String string2) {
        File file = null;
        File file2 = null;
        FileInputStream fileInputStream = null;
        try {
            boolean bl = true;
            file = new File(string);
            file2 = new File(string2);
            fileInputStream = new FileInputStream(file);
            bl = this.copyFile((InputStream)fileInputStream, file2);
            fileInputStream.close();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            fileInputStream = null;
            file = null;
            file2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyFile(InputStream inputStream, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            byte[] byArray = new byte[1024];
            boolean bl = false;
            fileOutputStream = new FileOutputStream(file);
            while (!bl) {
                int n = inputStream.read(byArray);
                if (n != 1024) {
                    bl = true;
                }
                if (n != -1 && bl) {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    fileOutputStream.write(byArray2);
                    break;
                }
                if (n != 1024) continue;
                fileOutputStream.write(byArray);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
            }
            finally {
                fileOutputStream = null;
            }
        }
    }

    @Override
    public boolean fileExists(String string) {
        return this.ficheroExiste(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ficheroExiste(String string) {
        File file = null;
        try {
            file = new File(string);
            boolean bl = file.exists();
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            file = null;
        }
    }

    @Override
    public String obtenerRutaDirectorioFichero(String string) {
        try {
            File file = new File(string);
            if (file.isDirectory()) {
                return string + File.separatorChar;
            }
            File file2 = file.getParentFile();
            if (file2.isDirectory()) {
                return file2.getPath() + File.separatorChar;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean borraFichero(String string) {
        File file = null;
        try {
            file = new File(string);
            file.delete();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            file = null;
        }
    }

    @Override
    public boolean ficheroEscribible(String string) {
        try {
            return this.ficheroEscribible(string, 0);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ficheroEscribible(String string, int n) {
        File file = null;
        FileWriter fileWriter = null;
        try {
            file = new File(string);
            fileWriter = new FileWriter(file);
            if (n < 1) {
                fileWriter.write("Fichero Escribible");
            } else {
                String string2 = "";
                while (n > 0) {
                    string2 = string2 + "X";
                }
                fileWriter.write(string2);
            }
            fileWriter.close();
            file.delete();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            fileWriter = null;
            file = null;
        }
    }

    @Override
    public void inicializarContadorMilisegundos() {
        this.inicializarContadorMilisegundos("STANDARD");
    }

    @Override
    public void inicializarContadorMilisegundos(String string) {
        this.conjuntoDeContadoresMilisegundos.put(string.toUpperCase(), System.currentTimeMillis());
    }

    @Override
    public long mostrarContadorMilisegundos() {
        return this.mostrarContadorMilisegundos("STANDARD");
    }

    @Override
    public long mostrarContadorMilisegundos(String string) {
        return System.currentTimeMillis() - this.conjuntoDeContadoresMilisegundos.get(string.toUpperCase());
    }

    @Override
    public boolean redireccionaOutErrFichero(String string) {
        try {
            if (!this.puedoRestaurar) {
                this.errAnterior = System.err;
                this.outAnterior = System.out;
            }
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            System.setOut(printStream);
            System.setErr(printStream);
            this.puedoRestaurar = true;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean redireccionaOutErrRestaurar() {
        try {
            if (!this.puedoRestaurar) {
                return false;
            }
            System.setOut(this.outAnterior);
            System.setErr(this.errAnterior);
            this.puedoRestaurar = false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String mostrarContador(long l) {
        long l2 = l;
        try {
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            double d = 0.0;
            long l3 = 0L;
            string2 = String.valueOf(l2);
            if (string2.length() < "000".length()) {
                string2 = "000" + string2;
            }
            if ((l3 = Long.valueOf(string2.substring(string2.length() - 3)).longValue()) > 0L) {
                string3 = String.valueOf(l3).trim() + " Milisegundo";
                if (l3 > 1L) {
                    string3 = string3 + "s";
                }
            }
            l2 = string2.length() == 3 ? 0L : Long.valueOf(string2.substring(0, string2.length() - 3));
            string2 = String.valueOf(l2);
            d = l2 / 3600L;
            l3 = (long)d;
            if (l3 > 0L) {
                string6 = String.valueOf(l3).trim() + " Hora";
                if (l3 > 1L) {
                    string6 = string6 + "s";
                }
                l2 -= l3 * 3600L;
            } else {
                string6 = "";
            }
            d = l2 / 60L;
            l3 = (long)d;
            if (l3 > 0L) {
                string5 = String.valueOf(l3).trim() + " Minuto";
                if (l3 > 1L) {
                    string5 = string5 + "s";
                }
                l2 -= l3 * 60L;
            } else {
                string5 = "";
            }
            if (l2 > 0L) {
                string4 = String.valueOf(l2).trim() + " Segundo";
            }
            if (l2 > 1L) {
                string4 = string4 + "s";
            }
            if (string6.length() > 0) {
                string = string6;
            }
            if (string5.length() > 0) {
                string = string + " " + string5;
            }
            if (string4.length() > 0) {
                string = string + " " + string4;
            }
            if (string3.length() > 0) {
                string = string + " " + string3;
            }
            if (string.length() == 0) {
                string = "0 Milisegundos";
            } else if (string.charAt(0) == ' ') {
                string = string.substring(1);
            }
            return string;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return l2 + " milisegundos";
        }
    }

    @Override
    public String mostrarContador() {
        return this.mostrarContador("STANDARD");
    }

    @Override
    public String mostrarContador(String string) {
        try {
            long l = System.currentTimeMillis() - this.conjuntoDeContadoresMilisegundos.get(string.toUpperCase());
            return this.mostrarContador(l);
        }
        catch (Exception exception) {
            return "Desconocido por error " + exception.toString();
        }
    }

    @Override
    public List<ITablaMotorEntrada> hashMap2ArrayListTablaMotorEntrada(Map<String, ITablaMotorEntrada> map) {
        try {
            if (map == null) {
                return null;
            }
            ArrayList<ITablaMotorEntrada> arrayList = new ArrayList<ITablaMotorEntrada>();
            String string2 = null;
            Set<String> set = map.keySet();
            for (String string2 : set) {
                arrayList.add(map.get(string2));
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return null;
        }
    }

    @Override
    public List<String> hashMap2ArrayList(Map<String, String> map) {
        try {
            if (map == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = null;
            Set<String> set = map.keySet();
            for (String string2 : set) {
                arrayList.add(string2);
                arrayList.add(String.valueOf(map.get(string2)));
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return null;
        }
    }

    @Override
    public List<?> hashMap2List(Map<String, ?> map) {
        try {
            if (map == null) {
                return null;
            }
            ArrayList arrayList = new ArrayList();
            String string2 = null;
            Set<String> set = map.keySet();
            for (String string2 : set) {
                arrayList.add(map.get(string2));
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return null;
        }
    }

    public Object getClase(String string, ISesion iSesion) {
        try {
            Object object = null;
            try {
                object = Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object == null) {
                try {
                    object = Class.forName(string.replaceAll("\\.", "/")).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object == null && (object = iSesion.getModelo().getClaseGeneradorDinamicoClases().loadClassFromJarFile(string)) == null) {
                object = iSesion.getModelo().getClaseGeneradorDinamicoClases().loadClassFromJarFile(string.replaceAll("\\.", "/"));
            }
            if (object == null) {
                throw new ExceptionMotor("clase no encontrada");
            }
            return object;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return null;
        }
    }

    @Override
    public String sello(String string, char c) throws Exception {
        return this.selloPos(string, 237, c);
    }

    @Override
    public String selloPos(String string, int n, char c) throws Exception {
        int n2;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        byte[] byArray = new byte[5120];
        boolean bl = true;
        Sello sello = new Sello();
        if (n > 5120) {
            this.muestraAviso("AVISO: Revisar la funcion de selloPos, no esta sellando correctamente");
        }
        while ((n2 = randomAccessFile.read(byArray)) != -1) {
            if (bl) {
                for (int i = 0; i < 13; ++i) {
                    byArray[n + i] = 32;
                }
                bl = false;
            }
            sello.update(byArray, 0, n2);
        }
        randomAccessFile.seek(n);
        String string2 = sello.sellar();
        string2 = string2 + c;
        randomAccessFile.write(string2.getBytes());
        randomAccessFile.close();
        return string2;
    }

    @Override
    public String selloPos(byte[] byArray, int n, char c) throws Exception {
        for (int i = 0; i < 13; ++i) {
            byArray[n + i] = 32;
        }
        Sello sello = new Sello();
        sello.update(byArray, 0, byArray.length);
        String string = sello.sellar() + c;
        for (int i = 0; i < 13; ++i) {
            byArray[n + i] = string.getBytes()[i];
        }
        return string;
    }

    @Override
    public boolean compruebaSelloXML(String string) throws Exception {
        try {
            String string2;
            int n;
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            byte[] byArray = new byte[5120];
            Sello sello = new Sello();
            String string3 = "";
            int n2 = -1;
            int n3 = -1;
            while ((n = randomAccessFile.read(byArray)) != -1) {
                string2 = new String(byArray);
                n3 = string2.indexOf("Sello=\"");
                if (n3 > -1 && n2 == -1) {
                    n2 = n3;
                    string3 = string2.substring(n2 + "Sello=\"".length(), n2 + "Sello=\"".length() + 13);
                    for (int i = 0; i < 13; ++i) {
                        byArray[n2 + "Sello=\"".length() + i] = 32;
                    }
                }
                sello.update(byArray, 0, n);
            }
            randomAccessFile.seek(n2);
            string2 = sello.sellar();
            randomAccessFile.close();
            return string3.startsWith(string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean compruebaSello(String string) throws Exception {
        return this.compruebaSello(string, 237);
    }

    @Override
    public boolean compruebaSello(String string, int n) throws Exception {
        try {
            String[] stringArray = this.dameSello(string, n);
            return stringArray[0].startsWith(stringArray[1]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String[] dameSello(String string, int n) throws Exception {
        String string2;
        int n2;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        byte[] byArray = new byte[5120];
        if (n > 5120) {
            this.muestraAviso("AVISO: Revisar la funcion de compruebaSello, no esta sellando correctamente");
        }
        boolean bl = true;
        Sello sello = new Sello();
        String string3 = "";
        while ((n2 = randomAccessFile.read(byArray)) != -1) {
            string2 = new String(byArray);
            if (bl) {
                string3 = string2.substring(n, n + 13);
                for (int i = 0; i < 13; ++i) {
                    byArray[n + i] = 32;
                }
                bl = false;
            }
            sello.update(byArray, 0, n2);
        }
        randomAccessFile.seek(n);
        string2 = sello.sellar();
        randomAccessFile.close();
        return new String[]{string3, string2};
    }

    @Override
    public boolean compruebaSello(byte[] byArray) throws Exception {
        return this.compruebaSello(byArray, 237);
    }

    @Override
    public boolean compruebaSello(byte[] byArray, int n) throws Exception {
        try {
            String[] stringArray = this.dameSello(byArray, n);
            return stringArray[0].startsWith(stringArray[1]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String[] dameSello(byte[] byArray, int n) throws Exception {
        byte[] byArray2 = new byte[13];
        for (int i = 0; i < 13; ++i) {
            byArray2[i] = byArray[n + i];
            byArray[n + i] = 32;
        }
        Sello sello = new Sello();
        sello.update(byArray, 0, byArray.length);
        String string = sello.sellar();
        for (int i = 0; i < 13; ++i) {
            byArray[n + i] = byArray2[i];
        }
        return new String[]{new String(byArray2), string};
    }

    @Override
    public String calculaSelloSinPosicion(byte[] byArray) throws Exception {
        Sello sello = new Sello();
        sello.update(byArray, 0, byArray.length);
        return sello.sellar();
    }

    @Override
    public String codificaCadena(String string) {
        try {
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                char c;
                char c2 = c = string.charAt(i);
                string2 = string2.length() == 0 ? string2 + c2 : string2 + "-" + c2;
            }
            return string2;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return string;
        }
    }

    @Override
    public String desCodificaCadena(String string) {
        try {
            String string2 = "";
            String[] stringArray = string.split("-");
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                try {
                    n = Integer.valueOf(stringArray[i]);
                }
                catch (Exception exception) {
                    return string;
                }
                char c = (char)n;
                string2 = string2 + c;
            }
            if (string.indexOf("-") == -1 && (string2.charAt(0) < ' ' || string2.charAt(0) > '\u0080') && string2.charAt(0) != '\u00a4' && string2.charAt(0) != '\u00a5') {
                return string;
            }
            return string2;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return string;
        }
    }

    @Override
    public boolean esNumerico(String string) {
        try {
            new BigDecimal(string.trim());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String object2String(Object object) {
        try {
            return object.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void borraFicherosTemporalesExportacion(List<List<String>> list) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                List<String> list2 = list.get(i);
                for (int j = 0; j < list2.size(); ++j) {
                    if (list2.get(j) == null || list2.get(j).toString().length() <= 0 || !this.ficheroExiste(list2.get(j).toString())) continue;
                    this.borraFichero(list2.get(j).toString());
                }
            }
        }
        catch (Exception exception) {
            this.muestraError(exception);
        }
    }

    @Override
    public List<ITipoDatosCampos> concatenaArrayList(List<ITipoDatosCampos> list, List<ITipoDatosCampos> list2) {
        try {
            int n;
            ArrayList<ITipoDatosCampos> arrayList = new ArrayList<ITipoDatosCampos>();
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    arrayList.add(list.get(n));
                }
            }
            if (list2 != null) {
                for (n = 0; n < list2.size(); ++n) {
                    arrayList.add(list2.get(n));
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return null;
        }
    }

    @Override
    public void concatenaArrayListStrings(List<String> list, List<String> list2) {
        try {
            if (list == null && list2 != null) {
                list = new ArrayList<String>();
            }
            if (list2 != null) {
                for (String string : list2) {
                    list.add(string);
                }
            }
        }
        catch (Exception exception) {
            this.muestraError(exception);
        }
    }

    @Override
    public <T> T[] concatenaByteArrays(T[] TArray, T[] TArray2) throws Exception {
        int n = TArray.length;
        int n2 = TArray2.length;
        if (n == 0) {
            return TArray2;
        }
        if (n2 == 0) {
            return TArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n + n2);
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray2, 0, objectArray, n, n2);
        return objectArray;
    }

    @Override
    public Map<Object, Object> concatenaHashMap(Map<Object, Object> map, Map<Object, Object> map2) {
        try {
            Map map3 = null;
            if (map != null) {
                map3 = (Map)((HashMap)map).clone();
            }
            if (map2 != null) {
                if (map3 == null) {
                    map3 = (Map)((HashMap)map2).clone();
                } else {
                    Set<Object> set = map2.keySet();
                    Object object2 = null;
                    for (Object object2 : set) {
                        map3.put(object2, map2.get(object2));
                    }
                }
            }
            return map3;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return null;
        }
    }

    @Override
    public <T> List<T> cloneList(List<T> list) throws ExceptionMotor {
        try {
            List list2 = (List)list.getClass().newInstance();
            for (T t : list) {
                Object object = t.getClass().getDeclaredMethod("clone", new Class[0]).invoke(t, new Object[0]);
                list2.add(object);
            }
            return list2;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public <T> List<T> concatList(List<T> list, List<T> list2) throws ExceptionMotor {
        try {
            for (T t : list2) {
                list.add(t);
            }
            return list;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public <T> List<T> concatList(List<T> list, List<T> list2, List<T> list3) throws ExceptionMotor {
        try {
            for (T t : list2) {
                list.add(t);
            }
            for (T t : list3) {
                list.add(t);
            }
            return list;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String dameCadenaPadreLocalizacion(List<ITipoDatosCampoValor> list) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> list2 = this.cloneList(list);
            if (list2.size() > 0) {
                list2.remove(list2.size() - 1);
            }
            return list2.toString();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String localizacion2String(List<ITipoDatosCampoValor> list) throws Exception {
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            if (string.length() > 0) {
                string = string + ",";
            }
            string = string + list.get(i).getNombreCampo() + "(" + list.get(i).getValor() + ")";
        }
        return string;
    }

    @Override
    public <K, V> Map<K, V> cloneMap(Map<K, V> map) throws ExceptionMotor {
        try {
            Map map2 = (Map)map.getClass().newInstance();
            for (K k : map.keySet()) {
                Object object = map.get(k).getClass().getDeclaredMethod("clone", new Class[0]).invoke(map.get(k), new Object[0]);
                map2.put(k, object);
            }
            return map2;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String versionSistemaOperativo() {
        try {
            String string = System.getProperty("os.name");
            if (string.equalsIgnoreCase("Windows NT")) {
                return "T";
            }
            if (string.equalsIgnoreCase("Windows 95")) {
                return "5";
            }
            if (string.equalsIgnoreCase("Windows 98")) {
                return "8";
            }
            if (string.equalsIgnoreCase("Windows XP")) {
                return "X";
            }
            if (string.equalsIgnoreCase("Windows 2000")) {
                return "Y";
            }
            return "O";
        }
        catch (Exception exception) {
            return "E";
        }
    }

    @Override
    public boolean clasesIguales(Class<?> clazz, Class<?> clazz2) {
        try {
            if (clazz == null) {
                return true;
            }
            if (Object.class.equals(clazz2)) {
                return true;
            }
            if (clazz2.equals(clazz)) {
                return true;
            }
            if (clazz2.isInterface()) {
                for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                    if (!this.claseCumpleInterfaz(clazz2, clazz.getInterfaces()[i])) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean claseCumpleInterfaz(Class<?> clazz, Class<?> clazz2) {
        try {
            if (clazz.equals(clazz2)) {
                return true;
            }
            for (int i = 0; i < clazz2.getInterfaces().length; ++i) {
                if (clazz.equals(clazz2.getInterfaces()[i])) {
                    return true;
                }
                if (!this.claseCumpleInterfaz(clazz, clazz2.getInterfaces()[i])) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean removeReadOnlyFlag(String string) {
        try {
            if (!new File(string).canWrite()) {
                File file = null;
                try {
                    file = new File(string + "~tmp");
                    file.delete();
                    file = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileInputStream fileInputStream = new FileInputStream(new File(string));
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string + "~tmp"));
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileInputStream.close();
                fileOutputStream.close();
                fileInputStream = null;
                fileOutputStream = null;
                try {
                    file = new File(string);
                    file.delete();
                    file = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                file = new File(string + "~tmp");
                file.renameTo(new File(string));
                file = null;
                try {
                    file = new File(string + "~tmp");
                    file.delete();
                    file = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                file = null;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Object limpiaCadenaDeCaracteresDeControl(Object object) {
        try {
            String string = object.toString();
            int n = 0;
            String string2 = "";
            for (int i = 0; i < 3; ++i) {
                switch (i) {
                    case 0: {
                        string2 = "\n";
                        break;
                    }
                    case 1: {
                        string2 = "\t";
                        break;
                    }
                    case 2: {
                        string2 = "\r";
                        break;
                    }
                }
                while ((n = string.indexOf(string2)) != -1) {
                    if (n == 0) {
                        string = string.substring(1);
                        continue;
                    }
                    string = string.substring(0, n) + string.substring(n + 1);
                }
            }
            if (string.compareTo(object.toString()) != 0) {
                return string;
            }
            return object;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return object;
        }
    }

    @Override
    public boolean existeDirectorio(String string) {
        try {
            return this.esDirectorio(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esReadOnly(String string) {
        if (this.existeFichero(string)) {
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(string);
                fileWriter.write("A");
                fileWriter.close();
            }
            catch (IOException iOException) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean existeFichero(String string) {
        try {
            File file = new File(string);
            return file.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esDirectorio(String string) {
        try {
            File file = new File(string);
            return file.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esFichero(String string) {
        try {
            File file = new File(string);
            return file.isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esPath(String string) {
        try {
            File file = new File(string);
            return file.isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean borraDirectorio(String string) {
        int n;
        File file = null;
        boolean bl = true;
        try {
            file = new File(string);
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                if (stringArray.length > 0) {
                    for (n = 0; n < stringArray.length; ++n) {
                        if (this.borraDirectorio(file.getPath().replace(File.separatorChar, '/') + '/' + stringArray[n])) continue;
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                bl = file.delete();
            } else {
                bl = file.delete();
            }
        }
        catch (Exception exception) {
            n = 0;
            return n != 0;
        }
        finally {
            file = null;
        }
        return bl;
    }

    @Override
    public String doubleToString(Double d) {
        return this.doubleToString((double)d);
    }

    private String quitaNotacionCientifica(String string) {
        String string2 = string;
        String string3 = "";
        int n = 0;
        int n2 = string2.lastIndexOf(69);
        int n3 = string2.lastIndexOf(46);
        String string4 = "";
        if (n2 != -1) {
            n = Integer.parseInt(string2.substring(n2 + 1, string2.length()));
            string2 = string2.replaceAll("\\.", "");
            if (n >= 0) {
                if (n + n3 < n2 - 1) {
                    string4 = string2.substring(n + n3, n2 - 1);
                    if (string4.length() == 1) {
                        string4 = string4 + "0";
                    }
                } else {
                    string4 = "00";
                }
                string3 = n + n3 >= n2 - 1 ? string2.substring(0, n2 - 1) : string2.substring(0, n + n3);
                while (n + 1 > n2 - n3) {
                    string3 = string3 + "0";
                    --n;
                }
                string3 = string3 + ".";
                string3 = string3 + string4;
            } else {
                string3 = "0.";
                n *= -1;
                for (int i = 1; i < n; ++i) {
                    string3 = string3 + "0";
                }
                string3 = string3 + string2.substring(0, n2 - 1);
            }
        } else {
            string3 = string2;
        }
        return string3;
    }

    @Override
    public boolean tieneDecimales(Double d) throws ExceptionMotor {
        try {
            if (d == null) {
                return false;
            }
            if (d.toString().indexOf(46) > 0) {
                Double d2 = new Double(d.toString().substring(d.toString().indexOf(46) + 1));
                if (d2 > 0.0) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String doubleToString(double d) {
        try {
            return this.quitaNotacionCientifica(String.valueOf(d));
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return String.valueOf(d);
        }
    }

    @Override
    public Map<?, ?> arrayList2HashMap(List<?> list) {
        try {
            HashMap hashMap = new HashMap();
            for (int i = 0; i < list.size(); i += 2) {
                hashMap.put(list.get(i), list.get(i + 1));
            }
            return hashMap;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return null;
        }
    }

    @Override
    public String text2Html(String string) {
        String string2 = string;
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("&", "&amp;");
        return string2;
    }

    @Override
    public String html2Text(String string) {
        if (string == null || !string.contains("&")) {
            return string;
        }
        String string2 = string.replaceAll("&lt;", "<");
        string2 = string2.replaceAll("&LT;", "<");
        string2 = string2.replaceAll("&gt;", ">");
        string2 = string2.replaceAll("&GT;", ">");
        string2 = string2.replaceAll("&amp;", "&");
        string2 = string2.replaceAll("&AMP;", "&");
        string2 = string2.replaceAll("&quot;", "\"");
        string2 = string2.replaceAll("&QUOT;", "\"");
        string2 = string2.replaceAll("&Eacute;", "\u00c9");
        string2 = string2.replaceAll("&EACUTE;", "\u00c9");
        string2 = string2.replaceAll("&eacute;", "\u00e9");
        string2 = string2.replaceAll("&Ccedil;", "\u00c7");
        string2 = string2.replaceAll("&CCEDIL;", "\u00c7");
        string2 = string2.replaceAll("&ccedil;", "\u00e7");
        string2 = string2.replaceAll("&AElig;", "\u00c6");
        string2 = string2.replaceAll("&AELIG;", "\u00c6");
        string2 = string2.replaceAll("&aelig;", "\u00e6");
        string2 = string2.replaceAll("&Aring;", "\u00c5");
        string2 = string2.replaceAll("&ARING;", "\u00c5");
        string2 = string2.replaceAll("&aring;", "\u00e5");
        string2 = string2.replaceAll("&Auml;", "\u00c4");
        string2 = string2.replaceAll("&AUML;", "\u00c4");
        string2 = string2.replaceAll("&auml;", "\u00e4");
        string2 = string2.replaceAll("&Acirc;", "\u00c2");
        string2 = string2.replaceAll("&ACIRC;", "\u00c2");
        string2 = string2.replaceAll("&acirc;", "\u00e2");
        string2 = string2.replaceAll("&Agrave;", "\u00c0");
        string2 = string2.replaceAll("&AGRAVE;", "\u00c0");
        string2 = string2.replaceAll("&agrave;", "\u00e0");
        string2 = string2.replaceAll("&nbsp;", " ");
        string2 = string2.replaceAll("&NBSP;", " ");
        string2 = string2.replaceAll("&euro;", "\u0080");
        string2 = string2.replaceAll("&EURO;", "\u0080");
        string2 = string2.replaceAll("&copy;", "\u00a9");
        string2 = string2.replaceAll("&COPY;", "\u00a9");
        string2 = string2.replaceAll("&reg;", "\u00ae");
        string2 = string2.replaceAll("&Uuml;", "\u00dc");
        string2 = string2.replaceAll("&uuml;", "\u00fc");
        string2 = string2.replaceAll("&Ucirc;", "\u00db");
        string2 = string2.replaceAll("&ucirc;", "\u00fb");
        string2 = string2.replaceAll("&Ugrave;", "\u00d9");
        string2 = string2.replaceAll("&ugrave;", "\u00f9");
        string2 = string2.replaceAll("&szlig;", "\u00df");
        string2 = string2.replaceAll("&Oslash;", "\u00d8");
        string2 = string2.replaceAll("&oslash;", "\u00f8");
        string2 = string2.replaceAll("&Ouml;", "\u00d6");
        string2 = string2.replaceAll("&ouml;", "\u00f6");
        string2 = string2.replaceAll("&Ocirc;", "\u00d4");
        string2 = string2.replaceAll("&ocirc;", "\u00f4");
        string2 = string2.replaceAll("&Iuml;", "\u00cf");
        string2 = string2.replaceAll("&iuml;", "\u00ef");
        string2 = string2.replaceAll("&Euml;", "\u00cb");
        string2 = string2.replaceAll("&euml;", "\u00eb");
        string2 = string2.replaceAll("&Ecirc;", "\u00ca");
        string2 = string2.replaceAll("&ecirc;", "\u00ea");
        string2 = string2.replaceAll("&Egrave;", "\u00c8");
        string2 = string2.replaceAll("&egrave;", "\u00e8");
        return string2;
    }

    protected String detallameError(Exception exception) {
        if (exception == null) {
            return null;
        }
        String string = exception.toString();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n; ++i) {
            string = string + "\n" + stackTraceElementArray[i].getFileName() + "[" + stackTraceElementArray[i].getLineNumber() + "] ==> " + stackTraceElementArray[i].getMethodName() + "()";
        }
        return string;
    }

    @Override
    public void muestraError(Exception exception) {
        this.muestraError(this.detallameError(exception));
    }

    @Override
    public void muestraError(Exception exception, String string) {
        this.muestraError("INFORMACION EXTRA DEL ERROR : " + string + "\n" + this.detallameError(exception));
    }

    @Override
    public void muestraError(String string) {
        if (string == null) {
            return;
        }
        if (this.listenersEventosMensajes == null) {
            System.err.println("Error : " + string);
        } else {
            for (int i = 0; i < this.listenersEventosMensajes.size(); ++i) {
                this.listenersEventosMensajes.get(i).eventoError(string);
            }
        }
    }

    @Override
    public void muestraAviso(Exception exception, String string) {
        this.muestraAviso("INFORMACION EXTRA DEL AVISO : " + string + "\n" + this.detallameError(exception));
    }

    @Override
    public void muestraAviso(Exception exception) {
        this.muestraAviso(this.detallameError(exception));
    }

    @Override
    public void muestraAviso(String string) {
        if (string == null) {
            return;
        }
        if (this.listenersEventosMensajes == null) {
            System.err.println("Aviso : " + string);
        } else {
            for (int i = 0; i < this.listenersEventosMensajes.size(); ++i) {
                this.listenersEventosMensajes.get(i).eventoAviso(string);
            }
        }
    }

    @Override
    public void muestraInfo(Exception exception, String string) {
        this.muestraInfo("INFORMACION EXTRA : " + string + "\n" + this.detallameError(exception));
    }

    @Override
    public void muestraInfo(Exception exception) {
        this.muestraInfo(this.detallameError(exception));
    }

    @Override
    public void muestraInfo(String string) {
        if (string == null) {
            return;
        }
        if (this.listenersEventosMensajes == null) {
            System.out.println("Info : " + string);
        } else {
            for (int i = 0; i < this.listenersEventosMensajes.size(); ++i) {
                this.listenersEventosMensajes.get(i).eventoInformacion(string);
            }
        }
    }

    @Override
    public void muestraInfoDebug(Exception exception, String string) {
        this.muestraInfoDebug("INFORMACION EXTRA : " + string + "\n" + this.detallameError(exception));
    }

    @Override
    public void muestraInfoDebug(Exception exception) {
        this.muestraInfoDebug(this.detallameError(exception));
    }

    @Override
    public void muestraInfoDebug(String string) {
        if (string == null) {
            return;
        }
        if (this.listenersEventosMensajes == null) {
            System.out.println("InfoDebug : " + string);
        } else {
            for (int i = 0; i < this.listenersEventosMensajes.size(); ++i) {
                this.listenersEventosMensajes.get(i).eventoInformacionDebug(string);
            }
        }
    }

    public void addEventosMensajes(IEventosMensajes iEventosMensajes) throws ExceptionMotor {
        try {
            if (this.listenersEventosMensajes == null) {
                this.listenersEventosMensajes = new ArrayList<IEventosMensajes>();
            }
            this.listenersEventosMensajes.add(iEventosMensajes);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void removeEventosMensajes() throws ExceptionMotor {
        try {
            if (this.listenersEventosMensajes != null) {
                this.listenersEventosMensajes.clear();
                this.listenersEventosMensajes = null;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String rellena(String string, char c, int n) {
        return this.rellena(string, c, n, false);
    }

    @Override
    public String truncaCadena(String string, int n, boolean bl) {
        if (string != null && string.length() > n) {
            string = n > 5 && bl ? string.substring(0, n - 3) + "..." : string.substring(0, n);
        }
        return string;
    }

    @Override
    public String rellena(String string, char c, int n, boolean bl) {
        String string2 = string;
        try {
            while (string2.length() < n) {
                if (bl) {
                    string2 = c + string2;
                    continue;
                }
                string2 = string2 + c;
            }
            return string2;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return string2;
        }
    }

    @Override
    public boolean mayorQue(String string, String string2) throws Exception {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = new BigDecimal(string.trim());
        return bigDecimal2.compareTo(bigDecimal = new BigDecimal(string2.trim())) > 0;
    }

    @Override
    public boolean menorQue(String string, String string2) throws Exception {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = new BigDecimal(string.trim());
        return bigDecimal2.compareTo(bigDecimal = new BigDecimal(string2.trim())) < 0;
    }

    @Override
    public File creaArchivoTemporal() {
        return this.creaArchivoTemporal(null, null);
    }

    @Override
    public File creaArchivoTemporal(String string, String string2) {
        String string3 = string2;
        String string4 = string;
        try {
            if (string4 == null) {
                string4 = "Mot";
            }
            if (string4.length() == 0) {
                string4 = "Mot";
            }
            if (string3 == null) {
                string3 = "Tmp";
            }
            if (string3.length() == 0) {
                string3 = "Tmp";
            }
            File file = File.createTempFile(string4, "." + string3);
            file.deleteOnExit();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    @Override
    public boolean sonIguales(boolean bl, Object object, Object object2) {
        try {
            if (object != null && object.toString().equalsIgnoreCase(object2.toString())) {
                return true;
            }
            if (bl) {
                try {
                    if (this.esNumerico(object.toString()) && this.esNumerico(object2.toString()) && new BigDecimal(object.toString().trim()).compareTo(new BigDecimal(object2.toString().trim())) == 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String convertStream2String(InputStream inputStream) throws ExceptionMotor, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("ISO-8859-1")));
        StringAEAT stringAEAT = new StringAEAT();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringAEAT.append(string + "\n");
        }
        return stringAEAT.getString();
    }

    @Override
    public InputStream string2inputstream(String string, Charset charset) {
        try {
            return new ByteArrayInputStream(string.getBytes(charset));
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return null;
        }
    }

    @Override
    public String convertStream2StringPersistencia(InputStream inputStream) throws ExceptionMotor, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("ISO-8859-1")));
        StringAEAT stringAEAT = new StringAEAT();
        int n = 0;
        while ((n = bufferedReader.read()) != -1) {
            stringAEAT.append((char)n);
        }
        return stringAEAT.getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String obfuscate(String string, int n) {
        try {
            switch (n) {
                case 1: {
                    StringBuffer stringBuffer = new StringBuffer();
                    byte[] byArray = string.getBytes();
                    StringBuffer stringBuffer2 = stringBuffer;
                    synchronized (stringBuffer2) {
                        stringBuffer.append("OBFAEAT");
                        for (int i = 0; i < byArray.length; ++i) {
                            byte by = byArray[i];
                            byte by2 = byArray[string.length() - (i + 1)];
                            int n2 = 127 + by + by2;
                            int n3 = 127 + by - by2;
                            int n4 = n2 * 256 + n3;
                            String string2 = Integer.toString(n4, 36);
                            switch (string2.length()) {
                                case 1: {
                                    stringBuffer.append('0');
                                }
                                case 2: {
                                    stringBuffer.append('0');
                                }
                                case 3: {
                                    stringBuffer.append('0');
                                }
                            }
                            stringBuffer.append(string2);
                        }
                        return stringBuffer.toString();
                    }
                }
            }
            return string;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return string;
        }
    }

    @Override
    public String deobfuscate(String string, int n) {
        try {
            switch (n) {
                case 1: {
                    if (string.startsWith("OBFAEAT")) {
                        string = string.substring("OBFAEAT".length());
                    }
                    byte[] byArray = new byte[string.length() / 2];
                    int n2 = 0;
                    for (int i = 0; i < string.length(); i += 4) {
                        String string2 = string.substring(i, i + 4);
                        int n3 = Integer.parseInt(string2, 36);
                        int n4 = n3 / 256;
                        int n5 = n3 % 256;
                        byArray[n2++] = (byte)((n4 + n5 - 254) / 2);
                    }
                    return new String(byArray, 0, n2);
                }
            }
            return string;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return string;
        }
    }

    @Override
    public String comprimeCadena(String string, Charset charset) {
        try {
            byte[] byArray = string.getBytes(charset);
            byte[] byArray2 = new byte[0x2000000];
            Deflater deflater = new Deflater(-1, true);
            deflater.setInput(byArray);
            deflater.finish();
            int n = 0;
            String string2 = "";
            while ((n = deflater.deflate(byArray2)) != 0) {
                string2 = string2 + new String(byArray2, 0, n, charset);
            }
            return string2;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return string;
        }
    }

    @Override
    public String desComprimeCadena(String string, Charset charset) {
        try {
            byte[] byArray = string.getBytes(charset);
            Inflater inflater = new Inflater(true);
            inflater.setInput(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[0x2000000];
            int n = 0;
            String string2 = "";
            do {
                if ((n = inflater.inflate(byArray2)) <= 0) continue;
                string2 = string2 + new String(byArray2, 0, n, charset);
            } while (inflater.getRemaining() != 0);
            return string2;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dameNombreTablaRaiz(IGestorConfiguracion iGestorConfiguracion) {
        GestorConfiguracionLooper gestorConfiguracionLooper = null;
        try {
            gestorConfiguracionLooper = new GestorConfiguracionLooper();
            gestorConfiguracionLooper.init(new Object[]{iGestorConfiguracion});
            String string = "";
            IRegTabla iRegTabla = (IRegTabla)gestorConfiguracionLooper.getPrimerElemento("Tablas".toUpperCase());
            while (iRegTabla != null) {
                if (iRegTabla.getNivel() == 0) {
                    string = iRegTabla.getIdTabla();
                    break;
                }
                iRegTabla = (IRegTabla)gestorConfiguracionLooper.getSiguienteElemento();
            }
            if (string.length() == 0) {
                throw new ExceptionMotor("No se cual es la tabla de nivel 0!!!!!!!");
            }
            String string2 = string;
            return string2;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            String string = "";
            return string;
        }
        finally {
            if (gestorConfiguracionLooper != null) {
                try {
                    gestorConfiguracionLooper.dispose();
                }
                catch (Exception exception) {}
                gestorConfiguracionLooper = null;
            }
        }
    }

    @Override
    public Document documentFromString(String string) throws Exception {
        String string2 = "ISO-8859-1";
        InputSource inputSource = new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(string.getBytes(string2)), Charset.forName(string2)));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputSource);
    }

    @Override
    public boolean sonIgualesXML(String string, String string2) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        String string3 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\" ?>";
        if (!string.startsWith(string3.substring(0, 12))) {
            string = string3 + string;
        }
        Document document = documentBuilder.parse(this.string2inputstream(string, Charset.forName("ISO-8859-1")));
        document.normalizeDocument();
        if (!string2.startsWith(string3.substring(0, 12))) {
            string2 = string3 + string2;
        }
        Document document2 = documentBuilder.parse(this.string2inputstream(string2, Charset.forName("ISO-8859-1")));
        document2.normalizeDocument();
        Element element = document.getDocumentElement();
        this.sortChildren(element, new DefaultNodeNameComparator());
        element = document2.getDocumentElement();
        this.sortChildren(element, new DefaultNodeNameComparator());
        return document.isEqualNode(document2);
    }

    protected void sortChildren(Node node, Comparator<Node> comparator) throws Exception {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            this.sortChildren(node2, comparator);
            arrayList.add(node2);
        }
        Collections.sort(arrayList, Collections.reverseOrder(comparator));
        for (Node node2 : arrayList) {
            node.appendChild(node2);
        }
    }

    @Override
    public String XmlDoc2String(Document document) throws Exception {
        StringWriter stringWriter = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", document.getXmlEncoding());
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public Document xmlString2Document(String string) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(byteArrayInputStream);
        return document;
    }

    @Override
    public boolean document2file(Document document, String string) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(document.getDocumentElement().toString().getBytes());
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return false;
        }
    }

    public String document2StringV2(Document document) {
        try {
            Class<?> clazz = Class.forName("org.apache.xml.serialize.OutputFormat");
            Constructor<?> constructor = clazz.getConstructor(Document.class, String.class, Boolean.TYPE);
            Object obj = constructor.newInstance(document, "UTF-8", true);
            StringWriter stringWriter = new StringWriter();
            clazz = Class.forName("org.apache.xml.serialize.XMLSerializer");
            constructor = clazz.getConstructor(Writer.class, obj.getClass());
            Object obj2 = constructor.newInstance(stringWriter, obj);
            try {
                Method method = obj2.getClass().getMethod("serialize", Document.class);
                method.invoke(obj2, document);
            }
            catch (Exception exception) {
                return "error";
            }
            return stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "ERROR";
        }
    }

    public String document2String(Document document) {
        String string = document.getDocumentElement().toString();
        Pattern pattern = Pattern.compile("[\t]*", 2);
        Matcher matcher = pattern.matcher(string);
        String string2 = matcher.replaceAll("");
        pattern = Pattern.compile("><", 2);
        matcher = pattern.matcher(string2);
        String string3 = matcher.replaceAll(">\n<");
        String[] stringArray = string3.split("\n");
        String string4 = "";
        string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(60);
            int n2 = stringArray[i].indexOf("</");
            if (n2 == -1) {
                n2 = stringArray[i].indexOf("/>");
            }
            if (n2 != n) {
                string4 = string4 + "\t";
            }
            string3 = string3 + string4;
            string3 = string3 + stringArray[i];
            string3 = string3 + "\n";
            if (n2 == -1 || string4.length() <= 0) continue;
            string4 = string4.substring(1);
        }
        return string3;
    }

    @Override
    public boolean existeIndice(Object[] objectArray, int n) {
        try {
            return objectArray[n] != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Document file2document(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(fileInputStream);
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return null;
        }
    }

    @Override
    public void bytes2file(byte[] byArray, String string) throws FileNotFoundException, IOException, ExceptionMotor {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public byte[] file2bytesISO(String string) throws FileNotFoundException, IOException, ExceptionMotor {
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            ByteWriterAEAT byteWriterAEAT = new ByteWriterAEAT();
            while ((string2 = bufferedReader.readLine()) != null) {
                byteWriterAEAT.writeln(string2);
            }
            fileInputStream.close();
            bufferedInputStream.close();
            return byteWriterAEAT.getBytes();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public byte[] file2bytes(File file) throws IOException, ExceptionMotor {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            long l = file.length();
            if (l > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] byArray = new byte[(int)l];
            int n2 = 0;
            for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
            }
            if (n < byArray.length) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IOException("No se pudo leer el fichero entero " + file.getName());
            }
            ((InputStream)fileInputStream).close();
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String dameNombrePartidaSinParentesis(String string) {
        int n = string.indexOf("(");
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public String dameRutaCompletaEntrada(IGestorConfiguracion iGestorConfiguracion, String string) {
        try {
            IRegEntrada iRegEntrada = iGestorConfiguracion.getEntrada(string);
            if (iRegEntrada == null) {
                throw new Exception("La entrada " + string + " no existe!!!");
            }
            String string2 = iRegEntrada.getIdVariable();
            if (iGestorConfiguracion.getRuta(iRegEntrada.getIdVariable()).length() > 0) {
                string2 = iGestorConfiguracion.getRuta(iRegEntrada.getIdVariable());
            }
            IRegTabla iRegTabla = iGestorConfiguracion.getTabla(iRegEntrada.getIdTabla());
            while (true) {
                string2 = iRegTabla.getIdTabla() + "/" + string2;
                if (iRegTabla.getNivel() == 0) break;
                iRegTabla = iGestorConfiguracion.getTabla(iRegTabla.getTablaPadre());
            }
            return "/" + string2;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return string;
        }
    }

    @Override
    public String cadenaSinTildes(String string) {
        try {
            return string.replaceAll("\u00c1", "A").replaceAll("\u00c0", "A").replaceAll("\u00e1", "a").replaceAll("\u00e0", "a").replaceAll("\u00c9", "E").replaceAll("\u00c8", "E").replaceAll("\u00e9", "e").replaceAll("\u00e8", "e").replaceAll("\u00cd", "I").replaceAll("\u00cc", "I").replaceAll("\u00ed", "i").replaceAll("\u00ec", "i").replaceAll("\u00d3", "O").replaceAll("\u00d2", "O").replaceAll("\u00f3", "o").replaceAll("\u00f2", "o").replaceAll("\u00da", "U").replaceAll("\u00d9", "U").replaceAll("\u00fa", "u").replaceAll("\u00f9", "u");
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return string;
        }
    }

    @Override
    public boolean unZip(File file, String string) {
        try {
            boolean bl = true;
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                File file2 = new File(string + File.separator + jarEntry.getName());
                if (jarEntry.isDirectory()) {
                    bl &= file2.mkdir();
                    continue;
                }
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while (inputStream.available() > 0) {
                    fileOutputStream.write(inputStream.read());
                }
                fileOutputStream.close();
                inputStream.close();
            }
            jarFile.close();
            return true;
        }
        catch (Exception exception) {
            this.muestraError(exception);
            return false;
        }
    }

    @Override
    public byte[] object2byteArray(Object object) throws ExceptionMotor {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object byteArray2object(byte[] byArray) throws ExceptionMotor {
        try {
            return new ObjectInputStream(new ByteArrayInputStream(byArray)).readObject();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object byteArray2object(byte[] byArray, ClassLoader classLoader) throws ExceptionMotor {
        try {
            return new ObjectInputStreamAEAT(new ByteArrayInputStream(byArray), classLoader).readObject();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public InputStream byteArray2inputStream(byte[] byArray) throws IOException {
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public byte[] inputStream2byteArray(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        while (!bl) {
            int n = inputStream.read(byArray);
            if (n != 1024) {
                bl = true;
            }
            if (n != -1 && bl) {
                byteArrayOutputStream.write(byArray, 0, n);
                break;
            }
            if (n != 1024) continue;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public char[] inputStream2byteArray(Reader reader) throws IOException {
        char[] cArray = new char[1024];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        boolean bl = false;
        while (!bl) {
            int n = reader.read(cArray);
            if (n != 1024) {
                bl = true;
            }
            if (n != -1 && bl) {
                charArrayWriter.write(cArray, 0, n);
                break;
            }
            if (n != 1024) continue;
            charArrayWriter.write(cArray, 0, n);
        }
        charArrayWriter.flush();
        charArrayWriter.close();
        return charArrayWriter.toCharArray();
    }

    @Override
    public List<ITipoDatosCampoValor> ListRaw2ListTipada(List<String> list) throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosCampoValor> arrayList = new ArrayList<ITipoDatosCampoValor>();
            for (int i = 0; i < list.size(); i += 2) {
                arrayList.add(new TipoDatosCampoValor(list.get(i), list.get(i + 1)));
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public InputStream getRecurso(String string, String string2) throws ExceptionMotor {
        InputStream inputStream = null;
        try {
            Object object;
            if (FuncionesUtiles.getFuncionesUtiles().fileExists(string)) {
                inputStream = new FileInputStream(string);
            }
            if (inputStream == null) {
                object = null;
                object = new LectorFicheroJar(string2);
                inputStream = ((LectorFicheroJar)object).getInputStream(string);
            }
            if (inputStream == null) {
                throw new ExceptionMotor("recurso no encontrado");
            }
            object = inputStream;
            return object;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, string);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getMemoriaLibre() {
        try {
            Runtime runtime = Runtime.getRuntime();
            NumberFormat numberFormat = NumberFormat.getInstance();
            StringBuilder stringBuilder = new StringBuilder();
            long l = runtime.maxMemory();
            long l2 = runtime.totalMemory();
            long l3 = runtime.freeMemory();
            stringBuilder.append("****************************************************************************\n");
            stringBuilder.append("free memory: " + numberFormat.format(l3 / 1024L));
            stringBuilder.append("\nallocated memory: " + numberFormat.format(l2 / 1024L));
            stringBuilder.append("\nmax memory: " + numberFormat.format(l / 1024L));
            stringBuilder.append("\ntotal free memory: " + numberFormat.format((l3 + (l - l2)) / 1024L));
            return numberFormat.format((l3 + (l - l2)) / 1024L);
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    public Object getInstancia(String string, Object[] objectArray, ClassLoader classLoader) throws ExceptionMotor {
        Class<?> clazz = null;
        try {
            if (classLoader != null) {
                clazz = classLoader.loadClass(string);
            }
            if (clazz == null) {
                if (this.getClass().getClassLoader() != null) {
                    clazz = this.getClass().getClassLoader().loadClass(string);
                }
                if (clazz == null) {
                    clazz = Class.forName(string);
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
        return this.getInstancia(clazz, objectArray);
    }

    public Object getInstancia(String string, Object[] objectArray) throws ExceptionMotor {
        return this.getInstancia(string, objectArray, this.getClass().getClassLoader());
    }

    @Override
    public Object getInstancia(Class<?> clazz, Object[] objectArray) throws ExceptionMotor {
        if (aopInyectorAOPDisponible) {
            try {
                Object object = Class.forName("aop.InyectorAOP").getMethod("getInstancia", Class.class).invoke(null, clazz);
                if (object == null) {
                    throw new Exception("Clase no adaptada a AOP...");
                }
                try {
                    this.ejecutaInit(object, clazz, objectArray, true);
                }
                catch (Exception exception) {
                    throw new Exception("No se pudo realizar el constructor de la clase... " + clazz.getCanonicalName());
                }
                return object;
            }
            catch (Exception exception) {
                aopInyectorAOPDisponible = false;
                FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("AOP no disponible aplicaci\u00f3n probablemente en producci\u00f3n...");
            }
        }
        try {
            Object obj = clazz.newInstance();
            this.ejecutaInit(obj, clazz, objectArray, true);
            return obj;
        }
        catch (Exception exception) {
            String string = "";
            try {
                string = clazz.getName();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new ExceptionMotor(exception, string);
        }
    }

    private void ejecutaInit(Object object, Class<?> clazz, Object[] objectArray, boolean bl) throws Exception {
        block3: {
            try {
                if (IAop.class.isInstance(object)) {
                    ((IAop)object).init(objectArray);
                }
            }
            catch (Exception exception) {
                if (!bl) break block3;
                throw exception;
            }
        }
    }

    @Override
    public byte[] serializaObjeto(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public Object desSerializaObjeto(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    @Override
    public void serializaObjeto(Object object, String string) throws ExceptionMotor {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            try {
                objectOutputStream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object desSerializaObjeto(String string) throws ExceptionMotor {
        ObjectInputStream objectInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean esLLamadaRecursiva() throws ExceptionMotor {
        try {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (!stackTraceElementArray[i].getClassName().equalsIgnoreCase(this.getClass().getName()) || !stackTraceElementArray[i].getMethodName().equalsIgnoreCase("esLLamadaRecursiva")) continue;
                StackTraceElement stackTraceElement = stackTraceElementArray[i + 1];
                for (int j = i + 2; j < stackTraceElementArray.length; ++j) {
                    boolean bl = false;
                    if (stackTraceElementArray[j].getFileName() == null || stackTraceElementArray[j].getFileName().equalsIgnoreCase(stackTraceElement.getFileName())) {
                        bl = true;
                    }
                    if (!stackTraceElementArray[j].getClassName().equalsIgnoreCase(stackTraceElement.getClassName()) || !stackTraceElementArray[j].getMethodName().equals(stackTraceElement.getMethodName()) || !bl) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String convierteMesenNumero(String string) {
        if (string.trim().equalsIgnoreCase("ENERO")) {
            return "01";
        }
        if (string.trim().equalsIgnoreCase("FEBRERO")) {
            return "02";
        }
        if (string.trim().equalsIgnoreCase("MARZO")) {
            return "03";
        }
        if (string.trim().equalsIgnoreCase("ABRIL")) {
            return "04";
        }
        if (string.trim().equalsIgnoreCase("MAYO")) {
            return "05";
        }
        if (string.trim().equalsIgnoreCase("JUNIO")) {
            return "06";
        }
        if (string.trim().equalsIgnoreCase("JULIO")) {
            return "07";
        }
        if (string.trim().equalsIgnoreCase("AGOSTO")) {
            return "08";
        }
        if (string.trim().equalsIgnoreCase("SEPTIEMBRE")) {
            return "09";
        }
        if (string.trim().equalsIgnoreCase("OCTUBRE")) {
            return "10";
        }
        if (string.trim().equalsIgnoreCase("NOVIEMBRE")) {
            return "11";
        }
        if (string.trim().equalsIgnoreCase("DICIEMBRE")) {
            return "12";
        }
        return "00";
    }

    @Override
    public String convierteNumeroEnMes(String string) {
        if (string.trim().equalsIgnoreCase("01")) {
            return "ENERO";
        }
        if (string.trim().equalsIgnoreCase("02")) {
            return "FEBRERO";
        }
        if (string.trim().equalsIgnoreCase("03")) {
            return "MARZO";
        }
        if (string.trim().equalsIgnoreCase("04")) {
            return "ABRIL";
        }
        if (string.trim().equalsIgnoreCase("05")) {
            return "MAYO";
        }
        if (string.trim().equalsIgnoreCase("06")) {
            return "JUNIO";
        }
        if (string.trim().equalsIgnoreCase("07")) {
            return "JULIO";
        }
        if (string.trim().equalsIgnoreCase("08")) {
            return "AGOSTO";
        }
        if (string.trim().equalsIgnoreCase("09")) {
            return "SEPTIEMBRE";
        }
        if (string.trim().equalsIgnoreCase("10")) {
            return "OCTUBRE";
        }
        if (string.trim().equalsIgnoreCase("11")) {
            return "NOVIEMBRE";
        }
        if (string.trim().equalsIgnoreCase("12")) {
            return "DICIEMBRE";
        }
        return "";
    }

    @Override
    public boolean existeConstructorPorDefecto(Class<?> clazz) throws Exception {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0 || constructor.getModifiers() != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void muestraTrazaAccesoDDBB(String string) {
    }

    @Override
    public IRegError generarErrorSiNoExiste(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            IRegError iRegError = iSesion.getModelo().getGestorConfiguracion().getError(string);
            if (iRegError == null) {
                try {
                    if (string.endsWith(".0")) {
                        iRegError = iSesion.getModelo().getGestorConfiguracion().getError(string.substring(0, string.length() - 2));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (iRegError == null) {
                    iRegError = new RegError();
                    iRegError.inicializaRegError(string, "");
                    iRegError.setTipoError("E");
                    if (string.equalsIgnoreCase("CHRNV")) {
                        iRegError.setMsg("Caracteres no v\u00e1lidos.");
                    } else if (string.equalsIgnoreCase("OVERFLOW_MOTOR")) {
                        iRegError.setMsg("La partida supera el m\u00e1ximo permitido.");
                    } else if (string.equalsIgnoreCase("IMPROCEDENTE")) {
                        iRegError.setMsg("Contenido improcedente.");
                    } else if (string.equalsIgnoreCase("LNGINC")) {
                        iRegError.setMsg("Longitud incorrecta.");
                    } else if (string.equalsIgnoreCase("MAXERR")) {
                        iRegError.setMsg("Existen m\u00e1s errores. No se muestran puesto que super\u00f3 el m\u00e1ximo a visualizar.");
                    } else if (string.equalsIgnoreCase("ADDERR")) {
                        iRegError.setMsg("Error al a\u00f1adir registro.");
                    } else if (string.equalsIgnoreCase("FECHERR")) {
                        iRegError.setMsg("Fecha incorrecta");
                    } else if (string.equalsIgnoreCase("ERRMAXREG")) {
                        iRegError.setMsg("No se pueden a\u00f1adir mas registros");
                    } else {
                        iRegError.setMsg("Texto de error no encontrado!!!");
                    }
                }
            }
            return iRegError;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public byte[] compressByteArray(byte[] byArray) throws ExceptionMotor {
        try {
            if (byArray == null) {
                return null;
            }
            Deflater deflater = new Deflater();
            deflater.setLevel(9);
            deflater.setInput(byArray);
            deflater.finish();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            byte[] byArray2 = new byte[1024];
            while (!deflater.finished()) {
                int n = deflater.deflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public byte[] inflateByteArray(byte[] byArray) throws ExceptionMotor {
        try {
            if (byArray == null) {
                return null;
            }
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray), new Inflater());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n;
                byte[] byArray2 = new byte[1024];
                while ((n = inflaterInputStream.read(byArray2, 0, 1024)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                inflaterInputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String byteArray2SerializableString(byte[] byArray) throws ExceptionMotor {
        try {
            if (byArray == null || byArray.length == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (byte by : byArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(by);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public byte[] serializableString2byteArray(String string) throws ExceptionMotor {
        try {
            if (string == null || string.length() == 0) {
                return null;
            }
            String[] stringArray = string.split(",");
            byte[] byArray = new byte[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                byArray[i] = new Byte(stringArray[i]);
            }
            return byArray;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public ITablaMotorEntrada sacaDeLista(Map<String, ITablaMotorEntrada> map, String string, String string2) throws ExceptionMotor {
        try {
            if (map.containsKey(string)) {
                return map.get(string);
            }
            if (map.containsKey(string2)) {
                return map.get(string2);
            }
            throw new Exception("Imposible encontrar ni " + string + " ni " + string2);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public ITablaMotorEntrada sacaDeListaEx(Map<String, ITablaMotorEntrada> map, String ... stringArray) throws ExceptionMotor {
        try {
            for (String string : stringArray) {
                if (!map.containsKey(string)) continue;
                return map.get(string);
            }
            throw new Exception("Imposible encontrar campo " + stringArray);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String dameValorAtributo(NamedNodeMap namedNodeMap, String string) throws ExceptionMotor {
        try {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                if (!namedNodeMap.item(i).getNodeName().equalsIgnoreCase(string)) continue;
                return namedNodeMap.item(i).getNodeValue();
            }
            return null;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String damePrimeraOpcion(List<String> list) {
        try {
            if (list != null && list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ITipoDatoRetornoProceso completaConErroresRecomendadosLista(ITipoDatoRetornoProceso iTipoDatoRetornoProceso, ISesion iSesion) {
        try {
            TipoDatoRetornoProceso tipoDatoRetornoProceso = new TipoDatoRetornoProceso(iTipoDatoRetornoProceso);
            tipoDatoRetornoProceso.setListadoErrores(this.completaConErroresRecomendadosLista(tipoDatoRetornoProceso.getListadoErrores(), iSesion));
            tipoDatoRetornoProceso.setListadoWarnings(this.completaConErroresRecomendadosLista(tipoDatoRetornoProceso.getListadoWarnings(), iSesion));
            return tipoDatoRetornoProceso;
        }
        catch (Exception exception) {
            return iTipoDatoRetornoProceso;
        }
    }

    public List<IRegError> completaConErroresRecomendadosLista(List<IRegError> list, ISesion iSesion) {
        try {
            ArrayList<IRegError> arrayList = new ArrayList<IRegError>();
            for (IRegError iRegError : list) {
                IRegError iRegError2 = iRegError.clone();
                arrayList.add(iRegError2);
            }
            return arrayList;
        }
        catch (Exception exception) {
            return list;
        }
    }

    @Override
    public void dejaSoloNerroresEntreListas(List<IRegError> list, List<IRegError> list2, int n) {
        try {
            if (list.size() + list2.size() == n) {
                return;
            }
            if (list2.size() > 0) {
                while (list2.size() > 0) {
                    list2.remove(list2.size() - 1);
                    if (list.size() + list2.size() != n) continue;
                    return;
                }
            }
            if (list.size() + list2.size() > n) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    if (list.get(i).getIdError().equalsIgnoreCase("OVERFLOW_MOTOR") || list.get(i).getIdError().equalsIgnoreCase("MAXERR")) continue;
                    list.remove(i);
                    if (list.size() + list2.size() == n) {
                        return;
                    }
                    i = list.size();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class DefaultNodeNameComparator
    implements Comparator<Node> {
        protected DefaultNodeNameComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            return node.getNodeName().compareTo(node2.getNodeName());
        }
    }
}

