/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.api.puente.IBusquedaNodos;
import java.io.Serializable;

public class FreezerMotor
implements Serializable {
    private static final long serialVersionUID = -7444115444699799759L;
    private IBusquedaNodos buscadorDeNodosTablaMotor = null;
    private boolean isfreezed = false;
    private Object nodoSalvado = null;
    private Object datosSalvados = null;
    private ISesion sesion = null;

    public FreezerMotor(ISesion iSesion) {
        this.sesion = iSesion;
        this.isfreezed = false;
    }

    protected ISesion getSesion() {
        return this.sesion;
    }

    public void freezeCompleto() throws ExceptionMotor {
        try {
            if (this.isIsfreezed()) {
                throw new ExceptionMotor("no se puede freeze dos veces, llame a unfreeze o a cancelfreeze");
            }
            this.freeze();
            this.datosSalvados = this.getSesion().getOperaciones().clona();
            if (this.datosSalvados == null) {
                throw new Exception("Error al clonar!!!");
            }
        }
        catch (Exception exception) {
            this.setIsfreezed(false);
            throw new ExceptionMotor(exception);
        }
    }

    public void freeze() throws ExceptionMotor {
        try {
            if (this.isIsfreezed()) {
                throw new ExceptionMotor("no se puede freeze dos veces, llame a unfreeze o a cancelfreeze");
            }
            this.datosSalvados = null;
            this.setNodoSalvado(null);
            this.setNodoSalvado(((ISesionExtendida)this.getSesion()).cloneListaNodosPrincipales());
            this.setIsfreezed(true);
        }
        catch (Exception exception) {
            this.setIsfreezed(false);
            if (exception instanceof ExceptionMotor) {
                throw (ExceptionMotor)exception;
            }
            throw new ExceptionMotor(exception);
        }
    }

    public void cancelfreeze() throws ExceptionMotor {
        try {
            if (!this.isIsfreezed()) {
                throw new ExceptionMotor("llame antes a freeze");
            }
            this.setNodoSalvado(null);
            this.datosSalvados = null;
            this.setIsfreezed(false);
        }
        catch (Exception exception) {
            this.setIsfreezed(false);
            if (exception instanceof ExceptionMotor) {
                throw (ExceptionMotor)exception;
            }
            throw new ExceptionMotor(exception);
        }
    }

    public void unfreeze() throws ExceptionMotor {
        try {
            if (!this.isIsfreezed()) {
                throw new ExceptionMotor("llame antes a freeze");
            }
            this.setIsfreezed(false);
            ((ISesionExtendida)this.getSesion()).overwriteListaNodosPrincipales(this.getNodoSalvado(), this.datosSalvados != null);
            this.setNodoSalvado(null);
            if (this.datosSalvados != null) {
                if (!this.getSesion().getOperaciones().restauraDocumento(this.datosSalvados)) {
                    throw new Exception("Error al restaurar los datos sobre el origen de datos!!!");
                }
                this.datosSalvados = null;
            }
        }
        catch (Exception exception) {
            this.setIsfreezed(false);
            if (exception instanceof ExceptionMotor) {
                throw (ExceptionMotor)exception;
            }
            throw new ExceptionMotor(exception);
        }
    }

    public void dispose() {
        this.sesion = null;
        this.buscadorDeNodosTablaMotor = null;
        this.nodoSalvado = null;
        this.datosSalvados = null;
    }

    public boolean isFreezed() {
        return this.isIsfreezed();
    }

    protected void setBuscadorDeNodosTablaMotor(IBusquedaNodos iBusquedaNodos) {
        this.buscadorDeNodosTablaMotor = iBusquedaNodos;
    }

    protected IBusquedaNodos getBuscadorDeNodosTablaMotor() {
        return this.buscadorDeNodosTablaMotor;
    }

    protected void setIsfreezed(boolean bl) {
        this.isfreezed = bl;
    }

    protected boolean isIsfreezed() {
        return this.isfreezed;
    }

    protected void setNodoSalvado(Object object) {
        this.nodoSalvado = object;
    }

    protected Object getNodoSalvado() {
        return this.nodoSalvado;
    }
}

