/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.utilidades.IFileWriterAEAT;
import es.aeat.pftw.mtrc.api.utilidades.IWriterAEAT;
import es.aeat.pftw.mtrc.imp.utilidades.StringAEAT;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class FileWriterAEAT
extends FileOutputStream
implements Serializable,
IWriterAEAT,
IFileWriterAEAT {
    private static final long serialVersionUID = 3854178989212345757L;
    private String newLine = "\r\n";
    private String charset = "ISO-8859-1";
    private boolean escribirAlCerrar = false;
    private List<byte[]> cadenas = new ArrayList<byte[]>();

    public FileWriterAEAT(File file) throws IOException {
        super(file);
    }

    public FileWriterAEAT(File file, boolean bl) throws IOException {
        super(file, bl);
    }

    public FileWriterAEAT(FileDescriptor fileDescriptor) throws IOException {
        super(fileDescriptor);
    }

    public FileWriterAEAT(String string) throws IOException {
        super(string);
    }

    public FileWriterAEAT(String string, boolean bl) throws IOException {
        super(string, bl);
    }

    protected void comunWrite(byte[] byArray) throws ExceptionMotor {
        try {
            if (this.isEscribirAlCerrar()) {
                this.cadenas.add(byArray);
            } else {
                this.write(byArray);
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void writeln() throws ExceptionMotor {
        try {
            this.comunWrite(this.newLine.getBytes(this.charset));
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void writeln(String string) throws ExceptionMotor {
        try {
            this.writeln(string.getBytes(this.charset));
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void writeln(byte[] byArray) throws IOException {
        try {
            this.comunWrite(byArray);
            this.comunWrite(this.newLine.getBytes(this.charset));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw new IOException(exceptionMotor.getMessage());
        }
    }

    @Override
    public void write(String string) throws ExceptionMotor {
        try {
            this.comunWrite(string.getBytes(this.charset));
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isEscribirAlCerrar()) {
            for (byte[] byArray : this.cadenas) {
                this.write(byArray);
            }
        }
        super.close();
    }

    @Override
    public void setEscribirAlCerrar(boolean bl) {
        this.escribirAlCerrar = bl;
    }

    @Override
    public boolean isEscribirAlCerrar() {
        return this.escribirAlCerrar;
    }

    @Override
    public List<byte[]> getCadenas() {
        return this.cadenas;
    }

    @Override
    public void sobreEscribirContenido(String string) throws ExceptionMotor {
        try {
            if (!this.isEscribirAlCerrar()) {
                throw new ExceptionMotor("Accion no soportada!!!");
            }
            this.cadenas.clear();
            this.write(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String toString() {
        try {
            StringAEAT stringAEAT = new StringAEAT();
            for (byte[] byArray : this.getCadenas()) {
                stringAEAT.append(new String(byArray));
            }
            return stringAEAT.getString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return super.toString();
        }
    }
}

