/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.utilidades.IFicherosIntermedios;
import es.aeat.pftw.mtrc.api.utilidades.IFileReaderBytes;
import es.aeat.pftw.mtrc.imp.utilidades.ByteWriterAEAT;
import es.aeat.pftw.mtrc.imp.utilidades.FileReaderBytes;
import java.io.Serializable;

public final class FicherosIntermedios
implements Serializable,
IFicherosIntermedios {
    private static final long serialVersionUID = -4365901580106149777L;
    private int hashRutaFicheroAValidarReal = -1;
    private byte[] rutaFicheroAValidarVirtualLectura = null;
    private ByteWriterAEAT fw = null;
    private IFileReaderBytes fr = null;
    private boolean usarVirtual = false;

    @Override
    public void inicializa() {
        this.hashRutaFicheroAValidarReal = -1;
        this.rutaFicheroAValidarVirtualLectura = null;
        this.fw = null;
        this.fr = null;
        this.usarVirtual = false;
    }

    @Override
    public IFileReaderBytes abrirFichero(byte[] byArray) throws ExceptionMotor {
        try {
            this.fr = null;
            this.fw = null;
            if (this.hashRutaFicheroAValidarReal != byArray.hashCode()) {
                this.hashRutaFicheroAValidarReal = byArray.hashCode();
                this.rutaFicheroAValidarVirtualLectura = (byte[])byArray.clone();
            }
            this.fr = new FileReaderBytes(this.rutaFicheroAValidarVirtualLectura);
            this.fw = new ByteWriterAEAT();
            return this.fr;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean nuevaLinea(String string, boolean bl) throws ExceptionMotor {
        try {
            if (bl) {
                this.usarVirtual = true;
            }
            if (string != null) {
                this.fw.write(string);
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean saltoDeLinea(boolean bl) throws ExceptionMotor {
        try {
            if (bl) {
                this.usarVirtual = true;
            }
            this.fw.writeln();
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void forzarAUsarElVirtual() {
        this.usarVirtual = true;
    }

    @Override
    public boolean cerrarFichero() throws ExceptionMotor {
        try {
            if (this.usarVirtual) {
                this.rutaFicheroAValidarVirtualLectura = this.fw.getBytes();
            }
            if (this.fw != null) {
                this.fw.close();
            }
            this.fw = null;
            if (this.fr != null) {
                this.fr.close();
            }
            this.fr = null;
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean eliminarFicheroVirtual() throws ExceptionMotor {
        try {
            this.rutaFicheroAValidarVirtualLectura = null;
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        this.inicializa();
    }
}

