/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.puente;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.api.puente.IListaTablaMotor;
import es.aeat.pftw.mtrc.api.puente.ITablaMotor;
import es.aeat.pftw.mtrc.api.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrc.api.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.imp.puente.ListaTablaMotor;
import es.aeat.pftw.mtrc.imp.utilidades.FileWriterAEAT;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TablaMotor
implements Serializable,
ITablaMotor {
    private static final long serialVersionUID = 9100377804845122631L;
    public static long contadorIds = 0L;
    private String nombre;
    private String nombreTablaPadre = "";
    private int nivel;
    private IListaTablaMotor relacionadas;
    private long claveActiva;
    private long claveUnica;
    private long claveSuperior;
    private long claveUnicaSuperior;
    private ITablaMotor ptrTablaPadre = null;
    private IOrigenDatos origenDatosRef = null;
    private ISesion sesion = null;
    private Map<String, Object> cachePartidas = null;
    private Map<String, Integer> cacheEstados = null;

    public TablaMotor(String string, ITablaMotor iTablaMotor, ISesion iSesion) throws ExceptionMotor {
        this.sesion = iSesion;
        if (iSesion != null) {
            this.origenDatosRef = iSesion.getOrigenDeDatos();
        }
        this.claveUnica = this.origenDatosRef != null && !this.origenDatosRef.isCreacionIDUnicoAutomatico() ? 0L : ++contadorIds;
        this.claveActiva = 0L;
        this.claveSuperior = 0L;
        this.nombre = string;
        this.ptrTablaPadre = iTablaMotor;
        this.nombreTablaPadre = "";
        this.relacionadas = new ListaTablaMotor();
        if (this.ptrTablaPadre != null) {
            this.nombreTablaPadre = iTablaMotor.getNombre();
        }
        this.cachePartidas = new HashMap<String, Object>();
        this.cacheEstados = new HashMap<String, Integer>();
    }

    @Override
    public ISesion getSesion() {
        return this.sesion;
    }

    @Override
    public String getNombre() {
        return this.nombre;
    }

    @Override
    public String getNombreTablaPadre() {
        return this.nombreTablaPadre;
    }

    @Override
    public int getNivel() {
        return this.nivel;
    }

    @Override
    public IListaTablaMotor getRelacionadas() {
        return this.relacionadas;
    }

    @Override
    public void setRelacionadas(IListaTablaMotor iListaTablaMotor) {
        this.relacionadas = iListaTablaMotor;
    }

    @Override
    public void setNombre(String string) {
        this.nombre = string;
    }

    @Override
    public void setNombreTablaPadre(String string) {
        this.nombreTablaPadre = string;
    }

    @Override
    public void setNivel(int n) {
        this.nivel = n;
    }

    @Override
    public ITablaMotor getTablaMotor(String string) {
        if (string.equalsIgnoreCase(this.nombre)) {
            return this;
        }
        return this.relacionadas.getTablaMotor(string);
    }

    @Override
    public ITablaMotor getTablaMotor(Integer n) {
        return this.relacionadas.getTablaMotor(n);
    }

    @Override
    public long getClaveActiva() {
        return this.claveActiva;
    }

    @Override
    public long getClaveUnica() {
        return this.claveUnica;
    }

    @Override
    public long getClaveSuperior() {
        return this.claveSuperior;
    }

    @Override
    public long getClaveUnicaSuperior() {
        return this.claveUnicaSuperior;
    }

    @Override
    public void setClaveSuperior(long l) {
        this.claveSuperior = l;
    }

    @Override
    public void setClaveUnicaSuperior(long l) {
        this.claveUnicaSuperior = l;
    }

    @Override
    public void setClaveActiva(long l) {
        if (l < 0L) {
            l = 0L;
        }
        this.claveActiva = l;
    }

    @Override
    public void setClaveUnica(long l) {
        this.claveUnica = l;
    }

    @Override
    public boolean establecerEstado(String string, String string2) throws ExceptionMotor {
        return this.establecerEstado(string, Integer.valueOf(string2));
    }

    @Override
    public boolean establecerEstado(String string, Integer n) throws ExceptionMotor {
        try {
            if (this.origenDatosRef.getDifferedWrite() == 1) {
                this.cacheEstados.put(string, n);
                return true;
            }
            return this.origenDatosRef.establecerEstado((ITablaMotor)this, string, n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void setPtrTablaPadre(ITablaMotor iTablaMotor) {
        this.ptrTablaPadre = iTablaMotor;
    }

    @Override
    public ITablaMotor getPtrTablaPadre() {
        return this.ptrTablaPadre;
    }

    @Override
    public int obtenerEstado(String string) throws ExceptionMotor {
        try {
            if (this.origenDatosRef.getDifferedWrite() == 1) {
                Integer n = this.cacheEstados.get(string);
                if (n == null) {
                    return this.sesion.getModelo().getGestorConfiguracion().getEntrada(string).getEstadoInicial();
                }
                return Integer.valueOf(((Object)n).toString());
            }
            return this.origenDatosRef.obtenerEstado(this, string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String obtenerPartidaString(String string, int n) throws ExceptionMotor {
        try {
            return this.origenDatosRef.obtenerPartidaString(this, string, n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String obtenerPartidaString(String string) throws ExceptionMotor {
        try {
            if (this.origenDatosRef.getDifferedWrite() == 1) {
                Object object = this.cachePartidas.get(string);
                if (object == null) {
                    return this.sesion.getModelo().getGestorConfiguracion().getEntrada(string).getValorInicial();
                }
                return object.toString();
            }
            return this.origenDatosRef.obtenerPartidaString(this, string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void cerrarTabla() {
        for (int i = 0; i < this.relacionadas.count(); ++i) {
            this.relacionadas.getTablaMotor(i).cerrarTabla();
        }
        this.claveUnicaSuperior = 0L;
        this.claveSuperior = 0L;
        this.claveActiva = 0L;
        this.claveUnica = 0L;
    }

    private String ordenaCamposParaPrintTree(Map<String, ITablaMotorEntrada> map) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            Collection<ITablaMotorEntrada> collection = map.values();
            Iterator<ITablaMotorEntrada> iterator = collection.iterator();
            ITablaMotorEntrada iTablaMotorEntrada = null;
            while (iterator.hasNext()) {
                iTablaMotorEntrada = iterator.next();
                arrayList.add(iTablaMotorEntrada.getNombreEntrada() + " = " + iTablaMotorEntrada.getValor() + " (" + iTablaMotorEntrada.getEstado() + ")");
            }
            Collections.sort(arrayList);
            return ((Object)arrayList).toString();
        }
        catch (Exception exception) {
            return "Error al obtener campos";
        }
    }

    private String prvPrintTree(String string, boolean bl) throws ExceptionMotor {
        String string2 = string + " ";
        for (int i = 0; i < new String("+TABLA     : " + this.nombre).length() - 1; ++i) {
            string2 = string2 + "=";
        }
        String string3 = string2 + "\n" + string + "+TABLA     : " + this.nombre + "\n";
        string3 = string3 + string2;
        string3 = string3 + string + " ID LOGICO : " + this.claveActiva + "\n";
        string3 = string3 + string + " ID FISICO : " + this.claveUnica + "\n";
        string3 = string3 + string + " IDINF     : " + this.claveSuperior + "\n";
        String string4 = "Null";
        Map<String, ITablaMotorEntrada> map = this.getRsDatosReferencia();
        if (map != null && map.size() > 0) {
            string4 = this.ordenaCamposParaPrintTree(map);
        }
        string3 = string3 + string + " DATOS     : " + string4 + "\n";
        string4 = "Null";
        if (bl) {
            string3 = ";" + this.nombre + ";";
        }
        if (this.relacionadas != null) {
            TablaMotor tablaMotor = null;
            for (int i = 0; i < this.relacionadas.count(); ++i) {
                tablaMotor = (TablaMotor)this.relacionadas.getTablaMotor(i);
                if (tablaMotor == null) continue;
                string3 = string3 + tablaMotor.prvPrintTree(string + "   ", bl);
            }
            tablaMotor = null;
        }
        return string3;
    }

    @Override
    public String printTree() throws ExceptionMotor {
        try {
            String string = "//////////////////////////////////////////////////////////\n";
            return string + "INFORMACI\u00d3N NODO :\n" + this.prvPrintTree(" ", false) + "\n" + string;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean writeTree(String string) {
        try {
            FileWriterAEAT fileWriterAEAT = new FileWriterAEAT(string);
            String string2 = this.printTree();
            String string3 = "";
            for (int i = 0; i < string2.length(); ++i) {
                if (string2.charAt(i) == '\n') {
                    fileWriterAEAT.writeln(string3);
                    string3 = "";
                    continue;
                }
                string3 = string3 + string2.charAt(i);
            }
            if (string3.length() > 0) {
                fileWriterAEAT.writeln(string3);
            }
            fileWriterAEAT.close();
            fileWriterAEAT = null;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String dameListaTablas() throws ExceptionMotor {
        try {
            return this.prvPrintTree("", true);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Map<String, ITablaMotorEntrada> rsDatosClone() throws ExceptionMotor {
        try {
            return (Map)((HashMap)this.getRsDatosReferencia()).clone();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Map<String, ITablaMotorEntrada> getRsDatosReferencia() throws ExceptionMotor {
        try {
            return this.origenDatosRef.obtenerRegistroFiltroEnPosicion(this);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean limpiaRegistro() throws ExceptionMotor {
        try {
            return this.origenDatosRef.limpiaRegistro(this);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected Map<String, ITablaMotorEntrada> clonaRsDatos(Map<String, ITablaMotorEntrada> map) throws ExceptionMotor {
        try {
            if (map == null) {
                return null;
            }
            HashMap<String, ITablaMotorEntrada> hashMap = new HashMap<String, ITablaMotorEntrada>();
            String string2 = "";
            Set<String> set = map.keySet();
            ITablaMotorEntrada iTablaMotorEntrada = new TablaMotorEntrada("");
            if (!iTablaMotorEntrada.checkNumeroParametrosParaClonar()) {
                throw new ExceptionMotor("Error no puedo clonar rsDatos");
            }
            iTablaMotorEntrada = null;
            for (String string2 : set) {
                iTablaMotorEntrada = map.get(string2);
                TablaMotorEntrada tablaMotorEntrada = new TablaMotorEntrada(iTablaMotorEntrada.getNombreEntrada());
                tablaMotorEntrada.setNombreEntrada(iTablaMotorEntrada.getNombreEntrada());
                tablaMotorEntrada.setEstado(iTablaMotorEntrada.getEstado());
                tablaMotorEntrada.setValor(iTablaMotorEntrada.getValor());
                hashMap.put(string2, tablaMotorEntrada);
                tablaMotorEntrada = null;
            }
            return hashMap;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String getLocalizacion(ITablaMotor iTablaMotor) {
        if (this.getNombreTablaPadre() == null || this.getNombreTablaPadre().length() == 0) {
            return String.valueOf(this.getClaveActiva());
        }
        return iTablaMotor.getTablaMotor(this.getNombreTablaPadre()).getLocalizacion(iTablaMotor) + "-" + this.getClaveActiva();
    }

    @Override
    public long getRecordCount() throws ExceptionMotor {
        return this.origenDatosRef.recordCount(this);
    }

    @Override
    public List<ITipoDatosCampoValor> getLocalizacion() throws ExceptionMotor {
        ArrayList<ITipoDatosCampoValor> arrayList = new ArrayList<ITipoDatosCampoValor>();
        try {
            for (ITablaMotor iTablaMotor = this; iTablaMotor != null; iTablaMotor = iTablaMotor.getPtrTablaPadre()) {
                arrayList.add(0, new TipoDatosCampoValor(iTablaMotor.getNombre(), String.valueOf(iTablaMotor.getClaveActiva())));
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<Object> lightClone() throws ExceptionMotor {
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.getClaveUnica());
            arrayList.add(this.getClaveActiva());
            arrayList.add(this.getClaveSuperior());
            arrayList.add(this.getClaveUnicaSuperior());
            ArrayList<List<Object>> arrayList2 = null;
            IListaTablaMotor iListaTablaMotor = this.getRelacionadas();
            for (int i = 0; i < iListaTablaMotor.count(); ++i) {
                ITablaMotor iTablaMotor = iListaTablaMotor.getTablaMotor(i);
                if (iTablaMotor == null) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<List<Object>>();
                }
                arrayList2.add(iTablaMotor.lightClone());
                arrayList2.add((List<Object>)i);
                iTablaMotor = null;
            }
            arrayList.add(arrayList2);
            return arrayList;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean overwriteLightClone(List<Object> list, boolean bl) throws ExceptionMotor {
        try {
            if (!bl && (Long)list.get(1) == 0L && this.getClaveActiva() > 0L && this.getSesion().getOperaciones().recordCount(this.nombre) > 0L && this.getSesion().getOperaciones().moveFirst(this.nombre) > 0L) {
                return true;
            }
            this.setClaveUnica((Long)list.get(0));
            this.setClaveActiva((Long)list.get(1));
            this.setClaveSuperior((Long)list.get(2));
            this.setClaveUnicaSuperior((Long)list.get(3));
            List list2 = (List)list.get(4);
            IListaTablaMotor iListaTablaMotor = this.getRelacionadas();
            if (list2 != null) {
                for (int i = 0; i < list2.size() - 1; i += 2) {
                    iListaTablaMotor.getTablaMotor((Integer)list2.get(i + 1)).overwriteLightClone((List)list2.get(i), bl);
                }
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public ITablaMotor clone(ISesion iSesion) throws CloneNotSupportedException, ExceptionMotor {
        try {
            TablaMotor tablaMotor = new TablaMotor(this.getNombre(), this.getPtrTablaPadre(), this.sesion);
            if (iSesion == null) {
                tablaMotor.sesion = null;
                tablaMotor.origenDatosRef = null;
            } else {
                tablaMotor.sesion = iSesion;
                tablaMotor.origenDatosRef = iSesion.getOrigenDeDatos();
            }
            tablaMotor.setClaveUnica(this.getClaveUnica());
            tablaMotor.setClaveActiva(this.getClaveActiva());
            tablaMotor.setClaveSuperior(this.getClaveSuperior());
            tablaMotor.setClaveUnicaSuperior(this.getClaveUnicaSuperior());
            tablaMotor.setNivel(this.getNivel());
            tablaMotor.setNombre(this.getNombre());
            tablaMotor.setNombreTablaPadre(this.getNombreTablaPadre());
            IListaTablaMotor iListaTablaMotor = this.getRelacionadas();
            for (int i = 0; i < iListaTablaMotor.count(); ++i) {
                ITablaMotor iTablaMotor = iListaTablaMotor.getTablaMotor(i);
                if (iTablaMotor == null) continue;
                if (tablaMotor.getRelacionadas() == null) {
                    tablaMotor.setRelacionadas(new ListaTablaMotor());
                }
                tablaMotor.getRelacionadas().setTablaMotor(iTablaMotor.clone(iSesion), i);
                tablaMotor.getRelacionadas().getTablaMotor(i).setPtrTablaPadre(tablaMotor);
                iTablaMotor = null;
            }
            return tablaMotor;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public ITablaMotor clone() throws CloneNotSupportedException {
        try {
            return this.clone(this.sesion);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw new CloneNotSupportedException(exceptionMotor.getMessage());
        }
    }

    @Override
    public String toString() {
        return this.getNombre() + " (ID " + this.getClaveActiva() + " IDINF " + this.getClaveSuperior() + " IDUNICO " + this.getClaveUnica() + ")";
    }

    @Override
    public String toDetailedString() {
        try {
            String string = "";
            List<ITipoDatosCampoValor> list = this.getLocalizacion();
            for (int i = 0; i < list.size(); ++i) {
                string = string + "//" + list.get(i).getNombreCampo() + "[" + list.get(i).getValor() + "]";
            }
            if (string.length() == 0) {
                return this.toString();
            }
            return string;
        }
        catch (Exception exception) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(exception);
            return this.toString();
        }
    }

    @Override
    public boolean establecerPartida(String string, Object object) throws ExceptionMotor {
        try {
            if (this.origenDatosRef.getDifferedWrite() == 1) {
                this.cachePartidas.put(string, object);
                return true;
            }
            return this.origenDatosRef.establecerPartida((ITablaMotor)this, string, object);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Map<String, Object> getCachePartidas() {
        return this.cachePartidas;
    }

    @Override
    public Map<String, Integer> getCacheEstados() {
        return this.cacheEstados;
    }
}

