/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.puente;

import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import es.aeat.pftw.mtrc.api.configuracion.IRegRelacionada;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.excepciones.NotImplementedException;
import es.aeat.pftw.mtrc.api.motor.IPartidaModificada;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.api.procesadorReglas.IPartidaModificadaReglas;
import es.aeat.pftw.mtrc.api.puente.IGestionOperaciones;
import es.aeat.pftw.mtrc.api.puente.IListaTablaMotor;
import es.aeat.pftw.mtrc.api.puente.IRegTablaModificada;
import es.aeat.pftw.mtrc.api.puente.ITablaMotor;
import es.aeat.pftw.mtrc.api.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrc.api.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCriteriosOrdenacion;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosRegistro;
import es.aeat.pftw.mtrc.api.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.utilidades.INodoArbol;
import es.aeat.pftw.mtrc.imp.procesadorReglas.PartidaModificada;
import es.aeat.pftw.mtrc.imp.puente.RegTablaModificada;
import es.aeat.pftw.mtrc.imp.tipos.TipoDatosRegistro;
import es.aeat.pftw.mtrc.imp.tipos.TipoListaPartidasAfectadasEnUnaEjecucion;
import es.aeat.pftw.mtrc.imp.utilidades.Formatear;
import es.aeat.pftw.mtrc.imp.utilidades.FreezerMotor;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.imp.utilidades.NodoArbol;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GestionOperaciones
implements IGestionOperaciones {
    private static final long serialVersionUID = 489254633859924375L;
    private Map<String, Boolean> tablasAnteriores = new HashMap<String, Boolean>();
    private boolean actualizando = false;

    @Override
    public void dispose() {
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
    }

    @Override
    public void recorrerNodosHijos(ISesion iSesion, ITablaMotor iTablaMotor) throws ExceptionMotor {
        block5: {
            ITablaMotor iTablaMotor2 = null;
            try {
                if (iTablaMotor.getRelacionadas() != null) {
                    for (int i = 0; i < iTablaMotor.getRelacionadas().count(); ++i) {
                        iTablaMotor2 = iTablaMotor.getRelacionadas().getTablaMotor(i);
                        this.actualizarNodo(iSesion, iTablaMotor2, iTablaMotor);
                    }
                }
            }
            catch (Exception exception) {
                if (((ISesionExtendida)iSesion).isModoSilencioso()) break block5;
                if (exception instanceof ExceptionMotor) {
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception);
            }
        }
    }

    protected void actualizarNodo(ISesion iSesion, ITablaMotor iTablaMotor, ITablaMotor iTablaMotor2) throws ExceptionMotor {
        try {
            iTablaMotor.cerrarTabla();
            iTablaMotor.setClaveSuperior(iTablaMotor2.getClaveActiva());
            iTablaMotor.setClaveUnicaSuperior(iTablaMotor2.getClaveUnica());
            this.moveFirst(iSesion, iTablaMotor.getNombre());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected void anniadirTablaAListaAfectadasEnUnaEjecucion(ISesion iSesion, String string, IRegTablaModificada iRegTablaModificada) throws ExceptionMotor {
        try {
            List<IRegTablaModificada> list = ((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(string.toUpperCase());
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (iRegTablaModificada.getIdInf() != list.get(i).getIdInf() || iRegTablaModificada.getId() != list.get(i).getId()) continue;
                    if (iRegTablaModificada.getAccion().equalsIgnoreCase(list.get(i).getAccion())) {
                        return;
                    }
                    if (iRegTablaModificada.getAccion().equalsIgnoreCase("del")) {
                        ((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(string.toUpperCase()).remove(i);
                        return;
                    }
                    if (!iRegTablaModificada.getAccion().equalsIgnoreCase("add")) continue;
                    ((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(string.toUpperCase()).remove(i);
                    ((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(string.toUpperCase()).add(iRegTablaModificada);
                    return;
                }
                ((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(string.toUpperCase()).add(iRegTablaModificada);
            } else {
                list = new ArrayList<IRegTablaModificada>();
                list.add(iRegTablaModificada);
                ((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().put(string.toUpperCase(), list);
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean borrarRegistros(ISesion iSesion, String string) throws ExceptionMotor {
        if (((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
        }
        if (iSesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio", Thread.currentThread().getStackTrace());
        }
        boolean bl = iSesion.getOrigenDeDatos().isCacheHabilitada();
        try {
            long l = 0L;
            iSesion.getOrigenDeDatos().setCacheHabilitada(false);
            while (this.recordCount(iSesion, string) != 0L && (l = this.moveFirst(iSesion, string)) != 0L) {
                this.borrarRegistro(iSesion, string);
            }
            if (!this.refrescarClaveActivaNodo(iSesion, string)) {
                throw new ExceptionMotor("No se consigue refrescar la clave activa del nodo " + string, Thread.currentThread().getStackTrace());
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            iSesion.getOrigenDeDatos().setCacheHabilitada(bl);
        }
    }

    @Override
    public boolean borrarTodosLosRegistrosDeTabla(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            if (((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            if (iSesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio", Thread.currentThread().getStackTrace());
            }
            ITablaMotor iTablaMotor = null;
            iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                return false;
            }
            ITablaMotor iTablaMotor2 = null;
            if (!iTablaMotor.getNombreTablaPadre().equalsIgnoreCase("")) {
                iTablaMotor2 = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(iTablaMotor.getNombreTablaPadre(), ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
                long l = iTablaMotor2.getClaveActiva();
                if (this.recordCount(iSesion, string) > 0L) {
                    this.moveFirst(iSesion, iTablaMotor2.getNombre());
                    while (true) {
                        this.borrarRegistros(iSesion, string);
                        if (this.recordCount(iSesion, string) == 0L) break;
                        this.moveNext(iSesion, iTablaMotor2.getNombre());
                    }
                    this.move(iSesion, iTablaMotor2.getNombre(), l);
                }
            } else {
                this.borrarRegistros(iSesion, string);
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected boolean refrescarClaveActivaNodo(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor;
            ITablaMotor iTablaMotor2 = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor2 != null && (iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(iTablaMotor2.getNombreTablaPadre(), ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()))) != null) {
                iTablaMotor2.setClaveSuperior(iTablaMotor.getClaveActiva());
                iTablaMotor2.setClaveUnicaSuperior(iTablaMotor.getClaveUnica());
            }
            return true;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return false;
        }
    }

    protected boolean borraRegistro(ISesion iSesion, ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            String string = iTablaMotor.getNombre() + "_ANTES_BORRAR";
            if (iSesion.getModelo().getGestorConfiguracion().getEntrada(string) != null && !iSesion.getGestionReglas().ejecutaReglasDePartida(string)) {
                return false;
            }
            boolean bl = iSesion.getOrigenDeDatos().borrarRegistro(iTablaMotor);
            if (bl) {
                this.anniadirTablaAListaAfectadasEnUnaEjecucion(iSesion, iTablaMotor.getNombre(), new RegTablaModificada(iSesion, iTablaMotor, "del"));
                string = iTablaMotor.getNombre() + "_DESPUES_BORRAR";
                if (iSesion.getModelo().getGestorConfiguracion().getEntrada(string) != null) {
                    iSesion.getGestionReglas().ejecutaReglasDePartida(string);
                }
                int n = iSesion.getOrigenDeDatos().getRecordCountTotal();
                this.establecerPartida(iSesion, "CON_REG", n);
            }
            this.actualizaPunterosSiProcede(iSesion, iTablaMotor);
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long borrarRegistro(ISesion iSesion, String string) throws ExceptionMotor {
        if (((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
        }
        if (iSesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio", Thread.currentThread().getStackTrace());
        }
        if (string == null) {
            throw new ExceptionMotor("No se ha especificado que tabla se desea borrar!!!");
        }
        if (string.equalsIgnoreCase(iSesion.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla())) {
            throw new ExceptionMotor("No se puede eliminar la tabla de nivel 0");
        }
        boolean bl = iSesion.getOrigenDeDatos().isCacheHabilitada();
        boolean bl2 = false;
        try {
            iSesion.getOrigenDeDatos().setCacheHabilitada(false);
            long l = 0L;
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor != null && iTablaMotor.getClaveActiva() != 0L) {
                if (((ISesionExtendida)iSesion).isModoSilencioso() || !((ISesionExtendida)iSesion).inTrans()) {
                    bl2 = ((ISesionExtendida)iSesion).beginTrans();
                }
                if (this.borraRegistro(iSesion, iTablaMotor)) {
                    this.anniadirTablaAListaAfectadasEnUnaEjecucion(iSesion, string, new RegTablaModificada(iSesion, iTablaMotor, "del"));
                    iTablaMotor.setClaveActiva(-1L);
                    this.moveFirst(iSesion, string);
                    ((ISesionExtendida)iSesion).actualizarPunterosTablas(iTablaMotor);
                }
                l = iTablaMotor.getClaveActiva();
                if (bl2) {
                    ((ISesionExtendida)iSesion).commitTrans();
                }
            } else {
                l = 0L;
            }
            long l2 = l;
            return l2;
        }
        catch (Exception exception) {
            if (bl2) {
                ((ISesionExtendida)iSesion).rollBack();
            }
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            long l = 0L;
            return l;
        }
        finally {
            iSesion.getOrigenDeDatos().setCacheHabilitada(bl);
        }
    }

    @Override
    public long move(ISesion iSesion, String string, long l) throws ExceptionMotor {
        return this.moveprv(iSesion, string, l);
    }

    protected long moveprv(ISesion iSesion, String string, long l) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor != null) {
                long l2;
                if (iTablaMotor.getNivel() == 0 && l != iTablaMotor.getClaveActiva()) {
                    return iTablaMotor.getClaveActiva();
                }
                if (l == 0L) {
                    return iTablaMotor.getClaveActiva();
                }
                if (l < 0L) {
                    l = 1L;
                }
                if ((l2 = iSesion.getOrigenDeDatos().recordCount(iTablaMotor)) == 0L) {
                    iTablaMotor.setClaveActiva(0L);
                    iTablaMotor.setClaveUnica(0L);
                } else if (l2 >= l) {
                    iTablaMotor.setClaveActiva(l);
                    if (iTablaMotor.getNivel() != 0) {
                        iTablaMotor.setClaveUnica(0L);
                        iTablaMotor.setClaveUnica(this.dameIDDeTablaMotor(iSesion, iTablaMotor));
                    }
                    ((ISesionExtendida)iSesion).actualizarPunterosTablas(iTablaMotor);
                }
                this.actualizaPunterosSiProcede(iSesion, iTablaMotor);
                return iTablaMotor.getClaveActiva();
            }
            return 0L;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return 0L;
        }
    }

    @Override
    public long recordCount(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                return 0L;
            }
            return iSesion.getOrigenDeDatos().recordCount(iTablaMotor);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    protected long dameIDDeTablaMotor(ISesion iSesion, ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            String string = iSesion.getOrigenDeDatos().obtenerPartidaString(iTablaMotor, "ID");
            if (string == null || Long.valueOf(string) == -1L) {
                ITablaMotorEntrada iTablaMotorEntrada;
                Map<String, ITablaMotorEntrada> map = iSesion.getOrigenDeDatos().obtenerRegistroFiltroEnPosicion(iTablaMotor);
                if (map != null && (iTablaMotorEntrada = map.get("ID")) != null) {
                    return Long.valueOf(iTablaMotorEntrada.getValor().toString());
                }
                return 0L;
            }
            return Long.valueOf(string);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public boolean moveFirstTodos(ISesion iSesion) throws ExceptionMotor {
        try {
            String string = iSesion.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla();
            return 1L == this.move(iSesion, string, 1L);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public long moveFirst(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = null;
            ITablaMotor iTablaMotor2 = null;
            iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor != null) {
                if (iTablaMotor.getNivel() == 0) {
                    return iTablaMotor.getClaveActiva();
                }
                iTablaMotor2 = ((ISesionExtendida)iSesion).obtenerNodoTabla(iTablaMotor.getNombreTablaPadre());
                long l = 0L;
                if (iTablaMotor2 == null || iTablaMotor2.getClaveActiva() != 0L) {
                    l = iSesion.getOrigenDeDatos().recordCount(iTablaMotor);
                }
                if (l != 0L) {
                    iTablaMotor.setClaveActiva(1L);
                    iTablaMotor.setClaveUnica(0L);
                    iTablaMotor.setClaveUnica(this.dameIDDeTablaMotor(iSesion, iTablaMotor));
                } else {
                    iTablaMotor.setClaveActiva(0L);
                    iTablaMotor.setClaveUnica(0L);
                }
                ((ISesionExtendida)iSesion).actualizarPunterosTablas(iTablaMotor);
                return iTablaMotor.getClaveActiva();
            }
            return 0L;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public boolean hasNext(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            long l;
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            return iTablaMotor != null && (l = iSesion.getOrigenDeDatos().recordCount(iTablaMotor)) != 0L && iTablaMotor.getClaveActiva() != l;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return false;
        }
    }

    @Override
    public boolean moveIfHasNext(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            if (this.hasNext(iSesion, string)) {
                this.moveNext(iSesion, string);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return false;
        }
    }

    @Override
    public long moveNext(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor != null) {
                if (iTablaMotor.getNivel() == 0) {
                    return iTablaMotor.getClaveActiva();
                }
                long l = iSesion.getOrigenDeDatos().recordCount(iTablaMotor);
                if (l != 0L) {
                    if (iTablaMotor.getClaveActiva() != l) {
                        iTablaMotor.setClaveActiva(iTablaMotor.getClaveActiva() + 1L);
                        iTablaMotor.setClaveUnica(0L);
                        iTablaMotor.setClaveUnica(this.dameIDDeTablaMotor(iSesion, iTablaMotor));
                        ((ISesionExtendida)iSesion).actualizarPunterosTablas(iTablaMotor);
                    }
                } else {
                    iTablaMotor.setClaveActiva(0L);
                }
                return iTablaMotor.getClaveActiva();
            }
            return 0L;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return 0L;
        }
    }

    @Override
    public long moveLast(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor != null) {
                if (iTablaMotor.getNivel() == 0) {
                    return iTablaMotor.getClaveActiva();
                }
                long l = iSesion.getOrigenDeDatos().recordCount(iTablaMotor);
                if (l != 0L) {
                    if (iTablaMotor.getClaveActiva() != l) {
                        iTablaMotor.setClaveActiva(l);
                        iTablaMotor.setClaveUnica(0L);
                        iTablaMotor.setClaveUnica(this.dameIDDeTablaMotor(iSesion, iTablaMotor));
                        ((ISesionExtendida)iSesion).actualizarPunterosTablas(iTablaMotor);
                    }
                } else {
                    iTablaMotor.setClaveActiva(0L);
                }
                return iTablaMotor.getClaveActiva();
            }
            return 0L;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return 0L;
        }
    }

    @Override
    public long movePrevious(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor != null) {
                long l = iSesion.getOrigenDeDatos().recordCount(iTablaMotor);
                if (l != 0L) {
                    if (iTablaMotor.getNivel() == 0) {
                        return iTablaMotor.getClaveActiva();
                    }
                    if (iTablaMotor.getClaveActiva() > 1L) {
                        iTablaMotor.setClaveActiva(iTablaMotor.getClaveActiva() - 1L);
                        iTablaMotor.setClaveUnica(0L);
                        iTablaMotor.setClaveUnica(this.dameIDDeTablaMotor(iSesion, iTablaMotor));
                        ((ISesionExtendida)iSesion).actualizarPunterosTablas(iTablaMotor);
                    }
                } else {
                    iTablaMotor.setClaveActiva(0L);
                }
                return iTablaMotor.getClaveActiva();
            }
            return 0L;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return 0L;
        }
    }

    @Override
    public ITablaMotorEntrada obtenerPartidayEstado(ISesion iSesion, String string) throws ExceptionMotor {
        return new TablaMotorEntrada(string, this.obtenerPartidaString(iSesion, string), this.obtenerEstadoPartida(iSesion, string));
    }

    @Override
    public String obtenerPartidaIndexada(ISesion iSesion, String string, int n) throws ExceptionMotor {
        return this.obtenerPartidaString(iSesion, string, null, n);
    }

    @Override
    public String obtenerPartidaString(ISesion iSesion, String string) throws ExceptionMotor {
        return this.obtenerPartidaString(iSesion, string, null);
    }

    @Override
    public String obtenerPartidaString(ISesion iSesion, String string, Map<String, String> map) throws ExceptionMotor {
        return this.obtenerPartidaString(iSesion, string, map, 0);
    }

    protected String obtenerPartidaString(ISesion iSesion, String string, Map<String, String> map, int n) throws ExceptionMotor {
        Object object = null;
        try {
            String string2 = ((ISesionExtendida)iSesion).buscarPartidaEnTabla(string);
            if (string2.length() == 0) {
                throw new ExceptionMotor("La partida '" + string + "' no se encuentra en ninguna tabla del modelo", Thread.currentThread().getStackTrace());
            }
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string2, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                throw new ExceptionMotor("La relaci\u00f3n que identifica la partida con su tabla no es correcta nombre de tabla: " + string2, Thread.currentThread().getStackTrace());
            }
            object = n != 0 ? iTablaMotor.obtenerPartidaString(string.toUpperCase(), n) : iTablaMotor.obtenerPartidaString(string.toUpperCase());
            if (object != null && object.toString().trim().length() == 0) {
                object = this.devolverValorDatoParseadoSegunTipo(iSesion, string);
            }
            if (object == null) {
                object = this.obtenerValorInicialPartida(iSesion, string);
            }
            if (object != null && object.toString().length() == 0 && iSesion.getModelo().getGestorConfiguracion().getEntrada(string).getTipoDato().equalsIgnoreCase("CADENA_NUMERICA")) {
                return "0";
            }
            return object.toString();
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Partida " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Partida " + string);
            }
            return null;
        }
    }

    @Override
    public String obtenerPartidaAnteriorDuranteReglaString(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            String string2 = ((ISesionExtendida)iSesion).buscarPartidaEnTabla(string);
            if (string2.length() == 0) {
                throw new ExceptionMotor("No encuentro nombre de entrada " + string, Thread.currentThread().getStackTrace());
            }
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string2);
            try {
                return ((ISesionExtendida)iSesion).getMapaPartidasAfectadasEnUnaEjecucion().get(string + "(" + iTablaMotor.getLocalizacion(((ISesionExtendida)iSesion).getNodoPrincipal()) + ")").getValorAnterior().toString();
            }
            catch (Exception exception) {
                return this.obtenerPartidaString(iSesion, string);
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    @Override
    public long obtenerClaveActiva(ISesion iSesion, String string) throws ExceptionMotor {
        long l = 0L;
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor == null) {
                throw new ExceptionMotor("No existe ninguna tabla con nombre " + string, Thread.currentThread().getStackTrace());
            }
            l = iTablaMotor.getClaveActiva();
            return l;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public long obtenerClaveSuperior(ISesion iSesion, String string) throws ExceptionMotor {
        long l = 0L;
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor == null) {
                throw new ExceptionMotor("No existe ninguna tabla con nombre " + string, Thread.currentThread().getStackTrace());
            }
            l = iTablaMotor.getClaveSuperior();
            return l;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int obtenerEstadoPartida(ISesion iSesion, String string) throws ExceptionMotor {
        boolean bl = ((ISesionExtendida)iSesion).isModoSilencioso();
        try {
            ((ISesionExtendida)iSesion).setModoSilencioso(true);
            String string2 = ((ISesionExtendida)iSesion).buscarPartidaEnTabla(string);
            if (string2.equalsIgnoreCase("")) {
                throw new ExceptionMotor("La partida '" + string + "' no se encuentra en ninguna tabla del modelo", Thread.currentThread().getStackTrace());
            }
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string2, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                throw new ExceptionMotor("La relaci\u00f3n que identifica la partida con su tabla no es correcta nombre de tabla: " + string2, Thread.currentThread().getStackTrace());
            }
            int n = iTablaMotor.obtenerEstado(string.toUpperCase());
            if (n == -1) {
                try {
                    int n2 = this.obtenerEstadoDefectoPartida(iSesion, string);
                    return n2;
                }
                catch (Exception exception) {
                    throw new ExceptionMotor(exception, "La partida " + string + " no se encuentra en Entradas");
                }
            }
            int n3 = n;
            return n3;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Partida " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Partida " + string);
            }
            int n = 0;
            return n;
        }
        finally {
            ((ISesionExtendida)iSesion).setModoSilencioso(bl);
        }
    }

    @Override
    public int obtenerEstadoPartidaAnteriorDuranteRegla(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            String string2 = ((ISesionExtendida)iSesion).buscarPartidaEnTabla(string);
            if (string2.length() == 0) {
                throw new ExceptionMotor("No encuentro nombre de entrada " + string, Thread.currentThread().getStackTrace());
            }
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string2);
            try {
                return ((ISesionExtendida)iSesion).getMapaPartidasAfectadasEnUnaEjecucion().get(string + "(" + iTablaMotor.getLocalizacion(((ISesionExtendida)iSesion).getNodoPrincipal()) + ")").getEstadoAnterior();
            }
            catch (Exception exception) {
                return iSesion.getOperaciones().obtenerEstadoPartida(string);
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    @Override
    public boolean estaVacioRegistroDatosTabla(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            boolean bl = true;
            Map<String, ITablaMotorEntrada> map = this.obtenerRegistroDatosTabla(iSesion, string);
            if (map == null) {
                return true;
            }
            List<String> list = iSesion.getModelo().getGestorConfiguracion().getCamposDeTabla(string);
            Set<String> set = map.keySet();
            Iterator<String> iterator = set.iterator();
            String string2 = "";
            String string3 = "";
            String string4 = "";
            IRegEntrada iRegEntrada = null;
            int n = -1;
            while (iterator.hasNext()) {
                string2 = iterator.next().toString();
                if (string2.equalsIgnoreCase("ID") || string2.equalsIgnoreCase("IDINF") || (n = list.indexOf(string2)) <= -1) continue;
                iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string2);
                string3 = FuncionesUtiles.getFuncionesUtiles().object2String(map.get(string2).getValor());
                string4 = FuncionesUtiles.getFuncionesUtiles().object2String(iRegEntrada.getValorInicial());
                if (iRegEntrada.getTipoDato().equalsIgnoreCase("DOBLE") || iRegEntrada.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    if (string4.length() == 0) {
                        string4 = "0";
                    }
                    if (string3.length() <= 0 || !((Boolean)iSesion.getMotor().getClaseOperaciones().evaluarOperacion(string3, string4, "!")).booleanValue()) continue;
                    return false;
                }
                if (iRegEntrada.getTipoDato().equalsIgnoreCase("LOGICO")) {
                    if (string4.length() == 0) {
                        string4 = "false";
                    }
                    if (string3.length() <= 0 || Boolean.valueOf(string3).toString().equalsIgnoreCase(Boolean.valueOf(string4).toString())) continue;
                    return false;
                }
                if (string3.trim().equalsIgnoreCase(iRegEntrada.getValorInicial().trim())) continue;
                return false;
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public boolean cerrarConexionOrigenDatos(ISesion iSesion) throws ExceptionMotor {
        try {
            return iSesion.getOrigenDeDatos().cerrarAlmacenamiento();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos(ISesion iSesion) throws ExceptionMotor {
        try {
            return this.abrirConexionOrigenDatos(iSesion, null);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos(ISesion iSesion, Object object) throws ExceptionMotor {
        try {
            return this.abrirConexionOrigenDatos(iSesion, object, null);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos(ISesion iSesion, Object object, Map<String, String> map) throws ExceptionMotor {
        try {
            return iSesion.getOrigenDeDatos().abrirAlmacenamiento(object, map);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public ITablaMotor getNodoPrincipal(ISesion iSesion) throws ExceptionMotor {
        try {
            return ((ISesionExtendida)iSesion).getNodoPrincipal();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void setNodoPrincipal(ISesion iSesion, ITablaMotor iTablaMotor) throws ExceptionMotor {
        ((ISesionExtendida)iSesion).setNodoPrincipal(iTablaMotor);
    }

    @Override
    public INodoArbol getArbolDatos(ISesion iSesion) throws ExceptionMotor {
        return this.concatenameNodos(((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
    }

    protected INodoArbol concatenameNodos(ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            NodoArbol nodoArbol = new NodoArbol(iTablaMotor.getNombre());
            IListaTablaMotor iListaTablaMotor = iTablaMotor.getRelacionadas();
            for (int i = 0; i < iListaTablaMotor.count(); ++i) {
                INodoArbol iNodoArbol = this.concatenameNodos((ITablaMotor)iListaTablaMotor.get(i));
                if (iNodoArbol == null) continue;
                nodoArbol.appendHijo(iNodoArbol);
            }
            return nodoArbol;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String getRegistroFicherosAuxiliares(ISesion iSesion, String string, String string2) throws ExceptionMotor {
        try {
            return iSesion.getModelo().getGestorDatosAuxiliares().getRegistro(string, string2);
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string + " clave " + string2);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string + " clave " + string2);
            }
            return "";
        }
    }

    @Override
    public String obtenerTipoPartida(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada != null) {
                return iRegEntrada.getTipoDato();
            }
            return null;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    @Override
    public long obtenerIdUnicoTabla(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor != null) {
                return iTablaMotor.getClaveUnica();
            }
            throw new ExceptionMotor("No existe ninguna tabla con nombre " + string, Thread.currentThread().getStackTrace());
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return 0L;
        }
    }

    @Override
    public String getLocalizacionEx(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor != null) {
                List<ITipoDatosCampoValor> list = iTablaMotor.getLocalizacion();
                String string2 = "";
                for (ITipoDatosCampoValor iTipoDatosCampoValor : list) {
                    if (string2.length() > 0) {
                        string2 = string2 + "-";
                    }
                    string2 = string2 + iTipoDatosCampoValor.getNombreCampo() + ":" + iTipoDatosCampoValor.getValor();
                }
                return string2;
            }
            throw new ExceptionMotor("No existe ninguna tabla con nombre " + string, Thread.currentThread().getStackTrace());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String getLocalizacion(ISesion iSesion, String string) throws ExceptionMotor {
        ((ISesionExtendida)iSesion).getNodoPrincipal();
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            if (iTablaMotor != null) {
                List<ITipoDatosCampoValor> list = iTablaMotor.getLocalizacion();
                String string2 = "";
                for (ITipoDatosCampoValor iTipoDatosCampoValor : list) {
                    if (string2.length() > 0) {
                        string2 = string2 + "-";
                    }
                    string2 = string2 + iTipoDatosCampoValor.getValor();
                }
                return string2;
            }
            throw new ExceptionMotor("No existe ninguna tabla con nombre " + string, Thread.currentThread().getStackTrace());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<?> obtenerOpcion(ISesion iSesion, String string) throws ExceptionMotor {
        return iSesion.getModelo().getGestorDatosOpciones().getOpcion(string);
    }

    @Override
    public Object obtenerValorPorDefectoPartida(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada != null) {
                return iRegEntrada.getValorInicial();
            }
            return null;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    @Override
    public Object getDatos(ISesion iSesion) throws ExceptionMotor {
        return this.getDatos(iSesion, false);
    }

    @Override
    public Object getDatos(ISesion iSesion, boolean bl) throws ExceptionMotor {
        try {
            if (iSesion.getModelo().getPersistenciaObj() == null) {
                throw new ExceptionMotor("No hay clase persistencia...", Thread.currentThread().getStackTrace());
            }
            return iSesion.getModelo().getPersistenciaObj().obtener(iSesion, bl);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object getPunteroADatos(ISesion iSesion) throws ExceptionMotor {
        try {
            return iSesion.getOrigenDeDatos().getPunteroADatos();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean setDatos(ISesion iSesion, Object object) throws ExceptionMotor {
        try {
            if (iSesion.getModelo().getPersistenciaObj() == null) {
                throw new ExceptionMotor("No hay clase persistencia...", Thread.currentThread().getStackTrace());
            }
            boolean bl = iSesion.getModelo().getPersistenciaObj().establece(iSesion.getOrigenDeDatos(), iSesion.getOrigenDeDatos(), object);
            bl &= ((ISesionExtendida)iSesion).construirArbol(true);
            return bl &= iSesion.getOperaciones().moveFirstTodos();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<?> getTablaFicherosAuxiliares(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            return iSesion.getModelo().getGestorDatosAuxiliares().getTabla(string);
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return null;
        }
    }

    @Override
    public List<?> getTablaFicherosAuxiliares(ISesion iSesion, String string, boolean bl) throws ExceptionMotor {
        try {
            return iSesion.getModelo().getGestorDatosAuxiliares().getTabla(string, bl);
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return null;
        }
    }

    @Override
    public List<?> getTablaFiltradaFicherosAuxiliares(ISesion iSesion, String string, String string2, String string3) throws ExceptionMotor {
        return this.getTablaFiltradaFicherosAuxiliares(iSesion, string, string2, string3, true);
    }

    @Override
    public List<?> getTablaFiltradaFicherosAuxiliares(ISesion iSesion, String string, String string2, String string3, boolean bl) throws ExceptionMotor {
        try {
            return iSesion.getModelo().getGestorDatosAuxiliares().getTablaFiltrada(string, string2, string3, bl);
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " TablaPadre " + string + " TablaHija " + string2 + " ClaveAjena " + string3);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " TablaPadre " + string + " TablaHija " + string2 + " ClaveAjena " + string3);
            }
            return null;
        }
    }

    @Override
    public void establecerCriterioOrdenacion(ISesion iSesion, List<ITipoDatosCriteriosOrdenacion> list) throws ExceptionMotor {
        try {
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (iSesion.getModelo().getGestorConfiguracion().getTabla(list.get(i).getTabla()) == null) {
                        iSesion.getOrigenDeDatos().setOrigenDeDatosOrdenadoPorCriterio(false);
                        throw new ExceptionMotor("La tabla " + list.get(i).getCampos() + " no se encuentra en el gestor de configuraci\u00f3n");
                    }
                    String[] stringArray = list.get(i).getCampos().split(",");
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (iSesion.getModelo().getGestorConfiguracion().getEntrada(stringArray[j].toUpperCase()) != null) continue;
                        iSesion.getOrigenDeDatos().setOrigenDeDatosOrdenadoPorCriterio(false);
                        throw new ExceptionMotor("La entrada " + stringArray[j] + " no se encuentra en el gestor de configuraci\u00f3n");
                    }
                }
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean establecerPartida(ISesion iSesion, String string, Object object, Object object2) throws ExceptionMotor {
        try {
            if (FuncionesUtiles.getFuncionesUtiles().sonIguales(iSesion.getModelo().getGestorConfiguracion().getEntrada(string).esTipoNumerico(), object2, object)) {
                return true;
            }
            if (!iSesion.isEnabled()) {
                return true;
            }
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoPartida(string);
            if (iTablaMotor == null) {
                return false;
            }
            return this.establecerPartida(iSesion, iTablaMotor, string, object, object2);
        }
        catch (Exception exception) {
            String string2 = " Partida " + string;
            try {
                string2 = string2 + " Valor " + object.toString() + " ValorAnterior " + object2.toString();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception instanceof ExceptionMotor) {
                ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + string2);
                throw (ExceptionMotor)exception;
            }
            throw new ExceptionMotor(exception, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean establecerPartida(ISesion iSesion, String string, Object object) throws ExceptionMotor {
        boolean bl = ((ISesionExtendida)iSesion).isModoSilencioso();
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoPartida(string);
            if (iTablaMotor == null) {
                throw new ExceptionMotor("No se encuentra nodo de Partida");
            }
            ((ISesionExtendida)iSesion).setModoSilencioso(true);
            Object object2 = this.obtenerPartida(iSesion, string);
            ((ISesionExtendida)iSesion).setModoSilencioso(bl);
            boolean bl2 = this.establecerPartida(iSesion, iTablaMotor, string, object, object2);
            return bl2;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                String string2 = " Partida " + string;
                try {
                    string2 = string2 + " valor " + object.toString();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + string2);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, string2);
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            ((ISesionExtendida)iSesion).setModoSilencioso(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean establecerPartida(ISesion iSesion, ITablaMotor iTablaMotor, String string, Object object, Object object2) throws ExceptionMotor {
        String string2 = this.valorDependienteDeTipo(iSesion, string, object);
        String string3 = string;
        Object object3 = object2;
        boolean bl = false;
        IPartidaModificadaReglas iPartidaModificadaReglas = null;
        Object object4 = null;
        boolean bl2 = false;
        try {
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string3);
            if (iTablaMotor != null && iTablaMotor.getClaveActiva() == 0L && iRegEntrada.esValorPorDefecto(string2.toString())) {
                boolean bl3 = true;
                return bl3;
            }
            bl2 = this.crearRegistroSiNoExiste(iSesion, iTablaMotor);
            if (FuncionesUtiles.getFuncionesUtiles().sonIguales(iRegEntrada.esTipoNumerico(), string2, object3)) {
                iPartidaModificadaReglas = null;
                if (((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().size() > 0) {
                    iPartidaModificadaReglas = ((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista().get(string3 + "(" + iTablaMotor.getLocalizacion(((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual())) + ")");
                }
                if (iPartidaModificadaReglas == null) {
                    iPartidaModificadaReglas = new PartidaModificada(iTablaMotor, string3);
                    iPartidaModificadaReglas.setValorAnterior(object3);
                }
                iPartidaModificadaReglas.setValorPosterior(string2);
                this.anniadirPartidaAListaAfectadasEnUnaEjecucion(iSesion, string3, iTablaMotor, iPartidaModificadaReglas);
                bl = true;
                iPartidaModificadaReglas = null;
                boolean bl4 = true;
                return bl4;
            }
            string3 = string3.toUpperCase();
            String string4 = iRegEntrada.getTipoDato();
            Object object5 = iTablaMotor.obtenerPartidaString(string3);
            if (object5 == null) {
                object5 = object3;
            }
            if (string4.equalsIgnoreCase("DOBLE")) {
                if (!object3.getClass().getName().equalsIgnoreCase(Double.class.getName())) {
                    try {
                        object3 = Double.valueOf(object3.toString());
                    }
                    catch (Exception exception) {
                        object3 = new Double(0.0);
                    }
                }
                object4 = Double.valueOf(string2.toString());
                object4 = Formatear.getFormatear().formatoDoble((Double)object4, iRegEntrada.getNumDecimales());
                bl = iTablaMotor.establecerPartida(string3, FuncionesUtiles.getFuncionesUtiles().doubleToString(Double.valueOf(object4.toString())));
            } else if (string4.equalsIgnoreCase("BIGDECIMAL")) {
                if (!object3.getClass().getName().equalsIgnoreCase(BigDecimal.class.getName())) {
                    try {
                        object3 = new BigDecimal(object3.toString().trim());
                    }
                    catch (Exception exception) {
                        object3 = BigDecimal.ZERO;
                    }
                }
                object4 = new BigDecimal(string2.toString().trim());
                object4 = ((BigDecimal)object4).setScale(iRegEntrada.getNumDecimales(), 4);
                bl = iTablaMotor.establecerPartida(string3, object4);
            } else if (string4.equalsIgnoreCase("ENTERO")) {
                if (!object3.getClass().getName().equalsIgnoreCase(Integer.class.getName())) {
                    try {
                        int n = object3.toString().indexOf(46);
                        if (n > 0) {
                            object3 = object3.toString().substring(0, n);
                        }
                        object3 = Integer.valueOf(object3.toString());
                    }
                    catch (Exception exception) {
                        object3 = 0;
                    }
                }
                object4 = Double.valueOf(string2.toString()).intValue();
                bl = iTablaMotor.establecerPartida(string3, object4);
            } else if (string4.equalsIgnoreCase("LOGICO")) {
                if (!object3.getClass().getName().equalsIgnoreCase(Boolean.class.getName())) {
                    object3 = Boolean.valueOf(object3.toString());
                }
                object4 = Boolean.valueOf(string2.toString());
                bl = iTablaMotor.establecerPartida(string3, object4);
            } else if (string4.equalsIgnoreCase("CADENA")) {
                object4 = string2;
                bl = iTablaMotor.establecerPartida(string3, object4);
            } else if (string4.equalsIgnoreCase("FECHA")) {
                object4 = string2;
                if (object4 != null && !object4.toString().trim().equalsIgnoreCase("") && !((Boolean)iSesion.getGestionReglas().ejecutarFuncion(iSesion, "esFecha", new Object[]{object4, "ddMMyyyy"})).booleanValue()) {
                    bl = false;
                    iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{"FECHERR"});
                } else {
                    bl = iTablaMotor.establecerPartida(string3, object4);
                }
            } else {
                object4 = string2;
                bl = iTablaMotor.establecerPartida(string3, object4);
            }
            if (bl) {
                if (((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().size() == 0) {
                    ((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().add(new TipoListaPartidasAfectadasEnUnaEjecucion(new HashMap<String, IPartidaModificadaReglas>()));
                }
                if ((iPartidaModificadaReglas = ((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista().get(string3 + "(" + iTablaMotor.getLocalizacion(((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual())) + ")")) == null) {
                    iPartidaModificadaReglas = new PartidaModificada(iTablaMotor, string3);
                }
                iPartidaModificadaReglas.setValorAnterior(object3);
                iPartidaModificadaReglas.setValorPosterior(object4);
                this.anniadirPartidaAListaAfectadasEnUnaEjecucion(iSesion, string3, iTablaMotor, iPartidaModificadaReglas);
            }
            boolean bl5 = bl;
            return bl5;
        }
        catch (Exception exception) {
            if (exception.getMessage().toUpperCase().contains("OVERFLOW_MOTOR")) {
                bl = false;
                iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{"OVERFLOW_MOTOR"});
            } else if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                String string5 = " Partida " + string;
                try {
                    string5 = string5 + " valor " + string2.toString() + " valor " + object.toString() + " valorAnterior " + object2.toString();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + string5);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, string5);
            }
            boolean bl6 = bl;
            return bl6;
        }
        finally {
            if (!bl && bl2) {
                this.borrarRegistro(iSesion, iTablaMotor.getNombre());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean recargaDatosdelOrigendeDatos(ISesion iSesion, String string) throws ExceptionMotor {
        FreezerMotor freezerMotor = new FreezerMotor(iSesion);
        try {
            freezerMotor.freeze();
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoTabla(string);
            iTablaMotor.setClaveActiva(0L);
            iTablaMotor.setClaveSuperior(0L);
            iTablaMotor.setClaveUnicaSuperior(0L);
            freezerMotor.unfreeze();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (freezerMotor.isFreezed()) {
                freezerMotor.unfreeze();
            }
            freezerMotor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean recargaDatosdelOrigendeDatos(ISesion iSesion) throws ExceptionMotor {
        FreezerMotor freezerMotor = new FreezerMotor(iSesion);
        try {
            freezerMotor.freeze();
            ((ISesionExtendida)iSesion).getNodoPrincipal().setClaveActiva(0L);
            ((ISesionExtendida)iSesion).getNodoPrincipal().setClaveSuperior(0L);
            ((ISesionExtendida)iSesion).getNodoPrincipal().setClaveUnicaSuperior(0L);
            freezerMotor.unfreeze();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (freezerMotor.isFreezed()) {
                freezerMotor.unfreeze();
            }
            freezerMotor = null;
        }
    }

    @Override
    public long anniadirRegistro(ISesion iSesion, String string) throws ExceptionMotor {
        return this.anniadirRegistro(iSesion, string, -1L);
    }

    @Override
    public long anniadirRegistro(ISesion iSesion, String string, long l) throws ExceptionMotor {
        if (iSesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio", Thread.currentThread().getStackTrace());
        }
        boolean bl = false;
        try {
            long l2;
            Integer n = null;
            int n2 = Integer.valueOf(this.obtenerPartidaString(iSesion, "MAX_REG"));
            if (n2 > 0) {
                int n3 = Integer.valueOf(this.obtenerPartidaString(iSesion, "CON_REG"));
                if (n3 == 0 && (n3 = iSesion.getOrigenDeDatos().getRecordCountTotal()) != 0) {
                    this.establecerPartida(iSesion, "CON_REG", n3);
                }
                if (n3 > n2) {
                    iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{"ERRMAXREG"});
                    return -2L;
                }
                n = n3 + 1;
            }
            ITablaMotor iTablaMotor = null;
            iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                return -1L;
            }
            if (iTablaMotor.getNivel() == 0 && iTablaMotor.getClaveActiva() != 0L) {
                return 1L;
            }
            if (iTablaMotor.getNivel() != 0 && iTablaMotor.getClaveSuperior() == 0L) {
                this.anniadirRegistro(iSesion, iTablaMotor.getNombreTablaPadre());
                iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            }
            if (((ISesionExtendida)iSesion).isModoSilencioso() || !((ISesionExtendida)iSesion).inTrans()) {
                bl = ((ISesionExtendida)iSesion).beginTrans();
            }
            long l3 = 0L;
            if (l > -1L) {
                iTablaMotor.setClaveSuperior(l);
            }
            if ((l2 = iSesion.getOrigenDeDatos().anniadirRegistro(iTablaMotor)) > 0L) {
                iTablaMotor.setClaveActiva(l2);
                this.anniadirTablaAListaAfectadasEnUnaEjecucion(iSesion, string, new RegTablaModificada(iSesion, iTablaMotor, "add"));
            }
            iTablaMotor.setClaveActiva(l2);
            if (iSesion.getOrigenDeDatos().isCreacionIDUnicoAutomatico()) {
                iTablaMotor.establecerPartida("ID", String.valueOf(iTablaMotor.getClaveActiva()));
            }
            this.recorrerNodosHijos(iSesion, iTablaMotor);
            l3 = iTablaMotor.getClaveActiva();
            if (bl) {
                ((ISesionExtendida)iSesion).commitTrans();
                bl = false;
            }
            if (l2 > 0L && n != null) {
                this.establecerPartida(iSesion, "CON_REG", n);
            }
            String string2 = string + "_ANADIR";
            if (iSesion.getModelo().getGestorConfiguracion().getEntrada(string2) != null) {
                iSesion.getGestionReglas().ejecutaReglasDePartida(string2);
            }
            this.actualizaPunterosSiProcede(iSesion, iTablaMotor);
            return l3;
        }
        catch (Exception exception) {
            if (bl) {
                ((ISesionExtendida)iSesion).rollBack();
            }
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return 0L;
        }
    }

    protected void actualizaPunterosSiProcede(ISesion iSesion, ITablaMotor iTablaMotor) throws ExceptionMotor {
        if (this.actualizando || iSesion.getPtrList().size() <= 1) {
            return;
        }
        String string = iSesion.getCurrentPtr();
        try {
            this.actualizando = true;
            for (ITipoDatosCampoValor iTipoDatosCampoValor : iSesion.getPtrList()) {
                if (iTipoDatosCampoValor.getNombreCampo().equalsIgnoreCase(string)) continue;
                String string2 = iTipoDatosCampoValor.getValor();
                if (string2.trim().length() == 0) {
                    string2 = iSesion.getPtrList().get(TipoDatosCampoValor.indiceListaContieneCampo(iSesion.getPtrList(), string)).getValor();
                }
                if (!this.tablasAnteriores.containsKey(string2 + "+" + iTablaMotor.getNombre())) {
                    this.tablasAnteriores.put(string2 + "+" + iTablaMotor.getNombre(), string2.equalsIgnoreCase(iTablaMotor.getNombre()) || this.esTablaHija(iSesion, string2, iTablaMotor.getNombre()));
                }
                if (this.tablasAnteriores.get(string2 + "+" + iTablaMotor.getNombre()).booleanValue()) continue;
                iSesion.setCurrentPtr(iTipoDatosCampoValor.getNombreCampo());
                iSesion.getOperaciones().move(iTablaMotor.getNombre(), iTablaMotor.getClaveActiva());
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
        finally {
            this.actualizando = false;
            iSesion.setCurrentPtr(string);
        }
    }

    protected boolean esTablaHija(ISesion iSesion, String string, String string2) throws ExceptionMotor {
        try {
            IRegRelacionada iRegRelacionada = iSesion.getModelo().getGestorConfiguracion().getRelacionada(string);
            if (iRegRelacionada != null) {
                for (String string3 : iRegRelacionada.getTablaRelacionada()) {
                    if (string3.equalsIgnoreCase(string2)) {
                        return true;
                    }
                    if (!this.esTablaHija(iSesion, string3, string2)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected long anniadirRegistro(ISesion iSesion, String string, long l, boolean bl) throws ExceptionMotor {
        try {
            if (((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro() && !bl) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes");
            }
            if (iSesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio");
            }
            return this.anniadirRegistro(iSesion, string, l);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string + "(" + l + ")");
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string + "(" + l + ")");
        }
    }

    @Override
    public boolean batchAnniadirRegistro(ISesion iSesion, String string, List<ITipoDatosCampoValor> list) throws ExceptionMotor {
        try {
            if (!((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro()) {
                ((ISesionExtendida)iSesion).setEjecutandoBatchAnniadirRegistro(true);
                iSesion.getOrigenDeDatos().setDifferedWrite(1);
            }
            if (this.anniadirRegistro(iSesion, string, -1L, true) == -1L) {
                throw new ExceptionMotor("Error al insertar registro...");
            }
            boolean bl = true;
            String string2 = null;
            for (int i = 0; i < list.size(); ++i) {
                string2 = list.get(i).getValor();
                if (string2 == null) {
                    string2 = "";
                }
                bl &= this.establecerPartida(iSesion, list.get(i).getNombreCampo(), string2.toString());
            }
            return bl &= this.flush(iSesion, string, true);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public boolean batchCommit(ISesion iSesion) throws ExceptionMotor {
        if (!((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro()) {
            throw new ExceptionMotor("Se llamo a batch_Commit y no hay trabajos pendientes");
        }
        ((ISesionExtendida)iSesion).setEjecutandoBatchAnniadirRegistro(false);
        iSesion.getOrigenDeDatos().setDifferedWrite(0);
        return iSesion.getOrigenDeDatos().commitTrans();
    }

    @Override
    public IRegEntrada obtenerCaracteristicasPartida(ISesion iSesion, String string) throws ExceptionMotor {
        return iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
    }

    @Override
    public boolean limpiarRegistro(ISesion iSesion, String string) throws ExceptionMotor {
        ITablaMotor iTablaMotor = null;
        try {
            if (this.recordCount(iSesion, string) == 0L) {
                return true;
            }
            iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor != null && this.limpiarRegistrosHijos(iSesion, iTablaMotor.getRelacionadas())) {
                return this.limpiarRegistroActual(iSesion, iTablaMotor);
            }
            return false;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return false;
        }
    }

    protected boolean limpiarRegistrosHijos(ISesion iSesion, IListaTablaMotor iListaTablaMotor) throws ExceptionMotor {
        ITablaMotor iTablaMotor = null;
        boolean bl = true;
        long l = 0L;
        long l2 = 0L;
        try {
            if (iListaTablaMotor == null) {
                return true;
            }
            block2: for (int i = 0; i < iListaTablaMotor.count(); ++i) {
                iTablaMotor = iListaTablaMotor.getTablaMotor(i);
                l = this.moveFirst(iSesion, iTablaMotor.getNombre());
                l2 = this.recordCount(iSesion, iTablaMotor.getNombre());
                while (l2 > 0L) {
                    if (!this.limpiarRegistrosHijos(iSesion, iTablaMotor.getRelacionadas())) {
                        return false;
                    }
                    if (!this.limpiarRegistroActual(iSesion, iTablaMotor)) {
                        return false;
                    }
                    if (l == l2) continue block2;
                    l = this.moveNext(iSesion, iTablaMotor.getNombre());
                }
            }
            return bl;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception);
            }
            return false;
        }
    }

    protected boolean limpiarRegistroActual(ISesion iSesion, ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            boolean bl = true;
            List<String> list = iSesion.getModelo().getGestorConfiguracion().getCamposDeTabla(iTablaMotor.getNombre());
            for (String string : list) {
                bl &= this.establecerPartida(iSesion, string, iSesion.getModelo().getGestorConfiguracion().getEntrada(string).getValorInicial());
                bl &= this.establecerEstado(iSesion, string, iSesion.getModelo().getGestorConfiguracion().getEntrada(string).getEstadoInicial());
            }
            return bl;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean establecerEstado(ISesion iSesion, String string, int n) throws ExceptionMotor {
        int n2;
        if (!iSesion.isEnabled()) {
            return true;
        }
        int n3 = 0;
        boolean bl = false;
        ITablaMotor iTablaMotor = null;
        try {
            if (FuncionesUtiles.getFuncionesUtiles().sonIguales(iSesion.getModelo().getGestorConfiguracion().getEntrada(string).esTipoNumerico(), this.obtenerEstadoPartida(iSesion, string), n)) {
                boolean bl2 = true;
                return bl2;
            }
            bl = this.crearRegistroSiNoExiste(iSesion, ((ISesionExtendida)iSesion).obtenerNodoPartida(string));
            IPartidaModificadaReglas iPartidaModificadaReglas = null;
            iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoPartida(string);
            n2 = 0;
            if (iTablaMotor == null) {
                throw new ExceptionMotor("No encuentro nodo de partida " + string, Thread.currentThread().getStackTrace());
            }
            n2 = this.obtenerEstadoPartida(iSesion, string);
            if (n2 == n) {
                boolean bl3 = true;
                return bl3;
            }
            n3 = iTablaMotor.establecerEstado(string, n) ? 1 : 0;
            if (n3 != 0) {
                iPartidaModificadaReglas = null;
                if (((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().size() > 0) {
                    iPartidaModificadaReglas = ((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista().get(string + "(" + iTablaMotor.getLocalizacion(((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual())) + ")");
                }
                if (iPartidaModificadaReglas == null) {
                    iPartidaModificadaReglas = new PartidaModificada(iTablaMotor, string);
                }
                iPartidaModificadaReglas.setEstadoAnterior(n2);
                iPartidaModificadaReglas.setEstadoPosterior(n);
                this.anniadirPartidaAListaAfectadasEnUnaEjecucion(iSesion, string, iTablaMotor, iPartidaModificadaReglas);
                if (!((ISesionExtendida)iSesion).inTrans()) {
                    ((ISesionExtendida)iSesion).notifica(false);
                }
                iPartidaModificadaReglas = null;
            }
            int n4 = n3;
            return n4 != 0;
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Partida " + string + " estado " + n);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Partida " + string + " estado " + n);
            }
            n2 = n3;
            return n2 != 0;
        }
        finally {
            if (iTablaMotor != null && n3 == 0 && bl) {
                this.borrarRegistro(iSesion, iTablaMotor.getNombre());
            }
        }
    }

    @Override
    public boolean establecerEstado(ISesion iSesion, String string, boolean bl) throws ExceptionMotor {
        if (!iSesion.isEnabled()) {
            return true;
        }
        if (bl) {
            return this.establecerEstado(iSesion, string, 255);
        }
        return this.establecerEstado(iSesion, string, 254);
    }

    @Override
    public List<ITablaMotorEntrada> obtenerRegistroDatosTablaArrayList(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            if (((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            return FuncionesUtiles.getFuncionesUtiles().hashMap2ArrayListTablaMotorEntrada(this.obtenerRegistroDatosTabla(iSesion, string));
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public Map<String, ITablaMotorEntrada> obtenerRegistroDatosTabla(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            if (((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                return null;
            }
            return iTablaMotor.getRsDatosReferencia();
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public List<ITipoDatosRegistro> obtenerRegistroTabla(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            List<ITablaMotorEntrada> list = this.obtenerRegistroDatosTablaArrayList(iSesion, string);
            if (list == null) {
                return new ArrayList<ITipoDatosRegistro>();
            }
            ArrayList<ITipoDatosRegistro> arrayList = new ArrayList<ITipoDatosRegistro>();
            for (int i = 0; i < list.size(); ++i) {
                TipoDatosRegistro tipoDatosRegistro = new TipoDatosRegistro(list.get(i).getNombreEntrada(), list.get(i).getValor(), list.get(i).getEstado());
                if (list.get(i).getNombreEntrada().toString().equalsIgnoreCase("ID") || list.get(i).getNombreEntrada().toString().equalsIgnoreCase("IDINF")) {
                    tipoDatosRegistro.setTipoDato("ENTERO");
                } else {
                    tipoDatosRegistro.setTipoDato(iSesion.getModelo().getGestorConfiguracion().getEntrada(list.get(i).getNombreEntrada()).getTipoDato());
                }
                arrayList.add(tipoDatosRegistro);
                tipoDatosRegistro = null;
            }
            return arrayList;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public List<ITipoDatosRegistro> obtenerRegistroTabla(ISesion iSesion, String string, long l) throws ExceptionMotor {
        FreezerMotor freezerMotor = new FreezerMotor(iSesion);
        try {
            if (l != this.obtenerClaveActiva(iSesion, string)) {
                freezerMotor.freeze();
                if (this.move(iSesion, string, l) != l) {
                    List<ITipoDatosRegistro> list = null;
                    return list;
                }
            }
            List<ITipoDatosRegistro> list = this.obtenerRegistroTabla(iSesion, string);
            return list;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string + " id " + l);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string + " id " + l);
        }
        finally {
            if (freezerMotor.isFreezed()) {
                freezerMotor.unfreeze();
            }
            freezerMotor = null;
        }
    }

    @Override
    public List<List<ITipoDatosRegistro>> obtenerTabla(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                return null;
            }
            return iSesion.getOrigenDeDatos().obtenerTabla(iTablaMotor);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public List<Map<String, ITablaMotorEntrada>> obtenerTablaEx(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                return null;
            }
            return iSesion.getOrigenDeDatos().obtenerTablaHashMap(iTablaMotor);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public void enablePartidayTablasListeners(ISesion iSesion, boolean bl) throws ExceptionMotor {
        iSesion.getGestionReglas().setPartidayTablasListenersEnabled(bl);
    }

    @Override
    public void addPartidaModificadaListener(ISesion iSesion, IPartidaModificada iPartidaModificada, String string) throws ExceptionMotor {
        try {
            if (iSesion.getModelo().getGestorConfiguracion().getEntrada(string) == null) {
                throw new ExceptionMotor("Compruebe que " + string + " es un nombre de partida correcta...");
            }
            if (((ISesionExtendida)iSesion).getListenersPartidaModificada() == null) {
                ((ISesionExtendida)iSesion).setListenersPartidaModificada(new HashMap<String, List<IPartidaModificada>>());
            }
            if (((ISesionExtendida)iSesion).getListenersPartidaModificada().get(string.toUpperCase()) == null) {
                ((ISesionExtendida)iSesion).getListenersPartidaModificada().put(string.toUpperCase(), new ArrayList());
            }
            if (!((ISesionExtendida)iSesion).getListenersPartidaModificada().get(string.toUpperCase()).contains(iPartidaModificada)) {
                ((ISesionExtendida)iSesion).getListenersPartidaModificada().get(string.toUpperCase()).add(iPartidaModificada);
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    @Override
    public void addTablaModificadaListener(ISesion iSesion, IPartidaModificada iPartidaModificada, String string) throws ExceptionMotor {
        try {
            if (iSesion.getModelo().getGestorConfiguracion().getTabla(string) == null) {
                throw new ExceptionMotor("Compruebe que " + string + " es un nombre de tabla correcto...");
            }
            if (((ISesionExtendida)iSesion).getListenersTablaModificada() == null) {
                ((ISesionExtendida)iSesion).setListenersTablaModificada(new HashMap<String, List<IPartidaModificada>>());
            }
            if (((ISesionExtendida)iSesion).getListenersTablaModificada().get(string.toUpperCase()) == null) {
                ((ISesionExtendida)iSesion).getListenersTablaModificada().put(string.toUpperCase(), new ArrayList());
            }
            ((ISesionExtendida)iSesion).getListenersTablaModificada().get(string.toUpperCase()).add(iPartidaModificada);
            List<String> list = iSesion.getModelo().getGestorConfiguracion().getCamposDeTabla(string);
            for (int i = 0; i < list.size(); ++i) {
                this.addPartidaModificadaListener(iSesion, iPartidaModificada, list.get(i));
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public void refrescarPartidaModificadaListeners(ISesion iSesion) throws ExceptionMotor {
        this.refrescarPartidaModificadaListeners(null, null);
    }

    @Override
    public void refrescarPartidaModificadaListeners(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            for (String string2 : ((ISesionExtendida)iSesion).getListenersPartidaModificada().keySet()) {
                List<IPartidaModificada> list = ((ISesionExtendida)iSesion).getListenersPartidaModificada().get(string2);
                if (string != null && !iSesion.getModelo().getGestorConfiguracion().getEntrada(string2).getIdTabla().equalsIgnoreCase(string)) continue;
                String string3 = this.obtenerPartidaString(iSesion, string2);
                int n = this.obtenerEstadoPartida(iSesion, string2);
                for (int i = 0; i < list.size(); ++i) {
                    list.get(i).refrescaPartida(string2, 0L, 0L, string3, n);
                }
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public void removeTablaModificadaListener(ISesion iSesion, IPartidaModificada iPartidaModificada, String string) throws ExceptionMotor {
        try {
            if (iSesion.getModelo().getGestorConfiguracion().getTabla(string) == null) {
                throw new ExceptionMotor("Compruebe que " + string + " es un nombre de tabla correcto...", Thread.currentThread().getStackTrace());
            }
            if (((ISesionExtendida)iSesion).getListenersTablaModificada() != null && ((ISesionExtendida)iSesion).getListenersTablaModificada().get(string.toUpperCase()) != null) {
                ((ISesionExtendida)iSesion).getListenersTablaModificada().get(string.toUpperCase()).remove(iPartidaModificada);
                if (((ISesionExtendida)iSesion).getListenersTablaModificada().get(string.toUpperCase()).size() == 0) {
                    ((ISesionExtendida)iSesion).getListenersTablaModificada().remove(string.toUpperCase());
                }
            }
            List<String> list = iSesion.getModelo().getGestorConfiguracion().getCamposDeTabla(string);
            for (int i = 0; i < list.size(); ++i) {
                this.removePartidaModificadaListener(iSesion, iPartidaModificada, list.get(i));
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string);
        }
    }

    @Override
    public void removePartidaModificadaListener(ISesion iSesion, IPartidaModificada iPartidaModificada, String string) throws ExceptionMotor {
        try {
            if (iSesion.getModelo().getGestorConfiguracion().getEntrada(string) == null) {
                throw new ExceptionMotor("Compruebe que " + string + " es un nombre de partida correcta...", Thread.currentThread().getStackTrace());
            }
            if (((ISesionExtendida)iSesion).getListenersPartidaModificada() != null && ((ISesionExtendida)iSesion).getListenersPartidaModificada().get(string.toUpperCase()) != null) {
                ((ISesionExtendida)iSesion).getListenersPartidaModificada().get(string.toUpperCase()).remove(iPartidaModificada);
                if (((ISesionExtendida)iSesion).getListenersPartidaModificada().get(string.toUpperCase()).size() == 0) {
                    ((ISesionExtendida)iSesion).getListenersPartidaModificada().remove(string.toUpperCase());
                }
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    @Override
    public void funcionesErrorComportamientoEspecial(ISesion iSesion, boolean bl) throws ExceptionMotor {
        iSesion.isFuncionesErrorComportamientoEspecial();
    }

    @Override
    public boolean isFuncionesErrorComportamientoEspecial(ISesion iSesion) throws ExceptionMotor {
        return iSesion.isFuncionesErrorComportamientoEspecial();
    }

    @Override
    public Object clona(ISesion iSesion) throws ExceptionMotor {
        return iSesion.getOrigenDeDatos().clona();
    }

    @Override
    public boolean restauraDocumento(ISesion iSesion, Object object) throws ExceptionMotor {
        return iSesion.getOrigenDeDatos().restauraDocumento(object);
    }

    @Override
    public void setModoTransacciones(ISesion iSesion, int n) throws ExceptionMotor {
        iSesion.getOrigenDeDatos().setModoTransacciones(n);
    }

    @Override
    public int getModoTransacciones(ISesion iSesion) throws ExceptionMotor {
        return iSesion.getOrigenDeDatos().getModoTransacciones();
    }

    protected boolean establecerPartidas(ISesion iSesion, ITablaMotor iTablaMotor) throws ExceptionMotor {
        String string = "";
        long l = 0L;
        long l2 = 0L;
        try {
            string = iTablaMotor.getNombre();
            l = iTablaMotor.getClaveActiva();
            l2 = iTablaMotor.getClaveSuperior();
            if (iSesion.getOrigenDeDatos().getDifferedWrite() == 1) {
                try {
                    return iSesion.getOrigenDeDatos().establecerPartidas(iTablaMotor);
                }
                catch (NotImplementedException notImplementedException) {
                    // empty catch block
                }
            }
            return this.establecerPartidas(iSesion, iTablaMotor.getRsDatosReferencia(), iTablaMotor.getNombre(), iTablaMotor.getClaveActiva(), iTablaMotor.getClaveSuperior(), false);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string + " id " + l + " id padre " + l2);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string + " id " + l + " id padre " + l2);
        }
    }

    protected boolean establecerPartidas(ISesion iSesion, Map<String, ITablaMotorEntrada> map, String string, long l, long l2, boolean bl) throws ExceptionMotor {
        try {
            String string2 = "";
            String string32 = "";
            boolean bl2 = false;
            Set<String> set = map.keySet();
            for (String string32 : set) {
                if (string32.equalsIgnoreCase("ID") || string32.equalsIgnoreCase("IDINF")) continue;
                string2 = iSesion.getModelo().getGestorConfiguracion().getEntrada(string32).getIdTabla();
                bl2 = false;
                if (string2.equalsIgnoreCase(string)) {
                    bl2 = true;
                    break;
                }
                if (bl2 || ((ISesionExtendida)iSesion).isModoSilencioso()) continue;
                throw new ExceptionMotor("Al establecer partidas la partida " + string32 + " no parece pertenecer a la tabla " + string);
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + string + " id " + l + " id padre " + l2);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + string + " id " + l + " id padre " + l2);
        }
    }

    @Override
    public boolean flush(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            if (string == null || string.length() == 0) {
                return this.establecerPartidas(iSesion, null, "", -1L, -1L, false);
            }
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                return false;
            }
            return this.establecerPartidas(iSesion, iTablaMotor);
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Tabla " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Tabla " + string);
            }
            return false;
        }
    }

    protected boolean flush(ISesion iSesion, String string, boolean bl) throws ExceptionMotor {
        if (((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro() && !bl) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
        }
        return this.flush(iSesion, string);
    }

    @Override
    public boolean flushActualizarRegistro(ISesion iSesion, String string) throws ExceptionMotor {
        return this.flush(iSesion, string);
    }

    @Override
    public void setIgnorarRegistrosDeEstados(ISesion iSesion, boolean bl) throws ExceptionMotor {
        ((ISesionExtendida)iSesion).setIgnorarRegistrosDeEstados(bl);
    }

    @Override
    public void setTablaIdInfCacheHabilitada(ISesion iSesion, boolean bl) throws ExceptionMotor {
        ((ISesionExtendida)iSesion).setTablaIdInfCacheHabilitada(bl);
    }

    @Override
    public boolean getIgnorarRegistrosDeEstados(ISesion iSesion) throws ExceptionMotor {
        return ((ISesionExtendida)iSesion).getIgnorarRegistrosDeEstados();
    }

    @Override
    public boolean getTablaIdInfCacheHabilitada(ISesion iSesion) throws ExceptionMotor {
        return ((ISesionExtendida)iSesion).getTablaIdInfCacheHabilitada();
    }

    @Override
    public boolean forzarEscrituraRsDatosRsEstadosalOD(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            return ((ISesionExtendida)iSesion).obtenerNodoTabla(string) != null;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected Object obtenerTipoDatoPartida(ISesion iSesion, String string) {
        try {
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada != null) {
                String string2 = iRegEntrada.getTipoDato();
                if (string2.equalsIgnoreCase("DOBLE")) {
                    return 0.0;
                }
                if (string2.equalsIgnoreCase("BIGDECIMAL")) {
                    return "0";
                }
                if (string2.equalsIgnoreCase("LOGICO")) {
                    return Boolean.FALSE;
                }
                if (string2.equalsIgnoreCase("ENTERO")) {
                    return 0;
                }
                return "";
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object obtenerValorInicialPartida(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada.getTipoDato().equalsIgnoreCase("ENTERO")) {
                return Integer.valueOf(iRegEntrada.getValorInicial());
            }
            if (iRegEntrada.getTipoDato().equalsIgnoreCase("DOBLE")) {
                return Double.valueOf(iRegEntrada.getValorInicial());
            }
            if (iRegEntrada.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                return iRegEntrada.getValorInicial();
            }
            if (iRegEntrada.getTipoDato().equalsIgnoreCase("LOGICO")) {
                return Boolean.valueOf(iRegEntrada.getValorInicial());
            }
            if (iRegEntrada.getTipoDato().equalsIgnoreCase("CADENA_NUMERICA")) {
                return "0";
            }
            return iRegEntrada.getValorInicial().toString();
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Imposible obtener valor inicial de " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Imposible obtener valor inicial de " + string);
        }
    }

    protected Object obtenerDatoPartidaCreadoSegunSuValorString(ISesion iSesion, String string, String string2) {
        try {
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada != null) {
                if (iRegEntrada.getTipoDato().equalsIgnoreCase("DOBLE")) {
                    return Double.valueOf(string2);
                }
                if (iRegEntrada.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    return string2;
                }
                if (iRegEntrada.getTipoDato().equalsIgnoreCase("LOGICO")) {
                    return Boolean.valueOf(string2);
                }
                if (iRegEntrada.getTipoDato().equalsIgnoreCase("ENTERO")) {
                    return Integer.valueOf(string2);
                }
                return "";
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int obtenerEstadoDefectoPartida(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            int n = 255;
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada != null) {
                n = iRegEntrada.getEstadoInicial();
            }
            return n;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    protected Object obtenerDatoDelOrigenSegunSuTipoDato(ISesion iSesion, String string, ITablaMotor iTablaMotor, Object object) {
        if (object instanceof String) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(iSesion, string, iTablaMotor, (String)object);
        }
        if (object instanceof Double) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(iSesion, string, iTablaMotor, (Double)object);
        }
        if (object instanceof BigDecimal) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(iSesion, string, iTablaMotor, (BigDecimal)object);
        }
        if (object instanceof Boolean) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(iSesion, string, iTablaMotor, (Boolean)object);
        }
        if (object instanceof Integer) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(iSesion, string, iTablaMotor, (Integer)object);
        }
        return null;
    }

    @Override
    public Object obtenerPartida(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            String string2 = ((ISesionExtendida)iSesion).buscarPartidaEnTabla(string);
            if (string2.length() == 0) {
                throw new ExceptionMotor("La partida '" + string + "' no se encuentra en ninguna tabla del modelo");
            }
            ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).getBusquedaNodosObj().get(((ISesionExtendida)iSesion).getPunteroActual()).buscarNodo(string2, ((ISesionExtendida)iSesion).getVarNodoPrincipal().get(((ISesionExtendida)iSesion).getPunteroActual()));
            if (iTablaMotor == null) {
                throw new ExceptionMotor("La relaci\u00f3n que identifica la partida con su tabla no es correcta nombre de tabla: " + string2);
            }
            Object object = null;
            object = iTablaMotor.obtenerPartidaString(string.toUpperCase());
            if (object != null) {
                if (object.toString().trim().length() == 0) {
                    object = this.devolverValorDatoParseadoSegunTipo(iSesion, string);
                }
                return object.toString();
            }
            object = this.obtenerValorInicialPartida(iSesion, string);
            return object.toString();
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Partida " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Partida " + string);
            }
            return null;
        }
    }

    protected String devolverValorDatoParseadoSegunTipo(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada != null) {
                String string2 = iRegEntrada.getTipoDato();
                if (iRegEntrada.esTipoNumerico()) {
                    return "0";
                }
                if (string2.equalsIgnoreCase("LOGICO") || string2.equalsIgnoreCase("FICTICIA")) {
                    return "false";
                }
                return "";
            }
            throw new ExceptionMotor("No se puede devolver el dato parseado seg\u00fan el tipo porque la partida no tiene indicado el tipo de campo en el fichero Entradas.xml");
        }
        catch (Exception exception) {
            if (!((ISesionExtendida)iSesion).isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + " Partida " + string);
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, " Partida " + string);
            }
            return null;
        }
    }

    protected void anniadirPartidaAListaAfectadasEnUnaEjecucion(ISesion iSesion, String string, ITablaMotor iTablaMotor, IPartidaModificadaReglas iPartidaModificadaReglas) throws ExceptionMotor {
        try {
            if (!((ISesionExtendida)iSesion).inTrans()) {
                return;
            }
            if (iPartidaModificadaReglas.getValorAnterior().toString().equals(iPartidaModificadaReglas.getValorPosterior().toString()) && iPartidaModificadaReglas.getEstadoAnterior() == iPartidaModificadaReglas.getEstadoPosterior()) {
                return;
            }
            if (((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().size() == 0) {
                ((ISesionExtendida)iSesion).anniadirGrupoPartidasAfectadasEnUnaEjecucion();
            }
            if (iPartidaModificadaReglas.getLocalizacion().length() == 0) {
                iPartidaModificadaReglas.setLocalizacion(iTablaMotor.getLocalizacion(this.getNodoPrincipal(iSesion)));
            }
            if (iPartidaModificadaReglas.getValorPosterior() != null && iPartidaModificadaReglas.getValorPosterior() instanceof Double && iPartidaModificadaReglas.getValorPosterior().toString().contains("E")) {
                iPartidaModificadaReglas.setValorPosterior(FuncionesUtiles.getFuncionesUtiles().doubleToString((Double)iPartidaModificadaReglas.getValorPosterior()));
            }
            ((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().get(((ISesionExtendida)iSesion).getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista().put(string + "(" + iPartidaModificadaReglas.getLocalizacion() + ")", iPartidaModificadaReglas);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    private String valorDependienteDeTipo(ISesion iSesion, String string, Object object) {
        String string2 = object.toString();
        try {
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (string2 == null || string2.trim().length() == 0) {
                if (iRegEntrada == null) {
                    throw new ExceptionMotor("No puedo identificar la partida");
                }
                if (iRegEntrada.getTipoDato().equalsIgnoreCase("ENTERO") || iRegEntrada.getTipoDato().equalsIgnoreCase("DOBLE") || iRegEntrada.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    string2 = "0";
                } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("LOGICO")) {
                    string2 = "false";
                }
            }
            if (iRegEntrada.getTipoDato().equalsIgnoreCase("BLOB")) {
                string2 = object instanceof String ? FuncionesUtiles.getFuncionesUtiles().byteArray2SerializableString(((String)object).getBytes()) : FuncionesUtiles.getFuncionesUtiles().byteArray2SerializableString((byte[])object);
            }
            return string2;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    private boolean crearRegistroSiNoExiste(ISesion iSesion, ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            if (iTablaMotor != null && iTablaMotor.getClaveActiva() == 0L) {
                if (((ISesionExtendida)iSesion).getRegistrosA\u00f1adidosPorReglasAlImportar() != null) {
                    ((ISesionExtendida)iSesion).getRegistrosA\u00f1adidosPorReglasAlImportar().put(iTablaMotor.getNombre(), FuncionesUtiles.getFuncionesUtiles().dameCadenaPadreLocalizacion(iTablaMotor.getLocalizacion()));
                }
                return this.anniadirRegistro(iSesion, iTablaMotor.getNombre()) > 0L;
            }
            return false;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

