/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.procesadorReglas;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.procesadorReglas.IOperaciones;
import es.aeat.pftw.mtrc.api.tipos.DateMotor;
import es.aeat.pftw.mtrc.api.tipos.IDateMotor;
import es.aeat.pftw.mtrc.imp.utilidades.Formatear;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class Operaciones
implements Serializable,
IOperaciones {
    private static final long serialVersionUID = 4526214351024502237L;
    private static IOperaciones singletonOperacionesWrapper = null;

    private Operaciones() {
    }

    public static IOperaciones getOperacionesWrapper() {
        if (singletonOperacionesWrapper == null) {
            singletonOperacionesWrapper = new Operaciones();
        }
        return singletonOperacionesWrapper;
    }

    @Override
    public Object sumar(Object object, Object object2, int n) throws ExceptionMotor {
        try {
            if (object instanceof Integer) {
                return (Integer)object + (Integer)object2;
            }
            if (object instanceof Long) {
                return (Long)object + (Long)object2;
            }
            if (object instanceof Double) {
                return new Double(this.realizarSumaDobles((double)((Double)object), (double)((Double)object2), n));
            }
            if (object instanceof BigDecimal) {
                return this.realizarSumaBigDecimal((BigDecimal)object, (BigDecimal)object2, n);
            }
            if (object instanceof Float) {
                return Float.valueOf(((Float)object).floatValue() + ((Float)object2).floatValue());
            }
            if (object instanceof String) {
                return (String)object + (String)object2;
            }
            return null;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarSumaBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) throws ExceptionMotor {
        try {
            return bigDecimal.add(bigDecimal2).setScale(n, 4);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarSumaBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws ExceptionMotor {
        try {
            return bigDecimal.add(bigDecimal2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarSumaBigDecimal(Object object, Object object2) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : this.convierteABigDecimal(object);
            bigDecimal2 = object2 instanceof BigDecimal ? (BigDecimal)object2 : this.convierteABigDecimal(object2);
            return this.realizarSumaBigDecimal(bigDecimal, bigDecimal2);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarSumaBigDecimal(Object object, Object object2, int n) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : this.convierteABigDecimal(object);
            bigDecimal2 = object2 instanceof BigDecimal ? (BigDecimal)object2 : this.convierteABigDecimal(object2);
            return this.realizarSumaBigDecimal(bigDecimal, bigDecimal2, n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private int getScale(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws ExceptionMotor {
        try {
            int n = 0;
            n = bigDecimal.scale() >= bigDecimal2.scale() ? bigDecimal.scale() : bigDecimal2.scale();
            if (n == 0) {
                n = 2;
            }
            return n;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public int sumar(int n, int n2) throws ExceptionMotor {
        return n + n2;
    }

    @Override
    public long sumar(long l, long l2) throws ExceptionMotor {
        return l + l2;
    }

    @Override
    public float sumar(float f, float f2, int n) throws ExceptionMotor {
        return f + f2;
    }

    @Override
    public double sumar(double d, double d2, int n) throws ExceptionMotor {
        return this.realizarSumaDobles(d, d2, n);
    }

    @Override
    public Object restar(Object object, Object object2, int n) throws ExceptionMotor {
        try {
            if (object instanceof Integer) {
                return (Integer)object - (Integer)object2;
            }
            if (object instanceof Long) {
                return (Long)object - (Long)object2;
            }
            if (object instanceof Double) {
                return new Double(this.realizarRestaDobles((double)((Double)object), (double)((Double)object2), n));
            }
            if (object.getClass().toString().toUpperCase().contains("BIGDECIMAL")) {
                return this.realizarRestaBigDecimal((BigDecimal)object, (BigDecimal)object2, n);
            }
            if (object instanceof Float) {
                return Float.valueOf(((Float)object).floatValue() - ((Float)object2).floatValue());
            }
            return null;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public int restar(int n, int n2) throws ExceptionMotor {
        return n - n2;
    }

    @Override
    public long restar(long l, long l2) throws ExceptionMotor {
        return l - l2;
    }

    @Override
    public double restar(double d, double d2, int n) throws ExceptionMotor {
        return this.realizarRestaDobles(d, d2, n);
    }

    @Override
    public float restar(float f, float f2) throws ExceptionMotor {
        return f - f2;
    }

    @Override
    public Object multiplicar(Object object, Object object2, int n) throws ExceptionMotor {
        try {
            if (object instanceof Integer) {
                return (Integer)object * (Integer)object2;
            }
            if (object instanceof Long) {
                return (Long)object * (Long)object2;
            }
            if (object instanceof Double) {
                return new Double(this.realizarMultiplicacionDobles((double)((Double)object), (double)((Double)object2), n));
            }
            if (object.getClass().toString().toUpperCase().contains("BIGDECIMAL")) {
                return this.realizarMultiplicacionBigDecimal((BigDecimal)object, (BigDecimal)object2, n);
            }
            if (object instanceof Float) {
                return Float.valueOf(((Float)object).floatValue() * ((Float)object2).floatValue());
            }
            return null;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarMultiplicacionBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) throws ExceptionMotor {
        try {
            return bigDecimal.multiply(bigDecimal2).setScale(n, 4);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarMultiplicacionBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws ExceptionMotor {
        try {
            return bigDecimal.multiply(bigDecimal2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarMultiplicacionBigDecimal(Object object, Object object2) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : this.convierteABigDecimal(object);
            bigDecimal2 = object2 instanceof BigDecimal ? (BigDecimal)object2 : this.convierteABigDecimal(object2);
            return this.realizarMultiplicacionBigDecimal(bigDecimal, bigDecimal2);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarMultiplicacionBigDecimal(Object object, Object object2, int n) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : this.convierteABigDecimal(object);
            bigDecimal2 = object2 instanceof BigDecimal ? (BigDecimal)object2 : this.convierteABigDecimal(object2);
            return this.realizarMultiplicacionBigDecimal(bigDecimal, bigDecimal2, n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public int multiplicar(int n, int n2) throws ExceptionMotor {
        return n * n2;
    }

    @Override
    public long multiplicar(long l, long l2) throws ExceptionMotor {
        return l * l2;
    }

    @Override
    public double multiplicar(double d, double d2, int n) throws ExceptionMotor {
        return this.realizarMultiplicacionDobles(d, d2, n);
    }

    @Override
    public float multiplicar(float f, float f2) throws ExceptionMotor {
        return f * f2;
    }

    @Override
    public Object dividir(Object object, Object object2, int n) throws ExceptionMotor {
        try {
            if (object instanceof Integer) {
                if ((Integer)object2 == 0) {
                    return 0;
                }
                return (Integer)object / (Integer)object2;
            }
            if (object instanceof Long) {
                if ((Long)object2 == 0L) {
                    return 0L;
                }
                return (Long)object / (Long)object2;
            }
            if (object instanceof Double) {
                if ((Double)object2 == 0.0) {
                    return 0.0;
                }
                return this.realizarDivisionDobles((double)((Double)object), (double)((Double)object2), n);
            }
            if (object.getClass().toString().toUpperCase().contains("BIGDECIMAL")) {
                if (this.convierteABigDecimal(object2).doubleValue() == 0.0) {
                    return BigDecimal.ZERO;
                }
                return this.realizarDivisionBigDecimal((BigDecimal)object, (BigDecimal)object2, n);
            }
            if (object instanceof Float) {
                if (((Float)object2).floatValue() == 0.0f) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(((Float)object).floatValue() / ((Float)object2).floatValue());
            }
            return null;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public int dividir(int n, int n2) throws ExceptionMotor {
        try {
            if (n2 != 0) {
                return n / n2;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public long dividir(long l, long l2) throws ExceptionMotor {
        try {
            if (l2 != 0L) {
                return l / l2;
            }
            return 0L;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public float dividir(float f, float f2) throws ExceptionMotor {
        try {
            if (f2 != 0.0f) {
                return f / f2;
            }
            return 0.0f;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public double dividir(double d, double d2, int n) throws ExceptionMotor {
        try {
            if (d2 != 0.0) {
                return this.realizarDivisionDobles(d, d2, n);
            }
            return 0.0;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Double realizarSumaDobles(Double d, Double d2) throws ExceptionMotor {
        return this.realizarSumaDobles((double)d, (double)d2);
    }

    @Override
    public Double realizarSumaDobles(Double d, Double d2, int n) throws ExceptionMotor {
        return this.realizarSumaDobles((double)d, (double)d2, n);
    }

    @Override
    public double realizarSumaDobles(double d, double d2, int n) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d).trim());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(d2).trim());
            BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2).setScale(n, 4);
            return Formatear.getFormatear().formatoDoble(bigDecimal3.doubleValue(), n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public double realizarSumaDobles(double d, double d2) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d).trim());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(d2).trim());
            BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
            return bigDecimal3.doubleValue();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Double realizarRestaDobles(Double d, Double d2) throws ExceptionMotor {
        return this.realizarRestaDobles((double)d, (double)d2);
    }

    @Override
    public Double realizarRestaDobles(Double d, Double d2, int n) throws ExceptionMotor {
        return this.realizarRestaDobles((double)d, (double)d2, n);
    }

    @Override
    public double realizarRestaDobles(double d, double d2, int n) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d).trim());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(d2).trim());
            BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2).setScale(n, 4);
            return Formatear.getFormatear().formatoDoble(bigDecimal3.doubleValue(), n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public double realizarRestaDobles(double d, double d2) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d).trim());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(d2).trim());
            BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
            return bigDecimal3.doubleValue();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarRestaBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) throws ExceptionMotor {
        try {
            return bigDecimal.subtract(bigDecimal2).setScale(n, 4);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarRestaBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws ExceptionMotor {
        try {
            return bigDecimal.subtract(bigDecimal2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarRestaBigDecimal(Object object, Object object2) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : this.convierteABigDecimal(object);
            bigDecimal2 = object2 instanceof BigDecimal ? (BigDecimal)object2 : this.convierteABigDecimal(object2);
            return this.realizarRestaBigDecimal(bigDecimal, bigDecimal2);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarRestaBigDecimal(Object object, Object object2, int n) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : this.convierteABigDecimal(object);
            bigDecimal2 = object2 instanceof BigDecimal ? (BigDecimal)object2 : this.convierteABigDecimal(object2);
            return this.realizarRestaBigDecimal(bigDecimal, bigDecimal2, n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Double realizarMultiplicacionDobles(Double d, Double d2) throws ExceptionMotor {
        return this.realizarMultiplicacionDobles((double)d, (double)d2);
    }

    @Override
    public Double realizarMultiplicacionDobles(Double d, Double d2, int n) throws ExceptionMotor {
        return this.realizarMultiplicacionDobles((double)d, (double)d2, n);
    }

    @Override
    public double realizarMultiplicacionDobles(double d, double d2, int n) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d).trim());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(d2).trim());
            BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2).setScale(n, 4);
            return Formatear.getFormatear().formatoDoble(bigDecimal3.doubleValue(), n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public double realizarMultiplicacionDobles(double d, double d2) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d).trim());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(d2).trim());
            BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
            return bigDecimal3.doubleValue();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Double realizarDivisionDobles(Double d, Double d2) throws ExceptionMotor {
        return this.realizarDivisionDobles((double)d, (double)d2);
    }

    @Override
    public Double realizarDivisionDobles(Double d, Double d2, int n) throws ExceptionMotor {
        return this.realizarDivisionDobles((double)d, (double)d2, n);
    }

    @Override
    public double realizarDivisionDobles(double d, double d2, int n) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d).trim());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(d2).trim());
            BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, n, 4);
            return Formatear.getFormatear().formatoDoble(bigDecimal3.doubleValue(), n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public double realizarDivisionDobles(double d, double d2) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d).trim());
            BigDecimal bigDecimal2 = new BigDecimal(String.valueOf(d2).trim());
            BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 20, 4);
            return bigDecimal3.doubleValue();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarDivisionBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) throws ExceptionMotor {
        try {
            return bigDecimal.divide(bigDecimal2, n, 4);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarDivisionBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws ExceptionMotor {
        BigDecimal bigDecimal3 = null;
        try {
            bigDecimal3 = bigDecimal.divide(bigDecimal2);
            return bigDecimal3;
        }
        catch (ArithmeticException arithmeticException) {
            return this.realizarDivisionBigDecimal(bigDecimal, bigDecimal2, 12);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarDivisionBigDecimal(Object object, Object object2) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : this.convierteABigDecimal(object);
            bigDecimal2 = object2 instanceof BigDecimal ? (BigDecimal)object2 : this.convierteABigDecimal(object2);
            return this.realizarDivisionBigDecimal(bigDecimal, bigDecimal2);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public BigDecimal realizarDivisionBigDecimal(Object object, Object object2, int n) throws ExceptionMotor {
        try {
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : this.convierteABigDecimal(object);
            bigDecimal2 = object2 instanceof BigDecimal ? (BigDecimal)object2 : this.convierteABigDecimal(object2);
            return this.realizarDivisionBigDecimal(bigDecimal, bigDecimal2, n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object evaluarOperacion(int n, Object object, String string, int n2) throws ExceptionMotor {
        try {
            if (this.esEntero(object)) {
                return this.evaluarOperacion((double)n, (double)Integer.valueOf(object.toString()).intValue(), string, n2);
            }
            return this.evaluarOperacion((Object)n, object, string, n2);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object evaluarOperacion(Object object, int n, String string, int n2) throws ExceptionMotor {
        try {
            if (this.esEntero(object)) {
                return this.evaluarOperacion((double)Integer.valueOf(object.toString()).intValue(), (double)n, string, n2);
            }
            return this.evaluarOperacion(object, (Object)n, string, n2);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object evaluarOperacion(int n, int n2, String string) throws ExceptionMotor {
        Boolean bl = Boolean.FALSE;
        try {
            switch (string.toCharArray()[0]) {
                case 'L': {
                    return n < n2;
                }
                case 'G': {
                    return n > n2;
                }
                case '=': {
                    return n == n2;
                }
                case '!': {
                    return n != n2;
                }
                case 'H': {
                    return n >= n2;
                }
                case 'M': {
                    return n <= n2;
                }
                case 'N': {
                    break;
                }
            }
            return bl;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object evaluarOperacion(double d, double d2, String string, int n) throws ExceptionMotor {
        BigDecimal bigDecimal = new BigDecimal(d).setScale(n, 4);
        BigDecimal bigDecimal2 = new BigDecimal(d2).setScale(n, 4);
        try {
            switch (string.toCharArray()[0]) {
                case 'L': {
                    return bigDecimal.compareTo(bigDecimal2) < 0;
                }
                case 'G': {
                    return bigDecimal.compareTo(bigDecimal2) > 0;
                }
                case '=': {
                    return bigDecimal.compareTo(bigDecimal2) == 0;
                }
                case '!': {
                    return bigDecimal.compareTo(bigDecimal2) != 0;
                }
                case 'H': {
                    return bigDecimal.compareTo(bigDecimal2) >= 0;
                }
                case 'M': {
                    return bigDecimal.compareTo(bigDecimal2) <= 0;
                }
                case 'N': {
                    break;
                }
            }
            return Boolean.FALSE;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object evaluarOperacion(IDateMotor iDateMotor, String string, String string2) throws ExceptionMotor {
        return this.evaluarOperacion(iDateMotor, (IDateMotor)new DateMotor(string), string2);
    }

    @Override
    public Object evaluarOperacion(String string, IDateMotor iDateMotor, String string2) throws ExceptionMotor {
        return this.evaluarOperacion((IDateMotor)new DateMotor(string), iDateMotor, string2);
    }

    public Object evaluarOperacionDates(IDateMotor iDateMotor, IDateMotor iDateMotor2, String string) throws ExceptionMotor {
        try {
            boolean bl;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar.setLenient(false);
            gregorianCalendar2.setLenient(false);
            boolean bl2 = bl = iDateMotor2.getDate() == null || iDateMotor.getDate() == null;
            if (!bl) {
                gregorianCalendar.setTime(iDateMotor.getDate());
                gregorianCalendar2.setTime(iDateMotor2.getDate());
            }
            switch (string.toCharArray()[0]) {
                case 'L': {
                    if (bl) {
                        throw new Exception("Falta por especificar alguna fecha!!!");
                    }
                    return gregorianCalendar.before(gregorianCalendar2) && !((Calendar)gregorianCalendar).equals(gregorianCalendar2);
                }
                case 'G': {
                    if (bl) {
                        throw new Exception("Falta por especificar alguna fecha!!!");
                    }
                    return gregorianCalendar.after(gregorianCalendar2) && !((Calendar)gregorianCalendar).equals(gregorianCalendar2);
                }
                case '=': {
                    if (bl) {
                        return iDateMotor2.getDate() == null && iDateMotor.getDate() == null && iDateMotor2.getFechaOriginal().equalsIgnoreCase(iDateMotor.getFechaOriginal());
                    }
                    return ((Calendar)gregorianCalendar).equals(gregorianCalendar2);
                }
                case '!': {
                    return (Boolean)this.evaluarOperacion(iDateMotor2, iDateMotor, "=") == false;
                }
                case 'H': {
                    if (bl) {
                        throw new Exception("Falta por especificar alguna fecha!!!");
                    }
                    return gregorianCalendar.after(gregorianCalendar2) || ((Calendar)gregorianCalendar).equals(gregorianCalendar2);
                }
                case 'M': {
                    if (bl) {
                        throw new Exception("Falta por especificar alguna fecha!!!");
                    }
                    return gregorianCalendar.before(gregorianCalendar2) || ((Calendar)gregorianCalendar).equals(gregorianCalendar2);
                }
                case 'N': {
                    throw new ExceptionMotor("No tiene sentido el negativo en las fechas");
                }
            }
            throw new ExceptionMotor("Operador " + string.toCharArray()[0] + " no esperado!!!");
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object evaluarOperacion(IDateMotor iDateMotor, IDateMotor iDateMotor2, String string) throws ExceptionMotor {
        return this.evaluarOperacionDates(iDateMotor, iDateMotor2, string);
    }

    @Override
    public Object evaluarOperacion(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) throws ExceptionMotor {
        return this.evaluarOperacion(bigDecimal, bigDecimal2, string, this.getScale(bigDecimal, bigDecimal2));
    }

    @Override
    public Object evaluarOperacion(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, int n) throws ExceptionMotor {
        BigDecimal bigDecimal3 = new BigDecimal(bigDecimal.toString().trim()).setScale(n, 4);
        BigDecimal bigDecimal4 = new BigDecimal(bigDecimal2.toString().trim()).setScale(n, 4);
        try {
            switch (string.toCharArray()[0]) {
                case 'L': {
                    return bigDecimal3.compareTo(bigDecimal4) < 0;
                }
                case 'G': {
                    return bigDecimal3.compareTo(bigDecimal4) > 0;
                }
                case '=': {
                    return bigDecimal3.compareTo(bigDecimal4) == 0;
                }
                case '!': {
                    return bigDecimal3.compareTo(bigDecimal4) != 0;
                }
                case 'H': {
                    return bigDecimal3.compareTo(bigDecimal4) >= 0;
                }
                case 'M': {
                    return bigDecimal3.compareTo(bigDecimal4) <= 0;
                }
                case 'N': {
                    break;
                }
            }
            return Boolean.FALSE;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object evaluarOperacion(String string, String string2, String string3) throws ExceptionMotor {
        try {
            switch (string3.toCharArray()[0]) {
                case '=': {
                    return string.equalsIgnoreCase(string2);
                }
                case '!': {
                    return !string.equalsIgnoreCase(string2);
                }
                case 'H': {
                    return string.compareToIgnoreCase(string2) >= 0;
                }
                case 'G': {
                    return string.compareToIgnoreCase(string2) > 0;
                }
                case 'M': {
                    return string.compareToIgnoreCase(string2) <= 0;
                }
                case 'L': {
                    return string.compareToIgnoreCase(string2) < 0;
                }
            }
            return Boolean.FALSE;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object evaluarOperacion(boolean bl, boolean bl2, String string) throws ExceptionMotor {
        try {
            switch (string.toCharArray()[0]) {
                case '=': {
                    return bl == bl2;
                }
                case '!': {
                    return bl != bl2;
                }
                case 'Y': {
                    return bl && bl2;
                }
                case 'O': {
                    return bl || bl2;
                }
            }
            return Boolean.FALSE;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String operadoresComparables(Object object, Object object2) throws ExceptionMotor {
        try {
            if (object.getClass().toString().equalsIgnoreCase(object2.getClass().toString())) {
                return object.getClass().toString();
            }
            if (this.operadorNumerico(object) && this.operadorNumerico(object2)) {
                if (object.getClass().toString().toUpperCase().contains("BIGDECIMAL") || object2.getClass().toString().toUpperCase().contains("BIGDECIMAL")) {
                    return BigDecimal.class.toString();
                }
                if (object instanceof Double || object2 instanceof Double) {
                    return Double.class.toString();
                }
                if (object instanceof Float || object2 instanceof Float) {
                    return Float.class.toString();
                }
                if (object instanceof Integer || object2 instanceof Integer) {
                    return Integer.class.toString();
                }
                return BigDecimal.class.toString();
            }
            return "";
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean operadorNumerico(Object object) throws ExceptionMotor {
        try {
            boolean bl;
            boolean bl2 = bl = object instanceof Integer || object instanceof Double || object instanceof Long || object instanceof Float || object.getClass().toString().toUpperCase().contains("BIGDECIMAL");
            if (!bl) {
                return FuncionesUtiles.getFuncionesUtiles().esNumerico(object.toString());
            }
            return bl;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object evaluarOperacion(Object object, Object object2, String string) throws ExceptionMotor {
        return this.evaluarOperacion(object, object2, string, -1);
    }

    @Override
    public Object evaluarOperacion(Object object, double d, String string) throws ExceptionMotor {
        return this.evaluarOperacion(object, (Object)new Double(d), string, -1);
    }

    @Override
    public Object evaluarOperacion(Object object, double d, String string, int n) throws ExceptionMotor {
        return this.evaluarOperacion(object, (Object)new Double(d), string, n);
    }

    @Override
    public Object evaluarOperacion(double d, Object object, String string) throws ExceptionMotor {
        return this.evaluarOperacion((Object)new Double(d), object, string, -1);
    }

    @Override
    public Object evaluarOperacion(double d, Object object, String string, int n) throws ExceptionMotor {
        return this.evaluarOperacion((Object)new Double(d), object, string, n);
    }

    @Override
    public Object evaluarOperacion(Object object, Object object2, String string, int n) throws ExceptionMotor {
        try {
            int n2 = n;
            String string2 = this.operadoresComparables(object2, object);
            if (string2.length() > 0) {
                if (string2.toString().toUpperCase().contains("BIGDECIMAL")) {
                    if (n2 == -1) {
                        return this.evaluarOperacion(new BigDecimal(object.toString().trim()), new BigDecimal(object2.toString().trim()), string);
                    }
                    return this.evaluarOperacion(new BigDecimal(object.toString().trim()), new BigDecimal(object2.toString().trim()), string, n2);
                }
                if (string2.equals(Double.class.toString())) {
                    if (n2 == -1) {
                        n2 = 2;
                    }
                    return this.evaluarOperacion((double)Double.valueOf(object.toString()), (double)Double.valueOf(object2.toString()), string, n2);
                }
                if (string2.equals(Boolean.class.toString())) {
                    return this.evaluarOperacion(Boolean.valueOf(object.toString()), Boolean.valueOf(object2.toString()), string);
                }
                if (string2.equals(String.class.toString())) {
                    return this.evaluarOperacion(object.toString(), object2.toString(), string);
                }
                if (string2.equals(Integer.class.toString())) {
                    if (n2 == -1) {
                        n2 = 2;
                    }
                    return this.evaluarOperacion((double)((Integer)object).intValue(), (double)((Integer)object2).intValue(), string, n2);
                }
                if (string2.equals(DateMotor.class.toString())) {
                    return this.evaluarOperacionDates((IDateMotor)object, (IDateMotor)object2, string);
                }
                throw new ExceptionMotor("No se que tipo es");
            }
            switch (string.toCharArray()[0]) {
                case '=': {
                    return object.toString().compareTo(object2.toString()) == 0;
                }
            }
            return Boolean.FALSE;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private boolean esEntero(Object object) throws ExceptionMotor {
        try {
            if (object.getClass().toString().toUpperCase().contains("BIGDECIMAL") || object instanceof Double) {
                return false;
            }
            return object.toString().indexOf(46) == -1;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private BigDecimal convierteABigDecimal(Object object) throws ExceptionMotor {
        try {
            return new BigDecimal(object.toString().trim());
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

