/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.procesadorReglas;

import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import es.aeat.pftw.mtrc.api.configuracion.IRegError;
import es.aeat.pftw.mtrc.api.configuracion.IRegRegla;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.IMotor;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.tools.IGestionReglasExtendida;
import es.aeat.pftw.mtrc.api.procesadorReglas.IFunciones;
import es.aeat.pftw.mtrc.api.procesadorReglas.IGestionReglas;
import es.aeat.pftw.mtrc.api.puente.ITablaMotor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatoRetornoProceso;
import es.aeat.pftw.mtrc.api.tipos.ITipoNotificacion;
import es.aeat.pftw.mtrc.api.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.api.utilidades.INodoArbol;
import es.aeat.pftw.mtrc.imp.procesadorReglas.Comprobaciones;
import es.aeat.pftw.mtrc.imp.tipos.TipoValidacionReglas;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtilesExportacion;
import es.aeat.pftw.mtrc.imp.utilidades.ValidacionesGUIExtra;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GestionReglas
implements IGestionReglas {
    private static final long serialVersionUID = 8565408157459830933L;
    private IMotor motor = null;

    @Override
    public void dispose() {
        this.motor = null;
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            this.motor = (IMotor)objectArray[0];
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean partidaModificada(ISesion iSesion, String string, Object object) throws ExceptionMotor {
        return this.partidaModificada(iSesion, string, object, null);
    }

    @Override
    public boolean partidaModificada(ISesion iSesion, String string, Object object, Map<String, String> map) throws ExceptionMotor {
        if (!iSesion.isEnabled()) {
            return true;
        }
        try {
            if (((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            if (iSesion.getGestionReglas().isEmpezandoPartidaModificadaDesdeImportacion()) {
                iSesion.getGestionReglas().setEmpezandoPartidaModificadaDesdeImportacion(false);
                ITablaMotor iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoPartida(string);
                if (iTablaMotor != null && iTablaMotor.getClaveActiva() != 0L && iSesion.getOperaciones().obtenerEstadoPartida(string) == 254) {
                    IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
                    if (!FuncionesUtiles.getFuncionesUtiles().sonIguales(iRegEntrada.esTipoNumerico(), iSesion.getOperaciones().obtenerPartidaString(string), object.toString())) {
                        if (map != null) {
                            if (map.containsKey("ERRCALCULADO")) {
                                if (this.getDiscriminante(iSesion).contains("P")) {
                                    map.put("CAMPOMOTOR", string);
                                    iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{map.get("ERRCALCULADO"), "E", map});
                                }
                                return false;
                            }
                            map.put("CAMPOMOTOR", string);
                            iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{"IMPROCEDENTE", "E", map});
                        } else {
                            iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{"IMPROCEDENTE", "E", string});
                        }
                        return false;
                    }
                }
            }
            return this.partidaModificadaOestablecerDatosExportacionPartida(iSesion, string, object, "partidaModificada", false, false, null);
        }
        catch (Exception exception) {
            String string2 = " Nombre " + string;
            try {
                string2 = string2 + " valor " + object;
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception instanceof ExceptionMotor) {
                ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + string2);
                throw (ExceptionMotor)exception;
            }
            throw new ExceptionMotor(exception, string2);
        }
    }

    protected boolean prePartidaModificadaValidarEntradaDeDatos(ISesion iSesion, String string, Object object) throws ExceptionMotor {
        try {
            IRegEntrada iRegEntrada;
            int n = 0;
            if (object != null && (iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string)) != null) {
                if (iRegEntrada.getTipoDato().equalsIgnoreCase("ALFABETICO")) {
                    int n2 = iRegEntrada.getTamannioCampo();
                    if (n2 == 0) {
                        n2 = Integer.MAX_VALUE;
                    }
                    n = ValidacionesGUIExtra.getValidaciones().validarCampoAlfabetico(object.toString(), n2);
                } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("CADENA")) {
                    int n3 = iRegEntrada.getTamannioCampo();
                    if (n3 == 0) {
                        n3 = Integer.MAX_VALUE;
                    }
                    n = ValidacionesGUIExtra.getValidaciones().validarCampoAlfanum\u00e9rico(object.toString(), n3);
                } else if (!iRegEntrada.getTipoDato().equalsIgnoreCase("BLOB")) {
                    if (iRegEntrada.getTipoDato().equalsIgnoreCase("CADENA_NUMERICA")) {
                        int n4 = iRegEntrada.getTamannioCampo();
                        if (n4 == 0) {
                            n4 = Integer.MAX_VALUE;
                        }
                        n = ValidacionesGUIExtra.getValidaciones().validarCampoCadNum(object.toString(), n4);
                    } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("TELEFONO")) {
                        int n5 = iRegEntrada.getTamannioCampo();
                        if (n5 == 0) {
                            n5 = Integer.MAX_VALUE;
                        }
                        n = ValidacionesGUIExtra.getValidaciones().validarCampoTelefonoEuropeo(object.toString(), n5);
                    } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("CADENA_NUMERICA_2")) {
                        int n6 = iRegEntrada.getTamannioCampo();
                        if (n6 == 0) {
                            n6 = Integer.MAX_VALUE;
                        }
                        n = ValidacionesGUIExtra.getValidaciones().validarCampoCadNum2(object.toString(), n6);
                    } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("EMAIL")) {
                        int n7 = iRegEntrada.getTamannioCampo();
                        if (n7 == 0) {
                            n7 = Integer.MAX_VALUE;
                        }
                        n = ValidacionesGUIExtra.getValidaciones().validarCampoEmail(object.toString(), n7);
                    } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("LOGICO")) {
                        n = ValidacionesGUIExtra.getValidaciones().validarCampoLogico(object.toString());
                    } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("ENTERO")) {
                        int n8 = 0;
                        try {
                            n8 = Integer.valueOf(iRegEntrada.getPropiedad("NUMEROENTEROS"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n8 == 0) {
                            n8 = Integer.MAX_VALUE;
                        }
                        n = ValidacionesGUIExtra.getValidaciones().validarCampoEntero(object.toString(), n8);
                    } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("FECHA")) {
                        n = ValidacionesGUIExtra.getValidaciones().validarCampoFecha(object.toString());
                    } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("DOBLE")) {
                        int n9 = 0;
                        int n10 = 0;
                        try {
                            n10 = iRegEntrada.getNumDecimales();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            try {
                                n9 = Integer.valueOf(iRegEntrada.getPropiedad("NUMEROENTEROS"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (n9 == 0) {
                                n9 = iRegEntrada.getTamannioCampo() + n10;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        n = ValidacionesGUIExtra.getValidaciones().validarCampoDoble(object.toString(), n9, n10);
                    } else if (iRegEntrada.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                        int n11 = 0;
                        int n12 = 0;
                        try {
                            n12 = iRegEntrada.getNumDecimales();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            n11 = Integer.valueOf(iRegEntrada.getPropiedad("NUMEROENTEROS"));
                        }
                        catch (Exception exception) {
                            try {
                                n11 = iRegEntrada.getTamannioCampo() - n12;
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                        n = ValidacionesGUIExtra.getValidaciones().validarCampoDoble(object.toString(), n11, n12);
                    } else {
                        FuncionesUtiles.getFuncionesUtiles().muestraAviso("Tipo de dato " + iRegEntrada.getTipoDato() + " no esperado en prePartidaModificada!!!");
                    }
                }
            }
            switch (n) {
                case 1: {
                    iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{"CHRNV"});
                    return false;
                }
                case 2: {
                    iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{"LNGINC"});
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            if (exception instanceof ExceptionMotor) {
                throw (ExceptionMotor)exception;
            }
            throw new ExceptionMotor(exception);
        }
    }

    protected boolean partidaModificadaOestablecerDatosExportacionPartida(ISesion iSesion, String string, Object object, String string2, boolean bl, boolean bl2, Map<String, String> map) throws ExceptionMotor {
        if (iSesion.isComprobarCaracteresEnPartidaModificada() && !this.prePartidaModificadaValidarEntradaDeDatos(iSesion, string, object)) {
            return false;
        }
        boolean bl3 = false;
        boolean bl4 = ((ISesionExtendida)iSesion).inTrans();
        boolean bl5 = iSesion.getGestionReglas().isEjecutandoReglas();
        try {
            boolean bl6;
            boolean bl7 = string2.equalsIgnoreCase("PartidaModificada");
            if (bl7) {
                ((IGestionReglasExtendida)iSesion.getGestionReglas()).setEjecutandoReglas(true);
            }
            boolean bl8 = false;
            boolean bl9 = false;
            String string3 = "";
            string3 = iSesion.getOperaciones().obtenerPartidaString(string, map);
            if (!bl4 && ((ISesionExtendida)iSesion).getListaPartidasAfectadasPorPartidaModificada() != null && ((ISesionExtendida)iSesion).getListaPartidasAfectadasPorPartidaModificada().getLista() != null && ((ISesionExtendida)iSesion).getListaPartidasAfectadasPorPartidaModificada().getLista().size() > 0) {
                ((ISesionExtendida)iSesion).getListaPartidasAfectadasPorPartidaModificada().getLista().clear();
            }
            if (string3 != null) {
                if (bl2) {
                    object = string3;
                    bl9 = false;
                } else {
                    bl9 = FuncionesUtiles.getFuncionesUtiles().sonIguales(iSesion.getModelo().getGestorConfiguracion().getEntrada(string).esTipoNumerico(), string3, object);
                }
                bl8 = bl9;
                if (!bl9) {
                    if (!this.isAlmacenarErrorLista(iSesion) && !bl4) {
                        ((IGestionReglasExtendida)iSesion.getGestionReglas()).listaErroresEnReglasClear();
                    }
                    this.setPartidaProcesando(iSesion, string);
                    if (object != null) {
                        if (!bl4) {
                            ((ISesionExtendida)iSesion).beginTrans();
                        }
                        bl3 = true;
                        if (iSesion.getOperaciones().establecerPartida(string, object, string3)) {
                            bl6 = false;
                            bl6 = bl7 ? this.dispararRegla(iSesion, string) : iSesion.getOperaciones().establecerEstado(string, bl);
                            if (bl6) {
                                if (!bl4) {
                                    ((ISesionExtendida)iSesion).commitTrans();
                                }
                                bl3 = false;
                                bl8 = true;
                            } else {
                                if (!bl4) {
                                    ((ISesionExtendida)iSesion).rollBack();
                                }
                                bl3 = false;
                            }
                        } else {
                            if (!bl4) {
                                ((ISesionExtendida)iSesion).rollBack();
                            }
                            bl3 = false;
                        }
                    }
                }
            }
            bl6 = bl8;
            return bl6;
        }
        catch (Exception exception) {
            if (bl3 && !bl4) {
                ((ISesionExtendida)iSesion).rollBack();
            }
            String string4 = " Nombre " + string;
            try {
                string4 = string4 + " valor " + object;
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception instanceof ExceptionMotor) {
                ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + string4);
                throw (ExceptionMotor)exception;
            }
            throw new ExceptionMotor(exception, string4);
        }
        finally {
            ((IGestionReglasExtendida)iSesion.getGestionReglas()).setEjecutandoReglas(bl5);
        }
    }

    protected boolean dispararRegla(ISesion iSesion, String string) throws ExceptionMotor {
        int n = this.getTipoReglaBusqueda(iSesion);
        boolean bl = false;
        try {
            int n2;
            if (((IGestionReglasExtendida)iSesion.getGestionReglas()).getListaTipoReglasBusqueda() == null) {
                bl = true;
                ((IGestionReglasExtendida)iSesion.getGestionReglas()).setListaTipoReglasBusqueda(new ArrayList<Integer>());
                ((IGestionReglasExtendida)iSesion.getGestionReglas()).getListaTipoReglasBusqueda().add(n);
            }
            for (n2 = 0; n2 < ((IGestionReglasExtendida)iSesion.getGestionReglas()).getListaTipoReglasBusqueda().size(); ++n2) {
                this.setTipoReglaBusqueda(iSesion, ((IGestionReglasExtendida)iSesion.getGestionReglas()).getListaTipoReglasBusqueda().get(n2));
                Map<String, List<IRegRegla>> map = iSesion.getModelo().getGestorConfiguracion().getReglasDePartidaClasificadas(string);
                if (map == null || this.procesarReglas(iSesion, map, string)) continue;
                boolean bl2 = false;
                return bl2;
            }
            n2 = 1;
            return n2 != 0;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
        finally {
            if (bl) {
                ((IGestionReglasExtendida)iSesion.getGestionReglas()).setListaTipoReglasBusqueda(null);
            }
            this.setTipoReglaBusqueda(iSesion, n);
        }
    }

    protected boolean procesarReglas(ISesion iSesion, Map<String, List<IRegRegla>> map, String string) throws ExceptionMotor {
        try {
            if (map != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (this.getTipoValidacionReglas(iSesion) == 0) {
                    arrayList.add("V");
                    arrayList.add("O");
                } else {
                    arrayList.add(TipoValidacionReglas.getTipoValidacionReglas().getLetraCorrespondencia(this.getTipoValidacionReglas(iSesion)));
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    List<IRegRegla> list = iSesion.getModelo().getGestorConfiguracion().getReglasDePartidaClasificadas(string).get(((String)arrayList.get(i)).toString());
                    if (list == null) continue;
                    for (int j = 0; j < list.size(); ++j) {
                        if (this.procesaRegla(iSesion, list.get(j), string)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    @Override
    public boolean procesaRegla(ISesion iSesion, IRegRegla iRegRegla, String string) throws ExceptionMotor {
        int n = 0;
        int n2 = this.getUltimaReglaProcesada(iSesion);
        try {
            int n3;
            ((ISesionExtendida)iSesion).addPartidaQueHizoSaltarRegla(iRegRegla.getIdRegla(), string);
            n = 1;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String string2 = "";
            String[] stringArray = iRegRegla.getDestinos();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                hashMap.put(stringArray[n3], ((ISesionExtendida)iSesion).obtenerDestino(stringArray[n3]));
            }
            string2 = iRegRegla.getDiscriminante() == null ? "" : iRegRegla.getDiscriminante();
            if (string2.length() == 0 || this.getDiscriminante(iSesion).toUpperCase().contains(string2.toUpperCase())) {
                this.setUltimaReglaProcesada(iSesion, iRegRegla.getIdRegla());
                if (this.ejecucionDeReglaEnCodigoNumero(iSesion, iRegRegla.getIdRegla())) {
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        if (hashMap.get(stringArray[n3]).toString().equalsIgnoreCase(((ISesionExtendida)iSesion).obtenerDestino(stringArray[n3]).toString()) || this.dispararRegla(iSesion, stringArray[n3])) continue;
                        n = 0;
                    }
                } else {
                    n = 0;
                }
            }
            n3 = n;
            return n3 != 0;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
        finally {
            this.setUltimaReglaProcesada(iSesion, n2);
        }
    }

    protected boolean ejecucionDeReglaEnCodigoNumero(ISesion iSesion, int n) throws ExceptionMotor {
        try {
            return iSesion.getModelo().getClaseCodigoReglas().ejecutaRegla(iSesion, n);
        }
        catch (NullPointerException nullPointerException) {
            if (iSesion.getModelo().getClaseCodigoReglas() == null) {
                throw new ExceptionMotor(nullPointerException, "No se encuentra el bundle de las reglas!!!!");
            }
            throw nullPointerException;
        }
    }

    protected List<IRegRegla> ordenaReglas(ISesion iSesion, List<IRegRegla> list) throws ExceptionMotor {
        try {
            if (list == null) {
                return null;
            }
            ArrayList<IRegRegla> arrayList = new ArrayList<IRegRegla>();
            IRegRegla iRegRegla = null;
            for (int i = 0; i < list.size(); ++i) {
                iRegRegla = list.get(i);
                arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
            }
            if (list.size() == 0) {
                arrayList = null;
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected int enQueOrdenInsertarRegla(ISesion iSesion, List<IRegRegla> list, IRegRegla iRegRegla) {
        try {
            int n = iRegRegla.getOrden();
            if (n == Integer.MAX_VALUE) {
                return list.size();
            }
            for (int i = 0; i < list.size(); ++i) {
                if (n >= list.get(i).getOrden()) continue;
                return i;
            }
            return list.size();
        }
        catch (Exception exception) {
            return list.size();
        }
    }

    @Override
    public boolean ejecutaReglasDePartida(ISesion iSesion, String string) throws ExceptionMotor {
        return this.partidaModificadaOestablecerDatosExportacionPartida(iSesion, string, null, "partidaModificada", false, true, null);
    }

    @Override
    public ITipoDatoRetornoProceso comprobarDeclaracion(ISesion iSesion, String string, String[] stringArray) throws ExceptionMotor {
        return this.comprobarDeclaracion(iSesion, string, stringArray, true);
    }

    @Override
    public ITipoDatoRetornoProceso comprobarDeclaracion(ISesion iSesion, String string, String[] stringArray, boolean bl) throws ExceptionMotor {
        String string2 = iSesion.getGestionReglas().getDiscriminante();
        int n = ((IGestionReglasExtendida)iSesion.getGestionReglas()).getTipoReglaBusqueda();
        boolean bl2 = iSesion.getOrigenDeDatos().isCacheHabilitada();
        try {
            iSesion.getOrigenDeDatos().setCacheHabilitada(true);
            if (!iSesion.getGestionReglas().getDiscriminante().contains("C")) {
                iSesion.getGestionReglas().addDiscriminante("C");
            }
            ((IGestionReglasExtendida)iSesion.getGestionReglas()).listaErroresEnReglasClear();
            INodoArbol iNodoArbol = iSesion.getOperaciones().getArbolDatos();
            String string3 = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string4 : stringArray) {
                hashMap.put(string4.split(",")[0], string4.split(",")[1]);
            }
            string3 = FuncionesUtiles.getFuncionesUtiles().object2String(hashMap.get(string.toUpperCase()));
            INodoArbol iNodoArbol2 = iNodoArbol;
            if (iNodoArbol2.numeroHijos() > 0 && bl) {
                for (int i = 0; i < iNodoArbol2.numeroHijos(); ++i) {
                    this.chequearRegistrosHijosyElMismo(iSesion, iNodoArbol2.getHijo(i).getNombreNodo(), iNodoArbol, hashMap, i);
                }
            } else {
                this.chequearRegistro(iSesion, hashMap, string3, string, -1);
            }
            if (string.equalsIgnoreCase(iSesion.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla())) {
                this.chequearRegistro(iSesion, hashMap, string3, string, -1);
            }
            if (((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoErrores().size() + ((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings().size() >= iSesion.getGestionReglas().getMaxErrores()) {
                FuncionesUtiles.getFuncionesUtiles().dejaSoloNerroresEntreListas(((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoErrores(), ((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings(), iSesion.getGestionReglas().getMaxErrores());
                IRegError iRegError = iSesion.getModelo().getGestorConfiguracion().getError("MAXERR");
                if (iRegError != null) {
                    if (((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings().size() > 0) {
                        ((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings().add(iRegError);
                    } else {
                        ((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoErrores().add(iRegError);
                    }
                }
            }
            ITipoDatoRetornoProceso iTipoDatoRetornoProceso = ((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion();
            return iTipoDatoRetornoProceso;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
        finally {
            iSesion.getOrigenDeDatos().setCacheHabilitada(bl2);
            iSesion.getGestionReglas().setDiscriminante(string2);
            ((IGestionReglasExtendida)iSesion.getGestionReglas()).setTipoReglaBusqueda(n);
        }
    }

    protected void chequearRegistrosHijosyElMismo(ISesion iSesion, String string, INodoArbol iNodoArbol, Map<?, ?> map, int n) throws ExceptionMotor {
        block9: {
            String string2 = "";
            string2 = string.indexOf(47) > -1 ? FuncionesUtiles.getFuncionesUtiles().object2String(map.get(string.substring(0, string.indexOf(47)))) : FuncionesUtiles.getFuncionesUtiles().object2String(map.get(string));
            try {
                long l;
                INodoArbol iNodoArbol2 = iNodoArbol.buscaHijo(string);
                if (iNodoArbol2 == null) {
                    throw new Exception("Imposible encontrar en arbol motor tabla " + string);
                }
                boolean bl = false;
                bl = string.indexOf(47) > -1 ? map.containsKey(string.substring(0, string.indexOf(47))) : map.containsKey(string);
                if (!bl) break block9;
                boolean bl2 = true;
                if (string2.endsWith("[SOLOACTIVO]")) {
                    string2 = string2.substring(0, string2.length() - "[SOLOACTIVO]".length());
                    bl2 = false;
                }
                if ((l = iSesion.getOperaciones().recordCount(string)) <= 0L) break block9;
                if (bl2) {
                    iSesion.getOperaciones().moveFirst(string);
                }
                int n2 = 0;
                while ((long)n2 < l) {
                    for (int i = 0; i < iNodoArbol2.numeroHijos(); ++i) {
                        this.chequearRegistrosHijosyElMismo(iSesion, iNodoArbol2.getHijo(i).getNombreNodo(), iNodoArbol, map, i);
                    }
                    this.chequearRegistro(iSesion, map, string2, string, n2);
                    if (bl2) {
                        iSesion.getOperaciones().moveNext(string);
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (ExceptionMotor exceptionMotor) {
                throw exceptionMotor;
            }
            catch (Exception exception) {
                throw new ExceptionMotor(exception);
            }
        }
    }

    protected void chequearRegistro(ISesion iSesion, Map<?, ?> map, String string, String string2, int n) throws ExceptionMotor {
        try {
            String string3 = string2.indexOf(47) != -1 ? string2.substring(0, string2.indexOf(47)) : string2;
            string = FuncionesUtiles.getFuncionesUtiles().object2String(map.get(string3));
            if (string.endsWith("[SOLOACTIVO]")) {
                string = string.substring(0, string.length() - "[SOLOACTIVO]".length());
            }
            ((IGestionReglasExtendida)iSesion.getGestionReglas()).setTipoReglaBusqueda(8);
            this.chequear(iSesion, string);
            this.anadirErroresEnLista(iSesion, ((IGestionReglasExtendida)iSesion.getGestionReglas()).getListaErroresEnReglas());
            ((IGestionReglasExtendida)iSesion.getGestionReglas()).setTipoReglaBusqueda(3);
            this.chequear(iSesion, string);
            this.anadirErroresEnLista(iSesion, ((IGestionReglasExtendida)iSesion.getGestionReglas()).getListaErroresEnReglas());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected void anadirErroresEnLista(ISesion iSesion, List<IRegError> list) throws ExceptionMotor {
        try {
            if (list == null || list.size() == 0) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getPropiedad("TIPO ERROR").toString().equalsIgnoreCase("E")) {
                    ((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoErrores().add(list.get(i));
                    ((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().setCorrecto(false);
                    continue;
                }
                ((IGestionReglasExtendida)iSesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings().add(list.get(i));
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean chequear(ISesion iSesion, String string, boolean bl) throws ExceptionMotor {
        try {
            boolean bl2;
            if (((ISesionExtendida)iSesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            try {
                if (bl) {
                    ((ISesionExtendida)iSesion).beginTrans();
                }
                bl2 = this.getTipoReglaBusqueda(iSesion) == 8 ? ((Boolean)this.ejecutarFuncion(iSesion, "comprobarRegistroWarning", new Object[]{string})).booleanValue() : ((Boolean)this.ejecutarFuncion(iSesion, "comprobarRegistroConDiscriminante", new Object[]{string})).booleanValue();
                if (bl) {
                    ((ISesionExtendida)iSesion).commitTrans();
                }
            }
            catch (Exception exception) {
                boolean bl3 = false;
                ((ISesionExtendida)iSesion).rollBack();
                throw new ExceptionMotor(exception);
            }
            return bl2;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Partida " + string);
        }
    }

    @Override
    public boolean chequear(ISesion iSesion, String string) throws ExceptionMotor {
        return this.chequear(iSesion, string, true);
    }

    @Override
    public Object ejecutarFuncion(ISesion iSesion, String string, Object[] objectArray) throws ExceptionMotor {
        try {
            ITipoDatoRetornoMetodo iTipoDatoRetornoMetodo = this.getEjecutarFuncionDelValidador(iSesion, string, objectArray);
            if (iTipoDatoRetornoMetodo.isRetornaResultado()) {
                return iTipoDatoRetornoMetodo.getObjetoRetorno();
            }
            if (!iTipoDatoRetornoMetodo.isNoImplementado()) {
                throw new ExceptionMotor("Retorno de m\u00e9todo no esperado!!!");
            }
            if (string.equalsIgnoreCase("setst")) {
                return ((IFunciones)this.motor.getClaseFunciones()).setst(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("getst")) {
                return ((IFunciones)this.motor.getClaseFunciones()).getst(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("error")) {
                return ((IFunciones)this.motor.getClaseFunciones()).error(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("aviso")) {
                return ((IFunciones)this.motor.getClaseFunciones()).aviso(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("longitud")) {
                return ((IFunciones)this.motor.getClaseFunciones()).longitud(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("notifica")) {
                return ((IFunciones)this.motor.getClaseFunciones()).notifica(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("hoy")) {
                return ((IFunciones)this.motor.getClaseFunciones()).hoy();
            }
            if (string.equalsIgnoreCase("comprobarestadodepartida")) {
                return ((IFunciones)this.motor.getClaseFunciones()).comprobarEstadodePartida(iSesion, objectArray);
            }
            if (string.toLowerCase().equalsIgnoreCase("nifvalido")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nifValido(objectArray);
            }
            if (string.equalsIgnoreCase("niffisica")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nifFisica(objectArray);
            }
            if (string.equalsIgnoreCase("nifjuridica")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nifJuridica(objectArray);
            }
            if (string.equalsIgnoreCase("dametiponif")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).dameTipoNif(objectArray);
            }
            if (string.equalsIgnoreCase("nombreynif")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nombreyNif(objectArray);
            }
            if (string.equalsIgnoreCase("nombrevalido")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nombreValido(objectArray);
            }
            if (string.equalsIgnoreCase("validarfecha")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validarFecha(objectArray);
            }
            if (string.equalsIgnoreCase("compararfecha")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compararFecha(objectArray);
            }
            if (string.equalsIgnoreCase("valcntapcampos")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).valCntaPCampos(objectArray);
            }
            if (string.equalsIgnoreCase("valcntapcadena")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).valCntaPCadena(objectArray);
            }
            if (string.equalsIgnoreCase("comprobarnumerojustificante")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).comprobarNumeroJustificante(objectArray[0].toString());
            }
            if (string.equalsIgnoreCase("compNumJust")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compNumJust(objectArray[0].toString(), objectArray[1].toString());
            }
            if (string.equalsIgnoreCase("validarcodigopostal")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validarCodigoPostal(objectArray);
            }
            if (string.equalsIgnoreCase("rnd")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).rnd(objectArray[0], objectArray[1]);
            }
            if (string.equalsIgnoreCase("comprobarregistro")) {
                return ((IFunciones)this.motor.getClaseFunciones()).comprobarRegistro(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("comprobarregistrocondiscriminante")) {
                return ((IFunciones)this.motor.getClaseFunciones()).comprobarRegistroConDiscriminante(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("comprobarregistrowarning")) {
                return ((IFunciones)this.motor.getClaseFunciones()).comprobarRegistroWarning(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("cabeceranumerojustificante")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).cabeceraNumeroJustificante(objectArray);
            }
            if (string.equalsIgnoreCase("comprobarnombrefisica")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).comprobarNombreFisica(objectArray);
            }
            if (string.equalsIgnoreCase("emailCorrecto")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).emailCorrecto(objectArray);
            }
            if (string.equalsIgnoreCase("valorabsoluto")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).valorAbsoluto(objectArray[0]);
            }
            if (string.equalsIgnoreCase("validarcontraficheroauxiliar")) {
                return ((IFunciones)this.motor.getClaseFunciones()).validarContraFicheroAuxiliar(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("generaNumeroJustificante")) {
                return FuncionesUtilesExportacion.getFuncionesUtilesExportacion().generaNumeroJustificante(objectArray).toString();
            }
            if (string.equalsIgnoreCase("generaNumeroDeReferencia")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).generaNumeroDeReferencia(objectArray[0].toString(), objectArray[1].toString()).toString();
            }
            if (string.equalsIgnoreCase("generaNumeroDeReferenciaMI")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).generaNumeroDeReferenciaMI(objectArray[0].toString(), objectArray[1].toString()).toString();
            }
            if (string.equalsIgnoreCase("formatonombrecorrecto")) {
                return ((IFunciones)this.motor.getClaseFunciones()).formatoNombreCorrecto(objectArray);
            }
            if (string.equalsIgnoreCase("nombrefisicocorrecto")) {
                return ((IFunciones)this.motor.getClaseFunciones()).nombreFisicoCorrecto(objectArray);
            }
            if (string.equalsIgnoreCase("sumatorioCampoTabla")) {
                return ((IFunciones)this.motor.getClaseFunciones()).sumatorioCampoTabla(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("campoValidoParaPin")) {
                return ((IFunciones)this.motor.getClaseFunciones()).campoValidoParaPin(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("registrosDeTabla")) {
                return ((IFunciones)this.motor.getClaseFunciones()).registrosDeTabla(iSesion, objectArray);
            }
            if (string.equalsIgnoreCase("nifregimenatribucionrentas")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nifRegimenAtribucionRentas(objectArray);
            }
            if (string.equalsIgnoreCase("abs")) {
                return (Double)((Comprobaciones)this.motor.getClaseComprobaciones()).abs(objectArray[0]);
            }
            if (string.equalsIgnoreCase("esfecha")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).esFecha(objectArray[0].toString(), objectArray[1].toString());
            }
            if (string.equalsIgnoreCase("esfechainvertida")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).esFechaInvertida(objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("compruebacodpostal".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compruebaCodPostal(iSesion, objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("compruebacpconprovi".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compruebaCPconProvi(iSesion, objectArray[0].toString(), objectArray[1].toString(), objectArray[2].toString());
            }
            if (string.toLowerCase().startsWith("compruebaprovincia".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compruebaProvincia(iSesion, objectArray[0].toString(), objectArray[1].toString());
            }
            if (string.toLowerCase().startsWith("esEntero".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).esEntero(objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("hayRegistros".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).hayRegistros(iSesion, objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("validaIBAN".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaIBAN(objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("validaCuentaCliente".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaCuentaCliente(objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("validaCuentaCorriente".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaCuentaCorriente(objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("validaMovil".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaMovil(objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("validaTeleFax".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaTeleFax(objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("validaTelefono".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaTelefono(objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("desformateaCuentaBancaria".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).desformateaCuentaBancaria(objectArray[0].toString(), Integer.parseInt(objectArray[1].toString()));
            }
            if (string.toLowerCase().startsWith("superaUnAnno".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).superaUnAnno(objectArray[0].toString(), objectArray[1].toString());
            }
            if (string.toLowerCase().startsWith("inferiorUnAnno".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).inferiorUnAnno(objectArray[0].toString(), objectArray[1].toString());
            }
            if (string.toLowerCase().startsWith("dameEjercicio".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).dameEjercicio(objectArray[0].toString());
            }
            if (string.toLowerCase().startsWith("establecerNumeroDias".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).establecerEj(objectArray[0].toString(), objectArray[1].toString());
            }
            if (string.toLowerCase().startsWith("establecerEj".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).establecerNumeroDias(objectArray[0].toString(), objectArray[1].toString());
            }
            if (string.toLowerCase().startsWith("validarFechaPeriodo".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validarFechaPeriodo(objectArray[0].toString(), objectArray[1].toString(), objectArray[2].toString());
            }
            if (string.toLowerCase().startsWith("convertirIntACadena".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).convertirIntACadena((Integer)objectArray[0]);
            }
            if (string.toLowerCase().startsWith("dameAdministracion".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).dameAdministracion((String)objectArray[0]);
            }
            if (string.toLowerCase().startsWith("dameNIU".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).dameNIU((String)objectArray[0]);
            }
            throw new ExceptionMotor("No se encuentra la implementaci\u00f3n de la funci\u00f3n " + string);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Funcion " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Funcion " + string);
        }
    }

    protected ITipoDatoRetornoMetodo getEjecutarFuncionDelValidador(ISesion iSesion, String string, Object[] objectArray) throws ExceptionMotor {
        if (iSesion.getModelo().getClaseValidador() == null) {
            return new TipoDatoRetornoMetodo(-99998);
        }
        return iSesion.getModelo().getClaseValidador().ejecutarFuncion(iSesion, string, objectArray);
    }

    @Override
    public void setTipoReglaBusqueda(ISesion iSesion, int n) throws ExceptionMotor {
        this.setTipoValidacionReglas(iSesion, n);
    }

    @Override
    public int getTipoReglaBusqueda(ISesion iSesion) throws ExceptionMotor {
        return this.getTipoValidacionReglas(iSesion);
    }

    @Override
    public int getUltimaReglaProcesada(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).getUltimaReglaProcesada();
    }

    @Override
    public void setUltimaReglaProcesada(ISesion iSesion, int n) throws ExceptionMotor {
        ((IGestionReglasExtendida)iSesion.getGestionReglas()).setUltimaReglaProcesada(n);
    }

    @Override
    public List<Integer> getListaTipoReglasBusqueda(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).getListaTipoReglasBusqueda();
    }

    @Override
    public boolean isAlmacenarErrorLista(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).isAlmacenarErrorLista();
    }

    @Override
    public void setAlmacenarErrorLista(ISesion iSesion, boolean bl) throws ExceptionMotor {
        ((IGestionReglasExtendida)iSesion.getGestionReglas()).setAlmacenarErrorLista(bl);
    }

    @Override
    public String getDiscriminante(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).getDiscriminante();
    }

    @Override
    public void setDiscriminante(ISesion iSesion, String string) throws ExceptionMotor {
        ((IGestionReglasExtendida)iSesion.getGestionReglas()).setDiscriminante(string);
    }

    @Override
    public String getPartidaProcesando(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).getPartidaProcesando();
    }

    @Override
    public void setPartidaProcesando(ISesion iSesion, String string) throws ExceptionMotor {
        ((IGestionReglasExtendida)iSesion.getGestionReglas()).setPartidaProcesando(string);
    }

    @Override
    public boolean isEjecutandoReglas(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).isEjecutandoReglas();
    }

    @Override
    public void setEjecutandoReglas(ISesion iSesion, boolean bl) throws ExceptionMotor {
        ((IGestionReglasExtendida)iSesion.getGestionReglas()).setEjecutandoReglas(bl);
    }

    @Override
    public boolean isCortarEjecucionReglas(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).isCortarEjecucionReglas();
    }

    @Override
    public void setCortarEjecucionReglas(ISesion iSesion, boolean bl) throws ExceptionMotor {
        ((IGestionReglasExtendida)iSesion.getGestionReglas()).setCortarEjecucionReglas(bl);
    }

    @Override
    public List<IRegError> getListaErroresEnReglas(ISesion iSesion) throws ExceptionMotor {
        ArrayList<IRegError> arrayList = new ArrayList<IRegError>();
        for (int i = 0; i < ((IGestionReglasExtendida)iSesion.getGestionReglas()).listaErroresEnReglasSize(); ++i) {
            arrayList.add(((IGestionReglasExtendida)iSesion.getGestionReglas()).listaErroresEnReglasGet(i));
        }
        ((IGestionReglasExtendida)iSesion.getGestionReglas()).listaErroresEnReglasClear();
        return arrayList;
    }

    @Override
    public List<ITipoNotificacion> getNotificaciones(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).getNotificaciones();
    }

    @Override
    public List<IRegError> getRefListaErroresEnReglas(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).getListaErroresEnReglas();
    }

    @Override
    public int getTipoValidacionReglas(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).getTipoValidacionReglas();
    }

    @Override
    public void setTipoValidacionReglas(ISesion iSesion, int n) throws ExceptionMotor {
        ((IGestionReglasExtendida)iSesion.getGestionReglas()).setTipoValidacionReglas(n);
    }

    @Override
    public boolean isExtraerReglasEnHashMap(ISesion iSesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)iSesion.getGestionReglas()).isExtraerReglasEnHashMap();
    }

    @Override
    public void setExtraerReglasEnHashMap(ISesion iSesion, boolean bl) throws ExceptionMotor {
        ((IGestionReglasExtendida)iSesion.getGestionReglas()).setExtraerReglasEnHashMap(bl);
    }

    @Override
    public List<IRegRegla> buscarReglasDePartida(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            if (iSesion.getModelo().getGestorConfiguracion().getConjuntoReglasDePartidaClasificadas().size() > 0) {
                String string2 = TipoValidacionReglas.getTipoValidacionReglas().getLetraCorrespondencia(((IGestionReglasExtendida)iSesion.getGestionReglas()).getTipoValidacionReglas());
                if (string2.equalsIgnoreCase("VO")) {
                    List<IRegRegla> list;
                    List<IRegRegla> list2 = iSesion.getModelo().getGestorConfiguracion().getReglasDePartidaClasificadas(string).get("V");
                    if (list2 == null) {
                        list2 = new ArrayList<IRegRegla>();
                    }
                    if ((list = iSesion.getModelo().getGestorConfiguracion().getReglasDePartidaClasificadas(string).get("O")) == null) {
                        list = new ArrayList<IRegRegla>();
                    }
                    ArrayList arrayList = new ArrayList();
                    return FuncionesUtiles.getFuncionesUtiles().concatList(arrayList, list2, list);
                }
                List<IRegRegla> list = iSesion.getModelo().getGestorConfiguracion().getReglasDePartidaClasificadas(string).get(string2);
                if (list == null) {
                    list = new ArrayList<IRegRegla>();
                }
                return list;
            }
            return this.buscarReglasDePartidaOLD(iSesion, string);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string);
        }
    }

    @Deprecated
    protected List<IRegRegla> buscarReglasDePartidaOLD(ISesion iSesion, String string) throws Exception {
        ArrayList<IRegRegla> arrayList = new ArrayList<IRegRegla>();
        List<IRegRegla> list = iSesion.getModelo().getGestorConfiguracion().getReglasDePartida(string);
        if (list == null) {
            return arrayList;
        }
        IRegRegla iRegRegla = null;
        block12: for (int i = 0; i < list.size(); ++i) {
            iRegRegla = list.get(i);
            switch (((IGestionReglasExtendida)iSesion.getGestionReglas()).getTipoValidacionReglas()) {
                case 0: {
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
                case 1: {
                    if (!iRegRegla.getTipoRegla().equalsIgnoreCase("V")) continue block12;
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
                case 2: {
                    if (!iRegRegla.getTipoRegla().equalsIgnoreCase("O")) continue block12;
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
                case 3: {
                    if (!iRegRegla.getTipoRegla().equalsIgnoreCase("R")) continue block12;
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
                case 4: {
                    if (!iRegRegla.getTipoRegla().equalsIgnoreCase("F")) continue block12;
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
                case 5: {
                    if (!iRegRegla.getTipoRegla().equalsIgnoreCase("E")) continue block12;
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
                case 6: {
                    if (!iRegRegla.getTipoRegla().equalsIgnoreCase("C")) continue block12;
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
                case 7: {
                    if (!iRegRegla.getTipoRegla().equalsIgnoreCase("B")) continue block12;
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
                case 8: {
                    if (!iRegRegla.getTipoRegla().equalsIgnoreCase("W")) continue block12;
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
                case 9: {
                    if (!iRegRegla.getTipoRegla().equalsIgnoreCase("D")) continue block12;
                    arrayList.add(this.enQueOrdenInsertarRegla(iSesion, arrayList, iRegRegla), iRegRegla);
                    continue block12;
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean establecerDatosExportacionPartida(ISesion iSesion, String string, Object object, boolean bl) throws ExceptionMotor {
        return this.partidaModificadaOestablecerDatosExportacionPartida(iSesion, string, object, "establecerDatosExportacionPartida", bl, false, null);
    }
}

