/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.procesadorReglas;

import es.aeat.pftw.mtrc.api.IAop;
import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import es.aeat.pftw.mtrc.api.configuracion.IRegError;
import es.aeat.pftw.mtrc.api.configuracion.IRegRegla;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.IMotor;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.tools.IGestionReglasExtendida;
import es.aeat.pftw.mtrc.api.procesadorReglas.IFunciones;
import es.aeat.pftw.mtrc.api.puente.ITablaMotor;
import es.aeat.pftw.mtrc.api.tipos.DateMotor;
import es.aeat.pftw.mtrc.api.tipos.IDateMotor;
import es.aeat.pftw.mtrc.api.utilidades.StringUtility;
import es.aeat.pftw.mtrc.imp.tipos.TipoNotificacion;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.imp.utilidades.Validaciones;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Funciones
implements IAop,
Serializable,
IFunciones {
    private static final long serialVersionUID = 3446052865095650590L;
    private IMotor motor = null;
    public static final String LITERAL_MENSAJE = "MENSAJE";

    @Override
    public void dispose() throws ExceptionMotor {
        this.motor = null;
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            this.motor = (IMotor)objectArray[0];
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Boolean setst(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            return this.sets(iSesion, objectArray[0].toString(), objectArray[1].toString());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public int getst(ISesion iSesion, Object[] objectArray) {
        return this.gets(iSesion, objectArray[0].toString());
    }

    private boolean sets(ISesion iSesion, String string, Object object) throws ExceptionMotor {
        try {
            boolean bl = true;
            int n = 255;
            if (FuncionesUtiles.getFuncionesUtiles().esNumerico(String.valueOf(object))) {
                n = Double.valueOf(String.valueOf(object)).intValue();
            } else if (!Boolean.valueOf(String.valueOf(object)).booleanValue()) {
                n = 254;
            }
            String[] stringArray = this.getDestinos(iSesion, string);
            for (int i = 0; i < stringArray.length; ++i) {
                bl &= iSesion.getOperaciones().establecerEstado(stringArray[i], n);
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public int longitud(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            return iSesion.getOperaciones().obtenerPartidaString(objectArray[0].toString()).length();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private int gets(ISesion iSesion, String string) {
        try {
            return iSesion.getOperaciones().obtenerEstadoPartida(string);
        }
        catch (Exception exception) {
            return 255;
        }
    }

    @Override
    public String[] getDestinos(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            String[] stringArray = StringUtility.getStringUtility().split(string, ((IGestionReglasExtendida)iSesion.getGestionReglas()).getSeparadorDestinos());
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            return stringArray;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public IDateMotor hoy() throws ExceptionMotor {
        try {
            Calendar calendar = Calendar.getInstance();
            String string = FuncionesUtiles.getFuncionesUtiles().rellena(String.valueOf(calendar.get(5)), '0', 2, true) + "/" + FuncionesUtiles.getFuncionesUtiles().rellena(String.valueOf(calendar.get(2) + 1), '0', 2, true) + "/" + FuncionesUtiles.getFuncionesUtiles().rellena(String.valueOf(calendar.get(1)), '0', 4, true);
            return new DateMotor(string);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Boolean aviso(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        this.error(iSesion, objectArray);
        return true;
    }

    @Override
    public Boolean error(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            Object object;
            String string = objectArray[0].toString();
            IRegError iRegError = FuncionesUtiles.getFuncionesUtiles().generarErrorSiNoExiste(iSesion, string);
            iRegError = iRegError.clone();
            if (objectArray.length != 3) {
                int n;
                if (iSesion.getGestionReglas() != null && (n = ((IGestionReglasExtendida)iSesion.getGestionReglas()).getUltimaReglaProcesada()) != -1) {
                    iRegError.setPropiedad("TIPO REGLA", iSesion.getModelo().getGestorConfiguracion().getRegla(n).getTipoRegla());
                    iRegError.setPropiedad("ID REGLA", String.valueOf(n));
                }
                try {
                    ITablaMotor iTablaMotor;
                    if (iRegError.getCampoError() != null && iRegError.getCampoError().length() > 0 && (iTablaMotor = ((ISesionExtendida)iSesion).obtenerNodoPartida(iRegError.getCampoError())) != null) {
                        iRegError.setPropiedad("LOCALIZACIONERROR", FuncionesUtiles.getFuncionesUtiles().localizacion2String(((ISesionExtendida)iSesion).obtenerNodoPartida(iRegError.getCampoError()).getLocalizacion()));
                    }
                }
                catch (Exception exception) {
                    FuncionesUtiles.getFuncionesUtiles().muestraInfo("No pude establecer donde se produjo el error de un campo");
                }
                ((IGestionReglasExtendida)iSesion.getGestionReglas()).addErrorAListaErroresEnReglas(iRegError);
                return Boolean.FALSE;
            }
            if (objectArray.length > 2) {
                Object object2;
                try {
                    if (objectArray[2] instanceof Map) {
                        object2 = (Map)objectArray[2];
                        object = object2.keySet();
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string2 = ((String)iterator.next()).toString();
                            if (string2.equalsIgnoreCase(LITERAL_MENSAJE)) {
                                if (iRegError.getMsg() != null && iRegError.getMsg().trim().length() != 0) continue;
                                iRegError.setPropiedad(string2, (String)object2.get(string2));
                                continue;
                            }
                            if (string2.equalsIgnoreCase("CAMPOMOTOR")) {
                                iRegError.setPropiedad("CAMPO ERROR", (String)object2.get(string2));
                                continue;
                            }
                            iRegError.setPropiedad(string2, (String)object2.get(string2));
                        }
                    } else {
                        iRegError.setPropiedad("CAMPO ERROR", objectArray[2].toString());
                    }
                }
                catch (Exception exception) {
                    iRegError.setPropiedad("CAMPO ERROR", iRegError.getCampoError());
                }
                try {
                    object2 = objectArray[1].toString();
                    if (((String)object2).length() > 0) {
                        iRegError.setPropiedad("TIPO ERROR", (String)object2);
                    }
                }
                catch (Exception exception) {}
            } else {
                iRegError.setPropiedad("CAMPO ERROR", iRegError.getCampoError());
            }
            boolean bl = false;
            if (iSesion.getOperaciones().getFuncionesErrorComportamientoEspecial()) {
                try {
                    object = iRegError.getPropiedad("TIPO ERROR").toString().trim();
                    if (((String)object).length() > 0 && !((String)object).equalsIgnoreCase("E") && !((String)object).equalsIgnoreCase("H")) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((IGestionReglasExtendida)iSesion.getGestionReglas()).addErrorAListaErroresEnReglas(iRegError);
            iRegError = null;
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Boolean notifica(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            String string = objectArray[0].toString();
            Object[] objectArray2 = objectArray[1].toString().split(",");
            TipoNotificacion tipoNotificacion = new TipoNotificacion(string, objectArray2);
            ((IGestionReglasExtendida)iSesion.getGestionReglas()).addNotificacionAListaNotificaciones(tipoNotificacion);
            return Boolean.TRUE;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean comprobarRegistroConDiscriminante(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            boolean bl = true;
            boolean bl2 = true;
            String string = objectArray[0].toString().trim();
            String string2 = iSesion.getGestionReglas().getDiscriminante();
            String string3 = "";
            List<IRegRegla> list = this.motor.getClaseGestionReglas().buscarReglasDePartida((ISesionExtendida)iSesion, string);
            for (int i = 0; i < list.size(); ++i) {
                IRegRegla iRegRegla = list.get(i);
                string3 = iRegRegla.getDiscriminante() == null ? "" : iRegRegla.getDiscriminante();
                if (string3.length() != 0 && !string2.toUpperCase().contains(string3.toUpperCase())) continue;
                bl2 = this.motor.getClaseGestionReglas().procesaRegla((ISesionExtendida)iSesion, iRegRegla, string);
                if (!bl2) {
                    FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("comprobarRegistroConDiscriminante : Regla " + iRegRegla.getIdRegla() + " retorno falso...");
                }
                bl = bl && bl2;
            }
            if (bl) {
                String string4 = iSesion.getOperaciones().obtenerPartidaString(string);
                if (string4.equalsIgnoreCase("2")) {
                    iSesion.getOperaciones().establecerPartida(string, 2);
                } else {
                    iSesion.getOperaciones().establecerPartida(string, 1);
                }
            } else {
                iSesion.getOperaciones().establecerPartida(string, 0);
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean comprobarRegistroWarning(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            boolean bl = true;
            String string = objectArray[0].toString().trim();
            List<IRegRegla> list = this.motor.getClaseGestionReglas().buscarReglasDePartida((ISesionExtendida)iSesion, string);
            for (int i = 0; i < list.size(); ++i) {
                bl &= this.motor.getClaseGestionReglas().procesaRegla((ISesionExtendida)iSesion, list.get(i), string);
            }
            if (bl) {
                iSesion.getOperaciones().establecerPartida(string, 0);
            } else {
                iSesion.getOperaciones().establecerPartida(string, 2);
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean comprobarRegistro(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            boolean bl = true;
            String string = objectArray[0].toString();
            List<IRegRegla> list = this.motor.getClaseGestionReglas().buscarReglasDePartida((ISesionExtendida)iSesion, string);
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getTipoRegla().equalsIgnoreCase("W")) continue;
                bl &= this.motor.getClaseGestionReglas().procesaRegla((ISesionExtendida)iSesion, list.get(i), string);
            }
            if (bl) {
                String string2 = iSesion.getOperaciones().obtenerPartidaString(string);
                if (string2.equalsIgnoreCase("2")) {
                    iSesion.getOperaciones().establecerPartida(string, 2);
                } else {
                    iSesion.getOperaciones().establecerPartida(string, 1);
                }
            } else {
                iSesion.getOperaciones().establecerPartida(string, 0);
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Boolean comprobarEstadodePartida(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            return this.comprobarEstadodePartida(iSesion, objectArray[1].toString(), (Boolean)objectArray[2]);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private boolean comprobarEstadodePartida(ISesion iSesion, String string, boolean bl) throws ExceptionMotor {
        try {
            int n = 255;
            int n2 = 255;
            n2 = bl ? 255 : 254;
            n = iSesion.getOperaciones().obtenerEstadoPartida(string);
            return n == n2;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Partida " + string);
        }
    }

    @Override
    public Object buscarValorPartida(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            int n = ((IGestionReglasExtendida)iSesion.getGestionReglas()).getNumDecimales();
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada != null && iRegEntrada.getTipoDato().equalsIgnoreCase("DOBLE") || iRegEntrada.getTipoDato().equalsIgnoreCase("BIGDECIMAL") && n < iRegEntrada.getNumDecimales()) {
                ((IGestionReglasExtendida)iSesion.getGestionReglas()).setNumDecimales(iRegEntrada.getNumDecimales());
            }
            return iSesion.getOperaciones().obtenerPartidaString(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean validarContraFicheroAuxiliar(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            if (iSesion.getModelo().getGestorDatosAuxiliares() == null) {
                throw new ExceptionMotor("No se pudieron cargar los ficheros auxiliares");
            }
            return iSesion.getModelo().getGestorDatosAuxiliares().getRegistro(objectArray[0].toString(), objectArray[1].toString()).length() > 0;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean formatoNombreCorrecto(Object[] objectArray) throws ExceptionMotor {
        try {
            String string = objectArray[0].toString();
            if (string.length() == 0) {
                return false;
            }
            char[] cArray = string.toCharArray();
            if (cArray[0] == ' ') {
                return false;
            }
            for (int i = 1; i < cArray.length; ++i) {
                if (cArray[i] != ' ' || cArray[i - 1] != ' ') continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean nombreFisicoCorrecto(Object[] objectArray) throws ExceptionMotor {
        try {
            String string = objectArray[0].toString();
            if (string.length() == 0 || string.length() < 3) {
                return false;
            }
            char[] cArray = string.toCharArray();
            if (cArray[0] == cArray[1] && cArray[0] == cArray[2]) {
                return false;
            }
            if (string.indexOf(32, 0) == -1) {
                return false;
            }
            return Validaciones.getValidaciones().esAlfabeticoAEAT(string);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Object sumatorioCampoTabla(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            String string = objectArray[0].toString();
            int n = Integer.valueOf(objectArray[1].toString());
            IRegEntrada iRegEntrada = iSesion.getModelo().getGestorConfiguracion().getEntrada(string);
            long l = iSesion.getOperaciones().recordCount(iRegEntrada.getIdTabla());
            BigDecimal bigDecimal = BigDecimal.ZERO;
            int n2 = 1;
            while ((long)n2 <= l) {
                bigDecimal = bigDecimal.add(new BigDecimal(iSesion.getOperaciones().obtenerPartidaIndexada(string, n2).trim()));
                ++n2;
            }
            if (n == 0) {
                return bigDecimal;
            }
            return bigDecimal.setScale(n, 4);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public int registrosDeTabla(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        return (int)iSesion.getOperaciones().recordCount(objectArray[0].toString());
    }

    @Override
    public boolean campoValidoParaPin(ISesion iSesion, Object[] objectArray) throws ExceptionMotor {
        try {
            if (iSesion.getModelo().getGestorConfiguracion().getEntrada("VALORESPIN") != null && iSesion.getOperaciones().obtenerPartidaString("VALORESPIN").trim().length() > 0) {
                String string = objectArray[0].toString();
                int n = Integer.valueOf(objectArray[1].toString());
                String string2 = "";
                try {
                    string2 = iSesion.getOperaciones().obtenerPartidaString("VALORESPIN").split(";")[n];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(string.trim().length() <= 0 && string2.trim().length() <= 0 || string.trim().equalsIgnoreCase(string2.trim()))) {
                    iSesion.getGestionReglas().ejecutarFuncion(iSesion, "error", new Object[]{"FRECH"});
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

