/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.procesadorReglas;

import es.aeat.pftw.mtrc.api.IAop;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.tipos.DateMotor;
import es.aeat.pftw.mtrc.api.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.imp.procesadorReglas.ValidaNif;
import es.aeat.pftw.mtrc.imp.utilidades.Formatear;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.imp.utilidades.Validaciones;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Comprobaciones
implements IAop,
Serializable {
    private static final long serialVersionUID = 3065431035827135233L;
    private static ValidaNif validarNif = null;
    private final int LONGITUD_MODELO = 3;

    @Override
    public void dispose() throws ExceptionMotor {
        if (validarNif != null) {
            validarNif.dispose();
            validarNif = null;
        }
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            validarNif = new ValidaNif();
            validarNif.init(new Object[0]);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String dameAdministracion(String string) throws ExceptionMotor {
        try {
            Class<?> clazz = Class.forName("es.aeat.MRBV_APCO.RUTIIMR");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getNIU", String.class);
            Object object = method.invoke(obj, string);
            method = object.getClass().getMethod("getAdm", new Class[0]);
            return method.invoke(object, new Object[0]).toString();
        }
        catch (InvocationTargetException invocationTargetException) {
            return "";
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionMotor("No dispongo de las librerias para hacer esta funci\u00f3n!!!");
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String dameNIU(String string) throws ExceptionMotor {
        try {
            Class<?> clazz = Class.forName("es.aeat.MRBV_APCO.RUTIIMR");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getNIU", String.class);
            Object object = method.invoke(obj, string);
            method = object.getClass().getMethod("getCodigo", new Class[0]);
            return method.invoke(object, new Object[0]).toString();
        }
        catch (InvocationTargetException invocationTargetException) {
            return "";
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionMotor("No dispongo de las librerias para hacer esta funci\u00f3n!!!");
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean compNumJust(String string, String string2) throws ExceptionMotor {
        try {
            boolean bl = false;
            int n = 0;
            String string3 = "";
            bl = string.length() == 0 ? false : ((n = this.filtroNSerie(string2, string3)) == 0 ? false : string2.substring(0, 3).equals(string));
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean comprobarNumeroJustificante(String string) throws ExceptionMotor {
        try {
            boolean bl = false;
            int n = 0;
            String string2 = "";
            bl = string.equalsIgnoreCase("0") ? true : (n = this.filtroNSerie(string, string2)) != 0;
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String generaNumeroDeReferenciaMI(String string, String string2) throws ExceptionMotor {
        return this.generaNumeroDeReferencia(string, "9998", string2);
    }

    public String generaNumeroDeReferencia(String string, String string2) throws ExceptionMotor {
        return this.generaNumeroDeReferencia(string, "9999", string2);
    }

    private String generaNumeroDeReferencia(String string, String string2, String string3) throws ExceptionMotor {
        try {
            String string4;
            String string5;
            int n = 0;
            String string6 = string;
            if (string6.length() == 0) {
                throw new Exception("Debe rellenar el Nif para calcular el numero de referencia");
            }
            if (Character.isLetter((string6 = string6.substring(0, 9)).charAt(8)) && Character.isLetter(string6.charAt(0))) {
                string5 = "9";
                string5 = string5 + string6.substring(1, 8);
            } else {
                string5 = Character.isLetter(string6.charAt(8)) && !Character.isLetter(string6.charAt(0)) ? string6.substring(0, 8) : string6.substring(1, 9);
            }
            string2 = string2 + string5;
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateInstance(3);
            String string7 = dateFormat.format(date);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/mm/yyyy");
            Date date2 = simpleDateFormat.parse(string7);
            String string8 = string4 = simpleDateFormat.format(date2);
            string7 = string8.substring(0, 2);
            string7 = string7 + string8.substring(3, 5);
            string7 = string7 + "20" + string8.substring(8, 10);
            String string9 = "";
            long l = 0L;
            l = this.comparaFechas(string3, string7) == 1 ? this.totalDias(string7, string3) : this.totalDias(string3, string7);
            string6 = string9 = Long.toString(Math.abs(l));
            if (string6.length() == 1) {
                string6 = "0" + string6;
            }
            string2 = string2 + string6.substring(0, 2);
            Calendar calendar = Calendar.getInstance();
            long l2 = (long)(calendar.get(11) + 1) * (long)(calendar.get(12) + 1) * (long)(calendar.get(13) + 1);
            String string10 = "";
            string6 = string10 = Long.toString(l2);
            for (n = string10.length() - 1; n < 4; ++n) {
                string6 = "0" + string6;
            }
            string2 = string2 + string6;
            n = this.modulo7(string2);
            String string11 = Integer.toString(n);
            return string2 + string11;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private int modulo7(String string) throws Exception {
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.substring(i, i + 1).equals(".")) continue;
            int n3 = n2 * n + Integer.parseInt(string.substring(i, i + 1));
            n = n3 % 7;
            n2 = 10;
        }
        if (n != 0) {
            n = 7 - n;
            return n;
        }
        return 0;
    }

    private int comparaFechas(String string, String string2) {
        if (!this.depuraFecha(string) || !this.depuraFecha(string2)) {
            return -2;
        }
        Fecha fecha = this.fechaaInt(string);
        if (!fecha.valida()) {
            return -2;
        }
        Fecha fecha2 = this.fechaaInt(string2);
        if (!fecha2.valida()) {
            return -2;
        }
        if (fecha.anno() < fecha2.anno()) {
            return -1;
        }
        if (fecha.anno() > fecha2.anno()) {
            return 1;
        }
        if (fecha.mes() < fecha2.mes()) {
            return -1;
        }
        if (fecha.mes() > fecha2.mes()) {
            return 1;
        }
        if (fecha.dia() < fecha2.dia()) {
            return -1;
        }
        if (fecha.dia() > fecha2.dia()) {
            return 1;
        }
        return 0;
    }

    private boolean depuraFecha(String string) {
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        Fecha fecha = this.fechaaInt(string);
        if (!fecha.valida()) {
            return false;
        }
        nArray[1] = fecha.anno() % 4 == 0 && (fecha.anno() % 100 != 0 || fecha.anno() % 400 == 0) ? 29 : 28;
        if (fecha.anno() < 0) {
            return false;
        }
        if (fecha.mes() < 1 || fecha.mes() > 12) {
            return false;
        }
        return fecha.dia() >= 1 && fecha.dia() <= nArray[fecha.mes() - 1];
    }

    private Fecha fechaaInt(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        string = string.replaceAll("/", "");
        if ((string = string.replaceAll("-", "")).length() != 8) {
            bl = false;
        } else {
            bl = true;
            n = Integer.parseInt(string.substring(0, 2));
            n2 = Integer.parseInt(string.substring(2, 4));
            n3 = Integer.parseInt(string.substring(4, 8));
        }
        return new Fecha(n, n2, n3, bl);
    }

    private long totalDias(String string, String string2) {
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (!this.depuraFecha(string) || !this.depuraFecha(string2)) {
            return -1L;
        }
        Fecha fecha = this.fechaaInt(string);
        if (!fecha.valida()) {
            return -1L;
        }
        Fecha fecha2 = this.fechaaInt(string2);
        if (!fecha2.valida()) {
            return -1L;
        }
        int n = this.comparaFechas(string, string2);
        if (n == -2 || n == 1) {
            return -1L;
        }
        if (n == 0) {
            return 0L;
        }
        long l = 0L;
        if (fecha.anno() < fecha2.anno()) {
            int n2;
            nArray[1] = fecha.anno() % 4 == 0 && (fecha.anno() % 100 != 0 || fecha.anno() % 400 == 0) ? 29 : 28;
            l = nArray[fecha.mes() - 1] - fecha.dia();
            for (n2 = fecha.mes(); n2 < 12; ++n2) {
                l += (long)nArray[n2];
            }
            for (n2 = fecha.anno() + 1; n2 < fecha2.anno(); ++n2) {
                if (n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0)) {
                    l += 366L;
                    continue;
                }
                l += 365L;
            }
            nArray[1] = fecha2.anno() % 4 == 0 && (fecha2.anno() % 100 != 0 || fecha2.anno() % 400 == 0) ? 29 : 28;
            for (n2 = 1; n2 < fecha2.mes(); ++n2) {
                l += (long)nArray[n2 - 1];
            }
            l += (long)fecha2.dia();
        } else {
            nArray[1] = fecha.anno() % 4 == 0 && (fecha.anno() % 100 != 0 || fecha.anno() % 400 == 0) ? 29 : 28;
            if (fecha.mes() < fecha2.mes()) {
                l += (long)(nArray[fecha.mes() - 1] - fecha.dia());
                for (int i = fecha.mes(); i < fecha2.mes() - 1; ++i) {
                    l += (long)nArray[i];
                }
                l += (long)fecha2.dia();
            } else {
                l = fecha2.dia() - fecha.dia();
            }
        }
        return l;
    }

    public boolean nifFisica(Object[] objectArray) throws ExceptionMotor {
        try {
            return this.nifFisica(objectArray[0].toString());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean nifFisica(String string) throws ExceptionMotor {
        try {
            int n = this.getValidarNif().checkNif(string);
            return n == 1 || n == 4 || n == 3 || n == 2;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean nifJuridica(Object[] objectArray) throws ExceptionMotor {
        try {
            return this.nifJuridica(objectArray[0].toString());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean nifJuridica(String string) throws ExceptionMotor {
        try {
            int n = this.getValidarNif().checkNif(string);
            return n == 21 || n == 23 || n == 20 || n == 22;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean nifValido(Object[] objectArray) throws ExceptionMotor {
        try {
            String string = objectArray[0].toString();
            if (string.length() == 0) {
                return true;
            }
            int n = this.getValidarNif().checkNifSinFormatear(string);
            return n > 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean nombreValido(Object[] objectArray) throws ExceptionMotor {
        try {
            if (objectArray.length > 0) {
                String string = objectArray[0].toString();
                if (string.length() == 0) {
                    return false;
                }
                if (string.indexOf(32, 0) == -1) {
                    return false;
                }
                char[] cArray = string.toCharArray();
                if (cArray[0] == ' ') {
                    return false;
                }
                return (cArray[0] != cArray[1] || cArray[0] != cArray[2]) && string.length() != 0;
            }
            return false;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean validarFecha(Object[] objectArray) throws ExceptionMotor {
        String string = "yyyyMMdd";
        boolean bl = false;
        try {
            String string2 = objectArray[0].toString();
            String string3 = "";
            String string4 = "";
            try {
                string3 = ((BigDecimal)objectArray[1]).intValue() + "0101";
            }
            catch (Exception exception) {
                string3 = ((Double)objectArray[1]).intValue() + "0101";
            }
            try {
                string4 = ((BigDecimal)objectArray[2]).intValue() + "1231";
            }
            catch (Exception exception) {
                string4 = ((Double)objectArray[2]).intValue() + "1231";
            }
            boolean bl2 = this.esFechaInvertida(string2);
            if (bl2) {
                boolean bl3 = this.esFechaInvertida(string3);
                boolean bl4 = this.esFechaInvertida(string4);
                if (bl3 && bl4 && bl2) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                    simpleDateFormat.setLenient(false);
                    Date date = simpleDateFormat.parse(string2);
                    Date date2 = simpleDateFormat.parse(string3);
                    Date date3 = simpleDateFormat.parse(string4);
                    if (date.compareTo(date2) >= 0 && date3.compareTo(date) >= 0) {
                        bl = true;
                    }
                }
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int abs(int n) throws ExceptionMotor {
        try {
            return Math.abs(n);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public double abs(double d) throws ExceptionMotor {
        try {
            return Math.abs(d);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public long abs(long l) throws ExceptionMotor {
        try {
            return Math.abs(l);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Object abs(Object object) throws ExceptionMotor {
        try {
            if (object instanceof String) {
                return this.rnd(object.toString());
            }
            if (object instanceof BigDecimal) {
                return this.abs((BigDecimal)object);
            }
            return Math.abs(Double.valueOf(object.toString()));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public BigDecimal abs(BigDecimal bigDecimal) throws ExceptionMotor {
        try {
            return bigDecimal.abs();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String abs(String string) throws ExceptionMotor {
        try {
            return this.abs(new BigDecimal(string.trim())).toString();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean nifRegimenAtribucionRentas(Object[] objectArray) throws ExceptionMotor {
        try {
            return this.getValidarNif().checkNif(objectArray[0].toString()) == 23;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int dameTipoNif(Object[] objectArray) throws ExceptionMotor {
        try {
            return this.getValidarNif().checkNif(objectArray[0].toString());
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Boolean valCntaPCampos(Object[] objectArray) throws ExceptionMotor {
        try {
            boolean bl = false;
            String string = "";
            if (objectArray.length == 4) {
                String string2 = objectArray[0].toString();
                String string3 = objectArray[1].toString();
                String string4 = objectArray[2].toString();
                String string5 = objectArray[3].toString();
                if (string2.compareTo("") == 0 || string3.compareTo("") == 0 || string4.compareTo("") == 0 || string5.compareTo("") == 0) {
                    bl = true;
                } else {
                    int n;
                    string = string2.trim() + string3.trim() + string4.trim() + string5.trim();
                    if (string.length() == 20 && !string.equalsIgnoreCase("00000000000000000000") && (n = this.getValidarNif().controlaCuenta(string)) == 0) {
                        bl = true;
                    }
                }
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Boolean valCntaPCadena(Object[] objectArray) throws ExceptionMotor {
        try {
            boolean bl = false;
            String string = "";
            string = string + objectArray[0].toString();
            if (string.length() == 0) {
                bl = true;
            } else if (string.length() == 20) {
                return this.valCntaPCampos(new Object[]{string.substring(0, 4), string.substring(4, 8), string.substring(8, 10), string.substring(10)});
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean nombreyNif(Object[] objectArray) throws ExceptionMotor {
        try {
            String string = objectArray[0].toString();
            String string2 = objectArray[1].toString();
            if (string.length() > 0 && string2.length() > 0) {
                char[] cArray = string2.toCharArray();
                if (this.nifFisica(string)) {
                    if (string2.indexOf(32, 0) == -1) {
                        return false;
                    }
                    if (cArray[0] == ' ') {
                        return false;
                    }
                    if (cArray[0] == cArray[1] && cArray[0] == cArray[2]) {
                        return false;
                    }
                    if (!Validaciones.getValidaciones().esAlfabeticoAEAT(string2)) {
                        return false;
                    }
                    if (Validaciones.getValidaciones().esNumericaAEAT(string2)) {
                        return false;
                    }
                } else {
                    if (this.getValidarNif().checkNif(string) == 0) {
                        return false;
                    }
                    if (cArray[0] == ' ') {
                        return false;
                    }
                }
                for (int i = 1; i < cArray.length; ++i) {
                    if (cArray[i] != ' ' || cArray[i - 1] != ' ') continue;
                    return false;
                }
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean caracteresDiferentes(String string) throws ExceptionMotor {
        try {
            char c = string.substring(0, 1).toCharArray()[0];
            int n = 0;
            if (c >= '0' && c <= '9') {
                for (n = 0; n <= 7 && c == string.substring(n + 1, 1).toCharArray()[0]; ++n) {
                }
                return n != 8;
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean esFechaInvertida(String string) throws ExceptionMotor {
        return this.esFecha(string, "yyyyMMdd");
    }

    public boolean esFecha(String string, String string2) throws ExceptionMotor {
        if (string2.indexOf("m") != -1) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso("Pattern de fecha incorrecto " + string2 + " se sustituye por " + string2.replaceAll("m", "M"));
            string2 = string2.replaceAll("m", "M");
        }
        if (string2.contains("/") && string.contains("-")) {
            string = string.replaceAll("-", "/");
        } else if (string2.contains("-") && string.contains("/")) {
            string = string.replaceAll("/", "-");
        }
        if (!string2.contains("/")) {
            string = string.replaceAll("/", "");
        }
        if (!string2.contains("-")) {
            string = string.replaceAll("-", "");
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.setLenient(false);
            simpleDateFormat.parse(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int filtroNSerie(String string, String string2) throws ExceptionMotor {
        int n;
        String string3 = string;
        String string4 = string2;
        int n2 = 0;
        try {
            n2 = string3.length();
            if (n2 == 13) {
                int n3;
                n = 0;
                string4 = "";
                string4 = this.obtenerNSerie(string3);
                n2 = string4.length();
                if (n2 == 13 && (n3 = this.comprobarDigitoControl(string4)) == -1) {
                    n = 1;
                }
            } else {
                n = 0;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
        return n;
    }

    private int comprobarDigitoControl(String string) throws ExceptionMotor {
        String string2 = "";
        try {
            double d = Double.parseDouble(string.substring(string.length() - 1, string.length()));
            string2 = string.substring(0, string.length() - 1);
            double d2 = Double.parseDouble(string2);
            double d3 = (long)(d2 / 7.0);
            double d4 = d2 - d3 * 7.0;
            d4 = 7.0 - d4;
            if (d4 == 7.0) {
                d4 = 0.0;
            }
            if (d4 == d) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private int nCarsOK(String string) throws ExceptionMotor {
        int n = 0;
        int n2 = 0;
        try {
            for (int i = 0; i < string.length(); ++i) {
                n2 = Integer.parseInt(string.substring(i, i + 1));
                if (n2 < 0 && n2 > 9) continue;
                ++n;
            }
            return n;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private String obtenerNSerie(String string) throws ExceptionMotor {
        String string2;
        String string3 = "";
        String string4 = "";
        string4 = string;
        try {
            int n = 0;
            int n2 = 0;
            string2 = "";
            string3 = "";
            for (n = 0; n < string4.length(); ++n) {
                String string5 = string4.substring(n, n + 1);
                if (string5.equalsIgnoreCase(" ")) continue;
                if (!string5.equalsIgnoreCase(" ") && n2 < 13) {
                    string3 = string3 + string5;
                    continue;
                }
                if (this.nCarsOK(string3) <= this.nCarsOK(string2)) continue;
                string2 = string3;
            }
            if (this.nCarsOK(string3) > this.nCarsOK(string2)) {
                string2 = string3;
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
        return string2;
    }

    public int rnd(int n) throws ExceptionMotor {
        try {
            return Math.round(n);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public double rnd(double d) throws ExceptionMotor {
        try {
            return Math.round(d);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public long rnd(long l) throws ExceptionMotor {
        try {
            return Math.round(l);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public BigDecimal rnd(BigDecimal bigDecimal) throws ExceptionMotor {
        try {
            return this.rnd(bigDecimal, new BigDecimal(2));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public BigDecimal rnd(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws ExceptionMotor {
        try {
            return new BigDecimal(bigDecimal.toString().trim()).setScale(bigDecimal2.intValue(), 4);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String rnd(String string) throws ExceptionMotor {
        try {
            return this.rnd(new BigDecimal(string.trim())).toString();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String rnd(String string, String string2) throws ExceptionMotor {
        try {
            return this.rnd(new BigDecimal(string.trim()), new BigDecimal(string2.trim())).toString();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Object rnd(Object object) throws ExceptionMotor {
        try {
            return new Double(Math.round(new Double(object.toString())));
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Object rnd(Object object, Object object2) throws ExceptionMotor {
        try {
            if (object instanceof String) {
                return this.rnd(object.toString(), object2.toString());
            }
            if (object instanceof BigDecimal) {
                return this.rnd((BigDecimal)object, (BigDecimal)object2);
            }
            return Formatear.getFormatear().redondea(object, object2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean cabeceraNumeroJustificante(Object[] objectArray) throws ExceptionMotor {
        try {
            String string = objectArray[0].toString();
            String string2 = objectArray[1].toString();
            if (string2.equalsIgnoreCase("0")) {
                return true;
            }
            if (string2.length() < 3) {
                return false;
            }
            return string2.substring(0, 3).equals(string);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String valorAbsoluto(String string) throws ExceptionMotor {
        try {
            return this.abs(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Object valorAbsoluto(Object object) throws ExceptionMotor {
        try {
            if (object instanceof String) {
                return this.abs(object.toString());
            }
            if (object instanceof Integer) {
                return this.abs((Integer)object);
            }
            if (object instanceof Double) {
                return this.abs((Double)object);
            }
            if (object instanceof BigDecimal) {
                return this.abs((BigDecimal)object);
            }
            return this.abs(object);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Boolean comprobarNombreFisica(Object[] objectArray) throws ExceptionMotor {
        try {
            return new Boolean(this.nombreyNif(new Object[]{"00000101D", objectArray[0].toString()}));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean emailCorrecto(Object[] objectArray) throws ExceptionMotor {
        try {
            String string = objectArray[0].toString();
            Pattern pattern = null;
            Matcher matcher = null;
            String string2 = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
            pattern = Pattern.compile(string2);
            matcher = pattern.matcher(string);
            return matcher.find();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean compararFecha(Object[] objectArray) throws ExceptionMotor {
        try {
            String string = objectArray[0].toString();
            String string2 = objectArray[1].toString();
            String string3 = objectArray[2].toString();
            if (string3.equalsIgnoreCase("<>") || string3.equalsIgnoreCase("!=") && !string.equalsIgnoreCase(string2)) {
                return true;
            }
            if (string3.indexOf(62) > -1 && string.compareTo(string2) > 0) {
                return true;
            }
            if (string3.indexOf(60) > -1 && string.compareTo(string2) < 0) {
                return true;
            }
            return string3.indexOf(61) > -1 && string.compareTo(string2) == 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public void setValidarNif(ValidaNif validaNif) throws ExceptionMotor {
        validarNif = validaNif;
    }

    public ValidaNif getValidarNif() throws ExceptionMotor {
        if (validarNif == null) {
            this.init(null);
        }
        return validarNif;
    }

    public boolean validarCodigoPostal(Object[] objectArray) throws ExceptionMotor {
        return this.compruebaCodPostal(null, objectArray[0].toString());
    }

    public boolean compruebaCodPostal(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            if (string.length() != 5) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                return false;
            }
            return Integer.valueOf(string) >= 1001 && Integer.valueOf(string) <= 52999;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean compruebaCPconProvi(ISesion iSesion, String string, String string2, String string3) throws ExceptionMotor {
        try {
            if (!this.compruebaCodPostal(iSesion, string2)) {
                return true;
            }
            if (string3.trim().length() == 0 || string3.trim().equalsIgnoreCase("00")) {
                return true;
            }
            int n = this.existeCodProvincia(iSesion, string, string2.substring(0, 2));
            if (n == -1) {
                throw new Exception("Provincia con Codigo " + string2.substring(0, 2) + " no existe en Tabla de provincias!!!");
            }
            return iSesion.getModelo().getGestorDatosAuxiliares().getTabla(string).get(n).getNombreCampo().trim().equalsIgnoreCase(string3);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean compruebaProvincia(ISesion iSesion, String string, String string2) throws ExceptionMotor {
        try {
            return this.existeCodProvincia(iSesion, string, string2) != -1;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public int existeCodProvincia(ISesion iSesion, String string, String string2) throws ExceptionMotor {
        try {
            return TipoDatosCampoValor.indiceListaContieneCampo(iSesion.getModelo().getGestorDatosAuxiliares().getTabla(string), string2);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean hayRegistros(ISesion iSesion, String string) throws ExceptionMotor {
        try {
            return iSesion.getOperaciones().recordCount(string) > 0L;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean esEntero(String string) throws ExceptionMotor {
        try {
            try {
                Integer.valueOf(string);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean validaMovil(String string) {
        return (string.startsWith("6") || string.startsWith("7") || string.startsWith("8")) && string.trim().length() == 9;
    }

    public boolean validaTeleFax(String string) {
        return !string.startsWith("0") && string.trim().length() == 9;
    }

    public boolean validaTelefono(String string) {
        return this.validaMovil(string) || this.validaTeleFax(string);
    }

    public int validaCuentaCorriente(String string) throws ExceptionMotor {
        try {
            string = string.replaceAll("/", "-");
            if (string.length() == 20 && string.indexOf("-") == -1) {
                string = string.substring(0, 4) + "-" + string.substring(4, 8) + "-" + string.substring(8, 10) + "-" + string.substring(10);
            }
            if (string.startsWith("0000")) {
                return 1;
            }
            return this.validaCuentaCliente(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Integer validaCuentaCliente(String string) throws ExceptionMotor {
        try {
            int[] nArray = new int[]{6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
            long l = 0L;
            long l2 = 0L;
            if (string.length() > 23) {
                return 0;
            }
            if (string == null | string.length() != 23) {
                return 1;
            }
            string = this.desformateaCuentaBancaria(string, 20);
            char[] cArray = string.toCharArray();
            int n = 7;
            int n2 = 0;
            while (n >= 0) {
                l += (long)((cArray[n] - 48) * nArray[n2]);
                --n;
                ++n2;
            }
            l2 = Math.abs(l % 11L - 11L);
            if (l2 == 10L) {
                l2 = 1L;
            }
            if (l2 == 11L) {
                l2 = 0L;
            }
            if (l2 != (long)(cArray[8] - 48)) {
                return 1;
            }
            l = 0L;
            n = 19;
            n2 = 0;
            while (n >= 10) {
                l += (long)((cArray[n] - 48) * nArray[n2]);
                --n;
                ++n2;
            }
            l2 = Math.abs(l % 11L - 11L);
            if (l2 == 10L) {
                l2 = 1L;
            }
            if (l2 == 11L) {
                l2 = 0L;
            }
            if (l2 != (long)(cArray[9] - 48)) {
                return 2;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public boolean validaIBAN(String string) throws ExceptionMotor {
        try {
            if (string.length() < 14 || string.length() > 34) {
                return false;
            }
            if (!(Validaciones.getValidaciones().esAlfabetico(string.charAt(0)) && Validaciones.getValidaciones().esAlfabetico(string.charAt(1)) && Validaciones.getValidaciones().esNumerica(string.charAt(2)) && Validaciones.getValidaciones().esNumerica(string.charAt(3)))) {
                return false;
            }
            for (int i = 4; i < string.length(); ++i) {
                if (Validaciones.getValidaciones().esAlfabetico(string.charAt(i)) || Validaciones.getValidaciones().esNumerica(string.charAt(i))) continue;
                return false;
            }
            String string2 = string.substring(4) + string.substring(0, 2) + "00";
            String string3 = "";
            for (byte by : string2.getBytes()) {
                string3 = Validaciones.getValidaciones().esNumerica((char)by) ? string3 + (char)by : string3 + String.valueOf(by - 55);
            }
            Object object = new BigDecimal(string3);
            object = ((BigDecimal)object).divideAndRemainder(new BigDecimal(97))[1];
            return ((BigDecimal)(object = new BigDecimal(98).subtract((BigDecimal)object))).intValue() == Integer.valueOf(string.substring(2, 4)).intValue();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String desformateaCuentaBancaria(String string, int n) throws ExceptionMotor {
        try {
            String string2 = string;
            String string3 = "";
            for (int i = 0; i < string2.length(); ++i) {
                if (!FuncionesUtiles.getFuncionesUtiles().esNumerico(string2.substring(i, i + 1))) continue;
                string3 = string3 + string2.substring(i, i + 1);
            }
            while (string3.length() < n) {
                string3 = string3 + "0";
            }
            return string3;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Boolean superaUnAnno(String string, String string2) throws ExceptionMotor {
        try {
            Date date = new DateMotor(string).getDate();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setLenient(false);
            Date date2 = new DateMotor(string2).getDate();
            if (date2 == null || date == null) {
                return true;
            }
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setLenient(false);
            gregorianCalendar2.setTime(date2);
            gregorianCalendar.setTime(date);
            if (gregorianCalendar.get(5) == 29 && gregorianCalendar.get(2) == 1) {
                ((Calendar)gregorianCalendar).add(5, 1);
            }
            ((Calendar)gregorianCalendar).add(1, 1);
            ((Calendar)gregorianCalendar).add(6, -1);
            return gregorianCalendar2.after(gregorianCalendar);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Boolean inferiorUnAnno(String string, String string2) throws ExceptionMotor {
        try {
            Date date = new DateMotor(string).getDate();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setLenient(false);
            Date date2 = new DateMotor(string2).getDate();
            if (date2 == null || date == null) {
                return true;
            }
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setLenient(false);
            gregorianCalendar2.setTime(date2);
            gregorianCalendar.setTime(date);
            if (gregorianCalendar.get(5) == 29 && gregorianCalendar.get(2) == 1) {
                ((Calendar)gregorianCalendar).add(5, 1);
            }
            ((Calendar)gregorianCalendar).add(1, 1);
            ((Calendar)gregorianCalendar).add(6, -1);
            boolean bl = gregorianCalendar2.before(gregorianCalendar);
            return bl;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Integer dameEjercicio(String string) throws ExceptionMotor {
        try {
            int n = 0;
            Date date = new DateMotor(string).getDate();
            if (date != null) {
                try {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setLenient(false);
                    gregorianCalendar.setTime(date);
                    n = gregorianCalendar.get(1);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    n = 0;
                }
            }
            return n;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Integer establecerNumeroDias(String string, String string2) throws ExceptionMotor {
        try {
            int n = 0;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
            gregorianCalendar.setLenient(false);
            gregorianCalendar2.setLenient(false);
            gregorianCalendar3.setLenient(false);
            Date date = new DateMotor(string).getDate();
            Date date2 = new DateMotor(string2).getDate();
            gregorianCalendar.setTime(date);
            gregorianCalendar2.setTime(date2);
            gregorianCalendar3.setTime(gregorianCalendar.getTime());
            ((Calendar)gregorianCalendar3).add(1, 1);
            ((Calendar)gregorianCalendar3).add(6, -1);
            if (gregorianCalendar.after(gregorianCalendar2)) {
                return -1;
            }
            n = gregorianCalendar2.get(5) == gregorianCalendar3.get(5) && gregorianCalendar2.get(2) == gregorianCalendar3.get(2) && gregorianCalendar2.get(1) == gregorianCalendar3.get(1) ? 365 : (gregorianCalendar.get(1) == gregorianCalendar2.get(1) ? gregorianCalendar2.get(6) - gregorianCalendar.get(6) + 1 : ((Calendar)gregorianCalendar).getMaximum(6) - gregorianCalendar.get(6) + gregorianCalendar2.get(6));
            return n;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String establecerEj(String string, String string2) throws ExceptionMotor {
        try {
            boolean bl;
            Date date = new DateMotor(string).getDate();
            Date date2 = new DateMotor(string2).getDate();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar.setLenient(false);
            gregorianCalendar2.setLenient(false);
            gregorianCalendar.setTime(date);
            gregorianCalendar2.setTime(date2);
            gregorianCalendar.clear(11);
            gregorianCalendar2.clear(11);
            if (gregorianCalendar.after(gregorianCalendar2)) {
                return "0";
            }
            GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
            gregorianCalendar3.setLenient(false);
            gregorianCalendar3.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
            if (gregorianCalendar3.get(5) == 29 && gregorianCalendar3.get(2) == 1) {
                ((Calendar)gregorianCalendar3).add(5, 1);
            }
            ((Calendar)gregorianCalendar3).add(1, 1);
            ((Calendar)gregorianCalendar3).add(6, -1);
            gregorianCalendar2.clear(11);
            gregorianCalendar3.clear(11);
            boolean bl2 = gregorianCalendar.get(5) == 1 && gregorianCalendar.get(2) == 0;
            boolean bl3 = gregorianCalendar2.get(5) == gregorianCalendar3.get(5) && gregorianCalendar2.get(2) == gregorianCalendar3.get(2) && gregorianCalendar2.get(1) == gregorianCalendar3.get(1);
            boolean bl4 = bl = gregorianCalendar3.after(gregorianCalendar2) && !bl3;
            if (gregorianCalendar3.before(gregorianCalendar2)) {
                return "0";
            }
            if (bl3 && bl2) {
                return "1";
            }
            if (bl) {
                return "3";
            }
            return "2";
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Boolean validarFechaPeriodo(String string, String string2, String string3) throws ExceptionMotor {
        try {
            Date date = new DateMotor(string).getDate();
            Date date2 = new DateMotor(string2).getDate();
            Date date3 = new DateMotor(string3).getDate();
            if (date == null || date2 == null || date3 == null) {
                return false;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
            gregorianCalendar.setLenient(false);
            gregorianCalendar2.setLenient(false);
            gregorianCalendar3.setLenient(false);
            gregorianCalendar.setTime(date);
            gregorianCalendar2.setTime(date2);
            gregorianCalendar3.setTime(date3);
            if (gregorianCalendar.before(gregorianCalendar2)) {
                return false;
            }
            if (gregorianCalendar.after(gregorianCalendar3)) {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public String convertirIntACadena(int n) {
        return String.valueOf(n);
    }

    class Fecha {
        private int mDia;
        private int mMes;
        private int mAnno;
        private boolean mValida = false;

        public int dia() {
            return this.mDia;
        }

        public int mes() {
            return this.mMes;
        }

        public int anno() {
            return this.mAnno;
        }

        public boolean valida() {
            return this.mValida;
        }

        public Fecha(int n, int n2, int n3, boolean bl) {
            this.mDia = n;
            this.mMes = n2;
            this.mAnno = n3;
            this.mValida = bl;
        }
    }
}

