/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.origenDatos.mem.transacciones.clonado;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.origenDatos.ITabla;
import es.aeat.pftw.mtrc.api.origenDatos.mem.transacciones.IGestorTransacciones;
import es.aeat.pftw.mtrc.api.puente.ITablaMotor;
import es.aeat.pftw.mtrc.api.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrc.imp.origenDatos.mem.OrigenDatosMem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GestorTransaccionesClonado
implements IGestorTransacciones,
Serializable {
    private static final long serialVersionUID = 8092618459789313281L;
    private int contadorTransacciones = 0;
    private List<ITabla> clonedRaiz = new ArrayList<ITabla>();
    private OrigenDatosMem origenDatos = null;

    @Override
    public void dispose() throws ExceptionMotor {
        this.clonedRaiz = null;
        this.origenDatos = null;
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            this.origenDatos = (OrigenDatosMem)objectArray[0];
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected OrigenDatosMem getOrigenDatos() {
        return this.origenDatos;
    }

    @Override
    public boolean addEventoInicioTransaccion() throws ExceptionMotor {
        try {
            if (this.getOrigenDatos().getRaiz() == null) {
                return false;
            }
            this.clonedRaiz.add(this.getOrigenDatos().getRaiz().clone());
            if (this.clonedRaiz.size() == 0) {
                throw new ExceptionMotor("No se pudo clonar el Raiz!!!");
            }
            ++this.contadorTransacciones;
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean addEventoCommitTransaccion() throws ExceptionMotor {
        try {
            if (this.contadorTransacciones == 0) {
                throw new ExceptionMotor("No hay transacciones activas!!!");
            }
            this.clonedRaiz.remove(this.clonedRaiz.size() - 1);
            --this.contadorTransacciones;
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean addEventoRollBackTransaccion() throws ExceptionMotor {
        try {
            if (this.contadorTransacciones == 0) {
                throw new ExceptionMotor("No hay transacciones activas!!!");
            }
            this.getOrigenDatos().setRaiz(this.clonedRaiz.get(this.clonedRaiz.size() - 1));
            this.clonedRaiz.remove(this.clonedRaiz.size() - 1);
            --this.contadorTransacciones;
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean addEventoValueChanged(ITablaMotor iTablaMotor, ITablaMotorEntrada iTablaMotorEntrada) throws ExceptionMotor {
        try {
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean addEventoAddedRecord(ITablaMotor iTablaMotor, long l) throws ExceptionMotor {
        try {
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean addEventoDeletedRecord(ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean enTransaccion() {
        return this.contadorTransacciones > 0;
    }
}

