/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.origenDatos.mem;

import es.aeat.pftw.mtrc.api.IAop;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.api.origenDatos.ITabla;
import es.aeat.pftw.mtrc.api.origenDatos.ITipoHijoTabla;
import es.aeat.pftw.mtrc.imp.origenDatos.mem.Tabla;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TipoHijoTabla
implements Serializable,
IAop,
ITipoHijoTabla {
    private static final long serialVersionUID = -1492409346700369474L;
    private String nombreTabla = "";
    private List<ITabla> tablasHijas = null;
    private int recordCount = 0;
    private IOrigenDatos io = null;

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            for (Object object : objectArray) {
                if (object instanceof IOrigenDatos) {
                    this.io = (IOrigenDatos)object;
                    continue;
                }
                if (!(object instanceof String)) continue;
                this.nombreTabla = object.toString();
            }
            this.tablasHijas = new ArrayList<ITabla>();
            this.recordCount = 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        this.tablasHijas = null;
        this.io = null;
    }

    @Override
    public IOrigenDatos getIo() {
        return this.io;
    }

    @Override
    public ITabla getItem(int n) {
        try {
            return this.tablasHijas.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public List<ITabla> getListaRegistros() {
        return this.tablasHijas;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    protected int rcAdded() throws ExceptionMotor {
        try {
            ++this.recordCount;
            return this.getRecordCount();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected int rcRemoved() throws ExceptionMotor {
        try {
            if (this.getRecordCount() < 1) {
                throw new ExceptionMotor("Intentado borrar registro y no existe!!!");
            }
            --this.recordCount;
            return this.getRecordCount();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public long addTablaHija() throws ExceptionMotor {
        try {
            Tabla tabla = new Tabla();
            tabla.init(new Object[]{this.nombreTabla, this.getIo()});
            this.tablasHijas.add(tabla);
            return this.rcAdded();
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + this.nombreTabla);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + this.nombreTabla);
        }
    }

    @Override
    public long addTablaHija(ITabla iTabla, long l) throws ExceptionMotor {
        try {
            if (this.getRecordCount() > 0 && l < (long)this.getRecordCount()) {
                this.tablasHijas.add((int)l, iTabla);
                this.rcAdded();
                return l;
            }
            this.rcAdded();
            this.tablasHijas.add(iTabla);
            return this.getRecordCount();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean borrarTablaHija(int n) throws ExceptionMotor {
        try {
            if (this.getRecordCount() > 0 && n < this.getRecordCount()) {
                this.tablasHijas.remove(n);
                this.rcRemoved();
                return true;
            }
            return false;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

