/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.origenDatos.mem;

import es.aeat.pftw.mtrc.api.IAop;
import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import es.aeat.pftw.mtrc.api.configuracion.RegEntrada;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.api.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.api.origenDatos.ITabla;
import es.aeat.pftw.mtrc.api.origenDatos.ITipoHijoTabla;
import es.aeat.pftw.mtrc.api.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrc.api.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.api.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.imp.origenDatos.mem.TipoHijoTabla;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Tabla
implements Serializable,
IAop,
ITabla {
    private static final long serialVersionUID = -1194911663505899557L;
    private Map<String, ITablaMotorEntrada> registro = null;
    private String tabla = "";
    private Map<String, ITipoHijoTabla> tablasHijas = null;
    private IOrigenDatos io = null;

    @Override
    public void dispose() throws ExceptionMotor {
        this.registro = null;
        this.tablasHijas = null;
        this.io = null;
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            Object object2;
            for (Object object2 : objectArray) {
                if (object2 instanceof IOrigenDatos) {
                    this.io = (IOrigenDatos)object2;
                    continue;
                }
                if (!(object2 instanceof String)) continue;
                this.tabla = object2.toString();
            }
            this.tablasHijas = new HashMap<String, ITipoHijoTabla>();
            Object object3 = new HashMap();
            List<String> list = this.getIo().getGestorConfiguracion().getCamposDeTabla(this.tabla);
            IRegEntrada iRegEntrada = null;
            object2 = "";
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i).toString();
                    if (string == null) continue;
                    iRegEntrada = this.getIo().getGestorConfiguracion().getEntrada(string);
                    object2 = iRegEntrada.getTipoDato();
                    if (((String)object2).equalsIgnoreCase("ENTERO")) {
                        object3.put(string, new TablaMotorEntrada(string, Integer.valueOf(iRegEntrada.getValorInicial()), iRegEntrada.getEstadoInicial() + ""));
                    } else if (((String)object2).equalsIgnoreCase("DOBLE")) {
                        object3.put(string, new TablaMotorEntrada(string, Double.valueOf(iRegEntrada.getValorInicial()), iRegEntrada.getEstadoInicial() + ""));
                    } else if (((String)object2).equalsIgnoreCase("BIGDECIMAL")) {
                        object3.put(string, new TablaMotorEntrada(string, iRegEntrada.getValorInicial(), iRegEntrada.getEstadoInicial() + ""));
                    } else if (((String)object2).equalsIgnoreCase("LOGICO")) {
                        object3.put(string, new TablaMotorEntrada(string, Boolean.valueOf(iRegEntrada.getValorInicial()), iRegEntrada.getEstadoInicial() + ""));
                    } else {
                        object3.put(string, new TablaMotorEntrada(string, iRegEntrada.getValorInicial(), iRegEntrada.getEstadoInicial() + ""));
                    }
                    iRegEntrada = null;
                }
            }
            iRegEntrada = null;
            this.registro = object3;
            object3 = null;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Tabla() {
    }

    protected Tabla(IOrigenDatos iOrigenDatos, String string) {
        this.setIo(iOrigenDatos);
        this.tabla = string;
    }

    @Override
    public String getTabla() {
        return this.tabla;
    }

    @Override
    public boolean hasTabla(String string) {
        if (this.getTablasHijas() == null) {
            return false;
        }
        return this.getTablasHijas().containsKey(string.toUpperCase());
    }

    @Override
    public ITabla getTablaHija(String string, long l) {
        if (!this.hasTabla(string)) {
            return null;
        }
        return this.getTablasHijas().get(string.toUpperCase()).getItem((int)l - 1);
    }

    @Override
    public int recordCount(String string) {
        if (!this.hasTabla(string)) {
            return 0;
        }
        return this.getTablasHijas().get(string.toUpperCase()).getRecordCount();
    }

    @Override
    public void clear() {
        if (this.getRegistro() != null) {
            this.getRegistro().clear();
        }
        this.getTablasHijas().clear();
    }

    @Override
    public boolean limpiaRegistro() {
        if (this.getRegistro() != null) {
            this.getRegistro().clear();
        }
        return true;
    }

    @Override
    public void setRegistro(Map<String, ITablaMotorEntrada> map) {
        this.registro = map;
    }

    @Override
    public Map<String, ITablaMotorEntrada> getRegistro() {
        return this.registro;
    }

    @Override
    public void setTablasHijas(Map<String, ITipoHijoTabla> map) {
        this.tablasHijas = map;
    }

    @Override
    public Map<String, ITipoHijoTabla> getTablasHijas() {
        return this.tablasHijas;
    }

    @Override
    public boolean establecerPartida(String string, String string2) throws ExceptionMotor {
        try {
            IRegEntrada iRegEntrada = this.getIo().getGestorConfiguracion().getEntrada(string);
            string = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(string);
            ITablaMotorEntrada iTablaMotorEntrada = this.registro.get(string);
            if (iTablaMotorEntrada == null) {
                if (iRegEntrada == null && (string.equalsIgnoreCase("ID") || string.equalsIgnoreCase("IDINF"))) {
                    iRegEntrada = new RegEntrada();
                    iRegEntrada.inicializaRegEntrada(string, this.getTabla(), "ENTERO".toUpperCase(), "1");
                }
                if (!iRegEntrada.getIdTabla().equalsIgnoreCase(this.getTabla())) {
                    throw new ExceptionMotor("La partida " + string + " no pertenece a la tabla " + this.getTabla());
                }
                iTablaMotorEntrada = new TablaMotorEntrada(string, iRegEntrada.getValorInicial(), iRegEntrada.getEstadoInicial());
                iRegEntrada = null;
            }
            if (iRegEntrada != null && iRegEntrada.esTipoNumerico()) {
                String string3 = "";
                int n = 0;
                if (iRegEntrada.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    try {
                        n = Integer.valueOf(iRegEntrada.getPropiedad("NUMEROENTEROS").toString());
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        n = Integer.valueOf(iRegEntrada.getPropiedad("LONGITUD").toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n == 0) {
                        try {
                            n = Integer.valueOf(iRegEntrada.getPropiedad("NUMEROENTEROS").toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (n != 0) {
                    string3 = FuncionesUtiles.getFuncionesUtiles().rellena("", '9', n);
                    int n2 = iRegEntrada.getNumDecimales();
                    if (n2 > 0) {
                        string3 = string3 + "." + FuncionesUtiles.getFuncionesUtiles().rellena("", '9', n2);
                    }
                    if (string3.trim().length() == 0) {
                        string3 = "0";
                    }
                    if (FuncionesUtiles.getFuncionesUtiles().mayorQue(string2, string3) || FuncionesUtiles.getFuncionesUtiles().menorQue(string2, "-" + string3)) {
                        if (this.getIo().isControlOverflow()) {
                            throw new ExceptionMotor("OVERFLOW_MOTOR");
                        }
                        try {
                            TipoDatosCampoValor tipoDatosCampoValor = new TipoDatosCampoValor(string, "");
                            tipoDatosCampoValor.setValor(((ISesionExtendida)this.getIo().getSesion()).obtenerNodoPartida(string).getLocalizacion(((ISesionExtendida)this.getIo().getSesion()).getNodoPrincipal()));
                            ((ISesionExtendida)this.getIo().getSesion()).add2ListaOverFlow(tipoDatosCampoValor);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (!this.getIo().isControlOverflow()) {
                        try {
                            if (this.getIo().getSesion().getListaOverFlow().size() > 0) {
                                TipoDatosCampoValor tipoDatosCampoValor = new TipoDatosCampoValor(string, "");
                                tipoDatosCampoValor.setValor(((ISesionExtendida)this.getIo().getSesion()).obtenerNodoPartida(string).getLocalizacion(((ISesionExtendida)this.getIo().getSesion()).getNodoPrincipal()));
                                ((ISesionExtendida)this.getIo().getSesion()).removeFromListaOverFlow(tipoDatosCampoValor);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            if (iRegEntrada != null && iRegEntrada.getTipoDato().equalsIgnoreCase("BLOB")) {
                iTablaMotorEntrada.setValor(FuncionesUtiles.getFuncionesUtiles().compressByteArray(FuncionesUtiles.getFuncionesUtiles().serializableString2byteArray(string2)));
            } else {
                iTablaMotorEntrada.setValor(string2);
            }
            this.registro.put(string, iTablaMotorEntrada);
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean establecerEstado(String string, int n) throws ExceptionMotor {
        try {
            string = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(string);
            ITablaMotorEntrada iTablaMotorEntrada = this.registro.get(string);
            if (iTablaMotorEntrada == null) {
                IRegEntrada iRegEntrada = this.getIo().getGestorConfiguracion().getEntrada(string);
                if (!iRegEntrada.getIdTabla().equalsIgnoreCase(this.getTabla())) {
                    throw new ExceptionMotor("La partida no pertenece a esta tabla");
                }
                iTablaMotorEntrada = new TablaMotorEntrada(string, iRegEntrada.getValorInicial(), iRegEntrada.getEstadoInicial());
                iRegEntrada = null;
            }
            iTablaMotorEntrada.setEstado(n);
            this.registro.put(string, iTablaMotorEntrada);
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String obtenerPartidaString(String string) throws ExceptionMotor {
        try {
            IRegEntrada iRegEntrada = this.getIo().getGestorConfiguracion().getEntrada(string);
            ITablaMotorEntrada iTablaMotorEntrada = this.registro.get(string);
            if (iTablaMotorEntrada == null) {
                if (string.equalsIgnoreCase("ID") || string.equalsIgnoreCase("IDINF")) {
                    return "-1";
                }
                if (iRegEntrada == null) {
                    throw new ExceptionMotor("Entrada " + string + " no se encuentra en entradas!!!");
                }
                return iRegEntrada.getValorInicial();
            }
            if (iRegEntrada != null && iRegEntrada.getTipoDato().equalsIgnoreCase("BLOB")) {
                if (iTablaMotorEntrada.getValor() != null) {
                    if (iTablaMotorEntrada.getValor() instanceof String) {
                        return iTablaMotorEntrada.getValor().toString();
                    }
                    return new String(FuncionesUtiles.getFuncionesUtiles().inflateByteArray((byte[])iTablaMotorEntrada.getValor()));
                }
                return iRegEntrada.getValorInicial();
            }
            return iTablaMotorEntrada.getValor().toString();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public int obtenerEstado(String string) throws ExceptionMotor {
        try {
            ITablaMotorEntrada iTablaMotorEntrada = this.registro.get(string);
            if (iTablaMotorEntrada == null) {
                IRegEntrada iRegEntrada = this.getIo().getGestorConfiguracion().getEntrada(string);
                if (iRegEntrada == null) {
                    throw new ExceptionMotor("Entrada " + string + " no se encuentra en entradas!!!");
                }
                return iRegEntrada.getEstadoInicial();
            }
            return Integer.valueOf(iTablaMotorEntrada.getEstado().toString());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITabla clone() throws CloneNotSupportedException {
        Tabla tabla = null;
        try {
            Object object;
            tabla = new Tabla(this.getIo(), this.getTabla());
            HashMap<String, Object> hashMap = null;
            if (this.getTablasHijas() != null) {
                hashMap = new HashMap<String, Object>();
                for (String collection2 : this.getTablasHijas().keySet()) {
                    object = new TipoHijoTabla();
                    object.init(new Object[]{this.io, collection2});
                    for (int i = 0; i < this.getTablasHijas().get(collection2).getRecordCount(); ++i) {
                        object.addTablaHija(this.getTablasHijas().get(collection2).getItem(i).clone(), i);
                    }
                    hashMap.put(collection2, object);
                    object = null;
                }
            }
            tabla.setTablasHijas(hashMap);
            Object object2 = null;
            if (this.getRegistro() != null) {
                object2 = new HashMap();
                Collection<ITablaMotorEntrada> collection = this.getRegistro().values();
                object = collection.iterator();
                ITablaMotorEntrada iTablaMotorEntrada = null;
                while (object.hasNext()) {
                    iTablaMotorEntrada = (ITablaMotorEntrada)object.next();
                    object2.put(iTablaMotorEntrada.getNombreEntrada(), iTablaMotorEntrada.clone());
                    iTablaMotorEntrada = null;
                }
                iTablaMotorEntrada = null;
            }
            tabla.setRegistro((Map<String, ITablaMotorEntrada>)object2);
            Tabla tabla2 = tabla;
            return tabla2;
        }
        catch (Exception exception) {
            FuncionesUtiles.getFuncionesUtiles().muestraError(exception);
            ITabla iTabla = null;
            return iTabla;
        }
        finally {
            tabla = null;
        }
    }

    @Override
    public String toString() {
        return this.getTabla();
    }

    @Override
    public void setIo(IOrigenDatos iOrigenDatos) {
        this.io = iOrigenDatos;
        if (this.getTablasHijas() != null) {
            for (String string : this.getTablasHijas().keySet()) {
                for (int i = 0; i < this.getTablasHijas().get(string).getRecordCount(); ++i) {
                    this.getTablasHijas().get(string).getItem(i).setIo(iOrigenDatos);
                }
            }
        }
    }

    @Override
    public IOrigenDatos getIo() {
        return this.io;
    }

    @Override
    public long addTablaHija(String string) throws ExceptionMotor {
        if (this.getTablasHijas().get(string.toUpperCase()) == null) {
            TipoHijoTabla tipoHijoTabla = new TipoHijoTabla();
            tipoHijoTabla.init(new Object[]{this.io, string.toUpperCase()});
            this.getTablasHijas().put(string.toUpperCase(), tipoHijoTabla);
        }
        return this.getTablasHijas().get(string.toUpperCase()).addTablaHija();
    }

    @Override
    public long addTablaHija(ITabla iTabla, long l) throws ExceptionMotor {
        if (this.getTablasHijas().get(iTabla.getTabla()) == null) {
            TipoHijoTabla tipoHijoTabla = new TipoHijoTabla();
            tipoHijoTabla.init(new Object[]{this.io, iTabla.getTabla()});
            this.getTablasHijas().put(iTabla.getTabla(), tipoHijoTabla);
        }
        return this.getTablasHijas().get(iTabla.getTabla()).addTablaHija(iTabla, l - 1L);
    }

    @Override
    public boolean borrarTablaHija(String string, int n) throws ExceptionMotor {
        if (this.getTablasHijas().get(string.toUpperCase()) == null) {
            return false;
        }
        return this.getTablasHijas().get(string.toUpperCase()).borrarTablaHija(n - 1);
    }

    @Override
    public int getRecordCountTotal() throws ExceptionMotor {
        try {
            int n = 1;
            Set<String> set = this.getTablasHijas().keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                ITipoHijoTabla iTipoHijoTabla = this.getTablasHijas().get(string);
                for (int i = 0; i < iTipoHijoTabla.getRecordCount(); ++i) {
                    n += iTipoHijoTabla.getItem(i).getRecordCountTotal();
                }
            }
            return n;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

