/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.origenDatos.mem;

import es.aeat.pftw.mtrc.api.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import es.aeat.pftw.mtrc.api.configuracion.IRegTabla;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.excepciones.NotImplementedException;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.api.origenDatos.IPersistencia;
import es.aeat.pftw.mtrc.api.origenDatos.ITabla;
import es.aeat.pftw.mtrc.api.origenDatos.ITipoHijoTabla;
import es.aeat.pftw.mtrc.api.origenDatos.mem.transacciones.IGestorTransacciones;
import es.aeat.pftw.mtrc.api.puente.ITablaMotor;
import es.aeat.pftw.mtrc.api.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrc.api.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValorEx;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosRegistro;
import es.aeat.pftw.mtrc.imp.origenDatos.mem.CachePosicionamientos;
import es.aeat.pftw.mtrc.imp.origenDatos.mem.Tabla;
import es.aeat.pftw.mtrc.imp.origenDatos.mem.transacciones.bitacora.GestorTransaccionesBitacora;
import es.aeat.pftw.mtrc.imp.origenDatos.mem.transacciones.clonado.GestorTransaccionesClonado;
import es.aeat.pftw.mtrc.imp.tipos.TipoDatosCampoValorEx;
import es.aeat.pftw.mtrc.imp.tipos.TipoDatosRegistro;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class OrigenDatosMem
implements IOrigenDatos,
Serializable {
    private static final long serialVersionUID = -7868110166066935065L;
    private boolean controlOverflow = true;
    private boolean origenDeDatosOrdenadoPorCriterio = false;
    private IGestorTransacciones gestorTransacciones = null;
    private ITabla raiz = null;
    private boolean trabajandoConAtributo = false;
    private int modoTransaccion = 1;
    private ISesion sesion = null;
    private transient CachePosicionamientos cachePosicionamiento = null;
    private boolean cacheHabilitada = false;
    private transient ITipoDatosCampoValorEx cacheListaRegistrosIndexada = null;
    private Object lightWeightContent = null;
    int con = 0;

    protected void limpiarCaches() throws ExceptionMotor {
        try {
            this.setCacheListaRegistrosIndexada(null);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        try {
            this.cerrarAlmacenamiento();
            this.limpiarCaches();
            if (this.gestorTransacciones != null) {
                this.gestorTransacciones.dispose();
                this.gestorTransacciones = null;
            }
            this.cachePosicionamiento = null;
            this.raiz = null;
            this.sesion = null;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public ISesion getSesion() {
        return this.sesion;
    }

    @Override
    public void setSesion(ISesion iSesion) {
        this.sesion = iSesion;
        try {
            this.limpiarCaches();
        }
        catch (ExceptionMotor exceptionMotor) {
            // empty catch block
        }
    }

    protected CachePosicionamientos getCachePosicionamiento() {
        if (this.cachePosicionamiento == null) {
            this.cachePosicionamiento = new CachePosicionamientos(5);
        }
        return this.cachePosicionamiento;
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            this.sesion = (ISesion)objectArray[0];
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Object crearDeclaracionPorDefecto() throws ExceptionMotor {
        try {
            IRegTabla iRegTabla = this.getSesion().getModelo().getGestorConfiguracion().getTablaNivel(0);
            if (iRegTabla == null) {
                throw new ExceptionMotor("No se han recuperado la tabla de nivel 0.");
            }
            String string = null;
            if (iRegTabla != null) {
                string = iRegTabla.getIdTabla();
            }
            if (string == null) {
                throw new ExceptionMotor("No se ha recuperado nombre de la tabla ra\u00edz.");
            }
            String string2 = "ISO-8859-1";
            String string3 = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><" + string.toUpperCase() + "></" + string.toUpperCase() + ">";
            InputSource inputSource = new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(string3.getBytes(string2)), Charset.forName(string2)));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean abrirAlmacenamiento() {
        try {
            this.limpiarCaches();
        }
        catch (ExceptionMotor exceptionMotor) {
            // empty catch block
        }
        if (this.gestorTransacciones != null) {
            try {
                this.gestorTransacciones.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.gestorTransacciones = null;
        }
        return this.getRaiz() != null;
    }

    @Override
    public boolean abrirAlmacenamiento(Object object) throws ExceptionMotor {
        try {
            this.limpiarCaches();
            if (object == null) {
                object = this.crearDeclaracionPorDefecto();
            }
            if (object == null) {
                return this.abrirAlmacenamiento();
            }
            if (this.gestorTransacciones != null) {
                try {
                    this.gestorTransacciones.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.gestorTransacciones = null;
            }
            return this.getPersist().establece(this, this, object);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean abrirAlmacenamiento(Object object, Map<String, String> map) throws ExceptionMotor {
        return this.abrirAlmacenamiento(object);
    }

    @Override
    public IGestorConfiguracion getGestorConfiguracion() throws ExceptionMotor {
        return this.getSesion().getModelo().getGestorConfiguracion();
    }

    @Override
    public boolean cerrarAlmacenamiento() {
        if (this.getRaiz() != null) {
            this.getRaiz().clear();
        }
        this.setRaiz(null);
        return true;
    }

    @Override
    public boolean beginTrans() throws ExceptionMotor {
        try {
            return this.getGestorTransacciones().addEventoInicioTransaccion();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean commitTrans() throws ExceptionMotor {
        try {
            return this.getGestorTransacciones().addEventoCommitTransaccion();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean rollBack(boolean bl) throws ExceptionMotor {
        return this.rollBack();
    }

    @Override
    public boolean rollBack() throws ExceptionMotor {
        try {
            return this.getGestorTransacciones().addEventoRollBackTransaccion();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected ITabla comunPosicionarPuntero(List<ITipoDatosCampoValor> list) throws ExceptionMotor {
        try {
            ITabla iTabla = null;
            if (this.isCacheHabilitada() && (iTabla = this.getCachePosicionamiento().getElemento(list.toString())) != null) {
                return iTabla;
            }
            iTabla = this.getRaiz();
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getNombreCampo().equalsIgnoreCase(iTabla.getTabla())) continue;
                if (iTabla.hasTabla(list.get(i).getNombreCampo())) {
                    if ((iTabla = iTabla.getTablaHija(list.get(i).getNombreCampo(), Integer.valueOf(list.get(i).getValor()).intValue())) != null || !list.get(i).getValor().equalsIgnoreCase("0")) continue;
                    return null;
                }
                return null;
            }
            if (this.isCacheHabilitada()) {
                this.getCachePosicionamiento().a\u00f1ade(list.toString(), iTabla);
            }
            return iTabla;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected ITabla posicionarPuntero(ITablaMotor iTablaMotor) throws ExceptionMotor {
        return this.comunPosicionarPuntero(iTablaMotor.getLocalizacion());
    }

    protected ITabla posicionarPunteroEnPadre(ITablaMotor iTablaMotor) throws ExceptionMotor {
        List<ITipoDatosCampoValor> list = iTablaMotor.getLocalizacion();
        list.remove(list.size() - 1);
        return this.comunPosicionarPuntero(list);
    }

    @Override
    public long anniadirRegistro(ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            ITabla iTabla = this.posicionarPunteroEnPadre(iTablaMotor);
            if (iTabla == null) {
                return 0L;
            }
            long l = iTabla.addTablaHija(iTablaMotor.getNombre());
            this.getGestorTransacciones().addEventoAddedRecord(iTablaMotor, l);
            return l;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean borrarRegistro(ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            this.limpiarCaches();
            ITabla iTabla = this.posicionarPunteroEnPadre(iTablaMotor);
            if (iTabla == null) {
                return false;
            }
            this.getGestorTransacciones().addEventoDeletedRecord(iTablaMotor);
            this.cachePosicionamiento = null;
            return iTabla.borrarTablaHija(iTablaMotor.getNombre(), (int)iTablaMotor.getClaveActiva());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean limpiaRegistro(ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            this.limpiarCaches();
            ITabla iTabla = this.posicionarPuntero(iTablaMotor);
            boolean bl = iTabla.limpiaRegistro();
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public long recordCount(ITablaMotor iTablaMotor) {
        try {
            if (iTablaMotor.getNombre().equalsIgnoreCase(this.getRaiz().getTabla())) {
                return 1L;
            }
            ITabla iTabla = this.posicionarPunteroEnPadre(iTablaMotor);
            if (iTabla == null) {
                return 0L;
            }
            return iTabla.recordCount(iTablaMotor.getNombre());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public boolean establecerPartida(ITablaMotor iTablaMotor, String string, double d) throws ExceptionMotor {
        return this.establecerPartida(iTablaMotor, string, FuncionesUtiles.getFuncionesUtiles().doubleToString(d));
    }

    @Override
    public boolean establecerPartida(ITablaMotor iTablaMotor, String string, int n) throws ExceptionMotor {
        return this.establecerPartida(iTablaMotor, string, (Object)n);
    }

    @Override
    public boolean establecerPartida(ITablaMotor iTablaMotor, String string, long l) throws ExceptionMotor {
        return this.establecerPartida(iTablaMotor, string, (Object)l);
    }

    @Override
    public boolean establecerPartida(ITablaMotor iTablaMotor, String string, boolean bl) throws ExceptionMotor {
        return this.establecerPartida(iTablaMotor, string, (Object)bl);
    }

    @Override
    public boolean establecerPartida(ITablaMotor iTablaMotor, String string, String string2) throws ExceptionMotor {
        try {
            ITabla iTabla = this.posicionarPuntero(iTablaMotor);
            if (iTabla == null) {
                return false;
            }
            if (!string.equalsIgnoreCase("ID") && !string.equalsIgnoreCase("IDINF") && iTabla.obtenerPartidaString(string) != null) {
                this.getGestorTransacciones().addEventoValueChanged(iTablaMotor, new TablaMotorEntrada(string, iTabla.obtenerPartidaString(string), iTabla.obtenerEstado(string)));
            }
            return iTabla.establecerPartida(string, string2);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean establecerEstado(ITablaMotor iTablaMotor, String string, int n) throws ExceptionMotor {
        try {
            ITabla iTabla = this.posicionarPuntero(iTablaMotor);
            if (iTabla == null) {
                return false;
            }
            this.getGestorTransacciones().addEventoValueChanged(iTablaMotor, new TablaMotorEntrada(string, iTabla.obtenerPartidaString(string), iTabla.obtenerEstado(string)));
            return iTabla.establecerEstado(string, n);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean establecerEstado(ITablaMotor iTablaMotor, String string, String string2) throws ExceptionMotor {
        return this.establecerEstado(iTablaMotor, string, Integer.valueOf(string2));
    }

    @Override
    public boolean establecerPartida(ITablaMotor iTablaMotor, String string, Object object) throws ExceptionMotor {
        return this.establecerPartida(iTablaMotor, string, object.toString());
    }

    @Override
    public Object obtenerPartida(ITablaMotor iTablaMotor, String string) throws ExceptionMotor {
        return this.obtenerPartidaString(iTablaMotor, string);
    }

    @Override
    public String obtenerPartidaString(ITablaMotor iTablaMotor, String string, int n) throws ExceptionMotor {
        try {
            ITabla iTabla;
            if (n > 0) {
                ITipoHijoTabla iTipoHijoTabla;
                if (this.getCacheListaRegistrosIndexada() != null && this.getCacheListaRegistrosIndexada().getNombreCampo().equalsIgnoreCase(((Object)iTablaMotor).toString())) {
                    return ((ITabla)((List)this.getCacheListaRegistrosIndexada().getValor()).get(n - 1)).obtenerPartidaString(string);
                }
                iTabla = this.posicionarPunteroEnPadre(iTablaMotor);
                if (iTabla.hasTabla(iTablaMotor.getNombre()) && (iTipoHijoTabla = iTabla.getTablasHijas().get(iTablaMotor.getNombre())).getListaRegistros() != null && iTipoHijoTabla.getListaRegistros().size() > 0) {
                    this.setCacheListaRegistrosIndexada(new TipoDatosCampoValorEx(((Object)iTablaMotor).toString(), iTipoHijoTabla.getListaRegistros()));
                    return iTipoHijoTabla.getListaRegistros().get(n - 1).obtenerPartidaString(string);
                }
            }
            if ((iTabla = this.posicionarPuntero(iTablaMotor)) == null) {
                return null;
            }
            return iTabla.obtenerPartidaString(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String obtenerPartidaString(ITablaMotor iTablaMotor, String string) throws ExceptionMotor {
        return this.obtenerPartidaString(iTablaMotor, string, 0);
    }

    @Override
    public int obtenerEstado(ITablaMotor iTablaMotor, String string) throws ExceptionMotor {
        try {
            ITabla iTabla = this.posicionarPuntero(iTablaMotor);
            if (iTabla == null) {
                return -1;
            }
            return iTabla.obtenerEstado(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Integer obtenerPartidaInteger(ITablaMotor iTablaMotor, String string) {
        try {
            return Integer.valueOf(this.obtenerPartidaString(iTablaMotor, string));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public Double obtenerPartidaDouble(ITablaMotor iTablaMotor, String string) throws ExceptionMotor {
        return Double.valueOf(this.obtenerPartidaString(iTablaMotor, string));
    }

    @Override
    public BigDecimal obtenerPartidaBigDecimal(ITablaMotor iTablaMotor, String string) throws ExceptionMotor {
        return new BigDecimal(this.obtenerPartidaString(iTablaMotor, string).trim());
    }

    @Override
    public Boolean obtenerPartidaBoolean(ITablaMotor iTablaMotor, String string) throws ExceptionMotor {
        return Boolean.valueOf(this.obtenerPartidaString(iTablaMotor, string));
    }

    protected long dameIDDeTablaMotor(ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            String string = iTablaMotor.obtenerPartidaString("ID");
            if (string == null) {
                return 0L;
            }
            return Long.valueOf(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<List<ITipoDatosRegistro>> obtenerTabla(ITablaMotor iTablaMotor) throws ExceptionMotor {
        if (iTablaMotor == null) {
            return null;
        }
        ArrayList<List<ITipoDatosRegistro>> arrayList = new ArrayList<List<ITipoDatosRegistro>>();
        long l = iTablaMotor.getClaveActiva();
        try {
            long l2 = iTablaMotor.getRecordCount();
            int n = 0;
            while ((long)n < l2) {
                ArrayList<TipoDatosRegistro> arrayList2 = new ArrayList<TipoDatosRegistro>();
                iTablaMotor.setClaveActiva(n + 1);
                iTablaMotor.setClaveUnica(0L);
                iTablaMotor.setClaveUnica(this.dameIDDeTablaMotor(iTablaMotor));
                Map<String, ITablaMotorEntrada> map = iTablaMotor.getRsDatosReferencia();
                Set<String> set = map.keySet();
                String string2 = "";
                for (String string2 : set) {
                    TipoDatosRegistro tipoDatosRegistro = new TipoDatosRegistro(string2);
                    if (string2.equalsIgnoreCase("IDINF") || string2.equalsIgnoreCase("ID")) {
                        tipoDatosRegistro.setTipoDato("ENTERO");
                    } else {
                        tipoDatosRegistro.setTipoDato(this.sesion.getModelo().getGestorConfiguracion().getEntrada(string2).getTipoDato());
                    }
                    tipoDatosRegistro.setValor(map.get(string2).getValor());
                    tipoDatosRegistro.setEstado(map.get(string2).getEstado());
                    arrayList2.add(tipoDatosRegistro);
                    tipoDatosRegistro = null;
                }
                map = null;
                arrayList.add(arrayList2);
                arrayList2 = null;
                ++n;
            }
            ArrayList<List<ITipoDatosRegistro>> arrayList3 = arrayList;
            return arrayList3;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + iTablaMotor.getNombre() + " idPadre " + iTablaMotor.getClaveSuperior());
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + iTablaMotor.getNombre() + " idPadre " + iTablaMotor.getClaveSuperior());
        }
        finally {
            iTablaMotor.setClaveActiva(l);
            iTablaMotor.setClaveUnica(0L);
            iTablaMotor.setClaveUnica(this.dameIDDeTablaMotor(iTablaMotor));
        }
    }

    @Override
    public List<Map<String, ITablaMotorEntrada>> obtenerTablaHashMap(ITablaMotor iTablaMotor) throws ExceptionMotor {
        if (iTablaMotor == null) {
            return null;
        }
        long l = iTablaMotor.getClaveSuperior();
        ArrayList<Map<String, ITablaMotorEntrada>> arrayList = new ArrayList<Map<String, ITablaMotorEntrada>>();
        long l2 = iTablaMotor.getClaveActiva();
        try {
            long l3 = this.recordCount(iTablaMotor);
            int n = 1;
            while ((long)n <= l3) {
                iTablaMotor.setClaveActiva(n);
                iTablaMotor.setClaveUnica(0L);
                iTablaMotor.setClaveUnica(this.dameIDDeTablaMotor(iTablaMotor));
                arrayList.add(this.obtenerRegistroFiltroEnPosicion(iTablaMotor));
                ++n;
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Tabla " + iTablaMotor.getNombre() + " idPadre " + l);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Tabla " + iTablaMotor.getNombre() + " idPadre " + l);
        }
        finally {
            iTablaMotor.setClaveActiva(l2);
            iTablaMotor.setClaveUnica(0L);
            iTablaMotor.setClaveUnica(this.dameIDDeTablaMotor(iTablaMotor));
        }
        return arrayList;
    }

    protected Map<String, ITablaMotorEntrada> obtenerRegistroDeTabla(ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            ITabla iTabla = this.posicionarPuntero(iTablaMotor);
            if (iTabla == null) {
                return null;
            }
            if (iTabla.getRegistro().size() == 0) {
                return null;
            }
            return iTabla.getRegistro();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected Object obtenerValorSegunSuTipoDeDatos(String string, String string2) {
        try {
            IRegEntrada iRegEntrada = this.getSesion().getModelo().getGestorConfiguracion().getEntrada(string);
            String string3 = iRegEntrada.getValorInicial();
            String string4 = iRegEntrada.getTipoDato();
            if (string4.equalsIgnoreCase("DOBLE")) {
                if (string2.length() == 0) {
                    if (string3.length() == 0) {
                        string3 = "0";
                    }
                    return Double.valueOf(string3);
                }
                return Double.valueOf(string2);
            }
            if (string4.equalsIgnoreCase("BIGDECIMAL")) {
                return BigDecimal.ZERO;
            }
            if (string4.equalsIgnoreCase("LOGICO") || string4.equalsIgnoreCase("L\u00f3gico")) {
                if (string2.length() == 0) {
                    if (string3.length() == 0) {
                        string3 = "false";
                    }
                    if (string3.equalsIgnoreCase("0")) {
                        string3 = "false";
                    }
                    if (string3.equalsIgnoreCase("1")) {
                        string3 = "true";
                    }
                    return Boolean.valueOf(string3);
                }
                return Boolean.valueOf(string2);
            }
            if (string4.equalsIgnoreCase("ENTERO")) {
                if (string2.length() == 0) {
                    if (string3 == null || string3.length() == 0) {
                        string3 = "0";
                    }
                    return Integer.valueOf(string3);
                }
                return Integer.valueOf(string2);
            }
            return string2;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    @Override
    public Map<String, ITablaMotorEntrada> obtenerRegistroFiltroEnPosicion(ITablaMotor iTablaMotor) throws ExceptionMotor {
        try {
            return this.obtenerRegistroDeTabla(iTablaMotor);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean inTrans() throws ExceptionMotor {
        try {
            return this.getGestorTransacciones().enTransaccion();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void setRaiz(ITabla iTabla) {
        this.cachePosicionamiento = null;
        this.raiz = iTabla;
        try {
            this.limpiarCaches();
        }
        catch (ExceptionMotor exceptionMotor) {
            // empty catch block
        }
    }

    @Override
    public ITabla getRaiz() {
        if (this.raiz == null && this.getLightWeightContent() != null) {
            try {
                this.raiz = this.restaura();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.raiz;
    }

    @Override
    public Object clona() throws ExceptionMotor {
        try {
            return this.getRaiz().clone();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean restauraDocumento(Object object) {
        this.setRaiz(null);
        this.setRaiz((ITabla)object);
        object = null;
        return true;
    }

    protected IPersistencia getPersist() throws ExceptionMotor {
        try {
            return this.getSesion().getModelo().getPersistenciaObj();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected void setTrabajandoConAtributo(boolean bl) {
        this.trabajandoConAtributo = bl;
    }

    protected boolean isTrabajandoConAtributo() {
        return this.trabajandoConAtributo;
    }

    @Override
    public void setModoTransacciones(int n) {
        this.modoTransaccion = n;
    }

    @Override
    public int getModoTransacciones() throws ExceptionMotor {
        return this.modoTransaccion;
    }

    protected IGestorTransacciones getGestorTransacciones() throws ExceptionMotor {
        if (this.gestorTransacciones == null) {
            switch (this.getModoTransacciones()) {
                case 0: {
                    this.gestorTransacciones = new GestorTransaccionesClonado();
                    this.gestorTransacciones.init(new Object[]{this});
                    break;
                }
                case 1: {
                    this.gestorTransacciones = new GestorTransaccionesBitacora();
                    this.gestorTransacciones.init(new Object[]{this});
                    break;
                }
                default: {
                    throw new ExceptionMotor("Modo(" + this.getModoTransacciones() + ") de transaccion desconocido!!! ");
                }
            }
        }
        return this.gestorTransacciones;
    }

    @Override
    public Object getPunteroADatos() {
        return this.getRaiz();
    }

    @Override
    public List<Long> listaIdsTabla(ITablaMotor iTablaMotor) {
        long l = this.recordCount(iTablaMotor);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = 1;
        while ((long)n <= l) {
            arrayList.add(new Long(n));
            ++n;
        }
        return arrayList;
    }

    @Override
    public void setOrigenDeDatosOrdenadoPorCriterio(boolean bl) {
        this.origenDeDatosOrdenadoPorCriterio = bl;
    }

    @Override
    public boolean isOrigenDeDatosOrdenadoPorCriterio() {
        return this.origenDeDatosOrdenadoPorCriterio;
    }

    @Override
    public boolean isCacheHabilitada() {
        return this.cacheHabilitada;
    }

    @Override
    public void setCacheHabilitada(boolean bl) {
        this.cacheHabilitada = bl;
    }

    @Override
    public void setControlOverflow(boolean bl) {
        this.controlOverflow = bl;
    }

    @Override
    public boolean isControlOverflow() {
        return this.controlOverflow;
    }

    @Override
    public int getDifferedWrite() {
        return 0;
    }

    @Override
    public void setDifferedWrite(int n) {
    }

    @Override
    public boolean establecerPartidas(ITablaMotor iTablaMotor) throws ExceptionMotor, NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public boolean getSopportsSQL() {
        return false;
    }

    @Override
    public Object ejecutaSQL(String string) throws ExceptionMotor {
        throw new ExceptionMotor("Opcion no soportada en este origen de datos!!!!");
    }

    @Override
    public boolean ejecutaAccion(String string) throws ExceptionMotor {
        throw new ExceptionMotor("Opcion no soportada en este origen de datos!!!!");
    }

    @Override
    public long getIdTablaRaiz() {
        return 1L;
    }

    @Override
    public boolean isCreacionIDUnicoAutomatico() {
        return true;
    }

    @Override
    public boolean getTablaIdInfCacheHabilitada() throws ExceptionMotor {
        return false;
    }

    @Override
    public void setTablaIdInfCacheHabilitada(boolean bl) {
    }

    @Override
    public int getRecordCountTotal() throws ExceptionMotor {
        return this.getRaiz().getRecordCountTotal() - 1;
    }

    public ITipoDatosCampoValorEx getCacheListaRegistrosIndexada() {
        return this.cacheListaRegistrosIndexada;
    }

    public void setCacheListaRegistrosIndexada(ITipoDatosCampoValorEx iTipoDatosCampoValorEx) {
        this.cacheListaRegistrosIndexada = iTipoDatosCampoValorEx;
    }

    public Object getLightWeightContent() {
        return this.lightWeightContent;
    }

    public void setLightWeightContent(Object object) {
        this.lightWeightContent = object;
    }

    @Override
    public void clearLightWeightContent() {
        this.lightWeightContent = null;
    }

    @Override
    public void generaLightWeightContent() throws ExceptionMotor {
        try {
            this.setLightWeightContent(this.recorre(this.raiz));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (IOException iOException) {
            throw new ExceptionMotor(iOException);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private Object serializaReg(Map<String, ITablaMotorEntrada> map) throws Exception {
        String[] stringArray = new String[map.size() * 3];
        int n = 0;
        Set<String> set = map.keySet();
        String string = "";
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            string = iterator.next().toString();
            ITablaMotorEntrada iTablaMotorEntrada = map.get(string);
            stringArray[n++] = iTablaMotorEntrada.getNombreEntrada();
            IRegEntrada iRegEntrada = this.sesion.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada != null && iRegEntrada.getTipoDato().equalsIgnoreCase("BLOB")) {
                stringArray[n] = iTablaMotorEntrada.getValor().toString();
                if (iTablaMotorEntrada.getValor() != null && iTablaMotorEntrada.getValor() instanceof byte[]) {
                    stringArray[n] = FuncionesUtiles.getFuncionesUtiles().byteArray2SerializableString(FuncionesUtiles.getFuncionesUtiles().inflateByteArray((byte[])iTablaMotorEntrada.getValor()));
                }
            } else {
                stringArray[n++] = iTablaMotorEntrada.getValor().toString();
            }
            int n2 = ++n;
            ++n;
            stringArray[n2] = iTablaMotorEntrada.getEstado().toString();
        }
        return stringArray;
    }

    private Object[] recorre(ITabla iTabla) throws Exception {
        int n = iTabla.getTablasHijas().size();
        Object[] objectArray = new Object[2 + n * 2];
        int n2 = 0;
        objectArray[n2++] = iTabla.getTabla();
        objectArray[n2++] = this.serializaReg(iTabla.getRegistro());
        Map<String, ITipoHijoTabla> map = iTabla.getTablasHijas();
        Set<String> set = map.keySet();
        String string = "";
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            string = iterator.next().toString();
            objectArray[n2++] = string;
            ITipoHijoTabla iTipoHijoTabla = map.get(string);
            List<ITabla> list = iTipoHijoTabla.getListaRegistros();
            Object[] objectArray2 = new Object[list.size()];
            int n3 = 0;
            for (ITabla iTabla2 : list) {
                objectArray2[n3++] = this.recorre(iTabla2);
            }
            objectArray[n2++] = objectArray2;
        }
        return objectArray;
    }

    private ITabla procRecursivo(ITabla iTabla, Object[] objectArray) throws Exception {
        Object[] objectArray2;
        int n;
        String string = objectArray[0].toString();
        if (iTabla == null) {
            iTabla = new Tabla();
        }
        iTabla.init(new Object[]{string, this});
        String[] stringArray = (String[])objectArray[1];
        for (n = 0; n <= stringArray.length - 3; n += 3) {
            objectArray2 = iTabla.getRegistro().get(stringArray[n]);
            if (objectArray2 == null) {
                iTabla.establecerPartida(stringArray[n], stringArray[n + 1]);
                iTabla.establecerEstado(stringArray[n], Integer.valueOf(stringArray[n + 2]));
                continue;
            }
            if (this.sesion.getModelo().getGestorConfiguracion().getEntrada(stringArray[n]).getTipoDato().equalsIgnoreCase("BLOB")) {
                objectArray2.setValor(FuncionesUtiles.getFuncionesUtiles().compressByteArray(FuncionesUtiles.getFuncionesUtiles().serializableString2byteArray(stringArray[n + 1])));
                if (objectArray2.getValor() == null) {
                    objectArray2.setValor("");
                }
            } else {
                objectArray2.setValor(stringArray[n + 1]);
            }
            objectArray2.setEstado(stringArray[n + 2]);
        }
        for (n = 2; n <= objectArray.length - 2; n += 2) {
            objectArray2 = (Object[])objectArray[n + 1];
            for (int i = 0; i < objectArray2.length; ++i) {
                ITabla iTabla2 = iTabla.getTablaHija(objectArray[n].toString(), iTabla.addTablaHija(objectArray[n].toString()));
                this.procRecursivo(iTabla2, (Object[])objectArray2[i]);
            }
        }
        return iTabla;
    }

    private ITabla restaura() throws Exception {
        Object[] objectArray = (Object[])this.getLightWeightContent();
        return this.procRecursivo(null, objectArray);
    }
}

