/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.motor.modelo.sesion.tools;

import es.aeat.pftw.mtrc.api.IAop;
import es.aeat.pftw.mtrc.api.configuracion.IRegError;
import es.aeat.pftw.mtrc.api.configuracion.IRegRegla;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.tools.IGestionReglasExtendida;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatoRetornoProceso;
import es.aeat.pftw.mtrc.api.tipos.ITipoNotificacion;
import es.aeat.pftw.mtrc.imp.tipos.TipoDatoRetornoProceso;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GestionReglas
implements IGestionReglasExtendida,
IAop,
Serializable {
    private static final long serialVersionUID = -1427285572963222993L;
    private ISesionExtendida sesion = null;
    private int ultimaReglaProcesada = -1;
    private List<Integer> listaTipoReglasBusqueda = null;
    private boolean haHabidoErrorValidacion = false;
    private boolean almacenarErrorLista = false;
    private String discriminante = "";
    private boolean canceladaEjecucionReglas = false;
    private boolean errorPartidaModificadaSobreCampoCerrado = false;
    private boolean esEmpezandoPartidaModificadaDesdeImportacion = false;
    private String partidaProcesando = "";
    private boolean ejecutandoReglas = false;
    private boolean cortarEjecucionReglas = false;
    private List<IRegError> listaErroresEnReglas = new ArrayList<IRegError>();
    private List<ITipoNotificacion> listaNotificaciones = new ArrayList<ITipoNotificacion>();
    private ITipoDatoRetornoProceso erroresComprobarDeclaracion = new TipoDatoRetornoProceso();
    private boolean partidayTablasListenersEnabled = true;
    private Integer maxErrores = null;
    private int tipoValidacionReglas = 0;
    private boolean extraerReglasEnHashMap = false;
    private String separadorDestinos = ";";
    private int numDecimales = 0;

    protected ISesionExtendida getSesion() {
        return this.sesion;
    }

    @Override
    public void dispose() {
        this.listaTipoReglasBusqueda = null;
        this.listaErroresEnReglas = null;
        this.listaNotificaciones = null;
        this.erroresComprobarDeclaracion = null;
        this.sesion = null;
    }

    @Override
    public ITipoDatoRetornoProceso getErroresComprobarDeclaracion() {
        return this.erroresComprobarDeclaracion;
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            this.sesion = (ISesionExtendida)objectArray[0];
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean partidaModificada(String string, Object object) throws ExceptionMotor {
        return this.getSesion().getMotor().getClaseGestionReglas().partidaModificada(this.getSesion(), string, object);
    }

    @Override
    public boolean partidaModificada(String string, Object object, Map<String, String> map) throws ExceptionMotor {
        return this.getSesion().getMotor().getClaseGestionReglas().partidaModificada(this.getSesion(), string, object, map);
    }

    @Override
    public boolean procesaRegla(IRegRegla iRegRegla, String string) throws ExceptionMotor {
        return this.getSesion().getMotor().getClaseGestionReglas().procesaRegla(this.getSesion(), iRegRegla, string);
    }

    @Override
    public boolean ejecutaReglasDePartida(String string) throws ExceptionMotor {
        return this.getSesion().getMotor().getClaseGestionReglas().ejecutaReglasDePartida(this.getSesion(), string);
    }

    @Override
    public boolean chequear(String string) throws ExceptionMotor {
        int n = ((IGestionReglasExtendida)this.sesion.getGestionReglas()).getTipoReglaBusqueda();
        try {
            ((IGestionReglasExtendida)this.sesion.getGestionReglas()).setTipoReglaBusqueda(3);
            boolean bl = this.getSesion().getMotor().getClaseGestionReglas().chequear(this.getSesion(), string);
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        finally {
            ((IGestionReglasExtendida)this.sesion.getGestionReglas()).setTipoReglaBusqueda(n);
        }
    }

    @Override
    public boolean chequear(String string, boolean bl) throws ExceptionMotor {
        return this.getSesion().getMotor().getClaseGestionReglas().chequear(this.getSesion(), string, bl);
    }

    @Override
    public ITipoDatoRetornoProceso comprobarDeclaracion(String string, String[] stringArray) throws ExceptionMotor {
        return this.comprobarDeclaracion(string, stringArray, true);
    }

    @Override
    public ITipoDatoRetornoProceso comprobarDeclaracion(String string, String[] stringArray, boolean bl) throws ExceptionMotor {
        this.erroresComprobarDeclaracion = new TipoDatoRetornoProceso();
        return FuncionesUtiles.getFuncionesUtiles().completaConErroresRecomendadosLista(this.getSesion().getMotor().getClaseGestionReglas().comprobarDeclaracion(this.getSesion(), string, stringArray, bl), (ISesion)this.getSesion());
    }

    @Override
    public Object ejecutarFuncion(ISesion iSesion, String string, Object[] objectArray) throws ExceptionMotor {
        return this.getSesion().getMotor().getClaseGestionReglas().ejecutarFuncion(this.getSesion(), string, objectArray);
    }

    @Override
    public void setSeparadorDestinos(String string) {
        this.separadorDestinos = string;
    }

    @Override
    public String getSeparadorDestinos() {
        return this.separadorDestinos;
    }

    @Override
    public void setNumDecimales(int n) {
        this.numDecimales = n;
    }

    @Override
    public int getNumDecimales() {
        return this.numDecimales;
    }

    @Override
    public void setTipoReglaBusqueda(int n) throws ExceptionMotor {
        this.setTipoValidacionReglas(n);
    }

    @Override
    public int getTipoReglaBusqueda() throws ExceptionMotor {
        return this.getTipoValidacionReglas();
    }

    @Override
    public int getUltimaReglaProcesada() throws ExceptionMotor {
        return this.ultimaReglaProcesada;
    }

    @Override
    public void setUltimaReglaProcesada(int n) throws ExceptionMotor {
        this.ultimaReglaProcesada = n;
    }

    @Override
    public List<Integer> getListaTipoReglasBusqueda() throws ExceptionMotor {
        return this.listaTipoReglasBusqueda;
    }

    @Override
    public void setListaTipoReglasBusqueda(List<Integer> list) {
        this.listaTipoReglasBusqueda = list;
    }

    public boolean isHaHabidoErrorValidacion() {
        return this.haHabidoErrorValidacion;
    }

    public void setHaHabidoErrorValidacion(boolean bl) {
        this.haHabidoErrorValidacion = bl;
    }

    @Override
    public boolean isAlmacenarErrorLista() throws ExceptionMotor {
        return this.almacenarErrorLista;
    }

    @Override
    public void setAlmacenarErrorLista(boolean bl) throws ExceptionMotor {
        this.almacenarErrorLista = bl;
    }

    @Override
    public String getDiscriminante() throws ExceptionMotor {
        return this.discriminante;
    }

    @Override
    public void setDiscriminante(String string) throws ExceptionMotor {
        this.discriminante = string;
    }

    @Override
    public void addDiscriminante(String string) throws ExceptionMotor {
        if (!this.discriminante.contains(string)) {
            this.discriminante = this.discriminante.length() > 0 ? this.discriminante + "," + string : this.discriminante + string;
        }
    }

    @Override
    public boolean isEmpezandoPartidaModificadaDesdeImportacion() {
        return this.esEmpezandoPartidaModificadaDesdeImportacion;
    }

    @Override
    public void setEmpezandoPartidaModificadaDesdeImportacion(boolean bl) {
        this.esEmpezandoPartidaModificadaDesdeImportacion = bl;
    }

    @Override
    public boolean isErrorPartidaModificadaSobreCampoCerrado() {
        return this.errorPartidaModificadaSobreCampoCerrado;
    }

    @Override
    public void setErrorPartidaModificadaSobreCampoCerrado(boolean bl) throws ExceptionMotor {
        this.errorPartidaModificadaSobreCampoCerrado = bl;
    }

    @Override
    public String getPartidaProcesando() throws ExceptionMotor {
        return this.partidaProcesando;
    }

    @Override
    public void setPartidaProcesando(String string) throws ExceptionMotor {
        this.partidaProcesando = string;
    }

    @Override
    public boolean isEjecutandoReglas() throws ExceptionMotor {
        return this.ejecutandoReglas;
    }

    @Override
    public void setEjecutandoReglas(boolean bl) throws ExceptionMotor {
        this.ejecutandoReglas = bl;
    }

    @Override
    public boolean isCortarEjecucionReglas() throws ExceptionMotor {
        return this.cortarEjecucionReglas;
    }

    @Override
    public void setCortarEjecucionReglas(boolean bl) throws ExceptionMotor {
        this.cortarEjecucionReglas = bl;
    }

    @Override
    public void cancelaReglasEnCurso() throws ExceptionMotor {
        this.canceladaEjecucionReglas = true;
    }

    @Override
    public void resetCancelaReglasEnCurso() throws ExceptionMotor {
        this.canceladaEjecucionReglas = false;
    }

    @Override
    public boolean isCancelaReglasEnCurso() throws ExceptionMotor {
        return this.canceladaEjecucionReglas;
    }

    @Override
    public List<IRegError> getListaErroresEnReglas() throws ExceptionMotor {
        this.listaErroresEnReglas = FuncionesUtiles.getFuncionesUtiles().completaConErroresRecomendadosLista(this.listaErroresEnReglas, (ISesion)this.getSesion());
        ArrayList<IRegError> arrayList = new ArrayList<IRegError>();
        for (int i = 0; i < this.listaErroresEnReglas.size(); ++i) {
            arrayList.add(this.listaErroresEnReglas.get(i));
        }
        this.listaErroresEnReglas.clear();
        return arrayList;
    }

    @Override
    public List<ITipoNotificacion> getNotificaciones() throws ExceptionMotor {
        ArrayList<ITipoNotificacion> arrayList = new ArrayList<ITipoNotificacion>();
        for (ITipoNotificacion iTipoNotificacion : this.listaNotificaciones) {
            arrayList.add(iTipoNotificacion);
        }
        this.listaNotificaciones.clear();
        return arrayList;
    }

    @Override
    public List<IRegError> getRefListaErroresEnReglas() throws ExceptionMotor {
        return this.listaErroresEnReglas;
    }

    @Override
    public List<ITipoNotificacion> getRefNotificaciones() throws ExceptionMotor {
        return this.listaNotificaciones;
    }

    @Override
    public int getMaxErrores() {
        try {
            if (this.maxErrores == null) {
                this.maxErrores = Integer.valueOf(this.getSesion().getModelo().getGestorDatosOpciones().getOpcion("MAXERRORES").get(0).toString());
            }
            return this.maxErrores;
        }
        catch (Exception exception) {
            this.maxErrores = Integer.MAX_VALUE;
            return this.maxErrores;
        }
    }

    @Override
    public void addErrorAListaErroresEnReglas(IRegError iRegError) throws ExceptionMotor {
        this.getRefListaErroresEnReglas().add(iRegError);
    }

    @Override
    public void addNotificacionAListaNotificaciones(ITipoNotificacion iTipoNotificacion) throws ExceptionMotor {
        this.getRefNotificaciones().add(iTipoNotificacion);
    }

    @Override
    public int listaErroresEnReglasSize() throws ExceptionMotor {
        return this.getRefListaErroresEnReglas().size();
    }

    @Override
    public int listaNotificacionesSize() throws ExceptionMotor {
        return this.getRefNotificaciones().size();
    }

    @Override
    public void listaErroresEnReglasClear() throws ExceptionMotor {
        this.getRefListaErroresEnReglas().clear();
        this.listaNotificacionesClear();
    }

    @Override
    public void listaNotificacionesClear() throws ExceptionMotor {
        this.getRefNotificaciones().clear();
    }

    @Override
    public IRegError listaErroresEnReglasGet(int n) throws ExceptionMotor {
        return this.getRefListaErroresEnReglas().get(n);
    }

    @Override
    public ITipoNotificacion listaNotificacionesGet(int n) throws ExceptionMotor {
        return this.getRefNotificaciones().get(n);
    }

    public void setListaErroresEnReglas(List<IRegError> list) {
        this.listaErroresEnReglas = list;
    }

    public void setNotificaciones(List<ITipoNotificacion> list) {
        this.listaNotificaciones = list;
    }

    @Override
    public int getTipoValidacionReglas() throws ExceptionMotor {
        return this.tipoValidacionReglas;
    }

    @Override
    public void setTipoValidacionReglas(int n) throws ExceptionMotor {
        this.tipoValidacionReglas = n;
    }

    @Override
    public boolean isExtraerReglasEnHashMap() throws ExceptionMotor {
        return this.extraerReglasEnHashMap;
    }

    @Override
    public void setExtraerReglasEnHashMap(boolean bl) throws ExceptionMotor {
        this.extraerReglasEnHashMap = bl;
    }

    @Override
    public boolean establecerDatosExportacionPartida(String string, Object object, boolean bl) throws ExceptionMotor {
        return this.getSesion().getMotor().getClaseGestionReglas().establecerDatosExportacionPartida(this.sesion, string, object, bl);
    }

    @Override
    public void setPartidayTablasListenersEnabled(boolean bl) {
        this.partidayTablasListenersEnabled = bl;
    }

    @Override
    public boolean isPartidayTablasListenersEnabled() {
        return this.partidayTablasListenersEnabled;
    }

    @Override
    public String partidaQueHizoSaltarRegla(int n) throws ExceptionMotor {
        return this.sesion.partidaQueHizoSaltarRegla(n);
    }

    @Override
    public String partidaQueHizoSaltarRegla() throws ExceptionMotor {
        return this.partidaQueHizoSaltarRegla(this.sesion.getGestionReglas().getUltimaReglaProcesada());
    }
}

