/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.motor.modelo.sesion;

import es.aeat.pftw.mtrc.api.IInteraccionConUsuario;
import es.aeat.pftw.mtrc.api.configuracion.IGestorConfiguracionLooper;
import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import es.aeat.pftw.mtrc.api.configuracion.IRegRelacionada;
import es.aeat.pftw.mtrc.api.configuracion.IRegTabla;
import es.aeat.pftw.mtrc.api.configuracion.RegEntrada;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.IMotor;
import es.aeat.pftw.mtrc.api.motor.IPartidaModificada;
import es.aeat.pftw.mtrc.api.motor.modelo.IModelo;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.tools.IGestionOperaciones;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.tools.IGestionOperacionesExtendida;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.tools.IGestionReglas;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.tools.IGestionReglasExtendida;
import es.aeat.pftw.mtrc.api.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.api.procesadorReglas.IOperaciones;
import es.aeat.pftw.mtrc.api.procesadorReglas.IPartidaModificadaReglas;
import es.aeat.pftw.mtrc.api.puente.IBusquedaNodos;
import es.aeat.pftw.mtrc.api.puente.IRegTablaModificada;
import es.aeat.pftw.mtrc.api.puente.ITablaMotor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.tipos.ITipoListaPartidasAfectadasEnUnaEjecucion;
import es.aeat.pftw.mtrc.api.tipos.ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion;
import es.aeat.pftw.mtrc.api.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.utilidades.ClassLoaderFromBytes;
import es.aeat.pftw.mtrc.api.utilidades.IFormatear;
import es.aeat.pftw.mtrc.api.utilidades.IFuncionesUtiles;
import es.aeat.pftw.mtrc.api.utilidades.IValidaciones;
import es.aeat.pftw.mtrc.imp.configuracion.GestorConfiguracionLooper;
import es.aeat.pftw.mtrc.imp.motor.modelo.sesion.SesionCloned;
import es.aeat.pftw.mtrc.imp.motor.modelo.sesion.tools.GestionOperaciones;
import es.aeat.pftw.mtrc.imp.motor.modelo.sesion.tools.GestionReglas;
import es.aeat.pftw.mtrc.imp.origenDatos.mem.OrigenDatosMem;
import es.aeat.pftw.mtrc.imp.procesadorReglas.Operaciones;
import es.aeat.pftw.mtrc.imp.puente.BusquedaNodos;
import es.aeat.pftw.mtrc.imp.puente.ListaTablaMotor;
import es.aeat.pftw.mtrc.imp.puente.TablaMotor;
import es.aeat.pftw.mtrc.imp.tipos.TipoListaPartidasAfectadasEnUnaEjecucion;
import es.aeat.pftw.mtrc.imp.tipos.TipoListaRegistroDeTablasAfectadasEnUnaEjecucion;
import es.aeat.pftw.mtrc.imp.utilidades.Formatear;
import es.aeat.pftw.mtrc.imp.utilidades.FreezerMotor;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.imp.utilidades.Validaciones;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sesion
implements ISesionExtendida,
Serializable {
    private static final long serialVersionUID = -8697888667595737146L;
    private String id = "";
    private long creadoTimeStamp = 0L;
    private long ultimoAccesoTimeStamp = 0L;
    private FreezerMotor fm = null;
    private Map<String, FreezerMotor> fmNoSingleton = null;
    private List<ITipoDatosCampoValor> listaOverFlow = null;
    private Integer maximoDeErroresPersonalizado = null;
    private boolean comprobarCaracteresEnPartidaModificada = true;
    Map<String, String> registrosA\u00f1adidosPorReglasAlImportar = null;
    private transient IModelo modelo = null;
    private IMotor motor = null;
    protected transient ClassLoaderFromBytes cloader = null;
    private String aliasModelo = "";
    private IOrigenDatos origenDeDatos = null;
    private IGestionReglas gestionReglas = null;
    private IGestionOperaciones gestionOperaciones = null;
    private boolean enabled = true;
    private String infoSwap = null;
    private String punteroActual = "DEFAULT";
    private List<String> nombrePunteros = new ArrayList<String>();
    private List<String> nombreTablaPunteros = new ArrayList<String>();
    private List<Object> nodosSalvados = new ArrayList<Object>();
    private boolean cacheHabilitada = false;
    private Map<String, ITablaMotor> nodoPrincipal = null;
    private Map<String, IBusquedaNodos> busquedaNodosObj = null;
    private List<ITipoListaPartidasAfectadasEnUnaEjecucion> listaPartidasAfectadasEnUnaEjecucion = null;
    private ITipoListaPartidasAfectadasEnUnaEjecucion listaPartidasAfectadasEnUnaEjecucionParaUsuario = null;
    private List<ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion> listaRegistroDeTablasAfectadasEnUnaEjecucion = null;
    private ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion listaTablasAfectadasEnUnaEjecucionParaUsuario = null;
    private boolean arbolConstruido = false;
    private boolean flagIgnorarRegistrosDeEstados = false;
    private boolean modoSilencioso = false;
    private Map<String, List<IPartidaModificada>> listenersPartidaModificada = null;
    private Map<String, List<IPartidaModificada>> listenersTablaModificada = null;
    private boolean partidayTablasListenersEnabled = true;
    private Map<Integer, String> partidaQueInvocaRegla = new HashMap<Integer, String>();
    private boolean ejecutandoBatchAnniadirRegistro = false;
    private boolean funcionesErrorComportamientoEspecial = false;
    private transient IGestorConfiguracionLooper gestorConfiguracionLooper = null;
    private transient IInteraccionConUsuario instanciaInteraccionConUsuario = null;

    @Override
    public void dispose() throws ExceptionMotor {
        this.listaPartidasAfectadasEnUnaEjecucion = null;
        this.listaPartidasAfectadasEnUnaEjecucionParaUsuario = null;
        this.listaTablasAfectadasEnUnaEjecucionParaUsuario = null;
        this.listaRegistroDeTablasAfectadasEnUnaEjecucion = null;
        this.listenersPartidaModificada = null;
        this.listenersTablaModificada = null;
        this.listaOverFlow = null;
        this.nodoPrincipal = null;
        this.busquedaNodosObj = null;
        this.nodosSalvados = null;
        this.nombrePunteros = null;
        this.nombreTablaPunteros = null;
        this.modelo = null;
        this.motor = null;
        if (this.cloader != null) {
            this.cloader = null;
        }
        if (this.gestionReglas != null) {
            ((IGestionReglasExtendida)this.gestionReglas).dispose();
            this.gestionReglas = null;
        }
        if (this.origenDeDatos != null) {
            this.origenDeDatos.dispose();
            this.origenDeDatos = null;
        }
        if (this.gestionOperaciones != null) {
            ((IGestionOperacionesExtendida)this.gestionOperaciones).dispose();
            this.gestionOperaciones = null;
        }
        if (this.gestorConfiguracionLooper != null) {
            this.gestorConfiguracionLooper.dispose();
            this.gestorConfiguracionLooper = null;
        }
        if (this.fm != null) {
            if (this.fm.isFreezed()) {
                this.fm.cancelfreeze();
            }
            this.fm.dispose();
            this.fm = null;
        }
    }

    protected void disposeVars() throws Exception {
        if (this.getVarNodoPrincipal() != null) {
            this.getVarNodoPrincipal().clear();
        }
    }

    @Override
    public boolean cerrarConexionOrigenDatos() throws ExceptionMotor {
        try {
            this.disposeVars();
            return ((IGestionOperacionesExtendida)this.getOperaciones()).cerrarConexionOrigenDatos();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            this.disposeVars();
            if (!this.inicializar()) {
                throw new Exception("Error inicializando sesion...");
            }
            return ((IGestionOperacionesExtendida)this.getOperaciones()).abrirConexionOrigenDatos();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos(Object object) throws ExceptionMotor {
        return this.abrirConexionOrigenDatos(object, null);
    }

    @Override
    public boolean abrirConexionOrigenDatos(Object object, Map<String, String> map) throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            this.disposeVars();
            boolean bl = ((IGestionOperacionesExtendida)this.getOperaciones()).abrirConexionOrigenDatos(object, map);
            if (!this.inicializar()) {
                throw new Exception("Error inicializando sesion...");
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public Sesion() {
    }

    public Sesion(String string) {
        this.infoSwap = string;
    }

    public Sesion(SesionCloned sesionCloned, IMotor iMotor, IModelo iModelo) throws Exception {
        this.id = sesionCloned.getId();
        this.creadoTimeStamp = sesionCloned.getCreadoTimeStamp();
        this.aliasModelo = sesionCloned.getAliasModelo();
        this.enabled = sesionCloned.isEnabled();
        this.cacheHabilitada = sesionCloned.isCacheHabilitada();
        this.modoSilencioso = sesionCloned.isModoSilencioso();
        this.flagIgnorarRegistrosDeEstados = sesionCloned.isFlagIgnorarRegistrosDeEstados();
        this.partidayTablasListenersEnabled = sesionCloned.isPartidayTablasListenersEnabled();
        this.ejecutandoBatchAnniadirRegistro = sesionCloned.isEjecutandoBatchAnniadirRegistro();
        this.funcionesErrorComportamientoEspecial = sesionCloned.isFuncionesErrorComportamientoEspecial();
        this.init(new Object[]{iMotor, iModelo, this.id});
        this.abrirConexionOrigenDatos(sesionCloned.getOrigenDeDatos());
        this.partidaQueInvocaRegla = (Map)((HashMap)sesionCloned.getPartidaQueInvocaRegla()).clone();
        this.getVarNodoPrincipal().clear();
        this.getVarNodoPrincipal().put("DEFAULT", sesionCloned.getNodoPrincipal().get("DEFAULT").clone(this));
        for (int i = 0; i < sesionCloned.getNombrePunteros().size(); ++i) {
            if (sesionCloned.getNombrePunteros().get(i).equalsIgnoreCase("DEFAULT") || sesionCloned.getNombreTablaPunteros().get(i).length() <= 0) continue;
            this.createPtr(sesionCloned.getNombrePunteros().get(i), sesionCloned.getNombreTablaPunteros().get(i));
        }
        this.setCurrentPtr("DEFAULT");
        Iterator<String> iterator = sesionCloned.getNodoPrincipal().keySet().iterator();
        String string = "";
        while (iterator.hasNext()) {
            string = iterator.next();
            this.getVarNodoPrincipal().put(string, sesionCloned.getNodoPrincipal().get(string).clone(this));
            this.busquedaNodosObj.get(string).clearCache();
        }
        this.setCurrentPtr("DEFAULT");
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            for (Object object : objectArray) {
                if (object instanceof IMotor) {
                    this.motor = (IMotor)object;
                    continue;
                }
                if (object instanceof IModelo) {
                    this.setModelo((IModelo)object);
                    continue;
                }
                if (!(object instanceof String)) continue;
                this.id = object.toString();
            }
            this.aliasModelo = this.getModelo().getAlias();
            this.creadoTimeStamp = System.currentTimeMillis();
            this.ultimoAccesoTimeStamp = System.currentTimeMillis();
            this.listaOverFlow = null;
            this.gestionReglas = new GestionReglas();
            ((GestionReglas)this.gestionReglas).init(new Object[]{this});
            this.gestionOperaciones = new GestionOperaciones();
            ((GestionOperaciones)this.gestionOperaciones).init(new Object[]{this});
            this.nombrePunteros.add("DEFAULT");
            this.nombreTablaPunteros.add("");
            this.nodoPrincipal = new HashMap<String, ITablaMotor>();
            this.busquedaNodosObj = new HashMap<String, IBusquedaNodos>();
            this.listaPartidasAfectadasEnUnaEjecucion = new ArrayList<ITipoListaPartidasAfectadasEnUnaEjecucion>();
            this.listaPartidasAfectadasEnUnaEjecucionParaUsuario = null;
            this.setListaRegistroDeTablasAfectadasEnUnaEjecucion(new ArrayList<ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion>());
            this.listaTablasAfectadasEnUnaEjecucionParaUsuario = null;
            this.crearPartidasDinamicamente();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public void crearPartidasDinamicamente() throws Exception {
        List<String> list;
        RegEntrada regEntrada;
        if (this.getModelo().getGestorConfiguracion().getEntrada("MAX_REG") == null) {
            regEntrada = new RegEntrada();
            regEntrada.setIdVariable("MAX_REG");
            regEntrada.setIdPartida("MAX_REG");
            regEntrada.setIdTabla(this.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            regEntrada.setTipoDato("ENTERO");
            regEntrada.setValorPorDefecto("0");
            regEntrada.setEstadoInicial(252);
            this.getModelo().getGestorConfiguracion().getConjuntoDeEntradas().put("MAX_REG", regEntrada);
            list = this.getModelo().getGestorConfiguracion().getCamposDeTabla(this.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            if (list == null) {
                this.getModelo().getGestorConfiguracion().addConjuntoDeCamposDeTabla(this.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla());
                list = this.getModelo().getGestorConfiguracion().getCamposDeTabla(this.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            }
            list.add("MAX_REG");
        }
        if (this.getModelo().getGestorConfiguracion().getEntrada("CON_REG") == null) {
            regEntrada = new RegEntrada();
            regEntrada.setIdVariable("CON_REG");
            regEntrada.setIdPartida("CON_REG");
            regEntrada.setIdTabla(this.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            regEntrada.setTipoDato("ENTERO");
            regEntrada.setValorPorDefecto("0");
            regEntrada.setEstadoInicial(252);
            this.getModelo().getGestorConfiguracion().getConjuntoDeEntradas().put("CON_REG", regEntrada);
            list = this.getModelo().getGestorConfiguracion().getCamposDeTabla(this.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            if (list == null) {
                this.getModelo().getGestorConfiguracion().addConjuntoDeCamposDeTabla(this.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla());
                list = this.getModelo().getGestorConfiguracion().getCamposDeTabla(this.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            }
            list.add("CON_REG");
        }
    }

    @Override
    public String getId() throws ExceptionMotor {
        return this.id;
    }

    @Override
    public boolean isEjecutandoBatchAnniadirRegistro() {
        return this.ejecutandoBatchAnniadirRegistro;
    }

    @Override
    public void setEjecutandoBatchAnniadirRegistro(boolean bl) {
        this.ejecutandoBatchAnniadirRegistro = bl;
    }

    @Override
    public List<ITipoListaPartidasAfectadasEnUnaEjecucion> getListaPartidasAfectadasEnUnaEjecucion() {
        return this.listaPartidasAfectadasEnUnaEjecucion;
    }

    @Override
    public void updateUltimaVezAccedido() {
        this.ultimoAccesoTimeStamp = System.currentTimeMillis();
    }

    public void setPunteroActual(String string) {
        this.punteroActual = string.toUpperCase();
    }

    @Override
    public String getPunteroActual() {
        return this.punteroActual;
    }

    public List<String> getNombrePunteros() {
        return this.nombrePunteros;
    }

    public List<String> getNombreTablaPunteros() {
        return this.nombreTablaPunteros;
    }

    public void setCacheHabilitada(boolean bl) {
        this.cacheHabilitada = bl;
    }

    public boolean isCacheHabilitada() {
        return this.cacheHabilitada;
    }

    @Override
    public void setModoSilencioso(boolean bl) {
        this.modoSilencioso = bl;
    }

    @Override
    public boolean isModoSilencioso() {
        return this.modoSilencioso;
    }

    @Override
    public void setIgnorarRegistrosDeEstados(boolean bl) {
        this.flagIgnorarRegistrosDeEstados = bl;
    }

    @Override
    public boolean getIgnorarRegistrosDeEstados() throws ExceptionMotor {
        return this.flagIgnorarRegistrosDeEstados;
    }

    @Override
    public boolean getTablaIdInfCacheHabilitada() throws ExceptionMotor {
        return this.getOrigenDeDatos().getTablaIdInfCacheHabilitada();
    }

    @Override
    public void setTablaIdInfCacheHabilitada(boolean bl) throws ExceptionMotor {
        this.getOrigenDeDatos().setTablaIdInfCacheHabilitada(bl);
    }

    public void setArbolConstruido(boolean bl) {
        this.updateUltimaVezAccedido();
        this.arbolConstruido = bl;
    }

    public boolean isArbolConstruido() {
        return this.arbolConstruido;
    }

    public void setVarNodoPrincipal(Map<String, ITablaMotor> map) {
        this.updateUltimaVezAccedido();
        this.nodoPrincipal = map;
    }

    @Override
    public Map<String, ITablaMotor> getVarNodoPrincipal() {
        return this.nodoPrincipal;
    }

    public void setBusquedaNodosObj(Map<String, IBusquedaNodos> map) {
        this.updateUltimaVezAccedido();
        this.busquedaNodosObj = map;
    }

    @Override
    public Map<String, IBusquedaNodos> getBusquedaNodosObj() {
        return this.busquedaNodosObj;
    }

    @Override
    public IGestionReglas getGestionReglas() throws ExceptionMotor {
        this.updateUltimaVezAccedido();
        return this.gestionReglas;
    }

    @Override
    public long getCreadoTimeStamp() throws ExceptionMotor {
        return this.creadoTimeStamp;
    }

    @Override
    public long getUltimoAccesoTimeStamp() throws ExceptionMotor {
        return this.ultimoAccesoTimeStamp;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void setModelo(IModelo iModelo) throws ExceptionMotor {
        this.modelo = iModelo;
        try {
            this.crearPartidasDinamicamente();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void setMotor(IMotor iMotor) {
        this.motor = iMotor;
    }

    @Override
    public IModelo getModelo() {
        return this.modelo;
    }

    @Override
    public IMotor getMotor() throws ExceptionMotor {
        return this.motor;
    }

    @Override
    public String getAliasModelo() throws ExceptionMotor {
        return this.aliasModelo;
    }

    @Override
    public IGestionOperaciones getOperaciones() {
        this.updateUltimaVezAccedido();
        return this.gestionOperaciones;
    }

    @Override
    public IOperaciones getClaseOperaciones() throws ExceptionMotor {
        return Operaciones.getOperacionesWrapper();
    }

    @Override
    public void setListenersPartidaModificada(Map<String, List<IPartidaModificada>> map) {
        this.listenersPartidaModificada = map;
    }

    @Override
    public Map<String, List<IPartidaModificada>> getListenersPartidaModificada() {
        return this.listenersPartidaModificada;
    }

    @Override
    public void setListenersTablaModificada(Map<String, List<IPartidaModificada>> map) {
        this.listenersTablaModificada = map;
    }

    @Override
    public Map<String, List<IPartidaModificada>> getListenersTablaModificada() {
        return this.listenersTablaModificada;
    }

    protected void setPartidayTablasListenersEnabled(boolean bl) {
        this.partidayTablasListenersEnabled = bl;
    }

    protected boolean isPartidayTablasListenersEnabled() {
        return this.partidayTablasListenersEnabled;
    }

    protected boolean inicializar() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            boolean bl = this.construirArbol();
            if (this.getVarNodoPrincipal().get(this.getPunteroActual()) != null) {
                bl &= this.actualizarNodos(this.getVarNodoPrincipal().get(this.getPunteroActual()).getNombre());
                this.setNodoPrincipal(this.getVarNodoPrincipal().get(this.getPunteroActual()));
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String partidaQueHizoSaltarRegla(int n) {
        return this.getPartidaQueInvocaRegla().get(n);
    }

    @Override
    public ITablaMotor getNodoPrincipal() {
        return this.getVarNodoPrincipal().get(this.getPunteroActual());
    }

    @Override
    public void setNodoPrincipal(ITablaMotor iTablaMotor) {
        this.updateUltimaVezAccedido();
        this.getVarNodoPrincipal().put(this.getPunteroActual(), iTablaMotor);
    }

    protected boolean actualizarNodos(String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = this.getBusquedaNodosObj().get(this.getPunteroActual()).buscarNodo(string, this.getVarNodoPrincipal().get(this.getPunteroActual()));
            this.recorrerNodosHijos(iTablaMotor);
            return true;
        }
        catch (Exception exception) {
            if (!this.isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception);
            }
            return false;
        }
    }

    protected void recorrerNodosHijos(ITablaMotor iTablaMotor) throws ExceptionMotor {
        block5: {
            ITablaMotor iTablaMotor2 = null;
            try {
                if (iTablaMotor.getRelacionadas() != null) {
                    for (int i = 0; i < iTablaMotor.getRelacionadas().count(); ++i) {
                        iTablaMotor2 = iTablaMotor.getRelacionadas().getTablaMotor(i);
                        this.actualizarNodo(iTablaMotor2, iTablaMotor);
                    }
                }
            }
            catch (Exception exception) {
                if (this.isModoSilencioso()) break block5;
                if (exception instanceof ExceptionMotor) {
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception);
            }
        }
    }

    @Override
    public void actualizarPunterosTablas(ITablaMotor iTablaMotor) throws ExceptionMotor {
        this.recorrerNodosHijos(iTablaMotor);
    }

    protected void actualizarNodo(ITablaMotor iTablaMotor, ITablaMotor iTablaMotor2) throws ExceptionMotor {
        try {
            iTablaMotor.cerrarTabla();
            iTablaMotor.setClaveSuperior(iTablaMotor2.getClaveActiva());
            iTablaMotor.setClaveUnicaSuperior(iTablaMotor2.getClaveUnica());
            this.getOperaciones().moveFirst(iTablaMotor.getNombre());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean construirArbol(boolean bl) throws ExceptionMotor {
        return this.construirArbol(bl, "");
    }

    protected boolean construirArbol() throws ExceptionMotor {
        return this.construirArbol(false, "");
    }

    protected boolean construirArbol(boolean bl, String string) throws ExceptionMotor {
        if (!this.isArbolConstruido() || bl) {
            try {
                IRegTabla iRegTabla = this.getModelo().getGestorConfiguracion().getTablaNivel(0);
                if (iRegTabla == null) {
                    throw new ExceptionMotor("No existe tabla de nivel 0. Revise el fichero Tablas.xml");
                }
                this.getVarNodoPrincipal().put(this.getPunteroActual(), new TablaMotor(iRegTabla.getIdTabla(), null, this));
                this.getVarNodoPrincipal().get(this.getPunteroActual()).setNivel(0);
                this.getBusquedaNodosObj().put(this.getPunteroActual(), new BusquedaNodos(string));
                if (this.getOrigenDeDatos() != null && !this.cargaArbol(this.getVarNodoPrincipal().get(this.getPunteroActual()).getNombre())) {
                    this.setArbolConstruido(false);
                    return false;
                }
                this.anniadirNodos(this.getVarNodoPrincipal().get(this.getPunteroActual()));
                this.setArbolConstruido(true);
                this.checkArbol();
            }
            catch (Exception exception) {
                if (!this.isModoSilencioso()) {
                    if (exception instanceof ExceptionMotor) {
                        throw (ExceptionMotor)exception;
                    }
                    throw new ExceptionMotor(exception);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean checkArbol() throws ExceptionMotor {
        try {
            boolean bl = true;
            if (this.getVarNodoPrincipal() != null) {
                String string = this.getVarNodoPrincipal().get(this.getPunteroActual()).dameListaTablas().toUpperCase();
                IRegTabla iRegTabla = (IRegTabla)this.getGestorConfiguracionLooper().getPrimerElemento("Tablas".toUpperCase());
                while (iRegTabla != null) {
                    if (string.indexOf(";" + iRegTabla.getIdTabla().toUpperCase() + ";") == -1) {
                        FuncionesUtiles.getFuncionesUtiles().muestraAviso(new ExceptionMotor("La tabla " + iRegTabla.getIdTabla() + " no esta relacionada con nadie. Revise fichero Relacionadas.xml"));
                    }
                    iRegTabla = (IRegTabla)this.getGestorConfiguracionLooper().getSiguienteElemento();
                }
            }
            return bl;
        }
        catch (Exception exception) {
            if (!this.isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception);
            }
            return false;
        }
    }

    protected void anniadirNodos(ITablaMotor iTablaMotor) throws ExceptionMotor {
        block14: {
            ITablaMotor iTablaMotor2 = null;
            try {
                IRegRelacionada iRegRelacionada = this.getModelo().getGestorConfiguracion().getRelacionada(iTablaMotor.getNombre());
                List<Object> list = new ArrayList();
                if (iRegRelacionada != null) {
                    list = iRegRelacionada.getTablaRelacionada();
                }
                ListaTablaMotor listaTablaMotor = new ListaTablaMotor();
                iTablaMotor.setRelacionadas(listaTablaMotor);
                boolean bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    IRegTabla iRegTabla = this.getModelo().getGestorConfiguracion().getTabla(((String)list.get(i)).toString());
                    if (iRegTabla.getNivel() != iTablaMotor.getNivel() + 1) {
                        FuncionesUtiles.getFuncionesUtiles().muestraAviso(new ExceptionMotor("La tabla " + iRegTabla.getIdTabla() + " deberia tener nivel " + iTablaMotor.getNivel() + 1 + " Revise Tablas.xml"));
                    }
                    if (!this.getPunteroActual().equalsIgnoreCase("DEFAULT")) {
                        bl = false;
                        switch (this.getBusquedaNodosObj().get("DEFAULT").tablaAnteriorATabla(this.getVarNodoPrincipal().get("DEFAULT"), iRegTabla.getIdTabla(), this.getBusquedaNodosObj().get(this.getPunteroActual()).getNombreTablaPuntero())) {
                            case 0: {
                                iTablaMotor2 = null;
                                break;
                            }
                            case 1: {
                                iTablaMotor2 = this.getBusquedaNodosObj().get("DEFAULT").buscarNodo(iRegTabla.getIdTabla(), this.getVarNodoPrincipal().get("DEFAULT"));
                                break;
                            }
                            case 2: {
                                iTablaMotor2 = this.getBusquedaNodosObj().get("DEFAULT").buscarNodo(iRegTabla.getIdTabla(), this.getVarNodoPrincipal().get("DEFAULT")).clone();
                            }
                        }
                    } else {
                        bl = true;
                        if (this.getBusquedaNodosObj().get(this.getPunteroActual()).buscarNodo(iRegTabla.getIdTabla(), this.getVarNodoPrincipal().get(this.getPunteroActual())) != null) {
                            throw new ExceptionMotor("La tabla " + iRegTabla.getIdTabla() + " tiene m\u00e1s de una tabla padre. Revise Relacionadas.xml");
                        }
                        iTablaMotor2 = new TablaMotor(((String)list.get(i)).toString(), iTablaMotor, this);
                        iTablaMotor2.setNivel(iTablaMotor.getNivel() + 1);
                        iTablaMotor2.setClaveSuperior(iTablaMotor.getClaveActiva());
                        iTablaMotor2.setClaveUnicaSuperior(iTablaMotor.getClaveUnica());
                    }
                    listaTablaMotor.anniadirElemento((Object)i, iTablaMotor2);
                    if (!bl) continue;
                    this.anniadirNodos(iTablaMotor.getTablaMotor(i));
                }
            }
            catch (Exception exception) {
                if (this.isModoSilencioso()) break block14;
                if (exception instanceof ExceptionMotor) {
                    ((ExceptionMotor)exception).setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra() + ((Object)iTablaMotor).toString());
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception, ((Object)iTablaMotor).toString());
            }
        }
    }

    protected boolean cargaArbol(String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = this.obtenerNodoTabla(string);
            if (iTablaMotor != null) {
                if (iTablaMotor.getNivel() == 0) {
                    iTablaMotor.setClaveActiva(1L);
                    iTablaMotor.setClaveUnica(this.getOrigenDeDatos().getIdTablaRaiz());
                    return true;
                }
                if (this.getOrigenDeDatos().recordCount(iTablaMotor) == 0L) {
                    iTablaMotor.setClaveActiva(0L);
                } else {
                    iTablaMotor.setClaveActiva(1L);
                }
            }
            return true;
        }
        catch (Exception exception) {
            if (!this.isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception);
            }
            return false;
        }
    }

    @Override
    public ITablaMotor obtenerNodoTabla(String string) throws ExceptionMotor {
        try {
            ITablaMotor iTablaMotor = null;
            iTablaMotor = this.getBusquedaNodosObj().get(this.getPunteroActual()).buscarNodo(string, this.getVarNodoPrincipal().get(this.getPunteroActual()));
            if (iTablaMotor != null) {
                return iTablaMotor;
            }
            return null;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Map<String, IPartidaModificadaReglas> getMapaPartidasAfectadasEnUnaEjecucion() {
        if (this.getListaPartidasAfectadasEnUnaEjecucion() != null && this.getListaPartidasAfectadasEnUnaEjecucion().size() > 0) {
            return this.getListaPartidasAfectadasEnUnaEjecucion().get(this.getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista();
        }
        return null;
    }

    @Override
    public Object obtenerDestino(String string) throws ExceptionMotor {
        try {
            if (string == null) {
                return "";
            }
            if (string.equalsIgnoreCase("VALI") || string.equalsIgnoreCase("NULO") || string.equalsIgnoreCase("NLL")) {
                return "";
            }
            ITablaMotor iTablaMotor = this.obtenerNodoPartida(string);
            String string2 = iTablaMotor.obtenerPartidaString(string);
            if (string2 != null) {
                return string2;
            }
            return this.getOperaciones().obtenerValorInicialPartida(string);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Destino " + string);
        }
    }

    @Override
    public ITablaMotor obtenerNodoPartida(String string) throws ExceptionMotor {
        try {
            String string2 = this.buscarPartidaEnTabla(string);
            ITablaMotor iTablaMotor = this.getBusquedaNodosObj().get(this.getPunteroActual()).buscarNodo(string2, this.getVarNodoPrincipal().get(this.getPunteroActual()));
            if (iTablaMotor == null) {
                return null;
            }
            return iTablaMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getListaOverFlow() {
        if (this.listaOverFlow == null) {
            this.listaOverFlow = new ArrayList<ITipoDatosCampoValor>();
        }
        return this.listaOverFlow;
    }

    @Override
    public void removeFromListaOverFlow(ITipoDatosCampoValor iTipoDatosCampoValor) {
        if (this.getListaOverFlow().size() > 0) {
            for (int i = 0; i < this.getListaOverFlow().size(); ++i) {
                if (!this.getListaOverFlow().get(i).getNombreCampo().equalsIgnoreCase(iTipoDatosCampoValor.getNombreCampo()) || !this.getListaOverFlow().get(i).getValor().equalsIgnoreCase(iTipoDatosCampoValor.getValor())) continue;
                this.getListaOverFlow().remove(i);
                return;
            }
        }
    }

    @Override
    public void add2ListaOverFlow(ITipoDatosCampoValor iTipoDatosCampoValor) {
        for (int i = 0; i < this.getListaOverFlow().size(); ++i) {
            if (!this.getListaOverFlow().get(i).getNombreCampo().equalsIgnoreCase(iTipoDatosCampoValor.getNombreCampo()) || !this.getListaOverFlow().get(i).getValor().equalsIgnoreCase(iTipoDatosCampoValor.getValor())) continue;
            return;
        }
        this.getListaOverFlow().add(iTipoDatosCampoValor);
    }

    @Override
    public String buscarPartidaEnTabla(String string) {
        try {
            IRegEntrada iRegEntrada = this.getModelo().getGestorConfiguracion().getEntrada(string);
            if (iRegEntrada != null) {
                return iRegEntrada.getIdTabla();
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setListaRegistroDeTablasAfectadasEnUnaEjecucion(List<ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion> list) {
        this.listaRegistroDeTablasAfectadasEnUnaEjecucion = list;
    }

    @Override
    public List<ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion> getListaRegistroDeTablasAfectadasEnUnaEjecucion() {
        return this.listaRegistroDeTablasAfectadasEnUnaEjecucion;
    }

    @Override
    public void anniadirGrupoPartidasAfectadasEnUnaEjecucion() throws ExceptionMotor {
        try {
            if (!this.inTrans()) {
                return;
            }
            this.getListaPartidasAfectadasEnUnaEjecucion().add(new TipoListaPartidasAfectadasEnUnaEjecucion(new HashMap<String, IPartidaModificadaReglas>()));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected void borraGrupoPartidasAfectadasEnUnaEjecucion() throws ExceptionMotor {
        try {
            if (this.getListaPartidasAfectadasEnUnaEjecucion() == null || this.getListaPartidasAfectadasEnUnaEjecucion().size() == 0) {
                FuncionesUtiles.getFuncionesUtiles().muestraAviso(new Exception("Posible error, se pide borrar el ultimo grupo y no hay ninguno"));
                return;
            }
            this.getListaPartidasAfectadasEnUnaEjecucion().remove(this.getListaPartidasAfectadasEnUnaEjecucion().size() - 1);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean beginTrans() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            boolean bl = this.getOrigenDeDatos().beginTrans();
            if (this.getOrigenDeDatos().getDifferedWrite() == 1) {
                if (this.nodosSalvados.size() == 0) {
                    this.nodosSalvados.add(this.cloneListaNodosPrincipales());
                }
                if (this.getListaPartidasAfectadasEnUnaEjecucion().size() == 0) {
                    this.anniadirGrupoPartidasAfectadasEnUnaEjecucion();
                }
                if (this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() == 0) {
                    this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().add(new TipoListaRegistroDeTablasAfectadasEnUnaEjecucion(new HashMap<String, List<IRegTablaModificada>>()));
                }
                return bl;
            }
            if (bl) {
                this.nodosSalvados.add(this.cloneListaNodosPrincipales());
                this.anniadirGrupoPartidasAfectadasEnUnaEjecucion();
                this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().add(new TipoListaRegistroDeTablasAfectadasEnUnaEjecucion(new HashMap<String, List<IRegTablaModificada>>()));
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean rollBack() throws ExceptionMotor {
        try {
            if (this.getGestionReglas().isCancelaReglasEnCurso()) {
                this.getGestionReglas().resetCancelaReglasEnCurso();
            }
            this.updateUltimaVezAccedido();
            if (this.isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes");
            }
            if (!this.inTrans()) {
                return true;
            }
            boolean bl = this.rollbackDataBase();
            if (this.getOrigenDeDatos().getDifferedWrite() == 1) {
                return bl;
            }
            this.notifica(true);
            if (bl) {
                Set<String> set = this.getBusquedaNodosObj().keySet();
                Iterator<String> iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.getBusquedaNodosObj().get(iterator.next().toString()).clearCache();
                }
                set = null;
                this.overwriteListaNodosPrincipales(this.nodosSalvados.get(this.nodosSalvados.size() - 1), true);
                this.nodosSalvados.remove(this.nodosSalvados.size() - 1);
            }
            return bl;
        }
        catch (Exception exception) {
            if (!this.isModoSilencioso()) {
                if (exception instanceof ExceptionMotor) {
                    throw (ExceptionMotor)exception;
                }
                throw new ExceptionMotor(exception);
            }
            return false;
        }
    }

    @Override
    public boolean commitTrans() throws ExceptionMotor {
        try {
            if (this.getGestionReglas().isCancelaReglasEnCurso()) {
                return this.rollBack();
            }
            this.updateUltimaVezAccedido();
            if (this.isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes");
            }
            if (!this.inTrans()) {
                return true;
            }
            boolean bl = this.getOrigenDeDatos().commitTrans();
            if (this.getOrigenDeDatos().getDifferedWrite() == 1) {
                return bl;
            }
            if (bl) {
                this.nodosSalvados.remove(this.nodosSalvados.size() - 1);
                this.notifica(false);
            } else {
                this.borraGrupoPartidasAfectadasEnUnaEjecucion();
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean rollbackDataBase() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            if (this.isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes");
            }
            if (!this.inTrans()) {
                return true;
            }
            this.borraGrupoPartidasAfectadasEnUnaEjecucion();
            return this.getOrigenDeDatos().rollBack();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean inTrans() throws ExceptionMotor {
        return this.getOrigenDeDatos().inTrans();
    }

    @Override
    public Object cloneListaNodosPrincipales() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < this.getNombrePunteros().size(); ++i) {
                arrayList.add(this.getNombrePunteros().get(i));
                arrayList.add(this.getVarNodoPrincipal().get(this.getNombrePunteros().get(i)).lightClone());
            }
            return arrayList;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean overwriteListaNodosPrincipales(Object object, boolean bl) throws ExceptionMotor {
        try {
            ArrayList arrayList = (ArrayList)object;
            for (int i = 0; i < arrayList.size() - 1; i += 2) {
                this.getVarNodoPrincipal().get(arrayList.get(i).toString()).overwriteLightClone((ArrayList)arrayList.get(i + 1), bl);
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void notifica(boolean bl) throws ExceptionMotor {
        try {
            try {
                this.listaTablasAfectadasEnUnaEjecucionParaUsuario = this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1);
                this.notificarTablasModificadas(this.listaTablasAfectadasEnUnaEjecucionParaUsuario.getLista());
                this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().remove(this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                this.listaPartidasAfectadasEnUnaEjecucionParaUsuario = this.getListaPartidasAfectadasEnUnaEjecucion().get(this.getListaPartidasAfectadasEnUnaEjecucion().size() - 1);
                this.notificarPartidasModificadas(this.listaPartidasAfectadasEnUnaEjecucionParaUsuario.getLista(), bl);
                this.borraGrupoPartidasAfectadasEnUnaEjecucion();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public ITipoListaPartidasAfectadasEnUnaEjecucion getListaPartidasAfectadasPorPartidaModificada() throws ExceptionMotor {
        return this.listaPartidasAfectadasEnUnaEjecucionParaUsuario;
    }

    @Override
    public ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion getListaTablasAfectadasPorPartidaModificada() throws ExceptionMotor {
        return this.listaTablasAfectadasEnUnaEjecucionParaUsuario;
    }

    @Override
    public boolean notificarPartidasModificadas(Map<String, IPartidaModificadaReglas> map, boolean bl) throws ExceptionMotor {
        try {
            boolean bl2 = true;
            if (!this.isPartidayTablasListenersEnabled()) {
                return true;
            }
            if (map == null || map.size() == 0) {
                return true;
            }
            if (this.getListenersPartidaModificada() == null || this.getListenersPartidaModificada().size() == 0) {
                return true;
            }
            String string4 = "";
            String string2 = "";
            List<IPartidaModificada> list = null;
            int n = 0;
            String string3 = "";
            for (String string4 : map.keySet()) {
                string2 = this.dameNombrePartidaSinIDs(string4.toUpperCase());
                if (map.get(string4).getValorPosterior().toString().equalsIgnoreCase(map.get(string4).getValorAnterior().toString()) && Integer.valueOf(map.get(string4).getEstadoPosterior()).intValue() == Integer.valueOf(map.get(string4).getEstadoAnterior()).intValue() || !this.getListenersPartidaModificada().containsKey(string2)) continue;
                list = this.getListenersPartidaModificada().get(string2);
                n = bl ? Integer.valueOf(map.get(string4).getEstadoAnterior()).intValue() : Integer.valueOf(map.get(string4).getEstadoPosterior()).intValue();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        string3 = bl ? map.get(string4).getValorAnterior().toString() : map.get(string4).getValorPosterior().toString();
                        list.get(i).refrescaPartida(string2, map.get(string4).getIdinf(), map.get(string4).getId(), string3, n);
                        continue;
                    }
                    catch (Exception exception) {
                        bl2 = false;
                        FuncionesUtiles.getFuncionesUtiles().muestraError(new ExceptionMotor(exception, "Error escuchador para partida " + string2 + " : " + exception.getMessage()));
                    }
                }
            }
            return bl2;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    private String dameNombrePartidaSinIDs(String string) {
        try {
            int n = string.lastIndexOf(40);
            if (n > -1) {
                return string.substring(0, n);
            }
            return string;
        }
        catch (Exception exception) {
            FuncionesUtiles.getFuncionesUtiles().muestraError(exception);
            return string;
        }
    }

    @Override
    public boolean notificarTablasModificadas(Map<String, List<IRegTablaModificada>> map) throws ExceptionMotor {
        try {
            if (!this.isPartidayTablasListenersEnabled()) {
                return true;
            }
            if (map == null || map.size() == 0) {
                return true;
            }
            if (this.getListenersTablaModificada() == null || this.getListenersTablaModificada().size() == 0) {
                return true;
            }
            List<IPartidaModificada> list = null;
            for (String string : map.keySet()) {
                List<IRegTablaModificada> list2 = map.get(string);
                if (!this.getListenersTablaModificada().containsKey(string)) continue;
                list = this.getListenersTablaModificada().get(string);
                for (int i = 0; i < list.size(); ++i) {
                    for (int j = 0; j < list2.size(); ++j) {
                        if (list2.get(j).getAccion().equalsIgnoreCase("add")) {
                            list.get(i).registroAniadido(string, list2.get(j).getIdInf(), list2.get(j).getId());
                        }
                        if (!list2.get(j).getAccion().equalsIgnoreCase("del")) continue;
                        list.get(i).registroEliminado(string, list2.get(j).getIdInf(), list2.get(j).getId());
                    }
                }
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void addPartidaQueHizoSaltarRegla(int n, String string) {
        this.getPartidaQueInvocaRegla().put(n, string);
    }

    @Override
    public void createPtr(String string, String string2) throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            boolean bl = true;
            if (this.getModelo().getGestorConfiguracion().getTabla(string2) == null) {
                throw new ExceptionMotor("Puntero apuntando a tabla inexistente (" + string2 + ")");
            }
            if (!this.getPunteroActual().equalsIgnoreCase("DEFAULT")) {
                throw new ExceptionMotor("No esta colocado en el puntero por defecto, fallar\u00e1 la creaci\u00f3n del nuevo puntero porque se hace a partir de \u00e9l.");
            }
            String string3 = this.getPunteroActual();
            this.setPunteroActual(string.toUpperCase());
            boolean bl2 = true;
            for (String string4 : this.getNombrePunteros()) {
                if (!string4.equalsIgnoreCase(this.getPunteroActual())) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                this.getNombrePunteros().add(this.getPunteroActual());
                this.getNombreTablaPunteros().add(string2);
            }
            if (!(bl = this.construirArbol(true, string2))) {
                this.setPunteroActual(string3);
            }
            if (!bl) {
                throw new ExceptionMotor("No pudo crearse Puntero " + string + " sobre tabla " + string2);
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void removePtr(String string) throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            if (string.equalsIgnoreCase("DEFAULT")) {
                throw new Exception("No se permite eliminar al puntero por defecto...");
            }
            if (this.getVarNodoPrincipal().containsKey(string.toUpperCase())) {
                for (int i = 0; i < this.getNombrePunteros().size(); ++i) {
                    if (!this.getNombrePunteros().get(i).equalsIgnoreCase(string)) continue;
                    this.getNombrePunteros().remove(i);
                    this.getNombreTablaPunteros().remove(i);
                    break;
                }
            } else {
                throw new Exception("Puntero " + string + " no encontrado...");
            }
            this.getVarNodoPrincipal().remove(string.toUpperCase());
            this.getBusquedaNodosObj().remove(string.toUpperCase());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void setCurrentPtr(String string) throws ExceptionMotor {
        try {
            if (!this.getVarNodoPrincipal().containsKey(string.toUpperCase())) {
                throw new Exception("Puntero " + string + " no encontrado...");
            }
            this.setPunteroActual(string.toUpperCase());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean existsPtr(String string) throws ExceptionMotor {
        try {
            if (this.getNombrePunteros() != null) {
                return this.getNombrePunteros().contains(string.toUpperCase());
            }
            return false;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String getCurrentPtr() throws ExceptionMotor {
        return this.getPunteroActual();
    }

    @Override
    public List<ITipoDatosCampoValor> getPtrList() throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosCampoValor> arrayList = new ArrayList<ITipoDatosCampoValor>();
            for (int i = 0; i < this.getNombrePunteros().size(); ++i) {
                TipoDatosCampoValor tipoDatosCampoValor = new TipoDatosCampoValor(this.getNombrePunteros().get(i), this.getNombreTablaPunteros().get(i));
                try {
                    long l = this.getBusquedaNodosObj().get(this.getNombrePunteros().get(i)).buscarNodo(this.getNombreTablaPunteros().get(i), this.getVarNodoPrincipal().get(this.getNombrePunteros().get(i))).getClaveActiva();
                    tipoDatosCampoValor.setExtra(String.valueOf(l));
                }
                catch (Exception exception) {
                    tipoDatosCampoValor.setExtra("??");
                }
                arrayList.add(tipoDatosCampoValor);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Integer getMaximoDeErroresPersonalizado() {
        return this.maximoDeErroresPersonalizado;
    }

    @Override
    public void setMaximoDeErroresPersonalizado(Integer n) {
        this.maximoDeErroresPersonalizado = n;
    }

    @Override
    public void setFuncionesErrorComportamientoEspecial(boolean bl) throws ExceptionMotor {
        this.funcionesErrorComportamientoEspecial = bl;
    }

    @Override
    public boolean isFuncionesErrorComportamientoEspecial() throws ExceptionMotor {
        return this.funcionesErrorComportamientoEspecial;
    }

    @Override
    public void setControlOverflow(boolean bl) throws ExceptionMotor {
        this.getOrigenDeDatos().setControlOverflow(bl);
    }

    @Override
    public boolean isControlOverflow() throws ExceptionMotor {
        return this.getOrigenDeDatos().isControlOverflow();
    }

    @Override
    public void cancelaReglasEnCurso() throws ExceptionMotor {
        this.getGestionReglas().cancelaReglasEnCurso();
    }

    @Override
    public void setComprobarCaracteresEnPartidaModificada(boolean bl) throws ExceptionMotor {
        this.comprobarCaracteresEnPartidaModificada = bl;
    }

    @Override
    public boolean isComprobarCaracteresEnPartidaModificada() {
        return this.comprobarCaracteresEnPartidaModificada;
    }

    @Override
    public IGestorConfiguracionLooper getGestorConfiguracionLooper() throws ExceptionMotor {
        this.updateUltimaVezAccedido();
        if (this.gestorConfiguracionLooper == null) {
            this.gestorConfiguracionLooper = new GestorConfiguracionLooper();
            this.gestorConfiguracionLooper.init(new Object[]{this.getModelo().getGestorConfiguracion()});
        }
        return this.gestorConfiguracionLooper;
    }

    @Override
    public void setInfoSwap(String string) {
        this.infoSwap = string;
    }

    @Override
    public String getInfoSwap() {
        return this.infoSwap;
    }

    @Override
    public IOrigenDatos getOrigenDeDatos() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            if (this.origenDeDatos == null) {
                this.origenDeDatos = new OrigenDatosMem();
                this.origenDeDatos.init(new Object[]{this});
            }
            return this.origenDeDatos;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    public void setPartidaQueInvocaRegla(Map<Integer, String> map) {
        this.partidaQueInvocaRegla = map;
    }

    public Map<Integer, String> getPartidaQueInvocaRegla() {
        return this.partidaQueInvocaRegla;
    }

    protected FreezerMotor getFreezer() throws ExceptionMotor {
        try {
            if (this.fm == null) {
                this.fm = new FreezerMotor(this);
            }
            if (this.fm == null) {
                throw new ExceptionMotor("Imposible crear clase Freezer...");
            }
            return this.fm;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void freezeSesionSoloPosicion() throws ExceptionMotor {
        this.getFreezer().freeze();
    }

    @Override
    public void freezeSesionCompleta() throws ExceptionMotor {
        this.getFreezer().freezeCompleto();
    }

    @Override
    public void unfreeze() throws ExceptionMotor {
        this.getFreezer().unfreeze();
    }

    @Override
    public void cancelfreeze() throws ExceptionMotor {
        this.getFreezer().cancelfreeze();
    }

    @Override
    public boolean isFreezed() throws ExceptionMotor {
        return this.getFreezer().isFreezed();
    }

    protected FreezerMotor getFreezerNoSingleton(String string) throws ExceptionMotor {
        try {
            if (this.fmNoSingleton == null) {
                this.fmNoSingleton = new HashMap<String, FreezerMotor>();
            }
            if (this.fmNoSingleton.get(string) == null) {
                this.fmNoSingleton.put(string, new FreezerMotor(this));
            }
            if (this.fmNoSingleton.get(string) == null) {
                throw new ExceptionMotor("Imposible crear clase Freezer...");
            }
            return this.fmNoSingleton.get(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected boolean existeFreezer(String string) throws ExceptionMotor {
        try {
            if (this.fmNoSingleton == null) {
                this.fmNoSingleton = new HashMap<String, FreezerMotor>();
            }
            return this.fmNoSingleton.get(string) != null;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void freezeSesionSoloPosicion(String string) throws ExceptionMotor {
        this.getFreezerNoSingleton(string).freeze();
    }

    @Override
    public void freezeSesionCompleta(String string) throws ExceptionMotor {
        this.getFreezerNoSingleton(string).freezeCompleto();
    }

    @Override
    public void unfreeze(String string) throws ExceptionMotor {
        this.getFreezerNoSingleton(string).unfreeze();
        this.liberaFreezerNoSingleton(string);
    }

    @Override
    public void cancelfreeze(String string) throws ExceptionMotor {
        if (!this.existeFreezer(string)) {
            return;
        }
        this.getFreezerNoSingleton(string).cancelfreeze();
        this.liberaFreezerNoSingleton(string);
    }

    @Override
    public boolean isFreezed(String string) throws ExceptionMotor {
        if (!this.existeFreezer(string)) {
            return false;
        }
        return this.getFreezerNoSingleton(string).isFreezed();
    }

    protected void liberaFreezerNoSingleton(String string) throws ExceptionMotor {
        try {
            if (!this.existeFreezer(string)) {
                return;
            }
            this.getFreezerNoSingleton(string).dispose();
            this.fmNoSingleton.remove(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Map<String, String> getRegistrosA\u00f1adidosPorReglasAlImportar() {
        return this.registrosA\u00f1adidosPorReglasAlImportar;
    }

    @Override
    public void setRegistrosA\u00f1adidosPorReglasAlImportar(Map<String, String> map) {
        this.registrosA\u00f1adidosPorReglasAlImportar = map;
    }

    @Override
    public void setInstanciaInteraccionConUsuario(IInteraccionConUsuario iInteraccionConUsuario) {
        this.instanciaInteraccionConUsuario = iInteraccionConUsuario;
    }

    @Override
    public IInteraccionConUsuario getInstanciaInteraccionConUsuario() {
        return this.instanciaInteraccionConUsuario;
    }

    @Override
    public IFuncionesUtiles getFuncionesUtiles() throws ExceptionMotor {
        return FuncionesUtiles.getFuncionesUtiles();
    }

    @Override
    public IFormatear getFormatear() throws ExceptionMotor {
        return Formatear.getFormatear();
    }

    @Override
    public IValidaciones getValidaciones() throws ExceptionMotor {
        return Validaciones.getValidaciones();
    }
}

