/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.motor;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.motor.IMotor;
import es.aeat.pftw.mtrc.api.motor.modelo.IModelo;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.api.procesadorReglas.IFunciones;
import es.aeat.pftw.mtrc.api.procesadorReglas.IGestionReglas;
import es.aeat.pftw.mtrc.api.procesadorReglas.IOperaciones;
import es.aeat.pftw.mtrc.api.puente.IGestionOperaciones;
import es.aeat.pftw.mtrc.imp.motor.modelo.Modelo;
import es.aeat.pftw.mtrc.imp.motor.modelo.sesion.Sesion;
import es.aeat.pftw.mtrc.imp.motor.modelo.sesion.SesionCloned;
import es.aeat.pftw.mtrc.imp.procesadorReglas.Comprobaciones;
import es.aeat.pftw.mtrc.imp.procesadorReglas.Funciones;
import es.aeat.pftw.mtrc.imp.procesadorReglas.GestionReglas;
import es.aeat.pftw.mtrc.imp.procesadorReglas.Operaciones;
import es.aeat.pftw.mtrc.imp.puente.GestionOperaciones;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.imp.utilidades.Serializer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Motor
implements IMotor {
    private static final long serialVersionUID = 6533435000598870529L;
    protected int timeOutSwap = 0;
    protected HiloSwapThread hiloSwap = null;
    private static volatile ConcurrentMap<String, IModelo> listaModelosDisponibles = null;
    private static volatile ConcurrentMap<String, ISesion> listaSesiones = null;
    private IGestionOperaciones claseGestionOperaciones = null;
    private IGestionReglas claseGestionReglas = null;
    private Comprobaciones claseComprobaciones = null;
    private Funciones claseFunciones = null;

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            listaModelosDisponibles = new ConcurrentHashMap<String, IModelo>();
            listaSesiones = new ConcurrentHashMap<String, ISesion>();
            try {
                this.timeOutSwap = (Integer)objectArray[0];
                if (this.timeOutSwap > 0) {
                    this.hiloSwap = new HiloSwapThread(this);
                    this.hiloSwap.start();
                }
            }
            catch (Exception exception) {
                this.timeOutSwap = 0;
                FuncionesUtiles.getFuncionesUtiles().muestraAviso("No se pudo establecer timeoutSwap...");
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public ISesion getSesion(String string, String string2) throws Exception {
        return this.getSesion(string, string2, false);
    }

    protected ISesion getSesion(String string, String string2, boolean bl) throws Exception {
        ISesion iSesion = (ISesion)listaSesiones.get(string);
        if (iSesion != null) {
            if (iSesion.getModelo() != null) {
                return iSesion;
            }
            iSesion = null;
            if (!bl) {
                this.unSwap(string, string2);
                return this.getSesion(string, string2, true);
            }
        }
        throw new Exception("Sesion " + string + " no encontrada!!!");
    }

    @Override
    public ISesion getSesion() throws Exception {
        Iterator iterator;
        if (listaSesiones.size() == 1 && (iterator = listaSesiones.keySet().iterator()).hasNext()) {
            String string = (String)iterator.next();
            return this.getSesion(((ISesion)listaSesiones.get(string)).getId(), ((ISesion)listaSesiones.get(string)).getAliasModelo());
        }
        throw new Exception("Sesion no encontrada o existe mas de una sesion!!!");
    }

    protected boolean existeSesion(String string) throws Exception {
        return listaSesiones.get(string) != null;
    }

    @Override
    public synchronized String addSesion(IModelo iModelo) throws Exception {
        if (!listaModelosDisponibles.containsKey(iModelo.getAlias())) {
            throw new Exception("Modelo no encontrado!!!");
        }
        String string = "";
        string = String.valueOf(System.currentTimeMillis());
        while (this.existeSesion(string)) {
            Thread.sleep(45L);
            string = String.valueOf(System.currentTimeMillis());
        }
        Sesion sesion = new Sesion();
        sesion.init(new Object[]{this, iModelo, string});
        listaSesiones.put(string, sesion);
        return sesion.getId();
    }

    @Override
    public synchronized void disposeSesion(String string) throws Exception {
        if (listaSesiones.get(string) == null) {
            throw new Exception("Sesion " + string + " no encontrada!!!");
        }
        ((ISesion)listaSesiones.get(string)).dispose();
        listaSesiones.remove(string);
    }

    @Override
    public void disposeModelo(String string) throws Exception {
        Iterator iterator = listaSesiones.keySet().iterator();
        ISesion iSesion = null;
        while (iterator.hasNext()) {
            iSesion = (ISesion)listaSesiones.get(iterator.next());
            if (iSesion == null || !iSesion.getModelo().getAlias().equalsIgnoreCase(string)) continue;
            throw new Exception("Sesion [" + iSesion.getId() + "] esta asociada a este modelo, no se puede eliminar...");
        }
        if (listaModelosDisponibles.containsKey(string)) {
            ((IModelo)listaModelosDisponibles.get(string)).dispose();
            listaModelosDisponibles.remove(listaModelosDisponibles.get(string));
            return;
        }
        throw new Exception("Modelo no encontrado!!!");
    }

    @Override
    public void addModelo(IModelo iModelo) throws Exception {
        if (this.existeModelo(iModelo.getAlias(), iModelo.getNombreCompletoJar())) {
            throw new Exception("Alias o Modelo ya existe!!!");
        }
        listaModelosDisponibles.put(iModelo.getAlias(), iModelo);
    }

    @Override
    public void addModeloClonado(String string, IModelo iModelo) throws Exception {
        ((Modelo)iModelo).setAlias(string);
        listaModelosDisponibles.put(string, iModelo);
    }

    @Override
    public void addModelo(String string, Object[] objectArray) throws Exception {
        if (string == null || string.length() == 0) {
            throw new Exception("Indique alias...");
        }
        if (this.existeModelo(string, "")) {
            throw new Exception("Alias o Modelo ya existe!!!");
        }
        Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length + 1);
        objectArray2[objectArray2.length - 1] = string;
        Modelo modelo = new Modelo();
        modelo.init(objectArray2);
        listaModelosDisponibles.put(string, modelo);
    }

    protected boolean existeModelo(String string, String string2) throws Exception {
        try {
            this.getModelo(string, string2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected IModelo getModelo(String string, String string2) throws Exception {
        IModelo iModelo = null;
        Iterator iterator = listaModelosDisponibles.keySet().iterator();
        while (iterator.hasNext()) {
            iModelo = (IModelo)listaModelosDisponibles.get(iterator.next());
            if (string.length() > 0 && iModelo.getAlias().equalsIgnoreCase(string)) {
                return iModelo;
            }
            if (string2.length() <= 0 || !iModelo.getNombreCompletoJar().equalsIgnoreCase(string2)) continue;
            return iModelo;
        }
        if (string.length() > 0) {
            throw new Exception("Modelo " + string + " no encontrado!!!");
        }
        if (string2.length() > 0) {
            throw new Exception("Modelo en " + string2 + " no encontrado!!!");
        }
        throw new Exception("Modelo no encontrado!!!");
    }

    @Override
    public IModelo getModelo(String string) throws Exception {
        return this.getModelo(string, "");
    }

    @Override
    public void dispose() throws ExceptionMotor {
        try {
            if (this.hiloSwap != null) {
                this.hiloSwap.dispose();
                this.hiloSwap = null;
            }
            Iterator iterator = listaSesiones.keySet().iterator();
            ISesion iSesion = null;
            while (iterator.hasNext()) {
                iSesion = (ISesion)listaSesiones.get(iterator.next());
                if (iSesion == null) continue;
                iSesion.dispose();
            }
            listaSesiones.clear();
            IModelo iModelo = null;
            Iterator iterator2 = listaModelosDisponibles.keySet().iterator();
            while (iterator2.hasNext()) {
                iModelo = (IModelo)listaModelosDisponibles.get(iterator2.next());
                iModelo.dispose();
            }
            listaModelosDisponibles.clear();
            if (this.claseFunciones != null) {
                this.claseFunciones.dispose();
                this.claseFunciones = null;
            }
            if (this.claseComprobaciones != null) {
                this.claseComprobaciones.dispose();
                this.claseComprobaciones = null;
            }
            if (this.claseGestionOperaciones != null) {
                this.claseGestionOperaciones.dispose();
                this.claseGestionOperaciones = null;
            }
            if (this.claseGestionReglas != null) {
                this.claseGestionReglas.dispose();
                this.claseGestionReglas = null;
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public IGestionOperaciones getClaseGestionOperaciones() throws ExceptionMotor {
        if (this.claseGestionOperaciones == null) {
            this.claseGestionOperaciones = new GestionOperaciones();
            this.claseGestionOperaciones.init(new Object[0]);
        }
        return this.claseGestionOperaciones;
    }

    @Override
    public IGestionReglas getClaseGestionReglas() throws ExceptionMotor {
        if (this.claseGestionReglas == null) {
            this.claseGestionReglas = new GestionReglas();
            this.claseGestionReglas.init(new Object[]{this});
        }
        return this.claseGestionReglas;
    }

    @Override
    public Comprobaciones getClaseComprobaciones() throws ExceptionMotor {
        if (this.claseComprobaciones == null) {
            this.claseComprobaciones = new Comprobaciones();
            this.claseComprobaciones.init(new Object[0]);
        }
        return this.claseComprobaciones;
    }

    @Override
    public IFunciones getClaseFunciones() throws ExceptionMotor {
        if (this.claseFunciones == null) {
            this.claseFunciones = new Funciones();
            this.claseFunciones.init(new Object[]{this});
        }
        return this.claseFunciones;
    }

    @Override
    public IOperaciones getClaseOperaciones() throws ExceptionMotor {
        return Operaciones.getOperacionesWrapper();
    }

    @Override
    public int getTimeOutSwap() {
        return this.timeOutSwap;
    }

    @Override
    public void unSwap(String string, String string2) {
        try {
            ISesion iSesion = (ISesion)listaSesiones.get(string);
            if (iSesion != null && ((ISesionExtendida)iSesion).getInfoSwap() != null) {
                FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("UNSWAP DE " + string);
                Serializer serializer = new Serializer(String.valueOf(string));
                iSesion = new Sesion((SesionCloned)serializer.recuperaObjeto(((ISesionExtendida)iSesion).getInfoSwap()), this, this.getModelo(string2));
                listaSesiones.put(string, iSesion);
                iSesion = null;
            }
        }
        catch (Exception exception) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(exception, "No se pudo hacer UnSwap de " + string + "...");
        }
    }

    @Override
    public void checkSwap() {
        try {
            Iterator iterator = listaSesiones.keySet().iterator();
            ISesion iSesion = null;
            while (iterator.hasNext()) {
                iSesion = (ISesion)listaSesiones.get(iterator.next());
                if (iSesion == null || ((ISesionExtendida)iSesion).getInfoSwap() != null || System.currentTimeMillis() - iSesion.getUltimoAccesoTimeStamp() <= (long)this.timeOutSwap) continue;
                FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("SWAP DE " + iSesion.getId());
                Serializer serializer = new Serializer(String.valueOf(iSesion.getId()));
                String string = serializer.guardaObjeto(new SesionCloned((Sesion)iSesion));
                serializer = null;
                listaSesiones.put(iSesion.getId(), new Sesion(string));
                iSesion.dispose();
                iSesion = null;
            }
        }
        catch (Exception exception) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(exception, "No se pudo hacer Swap...");
        }
    }

    class HiloSwapThread
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = 4194376548577755759L;
        boolean stop = false;
        IMotor motor = null;

        public HiloSwapThread(IMotor iMotor) {
            this.motor = iMotor;
            this.setPriority(1);
        }

        public void dispose() {
            this.stop = true;
            this.motor = null;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (this.stop) {
                            throw new InterruptedException();
                        }
                        HiloSwapThread.sleep(2000L);
                        if (this.motor == null) continue;
                        this.motor.checkSwap();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    FuncionesUtiles.getFuncionesUtiles().muestraError(exception);
                    continue;
                }
                break;
            }
        }
    }
}

