/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.manejoFicheros.importacion.boe;

import es.aeat.pftw.mtrc.api.ITransformaciones;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.manejoFicheros.importacion.IImportacion;
import es.aeat.pftw.mtrc.api.utilidades.StringUtility;
import es.aeat.pftw.mtrc.imp.formateador.FormateadorCadena;
import es.aeat.pftw.mtrc.imp.formateador.FormateadorNIF;
import es.aeat.pftw.mtrc.imp.formateador.FormateadorRellenarCadenaConCaracterDefinido;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.imp.utilidades.Validaciones;
import java.io.Serializable;

public final class Transformaciones
implements ITransformaciones,
Serializable {
    private static final long serialVersionUID = -1073558622655379124L;
    private FormateadorCadena formatCad = null;
    private FormateadorRellenarCadenaConCaracterDefinido relleno = null;
    private FormateadorNIF formatNif = null;
    private static ITransformaciones trans = null;

    private Transformaciones() {
    }

    public static ITransformaciones getTransformaciones() {
        if (trans == null) {
            trans = new Transformaciones();
            try {
                trans.init(new Object[0]);
            }
            catch (ExceptionMotor exceptionMotor) {
                exceptionMotor.printStackTrace();
            }
        }
        return trans;
    }

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
        try {
            this.formatCad = new FormateadorCadena();
            this.relleno = new FormateadorRellenarCadenaConCaracterDefinido(' ', 0);
            this.formatNif = new FormateadorNIF();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String getTransformacionSegunTipoEstandard(IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs) throws ExceptionMotor {
        try {
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_IBAN) {
                return "MAYUSCULAS";
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_AN) {
                return "MAYUSCULASACENTUADAS;MAYUSCULAS;AJUSTARNOMBRE";
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_A) {
                return "MAYUSCULASACENTUADAS;MAYUSCULAS;AJUSTARNOMBRE";
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_NIF) {
                return "AJUSTARNIF";
            }
            return "";
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String ejecutarTransformaciones(String string, String string2) throws ExceptionMotor {
        try {
            String[] stringArray;
            if (string2.length() > 0) {
                string2 = string2 + ";";
            }
            if ((stringArray = string2.split(";")).length > 0) {
                for (String string3 : stringArray) {
                    string = this.ejecutarTransformacion(string, string3);
                }
                return string;
            }
            return null;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected String ejecutarTransformacion(String string, String string2) throws ExceptionMotor {
        String string3 = string2;
        String string4 = string;
        try {
            String string5 = "";
            String[] stringArray = StringUtility.getStringUtility().split(string3, ":");
            if (stringArray.length > 1) {
                string3 = stringArray[0];
                string5 = stringArray[1];
            }
            if (string3.equalsIgnoreCase("CDATE")) {
                if (string4.trim().length() > 0) {
                    String[] stringArray2 = string4.split("-");
                    if (string5.equalsIgnoreCase("DDMMYYYY")) {
                        string4 = stringArray2[2].substring(0, 2);
                        string4 = string4 + stringArray2[1];
                        string4 = string4 + stringArray2[0];
                    } else if (string5.equalsIgnoreCase("YYYYMMDD")) {
                        string4 = stringArray2[0];
                        string4 = string4 + stringArray2[1];
                        string4 = string4 + stringArray2[2].substring(0, 2);
                    }
                }
                return string4;
            }
            if (string3.equalsIgnoreCase("CDATE/")) {
                if (string4.trim().length() > 0 && !string4.equalsIgnoreCase("00000000")) {
                    String[] stringArray3 = string4.split("/");
                    if (string5.equalsIgnoreCase("YYYYMMDD")) {
                        string4 = stringArray3[2].substring(0, 4);
                        string4 = string4 + stringArray3[1];
                        string4 = string4 + stringArray3[0];
                    }
                }
                return string4;
            }
            if (string5.equalsIgnoreCase("SIVACIO") || string5.equalsIgnoreCase("SICERO")) {
                string5 = stringArray[1];
                string3 = stringArray[0];
            }
            if (string3.equalsIgnoreCase("SIVACIO")) {
                if (string4 == null || string4.trim().length() == 0) {
                    return string5;
                }
                return string4;
            }
            if (string3.equalsIgnoreCase("SICERO")) {
                if (string4 != null && string4.trim().equalsIgnoreCase("0")) {
                    return string5;
                }
                return string4;
            }
            if (string3.equalsIgnoreCase("RELLENAIZQUIERDA") || string3.equalsIgnoreCase("RELLENADERECHA")) {
                String[] stringArray4 = string5.split(",");
                if (stringArray4.length != 2) {
                    throw new ExceptionMotor("Los par\u00e1metros de la transformaci\u00f3n " + string3 + " no tiene el formato esperado");
                }
                int n = Integer.valueOf(stringArray4[1]);
                if (string4.length() >= n) {
                    return string4;
                }
                while (string4.length() < n) {
                    if (string3.equalsIgnoreCase("RELLENAIZQUIERDA")) {
                        string4 = stringArray4[0] + string4;
                        continue;
                    }
                    string4 = string4 + stringArray4[0];
                }
                return string4;
            }
            if (string3.equalsIgnoreCase("MAYUSCULAS")) {
                return string4.toUpperCase();
            }
            if (string3.equalsIgnoreCase("LONGITUDREGISTRO")) {
                return string4;
            }
            if (string3.equalsIgnoreCase("AJUSTARNOMBRE")) {
                int n = string4.length();
                String string6 = this.formatCad.formatearHaciaMotor(string4).toString();
                if (string6 == null) {
                    return null;
                }
                if ((string6 = this.relleno.formatearHaciaMotor(string6, ' ', n).toString()) == null) {
                    return null;
                }
                return string6;
            }
            if (string3.equalsIgnoreCase("AJUSTARNIF")) {
                String string7 = this.formatNif.formatearHaciaMotor(string4).toString();
                if (string7 == null) {
                    return null;
                }
                string7 = string7.replaceAll(" ", "0");
                return string7;
            }
            if (string3.equalsIgnoreCase("ACEROS")) {
                String string8 = FuncionesUtiles.getFuncionesUtiles().rellena("", "0".charAt(0), string4.length());
                return string8;
            }
            if (string3.equalsIgnoreCase("ABLANCOS")) {
                String string9 = FuncionesUtiles.getFuncionesUtiles().rellena("", ' ', string4.length());
                return string9;
            }
            if (string3.equalsIgnoreCase("MAYUSCULASACENTUADAS")) {
                char[] cArray = string4.toCharArray();
                block19: for (int i = 0; i < string4.length(); ++i) {
                    switch (cArray[i]) {
                        case '\u00e1': {
                            cArray[i] = 65;
                            continue block19;
                        }
                        case '\u00e9': {
                            cArray[i] = 69;
                            continue block19;
                        }
                        case '\u00ed': {
                            cArray[i] = 73;
                            continue block19;
                        }
                        case '\u00f3': {
                            cArray[i] = 79;
                            continue block19;
                        }
                        case '\u00fa': {
                            cArray[i] = 85;
                            continue block19;
                        }
                        case '\u00fc': {
                            cArray[i] = 85;
                            continue block19;
                        }
                        case '\u00c1': {
                            cArray[i] = 65;
                            continue block19;
                        }
                        case '\u00c9': {
                            cArray[i] = 69;
                            continue block19;
                        }
                        case '\u00cd': {
                            cArray[i] = 73;
                            continue block19;
                        }
                        case '\u00d3': {
                            cArray[i] = 79;
                            continue block19;
                        }
                        case '\u00da': {
                            cArray[i] = 85;
                            continue block19;
                        }
                        case '\u00dc': {
                            cArray[i] = 85;
                            continue block19;
                        }
                        case '\u00b4': {
                            cArray[i] = 39;
                            continue block19;
                        }
                    }
                }
                string4 = String.valueOf(cArray);
                return string4;
            }
            if (string3.equalsIgnoreCase("CARACTERESNOALFANUM")) {
                int n = string4.length();
                for (int i = 0; i < n; ++i) {
                    char c = string4.charAt(i);
                    if (Validaciones.getValidaciones().esAlfanumericaAEAT(c)) continue;
                    string4 = string4.replace(c, ' ');
                }
                return string4;
            }
            if (string3.equalsIgnoreCase("CARACTERESNOALFABETICOS")) {
                int n = string4.length();
                for (int i = 0; i < n; ++i) {
                    char c = string4.charAt(i);
                    if (Validaciones.getValidaciones().esAlfabeticoAEAT(c)) continue;
                    string4 = string4.replace(c, ' ');
                }
                return string4;
            }
            if (string3.equalsIgnoreCase("CTE")) {
                string4 = string5;
                return string4;
            }
            throw new ExceptionMotor("Funci\u00f3n " + string3 + " no esperada");
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Valor " + string + " Transformacion " + string2);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Valor " + string + " Transformacion " + string2);
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        this.formatCad = null;
        this.relleno = null;
        this.formatNif = null;
    }
}

