/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.manejoFicheros.importacion.boe;

import es.aeat.pftw.mtrc.api.IClienteMotor;
import es.aeat.pftw.mtrc.api.ITransformaciones;
import es.aeat.pftw.mtrc.api.PFTW_MTRC_Factory;
import es.aeat.pftw.mtrc.api.configuracion.IRegError;
import es.aeat.pftw.mtrc.api.configuracion.RegError;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.manejoFicheros.importacion.IImportacion;
import es.aeat.pftw.mtrc.api.manejoFicheros.importacion.boe.IImportacionBOE;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.tipos.Caracter;
import es.aeat.pftw.mtrc.api.utilidades.IFuncionesUtiles;
import es.aeat.pftw.mtrc.api.utilidades.StringUtility;
import es.aeat.pftw.mtrc.imp.manejoFicheros.importacion.Importacion;
import es.aeat.pftw.mtrc.imp.manejoFicheros.importacion.boe.Transformaciones;
import es.aeat.pftw.mtrc.imp.utilidades.Validaciones;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImportacionBOE
extends Importacion
implements IImportacionBOE {
    private static final long serialVersionUID = -2055039647227053340L;
    protected byte[] contenidoFichero = null;
    protected int ptrFichero = -1;
    protected boolean esNumeroPositivoCon0 = false;
    protected boolean admitoN00000000 = false;
    protected IFuncionesUtiles funcionesUtiles = null;
    protected List<IRegError> listadoErroresCaracteres;
    protected List<IRegError> listadoWarningCaracteres;
    protected int contadorErroresCaracteres = 0;
    protected boolean erroresPrevios = false;

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
    }

    @Override
    public void dispose() throws ExceptionMotor {
        super.dispose();
        this.contenidoFichero = null;
        this.ptrFichero = -1;
        this.funcionesUtiles = null;
        this.listadoErroresCaracteres = null;
        this.listadoWarningCaracteres = null;
    }

    public IFuncionesUtiles getFuncionesUtiles() throws Exception {
        if (this.funcionesUtiles == null) {
            this.funcionesUtiles = PFTW_MTRC_Factory.getFuncionesUtiles();
        }
        return this.funcionesUtiles;
    }

    @Override
    public boolean isErroresPrevios() {
        return this.erroresPrevios;
    }

    protected void setErroresPrevios(boolean bl) {
        this.erroresPrevios = bl;
    }

    protected List<IRegError> getListadoErroresCaracteres() {
        if (this.listadoErroresCaracteres == null) {
            this.listadoErroresCaracteres = new ArrayList<IRegError>();
        }
        return this.listadoErroresCaracteres;
    }

    protected List<IRegError> getListadoWarningsCaracteres() {
        if (this.listadoWarningCaracteres == null) {
            this.listadoWarningCaracteres = new ArrayList<IRegError>();
        }
        return this.listadoWarningCaracteres;
    }

    @Override
    public void establecerFichero(byte[] byArray) throws ExceptionMotor {
        this.contenidoFichero = byArray;
        this.ptrFichero = -1;
    }

    @Override
    public void irPrincipioFichero() throws ExceptionMotor {
        this.ptrFichero = -1;
    }

    @Override
    public void irFinalFichero() throws ExceptionMotor {
        this.ptrFichero = this.contenidoFichero.length;
    }

    @Override
    public Caracter getCaracterEnPosicion(int n) throws ExceptionMotor {
        try {
            return new Caracter(this.contenidoFichero[n]);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void reescribe(String string) throws ExceptionMotor {
        try {
            int n = this.ptrFichero + 1 - string.length();
            for (int i = 0; i < string.length(); ++i) {
                this.contenidoFichero[n + i] = string.getBytes()[i];
            }
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public Caracter getSiguienteCaracter() throws ExceptionMotor {
        try {
            ++this.ptrFichero;
            if (this.ptrFichero >= this.contenidoFichero.length) {
                return new Caracter(-1);
            }
            return new Caracter(this.contenidoFichero[this.ptrFichero]);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String dameEtiquetaActual() throws ExceptionMotor {
        try {
            if (this.contenidoFichero[this.ptrFichero] == 60) {
                Caracter caracter;
                int n = this.ptrFichero;
                String string = "";
                while ((caracter = this.getSiguienteCaracter()) != null && caracter.getTipoCaracter() != Caracter.TipoCaracter.EOF) {
                    if (caracter.getChr() == '>') {
                        return string;
                    }
                    string = string + caracter.getChr();
                    if (!this.isEof()) continue;
                }
                this.ptrFichero = n;
            }
            return null;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean acabaEnEtiqueta(int n, String string) throws ExceptionMotor {
        try {
            if (this.disponeDeNCaracteres(n)) {
                int n2 = n + this.ptrFichero - string.length() + 1;
                String string2 = "";
                for (int i = 0; i < string.length(); ++i) {
                    Caracter caracter = new Caracter(this.contenidoFichero[n2 + i]);
                    if (caracter.getTipoCaracter() != Caracter.TipoCaracter.CARACTER) {
                        return false;
                    }
                    string2 = string2 + caracter.getChr();
                }
                return string2.equalsIgnoreCase(string);
            }
            return false;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String getSiguientesCaracteres(int n) throws ExceptionMotor {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                Caracter caracter = this.getSiguienteCaracter();
                if (caracter.getTipoCaracter() != Caracter.TipoCaracter.CARACTER) {
                    return null;
                }
                stringBuffer.append(caracter.getChr());
                if (this.isEof()) break;
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String getSiguientesCaracteresAvanzando(int n, int n2) throws ExceptionMotor {
        try {
            String string = "";
            for (int i = 0; i < n; ++i) {
                Caracter caracter = new Caracter(this.contenidoFichero[this.ptrFichero + n2 + i]);
                if (caracter.getTipoCaracter() != Caracter.TipoCaracter.CARACTER) continue;
                string = string + caracter.getChr();
            }
            return string;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void retrocedeCaracteres(int n) throws ExceptionMotor {
        this.ptrFichero -= n;
    }

    @Override
    public boolean disponeDeNCaracteres(int n) throws ExceptionMotor {
        if (this.ptrFichero + n <= this.contenidoFichero.length) {
            for (int i = 0; i <= n; ++i) {
                if (this.getCaracterEnPosicion(this.ptrFichero + i).getTipoCaracter() == Caracter.TipoCaracter.CARACTER) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEof() throws ExceptionMotor {
        try {
            return this.ptrFichero >= this.contenidoFichero.length - 1;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean isEsNumeroPositivoCon0() {
        return this.esNumeroPositivoCon0;
    }

    @Override
    public void setEsNumeroPositivoCon0(boolean bl) {
        this.esNumeroPositivoCon0 = bl;
    }

    @Override
    public boolean isAdmitoN00000000() {
        return this.admitoN00000000;
    }

    @Override
    public void setAdmitoN00000000(boolean bl) {
        this.admitoN00000000 = bl;
    }

    @Override
    public void limpiaErroresYWarnings() {
        super.limpiaErroresYWarnings();
        if (this.listadoErroresCaracteres != null) {
            this.listadoErroresCaracteres.clear();
        }
        if (this.listadoWarningCaracteres != null) {
            this.listadoWarningCaracteres.clear();
        }
        this.contadorErroresCaracteres = 0;
    }

    public boolean esNumericaAEAT(String string) {
        try {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean esnumericaConSignoAEAT(String string) {
        try {
            if (string.length() == 0) {
                return false;
            }
            if (!this.isEsNumeroPositivoCon0()) {
                if (string.charAt(0) == 'N' || string.charAt(0) == ' ') {
                    boolean bl = this.esNumericaAEAT(string.substring(1, string.length()));
                    if (bl && string.charAt(0) == 'N' && Long.valueOf(string.substring(1, string.length())) == 0L && !this.isAdmitoN00000000()) {
                        return false;
                    }
                    return bl;
                }
                return false;
            }
            if (string.charAt(0) == 'N' || this.esNumericaAEAT(String.valueOf(string.charAt(0)))) {
                boolean bl = this.esNumericaAEAT(string.substring(1, string.length()));
                if (bl && string.charAt(0) == 'N' && Long.valueOf(string.substring(1, string.length())) == 0L && !this.isAdmitoN00000000()) {
                    return false;
                }
                return bl;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean validaCaracteres(String string, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs) throws ExceptionMotor {
        try {
            block23: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block22: {
                                                if (tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_AN) break block22;
                                                if (!Validaciones.getValidaciones().esAlfanumericaAEAT(string) || Validaciones.getValidaciones().cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(string)) {
                                                    return false;
                                                }
                                                break block23;
                                            }
                                            if (tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_A) break block24;
                                            if (!Validaciones.getValidaciones().esAlfabeticoAEAT(string) || Validaciones.getValidaciones().cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(string)) {
                                                return false;
                                            }
                                            break block23;
                                        }
                                        if (tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_CADNUM2) break block25;
                                        if (!this.esNumericaAEAT(string) && string.trim().length() > 0) {
                                            return false;
                                        }
                                        break block23;
                                    }
                                    if (tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_NUM && tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_FECHAINVERTIDA && tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_FECHANORMAL && tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_FECHA_SIN_FORMATO && tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_CADNUM) break block26;
                                    if (!this.esNumericaAEAT(string)) {
                                        return false;
                                    }
                                    break block23;
                                }
                                if (tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_NUMSIGNO) break block27;
                                if (!this.esnumericaConSignoAEAT(string)) {
                                    return false;
                                }
                                break block23;
                            }
                            if (tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_NIF) break block28;
                            if (!Validaciones.getValidaciones().esAlfanumericaAEAT(string) || string.indexOf(32) != -1 && string.trim().length() > 0) {
                                return false;
                            }
                            break block23;
                        }
                        if (tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_1ATRUE) break block29;
                        switch (string.charAt(0)) {
                            case '0': 
                            case '1': {
                                break block23;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    if (tipoDatosEstandarChrs != IImportacion.TipoDatosEstandarChrs.LITERAL_XATRUE) break block30;
                    switch (string.charAt(0)) {
                        case ' ': 
                        case 'X': {
                            break block23;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_EMAIL) {
                    String string2 = string.trim();
                    if (string2.trim().length() > 0 && string2.startsWith(" ")) {
                        return false;
                    }
                    char[] cArray = string2.toUpperCase().toCharArray();
                    for (int i = 0; i < string2.length(); ++i) {
                        if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._@\u00d1\u00c7\u00b4\\:;&/()".indexOf(cArray[i]) != -1) continue;
                        return false;
                    }
                } else if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_IBAN) {
                    if (!Validaciones.getValidaciones().esAlfanumericaAEAT(string)) {
                        return false;
                    }
                } else {
                    throw new ExceptionMotor("No entendido atributo TipoDato =" + (Object)((Object)tipoDatosEstandarChrs) + " no se valida el tipo de campo");
                }
            }
            return true;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Valor " + string);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Valor " + string);
        }
    }

    @Override
    public void transformacionRealizadaConExito(String string, String string2, String string3, StringBuffer stringBuffer) throws ExceptionMotor {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("CAMPO", string3);
            hashMap.put("CODERRORI18N", "SUSTCHRS");
            this.addWarning(string, new RegError(string2 + "1", hashMap));
            this.reescribe(stringBuffer.toString());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected boolean validaCaracteresCampoCOMUN(String string, StringBuffer stringBuffer, String string2, String string3, String string4, Object object, Method method, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs) throws ExceptionMotor {
        try {
            boolean bl = method != null ? ((Boolean)method.invoke(object, stringBuffer.toString())).booleanValue() : this.validaCaracteres(stringBuffer.toString(), tipoDatosEstandarChrs);
            if (!bl && string4 != null) {
                String string5 = this.getTransformaciones().ejecutarTransformaciones(stringBuffer.toString(), string4);
                stringBuffer.delete(0, stringBuffer.capacity());
                stringBuffer.append(string5);
                bl = method != null ? ((Boolean)method.invoke(object, stringBuffer.toString())).booleanValue() : this.validaCaracteres(stringBuffer.toString(), tipoDatosEstandarChrs);
                if (bl) {
                    this.transformacionRealizadaConExito(string, string3, string2, stringBuffer);
                }
            }
            if (!bl) {
                this.anniadirErrorDeCaracteresNoValidos(string, stringBuffer, string2, string3);
            }
            return bl;
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Campo " + string2 + " Valor " + stringBuffer);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Campo " + string2 + " Valor " + stringBuffer);
        }
    }

    @Override
    public void anniadirErrorDeCaracteresNoValidos(String string, StringBuffer stringBuffer, String string2, String string3) throws ExceptionMotor {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("CODERRORI18N", "CHRNV");
            hashMap.put("CAMPO", string2);
            hashMap.put("TIPO ERROR", "E");
            this.addError(string, new RegError(string3, hashMap));
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Campo " + string2 + " Valor " + stringBuffer);
        }
    }

    @Override
    public boolean validaCaracteresCampo(String string, StringBuffer stringBuffer, String string2, String string3, String string4, Object object, Method method) throws ExceptionMotor {
        return this.validaCaracteresCampoCOMUN(string, stringBuffer, string2, string3, string4, object, method, null);
    }

    @Override
    public boolean validaCaracteresCampo(String string, StringBuffer stringBuffer, String string2, String string3, String string4, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs) throws ExceptionMotor {
        return this.validaCaracteresCampoCOMUN(string, stringBuffer, string2, string3, string4, null, null, tipoDatosEstandarChrs);
    }

    @Override
    public String formateaNumerico(String string, Object object) throws ExceptionMotor {
        int n = 0;
        try {
            if (string.length() == 0) {
                return string;
            }
            if (string.startsWith("N")) {
                return "-" + this.formateaNumerico(string.substring(1), object);
            }
            if (object != null && object.toString().length() > 0) {
                n = Integer.valueOf(object.toString());
            }
            String string2 = string;
            if (n == 0) {
                return Long.valueOf(string).toString();
            }
            if (n > string.length() - 1) {
                throw new ExceptionMotor("Error, demasiados decimales solicitados Valor = " + string + " Decimales = " + n);
            }
            string2 = string.substring(0, string.length() - n) + "." + string.substring(string.length() - n);
            return new BigDecimal(string2.toString().trim()).toString();
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Valor " + string + " Decimales " + n);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Valor " + string + " Decimales " + n);
        }
    }

    @Override
    public String formateaValor(String string, String string2, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs) throws ExceptionMotor {
        try {
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_1ATRUE) {
                if (string2.equalsIgnoreCase("1")) {
                    return "true";
                }
                if (string2.equalsIgnoreCase("0")) {
                    return "false";
                }
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_FECHAINVERTIDA) {
                switch (string2.length()) {
                    case 6: {
                        return string2.substring(4, 6) + string2.substring(2, 4) + string2.substring(0, 2);
                    }
                    case 8: {
                        return string2.substring(4, 8) + string2.substring(2, 4) + string2.substring(0, 2);
                    }
                }
                throw new ExceptionMotor("Longitud de dato para FechaInvertida no es ni 4 ni 8");
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_FECHANORMAL) {
                if (string2.length() == 8 && !string2.equalsIgnoreCase("00000000") && !string2.equalsIgnoreCase("        ")) {
                    string2 = string2.substring(0, 2) + "-" + string2.substring(2, 4) + "-" + string2.substring(4);
                }
                if (string2.equalsIgnoreCase("00000000")) {
                    string2 = "";
                }
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_XATRUE) {
                if (string2.equalsIgnoreCase("X") || string2.equalsIgnoreCase("true")) {
                    return "true";
                }
                if (string2.equalsIgnoreCase(" ") || string2.equalsIgnoreCase("false")) {
                    return "false";
                }
                throw new ExceptionMotor("Valor (" + string2 + ") no valido para tipo '" + (Object)((Object)IImportacion.TipoDatosEstandarChrs.LITERAL_XATRUE) + "'");
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_FECHA_SIN_FORMATO) {
                if (string2.length() == 8 && !string2.equalsIgnoreCase("00000000") && !string2.equalsIgnoreCase("        ")) {
                    string2 = string2.substring(6) + "-" + string2.substring(4, 6) + "-" + string2.substring(0, 4);
                }
                if (string2.equalsIgnoreCase("00000000")) {
                    string2 = "";
                }
                return string2;
            }
            if (string2.trim().length() == 0) {
                return "";
            }
            return StringUtility.getStringUtility().rTrim(string2);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.setInformacionExtra(exceptionMotor.getInformacionExtra() + " Partida " + string + " Valor " + string2);
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, " Partida " + string + " Valor " + string2);
        }
    }

    @Override
    public ITransformaciones getTransformaciones() {
        return Transformaciones.getTransformaciones();
    }

    @Override
    public void addError(String string, IRegError iRegError) {
        this.addError(string, iRegError, true);
    }

    @Override
    public void addError(String string, IRegError iRegError, boolean bl) {
        if (iRegError.getPropiedad("NOESPREVIA") != null) {
            iRegError.setPropiedad("NOESPREVIA", null);
        } else if (iRegError.getTipoError().equalsIgnoreCase("E") || iRegError.getTipoError().equalsIgnoreCase("H")) {
            this.setErroresPrevios(true);
        }
        super.addError(this.getListadoErroresCaracteres(), string, iRegError, bl);
    }

    @Override
    public void addWarning(String string, IRegError iRegError, boolean bl) {
        iRegError.setTipoError("A");
        super.addWarning(this.getListadoWarningsCaracteres(), string, iRegError, bl);
    }

    @Override
    public void addWarning(String string, IRegError iRegError) {
        this.addWarning(string, iRegError, true);
    }

    @Override
    public void hacerSaltarReglasDeRegistro(ISesion iSesion, String string, String string2) throws Exception {
        if (this.isErroresPrevios()) {
            return;
        }
        super.hacerSaltarReglasDeRegistro(iSesion, string, string2);
    }

    @Override
    public void hacerSaltarReglasDeRegistro(IClienteMotor iClienteMotor, String string, String string2) throws Exception {
        if (this.isErroresPrevios()) {
            return;
        }
        super.hacerSaltarReglasDeRegistro(iClienteMotor, string, string2);
    }

    @Override
    public boolean partidaModificada(IClienteMotor iClienteMotor, String string, String string2, String string3, String string4, String string5, String string6) throws ExceptionMotor {
        if (this.isErroresPrevios()) {
            return true;
        }
        return super.partidaModificada(iClienteMotor, string, string2, string3, string4, string5, string6);
    }

    @Override
    public boolean partidaModificada(ISesion iSesion, String string, String string2, String string3, String string4, String string5, String string6) throws ExceptionMotor {
        if (this.isErroresPrevios()) {
            return true;
        }
        return super.partidaModificada(iSesion, string, string2, string3, string4, string5, string6);
    }

    @Override
    public List<IRegError> getListaErrores() throws ExceptionMotor {
        try {
            if (this.isErroresPrevios()) {
                return this.getListadoErroresCaracteres();
            }
            return this.getFuncionesUtiles().concatList(this.getListadoErroresCaracteres(), super.getListaErrores());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<IRegError> getListaWarnings() throws ExceptionMotor {
        try {
            if (this.isErroresPrevios()) {
                return this.getListadoWarningsCaracteres();
            }
            return this.getFuncionesUtiles().concatList(this.getListadoWarningsCaracteres(), super.getListaWarnings());
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

