/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.manejoFicheros.importacion;

import es.aeat.pftw.mtrc.api.IAop;
import es.aeat.pftw.mtrc.api.IClienteMotor;
import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import es.aeat.pftw.mtrc.api.configuracion.IRegError;
import es.aeat.pftw.mtrc.api.configuracion.RegError;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.excepciones.MtrrException;
import es.aeat.pftw.mtrc.api.manejoFicheros.importacion.IImportacion;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatoRetornoProceso;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValorEx;
import es.aeat.pftw.mtrc.imp.tipos.TipoDatosCampoValorEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Importacion
implements IAop,
IImportacion {
    private static final long serialVersionUID = 482521332571881564L;
    private boolean superoNumeroMaximoErrores = false;
    private int numeroMaximoDeErrores = Integer.MAX_VALUE;
    protected List<IRegError> listadoErrores;
    protected List<IRegError> listadoWarning;
    protected int contadorErrores = 0;
    protected int contadorWarnings = 0;
    protected Map<String, List<ITipoDatosCampoValorEx>> ultimoRegistro = new HashMap<String, List<ITipoDatosCampoValorEx>>();

    @Override
    public void limpiaErroresYWarnings() {
        if (this.listadoErrores != null) {
            this.listadoErrores.clear();
        }
        if (this.listadoWarning != null) {
            this.listadoWarning.clear();
        }
        this.superoNumeroMaximoErrores = false;
        this.ultimoRegistro.clear();
        this.contadorErrores = 0;
        this.contadorWarnings = 0;
    }

    @Override
    public int getNumeroMaximoDeErrores() {
        return this.numeroMaximoDeErrores;
    }

    @Override
    public void setNumeroMaximoDeErrores(int n) {
        this.numeroMaximoDeErrores = n;
    }

    @Override
    public boolean isSuperoNumeroMaximoErrores() {
        return this.superoNumeroMaximoErrores;
    }

    @Override
    public void setSuperoNumeroMaximoErrores(boolean bl) {
        this.superoNumeroMaximoErrores = bl;
    }

    @Override
    public int errCount() {
        return this.contadorErrores;
    }

    public IRegError addErrorWarningComun(List<IRegError> list, String string, IRegError iRegError, boolean bl) {
        if (this.contadorErrores + this.contadorWarnings == this.getNumeroMaximoDeErrores()) {
            return null;
        }
        if (this.contadorErrores + this.contadorWarnings == this.getNumeroMaximoDeErrores() - 1) {
            this.setSuperoNumeroMaximoErrores(true);
            list.add(new RegError("MAXERR"));
            ++this.contadorErrores;
            return null;
        }
        if (bl) {
            if (iRegError.getTipoError().equalsIgnoreCase("E") || iRegError.getTipoError().equalsIgnoreCase("H")) {
                ++this.contadorErrores;
            } else {
                ++this.contadorWarnings;
            }
        }
        iRegError.setPropiedad("LOCALIZACION", string);
        return iRegError;
    }

    public void addError(List<IRegError> list, String string, IRegError iRegError, boolean bl) {
        if ((iRegError = this.addErrorWarningComun(list, string, iRegError, bl)) == null) {
            return;
        }
        if (iRegError.getTipoError() == null || iRegError.getTipoError().length() == 0) {
            iRegError.setTipoError("E");
        } else if (!iRegError.getTipoError().equalsIgnoreCase("E") && !iRegError.getTipoError().equalsIgnoreCase("H")) {
            this.addWarning(string, iRegError, false);
            return;
        }
        list.add(iRegError);
    }

    @Override
    public abstract void addError(String var1, IRegError var2);

    @Override
    public abstract void addError(String var1, IRegError var2, boolean var3);

    public void addError(List<IRegError> list, String string, IRegError iRegError) {
        this.addError(list, string, iRegError, true);
    }

    @Override
    public abstract void addWarning(String var1, IRegError var2, boolean var3);

    public void addWarning(List<IRegError> list, String string, IRegError iRegError, boolean bl) {
        if ((iRegError = this.addErrorWarningComun(list, string, iRegError, bl)) == null) {
            return;
        }
        if (iRegError.getTipoError() == null || iRegError.getTipoError().length() == 0) {
            iRegError.setTipoError("W");
        }
        list.add(iRegError);
    }

    @Override
    public abstract void addWarning(String var1, IRegError var2);

    public void addWarning(List<IRegError> list, String string, IRegError iRegError) {
        this.addWarning(list, string, iRegError, true);
    }

    @Override
    public List<IRegError> getListaErrores() throws ExceptionMotor {
        if (this.listadoErrores == null) {
            this.listadoErrores = new ArrayList<IRegError>();
        }
        return this.listadoErrores;
    }

    @Override
    public List<IRegError> getListaWarnings() throws ExceptionMotor {
        if (this.listadoWarning == null) {
            this.listadoWarning = new ArrayList<IRegError>();
        }
        return this.listadoWarning;
    }

    @Override
    public void dispose() throws ExceptionMotor {
        this.listadoErrores = null;
        this.listadoWarning = null;
        this.ultimoRegistro = null;
        this.contadorErrores = 0;
        this.contadorWarnings = 0;
    }

    protected boolean partidaModificadaCOMUN(ISesion iSesion, IClienteMotor iClienteMotor, String string, String string2, String string3, String string4, String string5, String string6) throws ExceptionMotor {
        try {
            boolean bl = true;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("CAMPOMOTOR", string3);
            hashMap.put("CAMPO", string5);
            if (iClienteMotor != null && iClienteMotor.getClientGestionReglas().isErrorPartidaModificadaSobreCampoCerrado()) {
                iClienteMotor.getClientGestionReglas().setEmpezandoPartidaModificadaDesdeImportacion();
            }
            if (iSesion != null && iSesion.getGestionReglas().isErrorPartidaModificadaSobreCampoCerrado()) {
                iSesion.getGestionReglas().setEmpezandoPartidaModificadaDesdeImportacion(true);
            }
            boolean bl2 = false;
            if (iClienteMotor != null) {
                bl2 = iClienteMotor.getClientGestionReglas().partidaModificada(string3, string4, hashMap);
            }
            if (iSesion != null) {
                bl2 = iSesion.getGestionReglas().partidaModificada(string3, string4, hashMap);
            }
            if (!bl2) {
                List<IRegError> list = null;
                if (iClienteMotor != null) {
                    list = iClienteMotor.getClientGestionReglas().getListaErroresEnReglas();
                }
                if (iSesion != null) {
                    list = iSesion.getGestionReglas().getListaErroresEnReglas();
                }
                for (IRegError iRegError : list) {
                    iRegError.setPropiedad("NOESPREVIA", "EnPartidaModificada");
                    this.addError(this.getListaErrores(), string, iRegError);
                    if (!iRegError.getTipoError().equals("E") && !iRegError.getTipoError().equals("H") || iRegError.getIdError().equalsIgnoreCase("IMPROCEDENTE")) continue;
                    bl = false;
                }
            }
            if (iClienteMotor != null) {
                hashMap.put("VALUE", iClienteMotor.getClientOperaciones().obtenerPartida(string3));
            }
            if (iSesion != null) {
                hashMap.put("VALUE", iSesion.getOperaciones().obtenerPartidaString(string3));
            }
            hashMap.put("ERRXLS", string6);
            hashMap.put("LINEA", string);
            this.ultimoRegistro.get(string2.toUpperCase()).add(new TipoDatosCampoValorEx(string3, hashMap));
            return bl;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean partidaModificada(ISesion iSesion, String string, String string2, String string3, String string4, String string5, String string6) throws ExceptionMotor {
        return this.partidaModificadaCOMUN(iSesion, null, string, string2, string3, string4, string5, string6);
    }

    @Override
    public boolean partidaModificada(IClienteMotor iClienteMotor, String string, String string2, String string3, String string4, String string5, String string6) throws ExceptionMotor {
        return this.partidaModificadaCOMUN(null, iClienteMotor, string, string2, string3, string4, string5, string6);
    }

    protected IImportacion.ResultadoAddReg anniadirRegistroCOMUN(ISesion iSesion, IClienteMotor iClienteMotor, String string) throws ExceptionMotor {
        try {
            long l = 0L;
            if (iClienteMotor != null) {
                l = iClienteMotor.getClientOperaciones().anniadirRegistro(string);
            }
            if (iSesion != null) {
                l = iSesion.getOperaciones().anniadirRegistro(string);
            }
            if (l < 1L) {
                if (l == -2L) {
                    return IImportacion.ResultadoAddReg.RESULTADO_SUPERA_MAXIMOS;
                }
                return IImportacion.ResultadoAddReg.RESULTADO_EXCEPCION;
            }
            this.ultimoRegistro.put(string.toUpperCase(), new ArrayList());
            return IImportacion.ResultadoAddReg.RESULTADO_OK;
        }
        catch (MtrrException mtrrException) {
            throw new ExceptionMotor(mtrrException);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public IImportacion.ResultadoAddReg anniadirRegistro(ISesion iSesion, String string) throws ExceptionMotor {
        return this.anniadirRegistroCOMUN(iSesion, null, string);
    }

    @Override
    public IImportacion.ResultadoAddReg anniadirRegistro(IClienteMotor iClienteMotor, String string) throws ExceptionMotor {
        return this.anniadirRegistroCOMUN(null, iClienteMotor, string);
    }

    protected ITipoDatoRetornoProceso gestionReglas_comprobarDeclaracion(ISesion iSesion, String string, boolean bl) throws MtrrException {
        try {
            List<String> list = iSesion.getModelo().getGestorDatosOpciones().getOpcion("COMPROBAR_DECLARACION");
            if (list == null || list.size() == 0) {
                iSesion = null;
                throw new MtrrException("Falta informacion de configuracion [COMPROBAR_DECLARACION]");
            }
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i).toString();
            }
            if (string == null) {
                string = stringArray[0].split(",")[0];
            }
            return iSesion.getGestionReglas().comprobarDeclaracion(string, stringArray, bl);
        }
        catch (MtrrException mtrrException) {
            throw mtrrException;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw new MtrrException(exceptionMotor);
        }
        catch (Exception exception) {
            throw new MtrrException(exception);
        }
    }

    protected void hacerSaltarReglasDeRegistroCOMUN(ISesion iSesion, IClienteMotor iClienteMotor, String string, String string2) throws Exception {
        ITipoDatoRetornoProceso iTipoDatoRetornoProceso = null;
        if (iClienteMotor != null) {
            iTipoDatoRetornoProceso = iClienteMotor.getClientGestionReglas().comprobarDeclaracion(string2, false);
        }
        if (iSesion != null) {
            iTipoDatoRetornoProceso = this.gestionReglas_comprobarDeclaracion(iSesion, string2, false);
        }
        if (!iTipoDatoRetornoProceso.isCorrecto()) {
            for (IRegError serializable : iTipoDatoRetornoProceso.getListadoErrores()) {
                serializable.setPropiedad("NOESPREVIA", "RegRegistro");
                this.addError(string, serializable);
            }
        }
        for (IRegError iRegError : iTipoDatoRetornoProceso.getListadoWarnings()) {
            this.addWarning(string, iRegError);
        }
        if (this.ultimoRegistro.containsKey(string2.toUpperCase())) {
            for (ITipoDatosCampoValorEx iTipoDatosCampoValorEx : this.ultimoRegistro.get(string2.toUpperCase())) {
                Map map = (Map)iTipoDatosCampoValorEx.getValor();
                String string3 = "";
                if (iClienteMotor != null) {
                    string3 = iClienteMotor.getClientOperaciones().obtenerPartida(iTipoDatosCampoValorEx.getNombreCampo());
                }
                if (iSesion != null) {
                    string3 = iSesion.getOperaciones().obtenerPartidaString(iTipoDatosCampoValorEx.getNombreCampo());
                }
                if (((String)map.get("VALUE")).equalsIgnoreCase(string3)) continue;
                map.put("CODERRORI18N", "CAMPACT");
                this.addWarning((String)map.get("LINEA"), new RegError((String)map.get("ERRXLS") + "2", map));
            }
            this.ultimoRegistro.remove(string2.toUpperCase());
        }
    }

    @Override
    public void hacerSaltarReglasDeRegistro(IClienteMotor iClienteMotor, String string, String string2) throws Exception {
        this.hacerSaltarReglasDeRegistroCOMUN(null, iClienteMotor, string, string2);
    }

    @Override
    public void hacerSaltarReglasDeRegistro(ISesion iSesion, String string, String string2) throws Exception {
        this.hacerSaltarReglasDeRegistroCOMUN(iSesion, null, string, string2);
    }

    @Override
    public void addWarningTotalActualizado(String string, String string2, String string3) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CAMPO", string3);
        hashMap.put("CODERRORI18N", "CAMPACT");
        this.addWarning(string, new RegError(string2 + "2", hashMap));
    }

    @Override
    public boolean contieneError(String string) throws Exception {
        if (this.getListaErrores().size() > 0) {
            for (IRegError iRegError : this.getListaErrores()) {
                if (!iRegError.getIdError().trim().equalsIgnoreCase(string.trim())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean esValorPorDefecto(String string, IClienteMotor iClienteMotor) throws Exception {
        IRegEntrada iRegEntrada = iClienteMotor.getClientGestorModelo().getEntradas().get(string.toUpperCase());
        if (iRegEntrada == null) {
            throw new Exception("Entrada " + string + " no encontrada!!!");
        }
        return iRegEntrada.esValorPorDefecto(iClienteMotor.getClientOperaciones().obtenerPartida(string));
    }
}

