/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.manejoFicheros.exportacion.boe;

import es.aeat.pftw.mtrc.api.IClienteMotor;
import es.aeat.pftw.mtrc.api.PFTW_MTRC_Factory;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.manejoFicheros.importacion.IImportacion;
import es.aeat.pftw.mtrc.api.manejoFicheros.importacion.boe.IExportacionBOE;
import es.aeat.pftw.mtrc.api.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.api.utilidades.IFuncionesUtiles;
import es.aeat.pftw.mtrc.api.utilidades.IWriterAEAT;
import es.aeat.pftw.mtrc.imp.manejoFicheros.exportacion.Exportacion;
import es.aeat.pftw.mtrc.imp.utilidades.ByteWriterAEAT;
import es.aeat.pftw.mtrc.imp.utilidades.Formatear;
import es.aeat.pftw.mtrc.imp.utilidades.StringAEAT;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ExportacionBOE
extends Exportacion
implements IExportacionBOE {
    private static final long serialVersionUID = 7219802344639785819L;
    protected IWriterAEAT writer;
    protected IFuncionesUtiles funcionesUtiles = null;
    protected boolean esNumeroPositivoCon0 = false;
    protected boolean admitoN00000000 = false;
    protected boolean usaBuffer = false;
    protected StringAEAT buffer = null;

    @Override
    public void init(Object[] objectArray) throws ExceptionMotor {
    }

    @Override
    public void iniciaUsoBuffer() {
        this.usaBuffer = true;
        this.buffer = new StringAEAT("ISO-8859-1");
    }

    @Override
    public void grabaBuffer() throws ExceptionMotor {
        this.usaBuffer = false;
        if (this.buffer != null) {
            this.getWriter().write(this.buffer.getString("ISO-8859-1"));
            this.buffer = null;
        }
    }

    @Override
    public boolean isEsNumeroPositivoCon0() {
        return this.esNumeroPositivoCon0;
    }

    @Override
    public void setEsNumeroPositivoCon0(boolean bl) {
        this.esNumeroPositivoCon0 = bl;
    }

    @Override
    public boolean isAdmitoN00000000() {
        return this.admitoN00000000;
    }

    @Override
    public void setAdmitoN00000000(boolean bl) {
        this.admitoN00000000 = bl;
    }

    protected IWriterAEAT getWriter() {
        if (this.writer == null) {
            this.writer = new ByteWriterAEAT();
        }
        return this.writer;
    }

    @Override
    public void dispose() throws ExceptionMotor {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
            this.funcionesUtiles = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writer = null;
    }

    @Override
    public byte[] dameFicheroGenerado() throws ExceptionMotor {
        try {
            return ((ByteWriterAEAT)this.getWriter()).getBytes();
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void write(String string) throws ExceptionMotor {
        if (this.usaBuffer) {
            this.buffer.append(string);
        } else {
            this.getWriter().write(string);
        }
    }

    @Override
    public void writeln(String string) throws ExceptionMotor {
        if (this.usaBuffer) {
            this.buffer.append(string);
            this.buffer.append("\r\n");
        } else {
            this.getWriter().writeln(string);
        }
    }

    public IFuncionesUtiles getFuncionesUtiles() throws Exception {
        if (this.funcionesUtiles == null) {
            this.funcionesUtiles = PFTW_MTRC_Factory.getFuncionesUtiles();
        }
        return this.funcionesUtiles;
    }

    public String eliminaNotacionExponencial(String string, int n) throws Exception {
        if (!string.toUpperCase().contains("E")) {
            return string;
        }
        String string2 = string;
        string2 = string2.replace('.', ',');
        Locale locale = new Locale("es", "ES");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        DecimalFormat decimalFormat = null;
        String string3 = "#0";
        for (int i = 1; i <= n; ++i) {
            if (i == 1) {
                string3 = string3 + ".";
            }
            string3 = string3 + "0";
        }
        decimalFormat = new DecimalFormat(string3, decimalFormatSymbols);
        try {
            string2 = decimalFormat.format(decimalFormat.parse(string2));
        }
        catch (Exception exception) {
            string2 = "";
        }
        string2 = string2.replace(',', '.');
        return string2;
    }

    public String formateaNumero(String string, int n, int n2) throws ExceptionMotor {
        try {
            int n3 = 0;
            String string2 = string;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            string2 = this.eliminaNotacionExponencial(string2, n2);
            int n4 = string2.indexOf(46);
            if (n4 > 0) {
                string4 = string2.substring(0, n4);
                string5 = string2.substring(n4 + 1);
                if (string5.length() > n2) {
                    string5 = string5.substring(0, n2);
                }
            } else {
                string4 = string2;
            }
            for (n3 = 0; n3 < n - n2 - string4.length(); ++n3) {
                string3 = "0" + string3;
            }
            string3 = string3 + string4;
            if (n2 > 0) {
                string3 = string3 + string5;
                for (n3 = 0; n3 < n2 - string5.length(); ++n3) {
                    string3 = string3 + "0";
                }
            }
            if (string3.contains("-")) {
                throw new ExceptionMotor("Intentando formatear sin signo una cantidad con negativos " + string);
            }
            return string3;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Valor " + string + " long " + n + " decimales " + n2);
        }
    }

    @Override
    public void escribeConstante(char c, int n) throws ExceptionMotor {
        try {
            String string = this.getFuncionesUtiles().rellena("", c, n);
            this.write(string);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void escribeCadena(IClienteMotor iClienteMotor, String string, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs, int n) throws ExceptionMotor {
        try {
            this.escribeCadena(iClienteMotor.getClientOperaciones().obtenerPartida(string), string, tipoDatosEstandarChrs, n);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void escribeCadena(ISesion iSesion, String string, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs, int n) throws ExceptionMotor {
        try {
            this.escribeCadena(iSesion.getOperaciones().obtenerPartidaString(string), string, tipoDatosEstandarChrs, n);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void escribeCadena(String string, String string2, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs, int n) throws ExceptionMotor {
        try {
            string = this.formateaEstandar(string, tipoDatosEstandarChrs, n);
            this.write(string);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void escribeNumerico(IClienteMotor iClienteMotor, String string, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs, int n, int n2) throws ExceptionMotor {
        try {
            this.escribeNumerico(iClienteMotor.getClientOperaciones().obtenerPartida(string), string, tipoDatosEstandarChrs, n, n2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void escribeNumerico(ISesion iSesion, String string, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs, int n, int n2) throws ExceptionMotor {
        try {
            this.escribeNumerico(iSesion.getOperaciones().obtenerPartidaString(string), string, tipoDatosEstandarChrs, n, n2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void escribeNumerico(String string, String string2, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs, int n, int n2) throws ExceptionMotor {
        try {
            string = this.formateaEstandar(string, tipoDatosEstandarChrs, n, n2);
            this.write(string);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, string2);
        }
    }

    @Override
    public String formateaEstandar(String string, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs, int n) throws ExceptionMotor {
        return this.formateaEstandar(string, tipoDatosEstandarChrs, n, 0);
    }

    protected int longitudNumeroSinPuntosetc(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            try {
                Integer.valueOf(string.substring(i, i + 1));
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public String formateaEstandar(String string, IImportacion.TipoDatosEstandarChrs tipoDatosEstandarChrs, int n, int n2) throws ExceptionMotor {
        try {
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_1ATRUE) {
                if (string.equalsIgnoreCase("true")) {
                    return "1";
                }
                if (string.equalsIgnoreCase("false")) {
                    return "0";
                }
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_FECHAINVERTIDA) {
                n = 8;
                if ((string = string.replaceAll("-", "").replaceAll("/", "")).length() != n) {
                    string = this.getFuncionesUtiles().rellena(string, '0', n);
                }
                return string.substring(6, 8) + string.substring(4, 6) + string.substring(0, 4);
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_XATRUE) {
                if (string.equalsIgnoreCase("true")) {
                    return "X";
                }
                return " ";
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_FECHA_SIN_FORMATO) {
                n = 8;
                if ((string = string.replaceAll("-", "").replaceAll("/", "")).length() != n) {
                    string = this.getFuncionesUtiles().rellena(string, '0', n);
                }
                return string.substring(4) + string.substring(2, 4) + string.substring(0, 2);
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_FECHANORMAL) {
                String string2 = string.replaceAll("-", "").replaceAll("/", "");
                if (string2.length() < 8) {
                    return "00000000";
                }
                return string2;
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_CADNUM) {
                if (string.length() != n) {
                    string = this.getFuncionesUtiles().rellena(string, '0', n, true);
                }
                return string;
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_CADNUM2) {
                if (string.length() != n) {
                    string = string.trim().length() == 0 ? this.getFuncionesUtiles().rellena(string, ' ', n, true) : this.getFuncionesUtiles().rellena(string, '0', n, true);
                }
                return string;
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_NUM) {
                if (string.length() == 0) {
                    string = this.getFuncionesUtiles().rellena(string, '0', n);
                }
                string = Formatear.getFormatear().redondea(new BigDecimal(string.trim()), (Object)n2).toString();
                return this.formateaNumero(string, n, n2);
            }
            if (tipoDatosEstandarChrs == IImportacion.TipoDatosEstandarChrs.LITERAL_NUMSIGNO) {
                String string3 = "";
                string = Formatear.getFormatear().redondea(new BigDecimal(string.trim()), (Object)n2).toString();
                String string4 = string;
                if (string4.length() == 0) {
                    string4 = this.getFuncionesUtiles().rellena(string4, '0', n);
                }
                if (string4.charAt(0) == '-') {
                    string4 = string4.substring(1);
                    string3 = "N";
                } else if (this.longitudNumeroSinPuntosetc(string4) < n) {
                    string3 = this.isEsNumeroPositivoCon0() ? "0" : " ";
                }
                return string3 + this.formateaNumero(string4, n - 1, n2);
            }
            return this.getFuncionesUtiles().rellena(string, ' ', n);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

