/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.imp.configuracion;

import es.aeat.pftw.mtrc.api.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import es.aeat.pftw.mtrc.api.configuracion.IRegError;
import es.aeat.pftw.mtrc.api.configuracion.IRegRegla;
import es.aeat.pftw.mtrc.api.configuracion.IRegRelacionada;
import es.aeat.pftw.mtrc.api.configuracion.IRegTabla;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatoDescModelo;
import es.aeat.pftw.mtrc.imp.tipos.TipoDatoDescModelo;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GestorConfiguracion
implements IGestorConfiguracion,
Serializable {
    private static final long serialVersionUID = 1442575904419736415L;
    protected String clave = null;
    protected boolean conexionAbierta = false;
    protected Map<String, IRegEntrada> conjuntoDeEntradas = new HashMap<String, IRegEntrada>();
    protected Map<String, IRegError> conjuntoDeErrores = new HashMap<String, IRegError>();
    protected Map<String, IRegRegla> conjuntoDeReglas = new HashMap<String, IRegRegla>();
    protected Map<String, List<String>> conjuntoDePartidaConReglas = new HashMap<String, List<String>>();
    protected Map<String, Map<String, List<IRegRegla>>> conjuntoReglasDePartidaClasificadas = new HashMap<String, Map<String, List<IRegRegla>>>();
    protected Map<String, IRegRelacionada> conjuntoDeRelacionadas = new HashMap<String, IRegRelacionada>();
    protected Map<String, IRegTabla> conjuntoDeTablas = new HashMap<String, IRegTabla>();
    protected Map<String, List<String>> conjuntoDeCamposDeTabla = new HashMap<String, List<String>>();
    protected Map<String, String> conjuntoDeAlias2Ruta = new HashMap<String, String>();
    protected Map<String, String> conjuntoDeRuta2Alias = new HashMap<String, String>();
    protected ITipoDatoDescModelo modelo = null;
    protected boolean guardarEnMayusculas = false;

    @Override
    public IRegEntrada getEntrada(String string) throws ExceptionMotor {
        try {
            String string2 = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(string);
            return this.getConjuntoDeEntradas().get(this.string2uppercase(string2));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Entrada " + string);
        }
    }

    @Override
    public IRegError getError(long l) throws ExceptionMotor {
        return this.getError(String.valueOf(l));
    }

    @Override
    public IRegError getError(int n) throws ExceptionMotor {
        return this.getError(String.valueOf(n));
    }

    @Override
    public IRegError getError(String string) throws ExceptionMotor {
        try {
            return this.getConjuntoDeErrores().get(string);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Error " + string);
        }
    }

    @Override
    public IRegError getErrorIfExists(String string) throws ExceptionMotor {
        try {
            return this.getConjuntoDeErrores().get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public IRegTabla getTablaNivel(int n) throws ExceptionMotor {
        try {
            Collection<IRegTabla> collection = this.getConjuntoDeTablas().values();
            Iterator<IRegTabla> iterator = collection.iterator();
            IRegTabla iRegTabla = null;
            while (iterator.hasNext()) {
                iRegTabla = iterator.next();
                if (iRegTabla.getNivel() != n) continue;
                return iRegTabla;
            }
            return null;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Nivel " + n);
        }
    }

    protected IRegTabla getTable(String string) throws ExceptionMotor {
        try {
            IRegTabla iRegTabla = this.getConjuntoDeTablas().get(this.string2uppercase(string));
            if (iRegTabla == null) {
                Collection<IRegTabla> collection = this.getConjuntoDeTablas().values();
                Iterator<IRegTabla> iterator = collection.iterator();
                IRegTabla iRegTabla2 = null;
                while (iterator.hasNext()) {
                    iRegTabla2 = iterator.next();
                    if (!iRegTabla2.getIdTabla().toUpperCase().equalsIgnoreCase(string)) continue;
                    return iRegTabla2;
                }
            }
            return iRegTabla;
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Tabla " + string);
        }
    }

    @Override
    public IRegTabla getTabla(String string) throws ExceptionMotor {
        return this.getTable(string);
    }

    @Override
    public List<String> getCamposDeTabla(String string) throws ExceptionMotor {
        try {
            return this.getConjuntoDeCamposDeTabla().get(this.string2uppercase(string));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Tabla " + string);
        }
    }

    @Override
    public IRegRegla getRegla(long l) throws ExceptionMotor {
        return this.getRegla(String.valueOf(l));
    }

    @Override
    public IRegRegla getRegla(int n) throws ExceptionMotor {
        return this.getRegla(String.valueOf(n));
    }

    @Override
    public IRegRegla getRegla(String string) throws ExceptionMotor {
        try {
            return this.getConjuntoDeReglas().get(this.string2uppercase(string));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Regla " + string);
        }
    }

    @Override
    @Deprecated
    public List<IRegRegla> getReglasDePartida(String string) {
        try {
            List<String> list = this.getConjuntoDePartidaConReglas().get(this.string2uppercase(string));
            if (list == null) {
                return new ArrayList<IRegRegla>();
            }
            ArrayList<IRegRegla> arrayList = new ArrayList<IRegRegla>();
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(this.getConjuntoDeReglas().get(list.get(i).toString()));
                if (arrayList.get(arrayList.size() - 1) != null) continue;
                arrayList.remove(arrayList.size() - 1);
            }
            return arrayList;
        }
        catch (Exception exception) {
            return new ArrayList<IRegRegla>();
        }
    }

    @Override
    public Map<String, List<IRegRegla>> getReglasDePartidaClasificadas(String string) {
        try {
            if (this.getConjuntoReglasDePartidaClasificadas().containsKey(string.toUpperCase())) {
                return this.getConjuntoReglasDePartidaClasificadas().get(string.toUpperCase());
            }
            this.getConjuntoReglasDePartidaClasificadas().put(string.toUpperCase(), this.getReglasDePartidaClasificadasNOGenerado(string));
            return this.getReglasDePartidaClasificadas(string);
        }
        catch (Exception exception) {
            return new HashMap<String, List<IRegRegla>>();
        }
    }

    public Map<String, List<IRegRegla>> getReglasDePartidaClasificadasNOGenerado(String string) {
        try {
            List<String> list = this.getConjuntoDePartidaConReglas().get(this.string2uppercase(string));
            if (list == null) {
                return new HashMap<String, List<IRegRegla>>();
            }
            ArrayList<IRegRegla> arrayList = null;
            IRegRegla iRegRegla = null;
            HashMap<String, List<IRegRegla>> hashMap = new HashMap<String, List<IRegRegla>>();
            String string2 = "";
            for (int i = 0; i < list.size(); ++i) {
                int n;
                iRegRegla = this.getConjuntoDeReglas().get(list.get(i));
                if (iRegRegla == null) continue;
                string2 = iRegRegla.getTipoRegla().toString();
                arrayList = (ArrayList<IRegRegla>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<IRegRegla>();
                }
                if (iRegRegla.getOrden() == Integer.MAX_VALUE) {
                    iRegRegla.setOrden(0);
                }
                if (iRegRegla.getOrden() == 0) {
                    if (arrayList.size() == 0 || ((IRegRegla)arrayList.get(arrayList.size() - 1)).getOrden() >= 0) {
                        arrayList.add(iRegRegla);
                    } else {
                        for (n = arrayList.size() - 1; n >= 0; --n) {
                            if (((IRegRegla)arrayList.get(n)).getOrden() < 0) continue;
                            ++n;
                            break;
                        }
                        arrayList.add(n, iRegRegla);
                    }
                } else if (iRegRegla.getOrden() > 0) {
                    if (arrayList.size() == 0 || ((IRegRegla)arrayList.get(0)).getOrden() <= 0) {
                        arrayList.add(0, iRegRegla);
                    } else {
                        for (n = 0; n < arrayList.size() && ((IRegRegla)arrayList.get(n)).getOrden() != 0 && iRegRegla.getOrden() > ((IRegRegla)arrayList.get(n)).getOrden(); ++n) {
                        }
                        arrayList.add(n, iRegRegla);
                    }
                } else if (iRegRegla.getOrden() < 0) {
                    if (arrayList.size() == 0 || ((IRegRegla)arrayList.get(arrayList.size() - 1)).getOrden() >= 0) {
                        arrayList.add(iRegRegla);
                    } else {
                        for (n = arrayList.size() - 1; n >= 0; --n) {
                            if (((IRegRegla)arrayList.get(n)).getOrden() != 0 && iRegRegla.getOrden() < ((IRegRegla)arrayList.get(n)).getOrden()) continue;
                            ++n;
                            break;
                        }
                        arrayList.add(n, iRegRegla);
                    }
                }
                hashMap.put(string2, arrayList);
                arrayList = null;
            }
            return hashMap;
        }
        catch (Exception exception) {
            return new HashMap<String, List<IRegRegla>>();
        }
    }

    @Override
    public IRegRelacionada getRelacionada(String string) throws ExceptionMotor {
        try {
            return this.getConjuntoDeRelacionadas().get(this.string2uppercase(string));
        }
        catch (ExceptionMotor exceptionMotor) {
            throw exceptionMotor;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception, "Tabla " + string);
        }
    }

    protected String estimarLoQueGuardar(String string, String string2) throws Exception {
        try {
            if (string.equalsIgnoreCase("IDPARTIDA")) {
                return this.string2uppercase(string2);
            }
            if (string.equalsIgnoreCase("TIPODATO")) {
                return this.string2uppercase(string2);
            }
            if (string.equalsIgnoreCase("IDVARIABLE")) {
                return this.string2uppercase(string2);
            }
            if (string.equalsIgnoreCase("idTabla")) {
                return this.string2uppercase(string2);
            }
            return string2;
        }
        catch (Exception exception) {
            return this.string2uppercase(string2);
        }
    }

    @Override
    public abstract boolean abrirAlmacenamiento(List<Object> var1) throws ExceptionMotor;

    @Override
    public IGestorConfiguracion getGestorConfiguracionGeneradoSinDependencias() {
        return null;
    }

    protected boolean esRuta(Object object) {
        try {
            File file = new File(object.toString());
            if (file.exists()) {
                file = null;
                return true;
            }
            file = null;
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean esInputStream(Object object) {
        try {
            if ((InputStream)object != null) {
                return true;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean cerrarAlmacenamiento() throws ExceptionMotor {
        try {
            if (this.getConjuntoDeTablas() != null) {
                this.getConjuntoDeTablas().clear();
                this.setConjuntoDeTablas(null);
            }
            if (this.getConjuntoDePartidaConReglas() != null) {
                this.getConjuntoDePartidaConReglas().clear();
                this.setConjuntoDePartidaConReglas(null);
            }
            if (this.getConjuntoReglasDePartidaClasificadas() != null) {
                this.getConjuntoReglasDePartidaClasificadas().clear();
            }
            if (this.getConjuntoDeEntradas() != null) {
                this.getConjuntoDeEntradas().clear();
                this.setConjuntoDeEntradas(null);
            }
            if (this.getConjuntoDeErrores() != null) {
                this.getConjuntoDeErrores().clear();
                this.setConjuntoDeErrores(null);
            }
            if (this.getConjuntoDeReglas() != null) {
                this.getConjuntoDeReglas().clear();
                this.setConjuntoDeReglas(null);
            }
            if (this.getConjuntoDeRelacionadas() != null) {
                this.getConjuntoDeRelacionadas().clear();
                this.setConjuntoDeRelacionadas(null);
            }
            if (this.getConjuntoDeCamposDeTabla() != null) {
                this.getConjuntoDeCamposDeTabla().clear();
                this.setConjuntoDeCamposDeTabla(null);
            }
            if (this.getConjuntoDeAlias2Ruta() != null) {
                this.getConjuntoDeAlias2Ruta().clear();
                this.setConjuntoDeAlias2Ruta(null);
            }
            if (this.getConjuntoDeRuta2Alias() != null) {
                this.getConjuntoDeRuta2Alias().clear();
                this.setConjuntoDeRuta2Alias(null);
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected String string2uppercase(String string) throws Exception {
        if (this.isGuardarEnMayusculas()) {
            return string.toUpperCase();
        }
        return string;
    }

    @Override
    public Map<String, IRegEntrada> getConjuntoDeEntradas() {
        return this.conjuntoDeEntradas;
    }

    @Override
    public Map<String, IRegError> getConjuntoDeErrores() {
        return this.conjuntoDeErrores;
    }

    @Override
    public Map<String, IRegRegla> getConjuntoDeReglas() {
        return this.conjuntoDeReglas;
    }

    @Override
    @Deprecated
    public Map<String, List<String>> getConjuntoDePartidaConReglas() {
        return this.conjuntoDePartidaConReglas;
    }

    @Override
    public Map<String, Map<String, List<IRegRegla>>> getConjuntoReglasDePartidaClasificadas() {
        if (this.conjuntoReglasDePartidaClasificadas == null) {
            this.conjuntoReglasDePartidaClasificadas = new HashMap<String, Map<String, List<IRegRegla>>>();
        }
        return this.conjuntoReglasDePartidaClasificadas;
    }

    @Override
    public Map<String, IRegRelacionada> getConjuntoDeRelacionadas() {
        return this.conjuntoDeRelacionadas;
    }

    @Override
    public Map<String, IRegTabla> getConjuntoDeTablas() {
        return this.conjuntoDeTablas;
    }

    @Override
    public Map<String, List<String>> getConjuntoDeCamposDeTabla() {
        return this.conjuntoDeCamposDeTabla;
    }

    @Override
    public void addConjuntoDeCamposDeTabla(String string) {
        this.getConjuntoDeCamposDeTabla().put(string, new ArrayList());
    }

    @Override
    public String getAlias(String string) {
        try {
            String string2 = this.getConjuntoDeRuta2Alias().get(this.string2uppercase(string));
            if (string2 == null) {
                return "";
            }
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getRuta(String string) {
        try {
            String string2 = this.getConjuntoDeAlias2Ruta().get(this.string2uppercase(string));
            if (string2 == null) {
                return "";
            }
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected boolean sanearRelacionadas(Map<String, IRegRelacionada> map) throws ExceptionMotor {
        try {
            Set<String> set = map.keySet();
            String string = "";
            IRegRelacionada iRegRelacionada = null;
            List<String> list = null;
            ArrayList<String> arrayList = null;
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                string = iterator.next().toString();
                iRegRelacionada = map.get(string);
                list = iRegRelacionada.getTablaRelacionada();
                if (list != null && list.size() > 1) {
                    arrayList = new ArrayList<String>();
                    for (int i = 0; i < list.size(); ++i) {
                        if (arrayList.contains(list.get(i))) continue;
                        arrayList.add(list.get(i));
                    }
                    if (arrayList.size() != list.size()) {
                        iRegRelacionada.setTablaRelacionada(arrayList);
                    }
                }
                arrayList = null;
                list = null;
                iRegRelacionada = null;
                string = "";
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    protected void setConexionAbierta(boolean bl) {
        this.conexionAbierta = bl;
    }

    protected boolean isConexionAbierta() {
        return this.conexionAbierta;
    }

    protected void setConjuntoDeEntradas(Map<String, IRegEntrada> map) {
        this.conjuntoDeEntradas = map;
    }

    protected void setConjuntoDeErrores(Map<String, IRegError> map) {
        this.conjuntoDeErrores = map;
    }

    protected void setConjuntoDeReglas(Map<String, IRegRegla> map) {
        this.conjuntoDeReglas = map;
    }

    protected void setConjuntoDePartidaConReglas(Map<String, List<String>> map) {
        this.conjuntoDePartidaConReglas = map;
    }

    protected void setConjuntoDeRelacionadas(Map<String, IRegRelacionada> map) {
        this.conjuntoDeRelacionadas = map;
    }

    protected void setConjuntoDeTablas(Map<String, IRegTabla> map) {
        this.conjuntoDeTablas = map;
    }

    protected void setConjuntoDeCamposDeTabla(Map<String, List<String>> map) {
        this.conjuntoDeCamposDeTabla = map;
    }

    protected void setConjuntoDeAlias2Ruta(Map<String, String> map) {
        this.conjuntoDeAlias2Ruta = map;
    }

    protected Map<String, String> getConjuntoDeAlias2Ruta() {
        return this.conjuntoDeAlias2Ruta;
    }

    protected void setConjuntoDeRuta2Alias(Map<String, String> map) {
        this.conjuntoDeRuta2Alias = map;
    }

    protected Map<String, String> getConjuntoDeRuta2Alias() {
        return this.conjuntoDeRuta2Alias;
    }

    protected void setGuardarEnMayusculas(boolean bl) {
        this.guardarEnMayusculas = bl;
    }

    protected boolean isGuardarEnMayusculas() {
        return this.guardarEnMayusculas;
    }

    @Override
    public String getModKeyBBDD() {
        return this.clave;
    }

    @Override
    public void setModKeyBBDD(String string) throws ExceptionMotor {
        this.clave = string;
    }

    @Override
    public ITipoDatoDescModelo getVersion() {
        if (this.modelo == null) {
            this.modelo = new TipoDatoDescModelo("???", "????", "?.??");
        }
        return this.modelo;
    }

    @Override
    public void setVersion(ITipoDatoDescModelo iTipoDatoDescModelo) {
        this.modelo = iTipoDatoDescModelo;
    }
}

