/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.api.utilidades;

import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrc.api.utilidades.IGestorTablas;
import es.aeat.pftw.mtrc.api.utilidades.INodoArbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GestorTablas
implements Serializable,
IGestorTablas {
    private static final long serialVersionUID = 5035144933230121544L;
    private Map<String, ITipoDatosCampoValor> tablasRecorriendo;
    private Map<String, String> tablasAcabadas;
    private Map<String, String> tablasEmpezadas;
    private INodoArbol arbolDatos;
    private final String separador = "&&&";

    public GestorTablas(INodoArbol iNodoArbol) {
        this.arbolDatos = iNodoArbol;
        this.init();
    }

    protected INodoArbol getArbolDatos() {
        return this.arbolDatos;
    }

    @Override
    public void acaboTabla(String string, String string2) throws ExceptionMotor {
        try {
            this.tablasAcabadas.put(string.toUpperCase() + "&&&" + string2, "");
            this.tablasRecorriendo.remove(string.toUpperCase() + "&&&" + string2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void comenzoTabla(String string, String string2) throws ExceptionMotor {
        try {
            this.tablasEmpezadas.put(string.toUpperCase() + "&&&" + string2, "");
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void quitarComenzoTabla(String string, String string2) throws ExceptionMotor {
        try {
            this.tablasEmpezadas.remove(string.toUpperCase() + "&&&" + string2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void quitarAcaboTabla(String string, String string2) throws ExceptionMotor {
        try {
            this.tablasAcabadas.remove(string.toUpperCase() + "&&&" + string2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void recorriendoTabla(String string, String string2, ITipoDatosCampoValor iTipoDatosCampoValor) throws ExceptionMotor {
        try {
            this.tablasRecorriendo.put(string.toUpperCase() + "&&&" + string2, iTipoDatosCampoValor);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public void init() {
        this.tablasRecorriendo = new HashMap<String, ITipoDatosCampoValor>();
        this.tablasAcabadas = new HashMap<String, String>();
        this.tablasEmpezadas = new HashMap<String, String>();
    }

    @Override
    public List<String> dameListaTablasRecorriendose() throws ExceptionMotor {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            Set<String> set = this.tablasRecorriendo.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((String)iterator.next()).split("&&&")[0]);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<String> dameListaTablasAcabadas() throws ExceptionMotor {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            Set<String> set = this.tablasAcabadas.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((String)iterator.next()).split("&&&")[0]);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public List<String> dameListaTablasEmpezadas() throws ExceptionMotor {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            Set<String> set = this.tablasEmpezadas.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((String)iterator.next()).split("&&&")[0]);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean isComenzoTabla(String string, String string2) throws ExceptionMotor {
        try {
            return this.tablasEmpezadas.containsKey(string.toUpperCase() + "&&&" + string2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean isRecorriendoTabla(String string, String string2) throws ExceptionMotor {
        try {
            return this.tablasRecorriendo.containsKey(string.toUpperCase() + "&&&" + string2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean isRecorriendoTablas() throws ExceptionMotor {
        try {
            return this.tablasRecorriendo.size() > 0;
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public int recorriendoTablasCount() throws ExceptionMotor {
        try {
            return this.tablasRecorriendo.size();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean isAcabadaTabla(String string, String string2) throws ExceptionMotor {
        try {
            return this.tablasAcabadas.containsKey(string.toUpperCase() + "&&&" + string2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public long getPosicionRecorriendoTabla(String string, String string2) throws ExceptionMotor {
        try {
            return Long.parseLong(this.tablasRecorriendo.get(string.toUpperCase() + "&&&" + string2).getNombreCampo());
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public String getLocalizacionRecorriendoTabla(String string, String string2) throws ExceptionMotor {
        try {
            return this.tablasRecorriendo.get(string.toUpperCase() + "&&&" + string2).getValor();
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }

    @Override
    public boolean esTablaAcabada(String string, String string2) throws ExceptionMotor {
        try {
            return this.tablasAcabadas.containsKey(string + "&&&" + string2);
        }
        catch (Exception exception) {
            throw new ExceptionMotor(exception);
        }
    }
}

