/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.api.utilidades;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderFromBytes
extends ClassLoader
implements Serializable {
    private static final long serialVersionUID = 870111380957620367L;
    private static ClassLoaderFromBytes singletonClassLoaderFromBytes = null;
    private static List<Object> listaClases = null;
    private static ClassLoader cloader = null;

    public static synchronized ClassLoaderFromBytes getClassLoaderFromBytes(ClassLoader classLoader, List<Object> list) {
        if (singletonClassLoaderFromBytes == null) {
            singletonClassLoaderFromBytes = new ClassLoaderFromBytes();
        }
        cloader = classLoader;
        listaClases = new ArrayList<Object>();
        if (list != null && list.size() != 0) {
            for (Object object : list) {
                listaClases.add((byte[])object);
            }
        }
        return singletonClassLoaderFromBytes;
    }

    public static synchronized ClassLoaderFromBytes getClassLoaderFromBytes(byte[] byArray) {
        if (singletonClassLoaderFromBytes == null) {
            singletonClassLoaderFromBytes = new ClassLoaderFromBytes();
        }
        listaClases = new ArrayList<Object>();
        listaClases.add(byArray);
        return singletonClassLoaderFromBytes;
    }

    private ClassLoaderFromBytes() {
    }

    public void dispose() {
        if (listaClases != null) {
            listaClases.clear();
            listaClases = null;
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.intentoCargaClase(null, string, bl);
        }
        catch (Exception exception) {
            clazz = null;
        }
        if (clazz != null) {
            return clazz;
        }
        if (listaClases != null && listaClases.size() > 0) {
            for (Object object : listaClases) {
                try {
                    clazz = this.intentoCargaClase((byte[])object, string, bl);
                    if (clazz == null) continue;
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = null;
                }
            }
        }
        try {
            clazz = cloader.loadClass(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        throw new ClassNotFoundException("Cannot load class: " + string);
    }

    protected Class<?> intentoCargaClase(byte[] byArray, String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            if (byArray == null) {
                throw new NoClassDefFoundError();
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            if (bl) {
                this.resolveClass(clazz);
            }
        }
        catch (ClassFormatError classFormatError) {
            throw new ClassNotFoundException(classFormatError.toString());
        }
        catch (SecurityException securityException) {
            clazz = super.loadClass(string, bl);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            clazz = super.loadClass(string, bl);
        }
        return clazz;
    }
}

