/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.api.tipos;

import es.aeat.pftw.mtrc.api.tipos.IDateMotor;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateMotor
implements Serializable,
IDateMotor {
    private static final long serialVersionUID = -8453346598032129822L;
    private Date date;
    private String fechaCadena;

    public DateMotor(String string) {
        this.date = this.pasaloComoUnDate(string);
    }

    private Date pasaloComoUnDate(String string) {
        if (string == null) {
            string = "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        if (string.length() == 8 && !string.contains("-") && !string.contains("/")) {
            string = string.substring(0, 2) + "/" + string.substring(2, 4) + "/" + string.substring(4);
        }
        string = string.replaceAll("-", "/");
        this.setFechaCadena(string);
        Date date = null;
        if (string.indexOf(47) != -1) {
            simpleDateFormat.setLenient(false);
            try {
                date = simpleDateFormat.parse(string);
                return date;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    @Override
    public String toString() {
        if (this.getDate() == null) {
            return "";
        }
        return this.getFechaOriginal();
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public static IDateMotor valueOf(String string) {
        return new DateMotor(string);
    }

    public static IDateMotor valueOf(IDateMotor iDateMotor) {
        return iDateMotor;
    }

    protected void setFechaCadena(String string) {
        this.fechaCadena = string;
    }

    @Override
    public String getFechaOriginal() {
        return this.fechaCadena;
    }
}

