/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.api.excepciones;

import java.io.Serializable;

public class ExceptionMotor
extends Exception
implements Serializable {
    private static final long serialVersionUID = -3852817769019221084L;
    protected String informacionExtra = "";
    protected StackTraceElement[] trazaExtra = null;

    public ExceptionMotor() {
    }

    public ExceptionMotor(String string) {
        super(string);
    }

    public ExceptionMotor(String string, StackTraceElement[] stackTraceElementArray) {
        super(string);
        this.trazaExtra = stackTraceElementArray;
    }

    public ExceptionMotor(Throwable throwable) {
        super(throwable);
    }

    public ExceptionMotor(Throwable throwable, String string) {
        this(throwable);
        this.setInformacionExtra(string);
    }

    public ExceptionMotor(String string, Throwable throwable) {
        super(string, throwable);
    }

    public ExceptionMotor(String string, Throwable throwable, String string2) {
        this(string, throwable);
        this.setInformacionExtra(string2);
    }

    public ExceptionMotor(Exception exception) {
        super(exception);
        this.setStackTrace((StackTraceElement[])exception.getStackTrace().clone());
        if (exception instanceof ExceptionMotor) {
            this.setInformacionExtra(((ExceptionMotor)exception).getInformacionExtra());
        }
    }

    public ExceptionMotor(Exception exception, String string) {
        this(exception);
        this.setInformacionExtra(string);
    }

    public void setInformacionExtra(String string) {
        if (!this.toString().contains(string)) {
            this.informacionExtra = string;
        }
    }

    public String getInformacionExtra() {
        return this.informacionExtra;
    }

    public void setTrazaExtra(StackTraceElement[] stackTraceElementArray) {
        this.trazaExtra = stackTraceElementArray;
    }

    public StackTraceElement[] getTrazaExtra() {
        return this.trazaExtra;
    }

    public String excepcionDetallada() {
        String string = super.toString();
        StackTraceElement[] stackTraceElementArray = this.getTrazaExtra();
        if (stackTraceElementArray == null) {
            stackTraceElementArray = this.getStackTrace();
        }
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n; ++i) {
            string = string + "\n" + stackTraceElementArray[i].getFileName() + "[" + stackTraceElementArray[i].getLineNumber() + "] ==> " + stackTraceElementArray[i].getMethodName() + "()";
        }
        return string;
    }

    @Override
    public String toString() {
        boolean bl;
        String string = super.toString();
        do {
            bl = true;
            int n = string.indexOf(ExceptionMotor.class.getName() + ":");
            if (n <= -1 || !string.substring(n + 1).contains(ExceptionMotor.class.getName() + ":")) continue;
            bl = false;
            string = string.substring(0, n) + string.substring(n + (ExceptionMotor.class.getName() + ":").length());
        } while (!bl);
        if (this.getInformacionExtra().length() > 0) {
            string = string + " (" + this.getInformacionExtra() + ")";
        }
        return string;
    }

    @Override
    public void printStackTrace() {
        System.out.println(this.toString());
    }
}

