/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.api.configuracion;

import es.aeat.pftw.mtrc.api.configuracion.IRegEntrada;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class RegEntrada
implements Serializable,
IRegEntrada {
    private static final long serialVersionUID = -9075135001076858668L;
    private Map<String, String> arrayDePropiedades = new HashMap<String, String>();

    public RegEntrada() {
        this.arrayDePropiedades.clear();
        this.arrayDePropiedades.put("ESTADO".toUpperCase(), String.valueOf(255));
        this.arrayDePropiedades.put("NUMERODECIMALES".toUpperCase(), "0");
    }

    @Override
    public void inicializaRegEntrada(String string, String string2, String string3, String string4) {
        this.setIdVariable(string);
        this.setIdPartida(string);
        this.setTipoDato(string3);
        this.setValorPorDefecto(string4);
        this.setIdTabla(string2);
    }

    @Override
    public void setPropiedad(String string, String string2) {
        if (string.equalsIgnoreCase("TIPODATO")) {
            this.setTipoDato(string2);
        } else {
            this.arrayDePropiedades.put(string.toUpperCase(), string2);
        }
    }

    @Override
    public String getPropiedad(String string) {
        return this.arrayDePropiedades.get(string.toUpperCase());
    }

    @Override
    public Map<String, String> getPropiedades() {
        return this.arrayDePropiedades;
    }

    @Override
    public String getIdPartida() {
        try {
            return this.getPropiedad("IDPARTIDA").toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void setIdPartida(String string) {
        if (string == null) {
            this.setPropiedad("IDPARTIDA", "");
        } else {
            this.setPropiedad("IDPARTIDA", string);
        }
    }

    @Override
    public String getIdVariable() {
        try {
            return this.getPropiedad("IDVARIABLE").toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void setIdVariable(String string) {
        if (string == null) {
            this.setPropiedad("IDVARIABLE", "");
        } else {
            this.setPropiedad("IDVARIABLE", string);
        }
    }

    @Override
    public String getIdTabla() {
        try {
            return this.getPropiedad("idTabla").toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void setIdTabla(String string) {
        if (string == null) {
            this.setPropiedad("idTabla", "");
        } else {
            this.setPropiedad("idTabla", string);
        }
    }

    @Override
    public String getTipoDato() {
        try {
            return this.getPropiedad("TIPODATO").toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void setTipoDato(String string) {
        if (string.equalsIgnoreCase("Cadena")) {
            string = "CADENA";
        } else if (string.equalsIgnoreCase("Email")) {
            string = "EMAIL";
        } else if (string.equalsIgnoreCase("CadNum")) {
            string = "CADENA_NUMERICA";
        } else if (string.equalsIgnoreCase("CadNum2")) {
            string = "CADENA_NUMERICA_2";
        } else if (string.equalsIgnoreCase("Logico")) {
            string = "LOGICO";
        } else if (string.equalsIgnoreCase("Entero")) {
            string = "ENTERO";
        } else if (string.equalsIgnoreCase("Doble")) {
            string = "DOBLE";
        } else if (string.equalsIgnoreCase("Fecha")) {
            string = "FECHA";
        } else if (string.equalsIgnoreCase("Tel")) {
            string = "TELEFONO";
        } else if (string.equalsIgnoreCase("BigDecimal")) {
            string = "BIGDECIMAL";
        } else if (string.equalsIgnoreCase("Blob")) {
            string = "BLOB";
        }
        this.arrayDePropiedades.put("TIPODATO", string);
        this.estimarValorInicial();
    }

    @Override
    public int getNumDecimales() {
        try {
            return Integer.valueOf(this.getPropiedad("NUMERODECIMALES").toString());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void setNumDecimales(int n) {
        this.setPropiedad("NUMERODECIMALES", String.valueOf(n));
    }

    @Override
    public void setNumDecimales(String string) {
        int n;
        try {
            n = Integer.valueOf(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        this.setNumDecimales(n);
    }

    @Override
    public void setEstadoInicial(int n) {
        this.setPropiedad("ESTADO", String.valueOf(n));
    }

    @Override
    public void setEstadoInicial(String string) {
        int n;
        try {
            n = Integer.valueOf(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        this.setEstadoInicial(n);
    }

    @Override
    public int getEstadoInicial() {
        try {
            return Integer.valueOf(this.getPropiedad("ESTADO").toString());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void setValorPorDefecto(String string) {
        this.setPropiedad("VALORPORDEFECTO", string);
    }

    @Override
    public String getValorInicial() {
        try {
            return this.getPropiedad("VALORPORDEFECTO").toString();
        }
        catch (Exception exception) {
            this.estimarValorInicial();
            String string = this.getPropiedad("VALORPORDEFECTO");
            if (string == null) {
                return "";
            }
            return string.toString();
        }
    }

    private void estimarValorInicial() {
        try {
            if (this.getPropiedad("TIPODATO") != null) {
                String string = this.getPropiedad("TIPODATO").toString();
                if (string.equalsIgnoreCase("ENTERO") || string.equalsIgnoreCase("DOBLE") || string.equalsIgnoreCase("BIGDECIMAL") || string.equalsIgnoreCase("CADENA_NUMERICA")) {
                    this.setPropiedad("VALORPORDEFECTO", "0");
                } else if (string.equalsIgnoreCase("LOGICO")) {
                    this.setPropiedad("VALORPORDEFECTO", "false");
                } else {
                    this.setPropiedad("VALORPORDEFECTO", "");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean esValorPorDefecto(String string) {
        try {
            if (this.getPropiedad("TIPODATO") != null) {
                String string2 = this.getPropiedad("TIPODATO").toString();
                if (this.esTipoNumerico()) {
                    try {
                        if (Double.valueOf(string.toString()).doubleValue() == Double.valueOf(this.getValorInicial()).doubleValue()) {
                            return true;
                        }
                    }
                    catch (Exception exception) {}
                } else if (string2.equalsIgnoreCase("LOGICO")) {
                    try {
                        if (Boolean.valueOf(string.toString()).booleanValue() == Boolean.valueOf(this.getValorInicial()).booleanValue()) {
                            return true;
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        if (string.trim().equalsIgnoreCase(this.getValorInicial().trim())) {
                            return true;
                        }
                        if ((string.equalsIgnoreCase("0") || string.equalsIgnoreCase("")) && (string2.equalsIgnoreCase("CADENA_NUMERICA") || string2.equalsIgnoreCase("CADENA_NUMERICA_2"))) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getLanzaVentana() {
        try {
            return this.getPropiedad("LANZAVENTANA").toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public int getTamannioTotal() {
        try {
            if (this.getPropiedad("NUMEROENTEROS") != null) {
                return Integer.parseInt(this.getPropiedad("NUMEROENTEROS")) + Integer.parseInt(this.getPropiedad("NUMERODECIMALES"));
            }
            if (this.getPropiedad("NUMERODECIMALES") != null) {
                return Integer.parseInt(this.getPropiedad("LONGITUD")) + Integer.parseInt(this.getPropiedad("NUMERODECIMALES"));
            }
            return this.getTamannioCampo();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public int getTamannioCampo() {
        try {
            return Integer.valueOf(this.getPropiedad("LONGITUD").toString());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public int getAdmiteNegativo() {
        try {
            String string = this.getPropiedad("ADMITENEGATIVOS").toString();
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("S") || string.equalsIgnoreCase("T")) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public boolean getMultiLinea() {
        try {
            return Integer.valueOf(this.getPropiedad("MULTILINEA").toString()) == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean esTipoNumerico() {
        return this.getTipoDato().equalsIgnoreCase("ENTERO") || this.getTipoDato().equalsIgnoreCase("DOBLE") || this.getTipoDato().equalsIgnoreCase("BIGDECIMAL");
    }

    @Override
    public IRegEntrada clone() throws CloneNotSupportedException {
        RegEntrada regEntrada = new RegEntrada();
        Set<String> set = this.arrayDePropiedades.keySet();
        String string = "";
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            string = iterator.next().toString();
            regEntrada.setPropiedad(string, this.arrayDePropiedades.get(string));
        }
        return regEntrada;
    }
}

