/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Err;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class XML10ContentChecker
extends ProxyReceiver {
    private NameChecker checker = Name10Checker.getInstance();
    private NamePool pool;
    private IntHashSet cache = new IntHashSet(100);

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pool = pipelineConfiguration.getConfiguration().getNamePool();
        super.setPipelineConfiguration(pipelineConfiguration);
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (!this.cache.contains(n)) {
            if (!this.checker.isValidNCName(this.pool.getLocalName(n))) {
                DynamicError dynamicError = new DynamicError("Invalid XML 1.0 element name " + Err.wrap(this.pool.getLocalName(n), 1));
                dynamicError.setErrorCode("SERE0005");
                dynamicError.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n3));
                throw dynamicError;
            }
            this.cache.add(n);
        }
        this.nextReceiver.startElement(n, n2, n3, n4);
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (!this.cache.contains(n)) {
            if (!this.checker.isValidNCName(this.pool.getLocalName(n))) {
                DynamicError dynamicError = new DynamicError("Invalid XML 1.0 attribute name " + Err.wrap(this.pool.getLocalName(n), 2));
                dynamicError.setErrorCode("SERE0005");
                dynamicError.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n3));
                throw dynamicError;
            }
            this.cache.add(n);
        }
        this.checkString(charSequence, n3);
        this.nextReceiver.attribute(n, n2, charSequence, n3, n4);
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        this.checkString(charSequence, n);
        this.nextReceiver.characters(charSequence, n, n2);
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        this.checkString(charSequence, n);
        this.nextReceiver.comment(charSequence, n, n2);
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (!this.checker.isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Invalid XML 1.0 processing instruction name " + Err.wrap(string));
            dynamicError.setErrorCode("SERE0005");
            dynamicError.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n));
            throw dynamicError;
        }
        this.checkString(charSequence, n);
        this.nextReceiver.processingInstruction(string, charSequence, n, n2);
    }

    private void checkString(CharSequence charSequence, int n) throws XPathException {
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = charSequence.charAt(i);
            if (XMLChar.isHighSurrogate(n3)) {
                char c = charSequence.charAt(i++);
                n3 = XMLChar.supplemental((char)n3, c);
            }
            if (XMLChar.isValid(n3)) continue;
            DynamicError dynamicError = new DynamicError("The result tree contains a character not allowed by XML 1.0 (hex " + Integer.toHexString(n3) + ')');
            dynamicError.setErrorCode("SERE0006");
            dynamicError.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n));
            throw dynamicError;
        }
    }
}

