/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rbarcode;

import com.java4less.rbarcode.RImageCreator;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class BarCode
extends Canvas {
    public static final int BAR39 = 0;
    public static final int BAR39EXT = 1;
    public static final int INTERLEAVED25 = 2;
    public static final int CODE11 = 3;
    public static final int CODABAR = 4;
    public static final int MSI = 5;
    public static final int UPCA = 6;
    public static final int IND25 = 7;
    public static final int MAT25 = 8;
    public static final int CODE93 = 9;
    public static final int EAN13 = 10;
    public static final int EAN8 = 11;
    public static final int UPCE = 12;
    public static final int CODE128 = 13;
    public static final int CODE93EXT = 14;
    public static final int POSTNET = 15;
    public static final int PDF417 = 16;
    public static final int DATAMATRIX = 17;
    public static final int EAN128 = 18;
    public static final int EAN128ETI = 19;
    public boolean textOnTop = false;
    public int barType = 0;
    public String code = "";
    public String codeSup = "";
    public boolean checkCharacter = false;
    public double postnetHeightTallBar = 0.25;
    public double postnetHeightShortBar = 0.125;
    public double leftMarginCM = 0.5;
    public double topMarginCM = 0.5;
    protected int leftMarginPixels = 0;
    protected int topMarginPixels = 0;
    private int leftGuardBar = 0;
    private int centerGuardBarStart = 0;
    private int centerGuardBarEnd = 0;
    private int rightGuardBar = 0;
    private int endOfCode = 0;
    private int startSuplement;
    private int endSuplement;
    private int suplementTopMargin;
    public String supplement = "";
    protected static final int d = 1;
    public boolean guardBars = true;
    public Color backColor = Color.white;
    public String codeText = "";
    protected int narrowBarPixels = 0;
    protected int widthBarPixels = 0;
    protected double narrowBarCM = 0.0;
    protected double widthBarCM = 0.0;
    public int resolution = 38;
    protected int barHeightPixels = 0;
    public double barHeightCM = 0.0;
    public Font textFont = new Font("Arial", 0, 11);
    public Color fontColor = Color.black;
    public Color barColor = Color.black;
    private int extraHeight = 0;
    public char UPCESytem = (char)49;
    public char CODABARStartChar = (char)65;
    public char CODABARStopChar = (char)66;
    public boolean UPCEANSupplement2 = false;
    public boolean UPCEANSupplement5 = false;
    public char Code128Set = (char)66;
    public double X = 0.03;
    public double N = 2.0;
    public double I = 1.0;
    public double H = 0.45;
    public double L = 0.0;
    public int rotate = 0;
    public double supSeparationCM = 0.5;
    public double supHeight = 0.8;
    protected int currentX = 0;
    protected int currentY = 0;
    protected String[][] set39 = new String[][]{{"0", "nnnwwnwnn"}, {"1", "wnnwnnnnw"}, {"2", "nnwwnnnnw"}, {"3", "wnwwnnnnn"}, {"4", "nnnwwnnnw"}, {"5", "wnnwwnnnn"}, {"6", "nnwwwnnnn"}, {"7", "nnnwnnwnw"}, {"8", "wnnwnnwnn"}, {"9", "nnwwnnwnn"}, {"A", "wnnnnwnnw"}, {"B", "nnwnnwnnw"}, {"C", "wnwnnwnnn"}, {"D", "nnnnwwnnw"}, {"E", "wnnnwwnnn"}, {"F", "nnwnwwnnn"}, {"G", "nnnnnwwnw"}, {"H", "wnnnnwwnn"}, {"I", "nnwnnwwnn"}, {"J", "nnnnwwwnn"}, {"K", "wnnnnnnww"}, {"L", "nnwnnnnww"}, {"M", "wnwnnnnwn"}, {"N", "nnnnwnnww"}, {"O", "wnnnwnnwn"}, {"P", "nnwnwnnwn"}, {"Q", "nnnnnnwww"}, {"R", "wnnnnnwwn"}, {"S", "nnwnnnwwn"}, {"T", "nnnnwnwwn"}, {"U", "wwnnnnnnw"}, {"V", "nwwnnnnnw"}, {"W", "wwwnnnnnn"}, {"X", "nwnnwnnnw"}, {"Y", "wwnnwnnnn"}, {"Z", "nwwnwnnnn"}, {"-", "nwnnnnwnw"}, {".", "wwnnnnwnn"}, {" ", "nwwnnnwnn"}, {"$", "nwnwnwnnn"}, {"/", "nwnwnnnwn"}, {"+", "nwnnnwnwn"}, {"%", "nnnwnwnwn"}, {"*", "nwnnwnwnn"}};
    protected String[][] set25 = new String[][]{{"0", "nnwwn"}, {"1", "wnnnw"}, {"2", "nwnnw"}, {"3", "wwnnn"}, {"4", "nnwnw"}, {"5", "wnwnn"}, {"6", "nwwnn"}, {"7", "nnnww"}, {"8", "wnnwn"}, {"9", "nwnwn"}};
    protected String[][] setMSI = new String[][]{{"0", "nwnwnwnw"}, {"1", "nwnwnwwn"}, {"2", "nwnwwnnw"}, {"3", "nwnwwnwn"}, {"4", "nwwnnwnw"}, {"5", "nwwnnwwn"}, {"6", "nwwnwnnw"}, {"7", "nwwnwnwn"}, {"8", "wnnwnwnw"}, {"9", "wnnwnwwn"}};
    protected String[][] set11 = new String[][]{{"0", "nnnnw"}, {"1", "wnnnw"}, {"2", "nwnnw"}, {"3", "wwnnn"}, {"4", "nnwnw"}, {"5", "wnwnn"}, {"6", "nwwnn"}, {"7", "nnnww"}, {"8", "wnnwn"}, {"9", "wnnnn"}, {"-", "nnwnn"}};
    protected String[][] setCODABAR = new String[][]{{"0", "nnnnnww"}, {"1", "nnnnwwn"}, {"2", "nnnwnnw"}, {"3", "wwnnnnn"}, {"4", "nnwnnwn"}, {"5", "wnnnnwn"}, {"6", "nwnnnnw"}, {"7", "nwnnwnn"}, {"8", "nwwnnnn"}, {"9", "wnnwnnn"}, {"-", "nnnwwnn"}, {"$", "nnwwnnn"}, {":", "wnnnwnw"}, {"/", "wnwnnnw"}, {".", "wnwnwnn"}, {"+", "nnwnwnw"}, {"A", "nnwwnwn"}, {"B", "nwnwnnw"}, {"C", "nnnwnww"}, {"D", "nnnwwwn"}};
    protected String[][] set93 = new String[][]{{"0", "131112"}, {"1", "111213"}, {"2", "111312"}, {"3", "111411"}, {"4", "121113"}, {"5", "121212"}, {"6", "121311"}, {"7", "111114"}, {"8", "131211"}, {"9", "141111"}, {"A", "211113"}, {"B", "211212"}, {"C", "211311"}, {"D", "221112"}, {"E", "221211"}, {"F", "231111"}, {"G", "112113"}, {"H", "112212"}, {"I", "112311"}, {"J", "122112"}, {"K", "132111"}, {"L", "111123"}, {"M", "111222"}, {"N", "111321"}, {"O", "121122"}, {"P", "131121"}, {"Q", "212112"}, {"R", "212211"}, {"S", "211122"}, {"T", "211221"}, {"U", "221121"}, {"V", "222111"}, {"W", "112122"}, {"X", "112221"}, {"Y", "112121"}, {"Z", "123111"}, {"-", "121131"}, {".", "311112"}, {" ", "311211"}, {"$", "321111"}, {"/", "112131"}, {"+", "113121"}, {"%", "211131"}, {"_1", "121211"}, {"_2", "312111"}, {"_3", "311121"}, {"_4", "122211"}};
    protected String[][] setUPCALeft = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCARight = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCEOdd = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCEEven = new String[][]{{"0", "1123"}, {"1", "1222"}, {"2", "2212"}, {"3", "1141"}, {"4", "2311"}, {"5", "1321"}, {"6", "4111"}, {"7", "2131"}, {"8", "3121"}, {"9", "2113"}};
    protected String[] set39Ext = new String[]{"%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"};
    protected String[] set93Ext = new String[]{"_2U", "_1A", "_1B", "_1C", "_1D", "_1E", "_1F", "_1G", "_1H", "_1I", "_1J", "_1K", "_1L", "_1M", "_1N", "_1O", "_1P", "_1Q", "_1R", "_1S", "_1T", "_1U", "_1V", "_1W", "_1X", "_1Y", "_1Z", "_2A", "_2B", "_2C", "_2D", "_2E", " ", "_3A", "_3B", "_3C", "_3D", "_3E", "_3F", "_3G", "_3H", "_3I", "_3J", "_3K", "_3L", "-", ".", "_3O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "_3Z", "_2F", "_2G", "_2H", "_2I", "_2J", "_2V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "_2K", "_2L", "_2M", "_2N", "_2O", "_2W", "_4A", "_4B", "_4C", "_4D", "_4E", "_4F", "_4G", "_4H", "_4I", "_4J", "_4K", "_4L", "_4M", "_4N", "_4O", "_4P", "_4Q", "_4R", "_4S", "_4T", "_4U", "_4V", "_4W", "_4X", "_4Y", "_4Z", "_2P", "_2Q", "_2R", "_2S", "_2T"};
    protected String[] UPCESystem0 = new String[]{"EEEOOO", "EEOEOO", "EEOOEO", "EEOOOE", "EOEEOO", "EOOEEO", "EOOOEE", "EOEOEO", "EOEOOE", "EOOEOE"};
    protected String[] UPCESystem1 = new String[]{"OOOEEE", "OOEOEE", "OOEEOE", "OOEEEO", "OEOOEE", "OEEOOE", "OEEEOO", "OEOEOE", "OEOEEO", "OEEOEO"};
    protected String[][] setEANLeftA = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setEANLeftB = new String[][]{{"0", "1123"}, {"1", "1222"}, {"2", "2212"}, {"3", "1141"}, {"4", "2311"}, {"5", "1321"}, {"6", "4111"}, {"7", "2131"}, {"8", "3121"}, {"9", "2113"}};
    protected String[][] setEANRight = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[] setEANCode = new String[]{"AAAAA", "ABABB", "ABBAB", "ABBBA", "BAABB", "BBAAB", "BBBAA", "BABAB", "BABBA", "BBABA"};
    protected String[] fiveSuplement = new String[]{"EEOOO", "EOEOO", "EOOEO", "EOOOE", "OEEOO", "OOEEO", "OOOEE", "OEOEO", "OEOOE", "OOEOE"};
    protected String[] set128 = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131"};
    protected String[] set128A = new String[]{" ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u000e", "\u000f", "\u0010", "\u0011", "\u0012", "\u0013", "\u0014", "\u0015", "\u0016", "\u0017", "\u0018", "\u0019", "\u001a", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "_96", "_97", "_98", "_99", "_100", "_101", "_102"};
    protected String[] set128B = new String[]{" ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "_92", "}", "~", "_95", "_96", "_97", "_98", "_99", "_100", "_101", "_102"};
    protected String[] set128C = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "_100", "_101", "_102"};
    protected String[][] setPOSTNET = new String[][]{{"0", "11000"}, {"1", "00011"}, {"2", "00101"}, {"3", "00110"}, {"4", "01001"}, {"5", "01010"}, {"6", "01100"}, {"7", "10001"}, {"8", "10010"}, {"9", "10100"}};
    public boolean processTilde = false;

    protected void addBar(Graphics graphics, int n, boolean bl, int n2) {
        if (bl) {
            graphics.setColor(this.barColor);
            graphics.fillRect(this.currentX, this.topMarginPixels + n2, n, this.barHeightPixels + this.extraHeight - n2);
        }
        this.currentX += n;
    }

    protected void paintPostNetChar(Graphics graphics, String string) {
        int n = (int)(this.postnetHeightShortBar * (double)this.resolution);
        int n2 = (int)(this.postnetHeightTallBar * (double)this.resolution);
        int n3 = n2 - n;
        graphics.setColor(this.barColor);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '0') {
                graphics.fillRect(this.currentX, this.topMarginPixels + n3, this.narrowBarPixels, n + this.extraHeight);
            }
            if (c == '1') {
                graphics.fillRect(this.currentX, this.topMarginPixels, this.narrowBarPixels, n2 + this.extraHeight);
            }
            this.currentX += this.narrowBarPixels;
            this.currentX += this.widthBarPixels;
        }
    }

    protected void paintPOSTNET(Graphics graphics) {
        String string;
        int n;
        int n2 = 0;
        int n3 = 0;
        String string2 = this.code;
        this.paintPostNetChar(graphics, "1");
        for (n = this.code.length() - 1; n >= 0; --n) {
            string = "" + this.code.charAt(n);
            n3 += this.findChar(this.setPOSTNET, string);
        }
        n = (int)BarCode.mod(n3, 10.0);
        if (n != 0) {
            n = 10 - n;
        }
        if (this.checkCharacter) {
            string2 = string2 + new Integer(n).toString();
        }
        for (int i = 0; i < string2.length(); ++i) {
            string = "" + string2.charAt(i);
            n2 = this.findChar(this.setPOSTNET, string);
            this.paintPostNetChar(graphics, this.setPOSTNET[n2][1]);
        }
        this.paintPostNetChar(graphics, "1");
    }

    protected int findChar(String[][] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.compareTo(stringArray[i][0]) != 0) continue;
            return i;
        }
        return -1;
    }

    protected void paintInterleaved25(Graphics graphics) {
        String string;
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        String string2 = this.code;
        this.paintChar(graphics, "bwbw", "nnnn");
        String string3 = "";
        if (BarCode.mod(this.code.length(), 2.0) == 0.0 && this.checkCharacter) {
            string2 = "0" + this.code;
        }
        if (BarCode.mod(this.code.length(), 2.0) == 1.0 && !this.checkCharacter) {
            string2 = "0" + this.code;
        }
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = true;
        for (n = string2.length() - 1; n >= 0; --n) {
            string = "" + string2.charAt(n);
            if (bl2) {
                n4 += this.findChar(this.set25, string);
            } else {
                n5 += this.findChar(this.set25, string);
            }
            bl2 = !bl2;
        }
        n = n4 * 3 + n5;
        if ((n = (int)BarCode.mod(n, 10.0)) != 0) {
            n = 10 - n;
        }
        if (this.checkCharacter) {
            string2 = string2 + new Integer(n).toString();
        }
        for (int i = 0; i < string2.length(); i += 2) {
            string = "" + string2.charAt(i);
            String string4 = "" + string2.charAt(i + 1);
            n2 = this.findChar(this.set25, string);
            n3 = this.findChar(this.set25, string4);
            for (int j = 0; j < 5; ++j) {
                this.paintChar(graphics, "b", "" + this.set25[n2][1].charAt(j));
                this.paintChar(graphics, "w", "" + this.set25[n3][1].charAt(j));
            }
        }
        this.paintChar(graphics, "bwb", "wnn");
        this.codeText = string2;
    }

    protected void paintIND25(Graphics graphics) {
        String string;
        int n;
        int n2 = 0;
        boolean bl = false;
        String string2 = this.code;
        this.paintChar(graphics, "bwbwbw", "wwwwnw");
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = true;
        for (n = string2.length() - 1; n >= 0; --n) {
            string = "" + string2.charAt(n);
            if (bl2) {
                n3 += this.findChar(this.set25, string);
            } else {
                n4 += this.findChar(this.set25, string);
            }
            bl2 = !bl2;
        }
        n = n3 * 3 + n4;
        if ((n = (int)BarCode.mod(n, 10.0)) != 0) {
            n = 10 - n;
        }
        if (this.checkCharacter) {
            string2 = string2 + new Integer(n).toString();
        }
        for (int i = 0; i < string2.length(); ++i) {
            string = "" + string2.charAt(i);
            n2 = this.findChar(this.set25, string);
            if (n2 < 0) continue;
            for (int j = 0; j < this.set25[n2][1].length(); ++j) {
                this.paintChar(graphics, "b", "" + this.set25[n2][1].charAt(j));
                this.paintChar(graphics, "w", "w");
            }
        }
        this.paintChar(graphics, "bwbwb", "wwnww");
    }

    protected String UPCEANCheck(String string) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (bl) {
                n += new Integer("" + string.charAt(i)).intValue();
            } else {
                n2 += new Integer("" + string.charAt(i)).intValue();
            }
            bl = !bl;
        }
        int n3 = (int)BarCode.mod(n2 = n * 3 + n2, 10.0);
        if (n3 != 0) {
            n3 = 10 - n3;
        }
        return "" + n3;
    }

    protected void paintUPCA(Graphics graphics) {
        int n = 0;
        boolean bl = false;
        if (this.code.length() == 11 && this.checkCharacter) {
            this.code = this.code + this.UPCEANCheck(this.code);
        }
        this.paintGuardChar(graphics, "bwb", "nnn", 0);
        this.leftGuardBar = this.currentX;
        for (int i = 0; i < this.code.length(); ++i) {
            String string = "" + this.code.charAt(i);
            n = -1;
            if (i <= 5) {
                n = this.findChar(this.setUPCALeft, string);
                this.paintChar(graphics, "wbwb", this.setUPCALeft[n][1]);
            } else {
                n = this.findChar(this.setUPCARight, string);
                this.paintChar(graphics, "bwbw", this.setUPCARight[n][1]);
            }
            if (i != 5) continue;
            this.centerGuardBarStart = this.currentX;
            this.paintGuardChar(graphics, "wbwbw", "nnnnn", 0);
            this.centerGuardBarEnd = this.currentX;
        }
        this.rightGuardBar = this.currentX;
        this.paintGuardChar(graphics, "bwb", "nnn", 0);
        this.endOfCode = this.currentX;
        if (this.UPCEANSupplement2) {
            this.paintSup2(graphics, this.code.substring(1, 3));
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(graphics, this.code.substring(1, 6));
        }
    }

    protected void paintEAN13(Graphics graphics) {
        int n = 0;
        boolean bl = false;
        if (this.code.length() == 12 && this.checkCharacter) {
            this.codeText = this.code = this.code + this.UPCEANCheck(this.code);
        }
        if (this.code.length() < 13) {
            return;
        }
        this.paintGuardChar(graphics, "bwb", "nnn", 0);
        this.leftGuardBar = this.currentX;
        String string = this.setEANCode[new Integer("" + this.code.charAt(0))];
        n = this.findChar(this.setEANLeftA, "" + this.code.charAt(1));
        this.paintChar(graphics, "wbwb", this.setEANLeftA[n][1]);
        for (int i = 2; i < 12; ++i) {
            String string2 = "" + this.code.charAt(i);
            n = -1;
            if (i <= 6) {
                String[][] stringArray = this.setEANLeftA;
                if (string.charAt(i - 2) == 'B') {
                    stringArray = this.setEANLeftB;
                }
                n = this.findChar(stringArray, string2);
                this.paintChar(graphics, "wbwb", stringArray[n][1]);
            } else {
                n = this.findChar(this.setEANRight, string2);
                this.paintChar(graphics, "bwbw", this.setEANRight[n][1]);
            }
            if (i != 6) continue;
            this.centerGuardBarStart = this.currentX;
            this.paintGuardChar(graphics, "wbwbw", "nnnnn", 0);
            this.centerGuardBarEnd = this.currentX;
        }
        n = this.findChar(this.setEANRight, "" + this.code.charAt(12));
        this.paintChar(graphics, "bwbw", this.setEANRight[n][1]);
        this.rightGuardBar = this.currentX;
        this.paintGuardChar(graphics, "bwb", "nnn", 0);
        this.endOfCode = this.currentX;
        if (this.UPCEANSupplement2) {
            this.paintSup2(graphics, this.code.substring(2, 4));
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(graphics, this.code.substring(2, 7));
        }
    }

    private int findInArray(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo(string) != 0) continue;
            return i;
        }
        return -1;
    }

    private String convertCode128ControlChar(String string) {
        String string2 = "\u00ca";
        String string3 = "\u00c5";
        String string4 = "\u00c4";
        String string5 = "\u00c9";
        String string6 = "\u00c8";
        if (string.compareTo(string2) == 0) {
            string = "_102";
        }
        if (string.compareTo(string5) == 0) {
            string = "_101";
        }
        if (string.compareTo(string6) == 0) {
            string = "_100";
        }
        if (string.compareTo(string3) == 0) {
            string = "_97";
        }
        if (string.compareTo(string4) == 0) {
            string = "_96";
        }
        return string;
    }

    private boolean isDigit(String string) {
        if (string.length() > 1) {
            return false;
        }
        return string.charAt(0) >= '0' && string.charAt(0) <= '9';
    }

    private int getNextLowerCase(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) < 'a' || string.charAt(i) > 'z') continue;
            return i;
        }
        return 9999;
    }

    private int getNextControlChar(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) >= ' ') continue;
            return i;
        }
        return 9999;
    }

    private boolean getEvenNumberDigits(String string, int n) {
        boolean bl = true;
        for (int i = n; i < string.length(); ++i) {
            if (!this.isDigit("" + string.charAt(i))) {
                return bl;
            }
            bl = !bl;
        }
        return bl;
    }

    private char calculateNextSet(String string, int n) {
        if (string.length() >= n + 4 && this.isDigit("" + string.charAt(n)) && this.isDigit("" + string.charAt(n + 1)) && this.isDigit("" + string.charAt(n + 2)) && this.isDigit("" + string.charAt(n + 3))) {
            return 'C';
        }
        if (this.getNextControlChar(string, n) < this.getNextLowerCase(string, n)) {
            return 'A';
        }
        return 'B';
    }

    protected void paintCode128(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        String[] stringArray = this.set128A;
        if (this.Code128Set == 'B') {
            stringArray = this.set128B;
        }
        int n3 = 103;
        if (this.Code128Set == 'B') {
            stringArray = this.set128B;
            n3 = 104;
        }
        if (this.Code128Set == 'C') {
            stringArray = this.set128C;
            n3 = 105;
        }
        if (this.Code128Set == 'B') {
            this.paintChar(graphics, "bwbwbw", "211214");
        }
        if (this.Code128Set == 'C') {
            this.paintChar(graphics, "bwbwbw", "211232");
        }
        if (this.Code128Set != 'B' && this.Code128Set != 'C') {
            this.paintChar(graphics, "bwbwbw", "211412");
        }
        int n4 = 1;
        for (int i = 0; i < this.code.length(); ++i) {
            String string = "" + this.code.charAt(i);
            if (this.Code128Set == 'C') {
                String string2 = "" + string;
                if (++i < this.code.length()) {
                    string2 = string2 + this.code.charAt(i);
                } else {
                    n = this.findInArray(this.set128C, "_100");
                    n3 += n * n4;
                    ++n4;
                    this.paintChar(graphics, "bwbwbw", this.set128[n]);
                    string2 = "" + (new Integer("" + string2) + 16);
                }
                n = this.findInArray(this.set128C, string2);
                if (n >= 0) {
                    this.paintChar(graphics, "bwbwbw", this.set128[n]);
                    n3 += n * n4;
                }
            } else {
                n = this.findInArray(stringArray, string);
                if (n >= 0) {
                    this.paintChar(graphics, "bwbwbw", this.set128[n]);
                    n3 += n * n4;
                }
            }
            ++n4;
        }
        if (this.checkCharacter) {
            n2 = (int)BarCode.mod(n3, 103.0);
            this.paintChar(graphics, "bwbwbw", this.set128[n2]);
        }
        this.paintChar(graphics, "bwbwbwb", "2331112");
    }

    protected void paintEAN128(Graphics graphics) {
        int n = 102;
        int n2 = 103;
        int n3 = 104;
        int n4 = 105;
        int n5 = 98;
        int n6 = 100;
        int n7 = 99;
        char[] cArray = new char[3];
        int[] nArray = new int[100];
        char[] cArray2 = new char[200];
        boolean bl = true;
        boolean bl2 = false;
        nArray[0] = n4;
        nArray[1] = n;
        int n8 = 2;
        String string = this.code;
        String string2 = "";
        int n9 = 0;
        while (!bl2 && string.charAt(n9) != '\u0000') {
            cArray[0] = string.charAt(n9);
            cArray[1] = n9 + 1 < string.length() ? string.charAt(n9 + 1) : (char)'\u0000';
            cArray[2] = '\u0000';
            if (this.isDigit("" + cArray[0]) && this.isDigit("" + cArray[1])) {
                if (!bl) {
                    bl = true;
                    nArray[n8] = n7;
                    ++n8;
                }
                nArray[n8] = Integer.parseInt("" + cArray[0] + cArray[1]);
                ++n8;
            } else {
                if (bl) {
                    bl = false;
                    nArray[n8] = n6;
                    ++n8;
                }
                for (int i = 0; i < 2; ++i) {
                    cArray[0] = n9 + i < string.length() ? string.charAt(n9 + i) : (char)'\u0000';
                    cArray[1] = '\u0000';
                    if (cArray[0] != '\u0000') {
                        if (this.isDigit("" + cArray[0])) {
                            nArray[n8] = cArray[0] - 48 + 16;
                            ++n8;
                            continue;
                        }
                        switch (cArray[0]) {
                            case '!': {
                                nArray[n8] = 1;
                                break;
                            }
                            case '\"': {
                                nArray[n8] = 2;
                                break;
                            }
                            case '#': 
                            case '\u00d1': {
                                nArray[n8] = 3;
                                break;
                            }
                            case '$': {
                                nArray[n8] = 4;
                                break;
                            }
                            case '%': {
                                nArray[n8] = 5;
                                break;
                            }
                            case '&': {
                                nArray[n8] = 6;
                                break;
                            }
                            case '\'': {
                                nArray[n8] = 7;
                                break;
                            }
                            case '(': {
                                nArray[n8] = 8;
                                break;
                            }
                            case ')': {
                                nArray[n8] = 9;
                                break;
                            }
                            case '*': {
                                nArray[n8] = 10;
                                break;
                            }
                            case '+': {
                                nArray[n8] = 11;
                                break;
                            }
                            case ',': {
                                nArray[n8] = 12;
                                break;
                            }
                            case '-': {
                                nArray[n8] = 13;
                                break;
                            }
                            case '.': {
                                nArray[n8] = 14;
                                break;
                            }
                            case '/': {
                                nArray[n8] = 15;
                                break;
                            }
                            case '[': {
                                nArray[n8] = 59;
                                break;
                            }
                            case '\\': {
                                nArray[n8] = 60;
                                break;
                            }
                            case ']': {
                                nArray[n8] = 61;
                                break;
                            }
                            case '~': 
                            case '\u00f1': {
                                nArray[n8] = 62;
                                break;
                            }
                            default: {
                                nArray[n8] = cArray[0] - 65 + 33;
                            }
                        }
                        ++n8;
                        continue;
                    }
                    bl2 = true;
                    break;
                }
            }
            n9 += 2;
        }
        int n10 = n8 - 1;
        int n11 = 0;
        for (n9 = 0; n9 <= n10; ++n9) {
            if (nArray[n9] == n || nArray[n9] == n2 || nArray[n9] == n3 || nArray[n9] == n4) {
                n11 += nArray[n9];
                continue;
            }
            n11 += nArray[n9] * n9;
        }
        nArray[n10 + 1] = (int)BarCode.mod(n11, 103.0);
        nArray[n10 + 2] = 0;
        for (n9 = 0; n9 <= n10 + 1; ++n9) {
            if (nArray[n9] <= 103) {
                this.paintChar(graphics, "bwbwbw", this.set128[nArray[n9]]);
                continue;
            }
            if (nArray[n9] != 105) continue;
            this.paintChar(graphics, "bwbwbw", "211232");
        }
        this.paintChar(graphics, "bwbwbwb", "2331112");
    }

    protected void paintEAN128Old(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        if (this.barType == 18) {
            this.Code128Set = (char)67;
        }
        String[] stringArray = this.set128A;
        if (this.Code128Set == 'B') {
            stringArray = this.set128B;
        }
        int n3 = 103;
        if (this.Code128Set == 'B') {
            stringArray = this.set128B;
            n3 = 104;
        }
        if (this.Code128Set == 'C') {
            stringArray = this.set128C;
            n3 = 105;
        }
        int n4 = this.Code128Set;
        if (this.Code128Set == 'B') {
            this.paintChar(graphics, "bwbwbw", "211214");
        }
        if (this.Code128Set == 'C') {
            this.paintChar(graphics, "bwbwbw", "211232");
        }
        if (this.Code128Set != 'B' && this.Code128Set != 'C') {
            this.paintChar(graphics, "bwbwbw", "211412");
        }
        int n5 = 1;
        for (int i = 0; i < this.code.length(); ++i) {
            int n6;
            stringArray = this.set128A;
            if (n4 == 66) {
                stringArray = this.set128B;
            }
            if (n4 == 67) {
                stringArray = this.set128C;
            }
            String string = "" + this.code.charAt(i);
            string = this.convertCode128ControlChar(string);
            if (this.barType == 18 && i == 0) {
                n = this.findInArray(this.set128C, "_102");
                this.paintChar(graphics, "bwbwbw", this.set128[n]);
                n3 += n * n5;
                ++n5;
            }
            if (n4 == 67) {
                n6 = 0;
                if (i < this.code.length() - 1) {
                    if (this.isDigit("" + string) && this.isDigit("" + this.code.charAt(i + 1))) {
                        n = this.findInArray(this.set128C, string = string + this.code.charAt(i + 1));
                        if (n >= 0) {
                            this.paintChar(graphics, "bwbwbw", this.set128[n]);
                            n3 += n * n5;
                        }
                        n6 = 1;
                        ++i;
                    } else if (this.isDigit("" + string) && !this.isDigit("" + this.code.charAt(i + 1))) {
                        n4 = this.calculateNextSet(this.code, i + 1);
                        --i;
                        n = this.findInArray(this.set128B, "_100");
                        if (n >= 0) {
                            this.paintChar(graphics, "bwbwbw", this.set128[n]);
                            n3 += n * n5;
                        }
                        ++n5;
                        continue;
                    }
                }
                if (n6 == 0 && !this.isDigit(string)) {
                    if (this.Code128Set == 'C') {
                        n4 = this.calculateNextSet(this.code, i);
                        n = this.findInArray(this.set128B, "_100");
                        if (n >= 0) {
                            this.paintChar(graphics, "bwbwbw", this.set128[n]);
                            n3 += n * n5;
                        }
                        ++n5;
                    }
                    if ((n = this.findInArray(this.set128B, string)) < 0) continue;
                    this.paintChar(graphics, "bwbwbw", this.set128[n]);
                    n3 += n * n5;
                    n6 = 1;
                    continue;
                }
                if (n6 == 0 && this.isDigit(string)) {
                    n4 = 66;
                    if (i < this.code.length() - 1 && this.getNextControlChar(this.code, i + 1) < this.getNextLowerCase(this.code, i + 1)) {
                        n4 = 65;
                    }
                    n = this.findInArray(this.set128C, "_100");
                    if (n4 == 65) {
                        n = this.findInArray(this.set128C, "_101");
                    }
                    n3 += n * n5;
                    ++n5;
                    this.paintChar(graphics, "bwbwbw", this.set128[n]);
                    string = "" + (new Integer("" + string) + 16);
                    n = this.findInArray(this.set128B, string);
                    if (n >= 0) {
                        this.paintChar(graphics, "bwbwbw", this.set128[n]);
                        n3 += n * n5;
                    }
                    n6 = 1;
                }
                if (n6 == 0 && !this.isDigit(string)) {
                    n4 = this.calculateNextSet(this.code, i);
                    --i;
                    n = this.findInArray(this.set128B, "_100");
                    if (n >= 0) {
                        this.paintChar(graphics, "bwbwbw", this.set128[n]);
                        n3 += n * n5;
                    }
                }
            } else if (this.calculateNextSet(this.code, i) == 'C') {
                n4 = 67;
                --i;
            } else {
                n = this.findInArray(stringArray, string);
                if (n4 == 65 && n == -1 && this.findInArray(this.set128B, string) >= 0) {
                    n6 = 0;
                    if (this.getNextControlChar(this.code, i) < this.getNextLowerCase(this.code, i)) {
                        n6 = this.findInArray(stringArray, "_98");
                    } else {
                        n6 = this.findInArray(stringArray, "_100");
                        n4 = 66;
                    }
                    this.paintChar(graphics, "bwbwbw", this.set128[n6]);
                    n3 += n6 * n5;
                    stringArray = this.set128B;
                }
                if (n4 == 66 && n == -1 && this.findInArray(this.set128A, string) >= 0) {
                    n6 = 0;
                    if (this.getNextControlChar(this.code, i) > this.getNextLowerCase(this.code, i)) {
                        n6 = this.findInArray(stringArray, "_98");
                    } else {
                        n6 = this.findInArray(stringArray, "_101");
                        n4 = 65;
                    }
                    this.paintChar(graphics, "bwbwbw", this.set128[n6]);
                    n3 += n6 * n5;
                    stringArray = this.set128A;
                }
                if ((n = this.findInArray(stringArray, string)) >= 0) {
                    this.paintChar(graphics, "bwbwbw", this.set128[n]);
                    n3 += n * n5;
                }
            }
            ++n5;
        }
        if (this.checkCharacter) {
            n2 = (int)BarCode.mod(n3, 103.0);
            this.paintChar(graphics, "bwbwbw", this.set128[n2]);
        }
        this.paintChar(graphics, "bwbwbwb", "2331112");
    }

    protected void paintEAN8(Graphics graphics) {
        int n = 0;
        boolean bl = false;
        if (this.code.length() == 7 && this.checkCharacter) {
            this.code = this.code + this.UPCEANCheck(this.code);
        }
        if (this.code.length() < 8) {
            return;
        }
        this.paintGuardChar(graphics, "bwb", "nnn", 0);
        this.leftGuardBar = this.currentX;
        for (int i = 0; i < 8; ++i) {
            String string = "" + this.code.charAt(i);
            n = -1;
            if (i <= 3) {
                n = this.findChar(this.setEANLeftA, string);
                this.paintChar(graphics, "wbwb", this.setEANLeftA[n][1]);
            } else {
                n = this.findChar(this.setEANRight, string);
                this.paintChar(graphics, "bwbw", this.setEANRight[n][1]);
            }
            if (i != 3) continue;
            this.centerGuardBarStart = this.currentX;
            this.paintGuardChar(graphics, "wbwbw", "nnnnn", 0);
            this.centerGuardBarEnd = this.currentX;
        }
        this.rightGuardBar = this.currentX;
        this.paintGuardChar(graphics, "bwb", "nnn", 0);
        this.endOfCode = this.currentX;
        if (this.UPCEANSupplement2) {
            this.paintSup2(graphics, this.code.substring(2, 4));
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(graphics, this.code.substring(2, 7));
        }
    }

    protected void paintUPCE(Graphics graphics) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        String string = "";
        if (this.code.length() == 11 && this.checkCharacter) {
            this.code = this.code + this.UPCEANCheck(this.code);
        }
        if (this.code.length() < 12) {
            return;
        }
        n2 = new Integer("" + this.code.charAt(11));
        if (this.code.substring(3, 6).compareTo("000") == 0 || this.code.substring(3, 6).compareTo("100") == 0 || this.code.substring(3, 6).compareTo("200") == 0) {
            string = this.code.substring(1, 3) + this.code.substring(8, 11) + this.code.charAt(3);
        }
        if (this.code.substring(3, 6).compareTo("300") == 0 || this.code.substring(3, 6).compareTo("400") == 0 || this.code.substring(3, 6).compareTo("500") == 0 || this.code.substring(3, 6).compareTo("600") == 0 || this.code.substring(3, 6).compareTo("700") == 0 || this.code.substring(3, 6).compareTo("800") == 0 || this.code.substring(3, 6).compareTo("900") == 0) {
            string = this.code.substring(1, 4) + this.code.substring(9, 11) + "3";
        }
        if (this.code.substring(4, 6).compareTo("10") == 0 || this.code.substring(4, 6).compareTo("20") == 0 || this.code.substring(4, 6).compareTo("30") == 0 || this.code.substring(4, 6).compareTo("40") == 0 || this.code.substring(4, 6).compareTo("50") == 0 || this.code.substring(4, 6).compareTo("60") == 0 || this.code.substring(4, 6).compareTo("70") == 0 || this.code.substring(4, 6).compareTo("80") == 0 || this.code.substring(4, 6).compareTo("90") == 0) {
            string = this.code.substring(1, 5) + this.code.substring(10, 11) + "4";
        }
        if (this.code.substring(5, 6).compareTo("0") != 0) {
            string = this.code.substring(1, 6) + this.code.substring(10, 11);
        }
        this.codeText = string;
        this.paintGuardChar(graphics, "bwb", "nnn", 0);
        this.leftGuardBar = this.currentX;
        String string2 = this.UPCESystem0[n2];
        if (this.UPCESytem == '1') {
            string2 = this.UPCESystem1[n2];
        }
        for (int i = 0; i < string.length(); ++i) {
            String string3 = "" + string.charAt(i);
            n = -1;
            String[][] stringArray = this.setUPCEOdd;
            if (string2.charAt(i) == 'E') {
                stringArray = this.setUPCEEven;
            }
            n = this.findChar(stringArray, string3);
            this.paintChar(graphics, "wbwb", stringArray[n][1]);
        }
        this.rightGuardBar = this.currentX;
        this.paintGuardChar(graphics, "wbwbwb", "nnnnnn", 0);
        this.endOfCode = this.currentX;
        if (this.UPCEANSupplement2) {
            this.paintSup2(graphics, string.substring(0, 2));
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(graphics, string.substring(0, 5));
        }
    }

    protected void paintSup2(Graphics graphics, String string) {
        int n;
        if (this.supplement.length() > 0) {
            string = this.supplement;
        }
        this.suplementTopMargin = (int)((double)this.barHeightPixels * (1.0 - this.supHeight));
        if (this.codeSup.length() == 0) {
            this.codeSup = string;
        }
        if (string.length() != 2) {
            return;
        }
        this.startSuplement = this.currentX = (int)((double)this.currentX + (double)this.resolution * this.supSeparationCM);
        try {
            n = Integer.valueOf(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        String string2 = "OO";
        if (BarCode.mod(n, 4.0) == 1.0) {
            string2 = "OE";
        }
        if (BarCode.mod(n, 4.0) == 2.0) {
            string2 = "EO";
        }
        if (BarCode.mod(n, 4.0) == 3.0) {
            string2 = "EE";
        }
        this.paintGuardChar(graphics, "bwb", "112", this.suplementTopMargin);
        String[][] stringArray = this.setUPCEOdd;
        if (string2.charAt(0) == 'E') {
            stringArray = this.setUPCEEven;
        }
        int n2 = this.findChar(stringArray, "" + string.charAt(0));
        this.paintGuardChar(graphics, "wbwb", stringArray[n2][1], this.suplementTopMargin);
        this.paintGuardChar(graphics, "wb", "11", this.suplementTopMargin);
        stringArray = this.setUPCEOdd;
        if (string2.charAt(1) == 'E') {
            stringArray = this.setUPCEEven;
        }
        n2 = this.findChar(stringArray, "" + string.charAt(1));
        this.paintGuardChar(graphics, "wbwb", stringArray[n2][1], this.suplementTopMargin);
        this.endSuplement = this.currentX;
    }

    protected void paintSup5(Graphics graphics, String string) {
        if (this.supplement.length() > 0) {
            string = this.supplement;
        }
        this.suplementTopMargin = (int)((double)this.barHeightPixels * (1.0 - this.supHeight));
        if (this.codeSup.length() == 0) {
            this.codeSup = string;
        }
        if (string.length() != 5) {
            return;
        }
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (bl) {
                n += new Integer("" + string.charAt(i)).intValue();
            } else {
                n2 += new Integer("" + string.charAt(i)).intValue();
            }
            bl = !bl;
        }
        n2 = n * 3 + n2 * 9;
        String string2 = "" + n2;
        int n3 = new Integer("" + string2.charAt(string2.length() - 1));
        String string3 = this.fiveSuplement[n3];
        this.startSuplement = this.currentX = (int)((double)this.currentX + (double)this.resolution * this.supSeparationCM);
        this.paintGuardChar(graphics, "bwb", "112", this.suplementTopMargin);
        String[][] stringArray = null;
        for (int i = 0; i < 5; ++i) {
            stringArray = this.setUPCEOdd;
            if (string3.charAt(i) == 'E') {
                stringArray = this.setUPCEEven;
            }
            int n4 = this.findChar(stringArray, "" + string.charAt(i));
            this.paintGuardChar(graphics, "wbwb", stringArray[n4][1], this.suplementTopMargin);
            if (i >= 4) continue;
            this.paintGuardChar(graphics, "wb", "11", this.suplementTopMargin);
        }
        this.endSuplement = this.currentX;
    }

    protected void paintMAT25(Graphics graphics) {
        int n = 0;
        boolean bl = false;
        String string = this.code;
        this.paintChar(graphics, "bwbwbw", "wnnnnn");
        for (int i = 0; i < string.length(); ++i) {
            String string2 = "" + this.code.charAt(i);
            n = this.findChar(this.set25, string2);
            if (n < 0) continue;
            this.paintChar(graphics, "bwbwbw", this.set25[n][1] + "n");
        }
        this.paintChar(graphics, "bwbwbw", "wnnnnn");
    }

    protected void paintBAR39(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        this.paintChar(graphics, "bwbwbwbwb", this.set39[this.findChar(this.set39, "*")][1]);
        int n3 = (int)(this.I * this.X * (double)this.resolution);
        if (n3 == 0) {
            n3 = 1;
        }
        this.currentX += n3;
        for (int i = 0; i < this.code.length(); ++i) {
            String string = "" + this.code.charAt(i);
            n = this.findChar(this.set39, string);
            if (n <= -1) continue;
            n2 += n;
            this.paintChar(graphics, "bwbwbwbwb", this.set39[n][1]);
            this.currentX += n3;
        }
        if (this.checkCharacter) {
            n = (int)BarCode.mod(n2, 43.0);
            this.paintChar(graphics, "bwbwbwbwb", this.set39[n][1]);
            this.currentX += n3;
            this.codeText = this.code + "" + this.set39[n][0];
        }
        this.paintChar(graphics, "bwbwbwbwb", this.set39[this.findChar(this.set39, "*")][1]);
    }

    protected void paintCODE11(Graphics graphics) {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.paintChar(graphics, "bwbwbw", "nnwwnn");
        int n4 = 1;
        n3 = 0;
        for (n = this.code.length() - 1; n >= 0; --n) {
            n3 += this.findChar(this.set11, "" + this.code.charAt(n)) * n4;
            if (++n4 != 11) continue;
            n4 = 1;
        }
        int n5 = (int)BarCode.mod(n3, 11.0);
        n4 = 2;
        n3 = n5;
        for (n = this.code.length() - 1; n >= 0; --n) {
            n3 += this.findChar(this.set11, "" + this.code.charAt(n)) * n4;
            if (++n4 != 10) continue;
            n4 = 1;
        }
        int n6 = (int)BarCode.mod(n3, 11.0);
        for (n = 0; n < this.code.length(); ++n) {
            String string = "" + this.code.charAt(n);
            n2 = this.findChar(this.set11, string);
            if (n2 <= -1) continue;
            this.paintChar(graphics, "bwbwbw", this.set11[n2][1] + "n");
        }
        if (this.checkCharacter) {
            this.paintChar(graphics, "bwbwb", this.set39[n5][1]);
            this.codeText = this.code + this.set39[n5][0];
            if (this.code.length() > 10) {
                this.paintChar(graphics, "bwbwb", this.set39[n6][1]);
                this.codeText = this.codeText + this.set39[n6][0];
            }
        }
        this.paintChar(graphics, "bwbwb", "nnwwn");
    }

    protected void paintCODABAR(Graphics graphics) {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.paintChar(graphics, "bwbwbwbw", this.setCODABAR[this.findChar(this.setCODABAR, "" + this.CODABARStartChar)][1] + "n");
        n3 = this.findChar(this.setCODABAR, "" + this.CODABARStartChar) + this.findChar(this.setCODABAR, "" + this.CODABARStopChar);
        for (n = this.code.length() - 1; n >= 0; --n) {
            n3 += this.findChar(this.setCODABAR, "" + this.code.charAt(n));
        }
        int n4 = (int)BarCode.mod(n3, 16.0);
        if (n4 != 0) {
            n4 = 16 - n4;
        }
        for (n = 0; n < this.code.length(); ++n) {
            String string = "" + this.code.charAt(n);
            n2 = this.findChar(this.setCODABAR, string);
            if (n2 <= -1) continue;
            this.paintChar(graphics, "bwbwbwbw", this.setCODABAR[n2][1] + "n");
        }
        if (this.checkCharacter) {
            this.codeText = this.code + this.setCODABAR[n4][0];
            this.paintChar(graphics, "bwbwbwbw", this.setCODABAR[n4][1] + "n");
        }
        this.paintChar(graphics, "bwbwbwb", this.setCODABAR[this.findChar(this.setCODABAR, "" + this.CODABARStopChar)][1]);
    }

    protected void paintMSI(Graphics graphics) {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.paintChar(graphics, "bw", "wn");
        n3 = 0;
        String string = "";
        boolean bl = true;
        for (n = this.code.length() - 1; n >= 0; --n) {
            if (!bl) {
                n3 += this.findChar(this.setMSI, "" + this.code.charAt(n));
            }
            if (bl) {
                string = this.findChar(this.setMSI, "" + this.code.charAt(n)) + string;
            }
            bl = !bl;
        }
        string = "" + new Long(string) * 2L;
        for (n = string.length() - 1; n >= 0; --n) {
            n3 += this.findChar(this.setMSI, "" + string.charAt(n));
        }
        int n4 = (int)BarCode.mod(n3, 10.0);
        if (n4 != 0) {
            n4 = 10 - n4;
        }
        for (n = 0; n < this.code.length(); ++n) {
            String string2 = "" + this.code.charAt(n);
            n2 = this.findChar(this.setMSI, string2);
            if (n2 <= -1) continue;
            this.paintChar(graphics, "bwbwbwbw", this.setMSI[n2][1]);
        }
        if (this.checkCharacter) {
            this.paintChar(graphics, "bwbwbwb", this.setMSI[n4][1]);
            this.codeText = this.code + this.setMSI[n4][0];
        }
        this.paintChar(graphics, "bwb", "nwn");
    }

    protected static double mod(double d, double d2) {
        double d3 = d / d2;
        double d4 = Math.round(d3);
        if (d4 > d3) {
            d4 -= 1.0;
        }
        return d - d2 * d4;
    }

    protected void paintBAR39Ext(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        this.paintChar(graphics, "bwbwbwbwb", this.set39[this.findChar(this.set39, "*")][1]);
        int n3 = (int)(this.I * this.X * (double)this.resolution);
        if (n3 == 0) {
            n3 = 1;
        }
        this.currentX += n3;
        for (int i = 0; i < this.code.length(); ++i) {
            byte by = (byte)this.code.charAt(i);
            if (by > 128) continue;
            String string = this.set39Ext[by];
            for (int j = 0; j < string.length(); ++j) {
                String string2 = "" + string.charAt(j);
                n = this.findChar(this.set39, string2);
                if (n <= -1) continue;
                n2 += n;
                this.paintChar(graphics, "bwbwbwbwb", this.set39[n][1]);
                this.currentX += n3;
            }
        }
        if (this.checkCharacter) {
            n = (int)BarCode.mod(n2, 43.0);
            this.paintChar(graphics, "bwbwbwbwb", this.set39[n][1]);
            this.currentX += n3;
            this.codeText = this.code + "" + this.set39[n][0];
        }
        this.paintChar(graphics, "bwbwbwbwb", this.set39[this.findChar(this.set39, "*")][1]);
    }

    protected void paintBAR93(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.paintChar(graphics, "bwbwbw", "111141");
        for (n2 = 0; n2 < this.code.length(); ++n2) {
            String string = "" + this.code.charAt(n2);
            n3 = this.findChar(this.set93, string);
            if (n3 <= -1) continue;
            n4 += n3;
            this.paintChar(graphics, "bwbwbw", this.set93[n3][1]);
        }
        n2 = 1;
        n4 = 0;
        for (n = this.code.length() - 1; n >= 0; --n) {
            n4 += this.findChar(this.set93, "" + this.code.charAt(n)) * n2;
            if (++n2 != 21) continue;
            n2 = 1;
        }
        n6 = (int)BarCode.mod(n4, 47.0);
        n2 = 2;
        n4 = n6;
        for (n = this.code.length() - 1; n >= 0; --n) {
            n4 += this.findChar(this.set93, "" + this.code.charAt(n)) * n2;
            if (++n2 != 16) continue;
            n2 = 1;
        }
        n5 = (int)BarCode.mod(n4, 47.0);
        if (this.checkCharacter) {
            this.paintChar(graphics, "bwbwbw", this.set93[n6][1]);
            this.paintChar(graphics, "bwbwbw", this.set93[n5][1]);
            this.codeText = this.code + this.set93[n6][0].charAt(0) + this.set93[n5][0].charAt(0);
        }
        this.paintChar(graphics, "bwbwbwb", "1111411");
    }

    protected void paintBAR93Ext(Graphics graphics) {
        int n;
        String string;
        String string2;
        byte by;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.paintChar(graphics, "bwbwbw", "111141");
        for (n2 = 0; n2 < this.code.length(); ++n2) {
            by = (byte)this.code.charAt(n2);
            if (by > 128) continue;
            string2 = this.set93Ext[by];
            if (string2.length() == 3) {
                string = "" + string2.charAt(0) + string2.charAt(1);
                n3 = this.findChar(this.set93, string);
                this.paintChar(graphics, "bwbwbw", this.set93[n3][1]);
                string = "" + string2.charAt(2);
            } else {
                string = "" + string2.charAt(0);
            }
            n3 = this.findChar(this.set93, string);
            n4 += n3;
            this.paintChar(graphics, "bwbwbw", this.set93[n3][1]);
        }
        n2 = 1;
        n4 = 0;
        for (n = this.code.length() - 1; n >= 0; --n) {
            by = (byte)this.code.charAt(n);
            if (by > 128) continue;
            string2 = this.set93Ext[by];
            if (string2.length() == 3) {
                string = "" + string2.charAt(0) + string2.charAt(1);
                n3 = this.findChar(this.set93, string);
                n4 += n3 * (n2 + 1);
                string = "" + string2.charAt(2);
                n3 = this.findChar(this.set93, string);
                n4 += n3 * n2;
                if (++n2 == 21) {
                    n2 = 1;
                }
                if (++n2 != 21) continue;
                n2 = 1;
                continue;
            }
            string = "" + string2.charAt(0);
            n3 = this.findChar(this.set93, string);
            n4 += n3 * n2;
            if (++n2 != 21) continue;
            n2 = 1;
        }
        n6 = (int)BarCode.mod(n4, 47.0);
        n2 = 2;
        n4 = n6;
        for (n = this.code.length() - 1; n >= 0; --n) {
            by = (byte)this.code.charAt(n);
            if (by > 128) continue;
            string2 = this.set93Ext[by];
            if (string2.length() == 3) {
                string = "" + string2.charAt(0) + string2.charAt(1);
                n3 = this.findChar(this.set93, string);
                n4 += n3 * (n2 + 1);
                string = "" + string2.charAt(2);
                n3 = this.findChar(this.set93, string);
                n4 += n3 * n2;
                if (++n2 == 16) {
                    n2 = 1;
                }
                if (++n2 != 16) continue;
                n2 = 1;
                continue;
            }
            string = "" + string2.charAt(0);
            n3 = this.findChar(this.set93, string);
            n4 += n3 * n2;
            if (++n2 != 16) continue;
            n2 = 1;
        }
        n5 = (int)BarCode.mod(n4, 47.0);
        if (this.checkCharacter) {
            this.paintChar(graphics, "bwbwbw", this.set93[n6][1]);
            this.paintChar(graphics, "bwbwbw", this.set93[n5][1]);
            this.codeText = this.code + this.set93[n6][0].charAt(0) + this.set93[n5][0].charAt(0);
        }
        this.paintChar(graphics, "bwbwbwb", "1111411");
    }

    protected void paintChar(Graphics graphics, String string, String string2) {
        this.paintChar2(graphics, string, string2, 0);
    }

    protected void paintChar2(Graphics graphics, String string, String string2, int n) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            if (c2 == 'n') {
                this.addBar(graphics, this.narrowBarPixels, c == 'b', n);
            }
            if (c2 == 'w') {
                this.addBar(graphics, this.widthBarPixels, c == 'b', n);
            }
            if (c2 == '1') {
                this.addBar(graphics, this.narrowBarPixels, c == 'b', n);
            }
            if (c2 == '2') {
                this.addBar(graphics, (int)(this.narrowBarCM * (double)this.resolution * 2.0), c == 'b', n);
            }
            if (c2 == '3') {
                this.addBar(graphics, (int)(this.narrowBarCM * (double)this.resolution * 3.0), c == 'b', n);
            }
            if (c2 != '4') continue;
            this.addBar(graphics, (int)(this.narrowBarCM * (double)this.resolution * 4.0), c == 'b', n);
        }
    }

    protected void paintGuardChar(Graphics graphics, String string, String string2, int n) {
        if (this.textFont != null && this.guardBars) {
            graphics.setFont(this.textFont);
            this.extraHeight = graphics.getFontMetrics().getHeight();
        }
        this.paintChar2(graphics, string, string2, n);
        this.extraHeight = 0;
    }

    protected void calculateSizes() {
        String string;
        byte by;
        int n;
        int n2 = this.code.length();
        this.narrowBarCM = this.X;
        this.widthBarCM = this.X * this.N;
        if (this.barType == 2) {
            if (BarCode.mod(n2, 2.0) == 0.0 && this.checkCharacter) {
                ++n2;
            }
            if (BarCode.mod(n2, 2.0) == 1.0 && !this.checkCharacter) {
                ++n2;
            }
            if (this.checkCharacter) {
                ++n2;
            }
            this.L = (double)(n2 / 2) * (3.0 + 2.0 * this.N) * this.X + 7.0 * this.X;
        }
        if (this.barType == 6) {
            if (this.checkCharacter) {
                ++n2;
            }
            this.L = (double)(n2 * 7) * this.X + 11.0 * this.X;
        }
        if (this.barType == 10) {
            this.L = (double)(n2 * 7) * this.X + 11.0 * this.X;
        }
        if (this.barType == 11) {
            this.L = (double)(n2 * 7) * this.X + 11.0 * this.X;
        }
        if (this.barType == 13 || this.barType == 18) {
            if (this.checkCharacter) {
                ++n2;
            }
            this.L = this.Code128Set == 'C' ? (double)(11 * n2 + 35) * this.X : (5.5 * (double)n2 + 35.0) * this.X;
        }
        if (this.barType == 12) {
            this.L = 42.0 * this.X + 9.0 * this.X;
        }
        if (this.barType == 7) {
            if (this.checkCharacter) {
                ++n2;
            }
            this.L = (double)n2 * (3.0 + 2.0 * this.N) * this.X + 7.0 * this.X;
        }
        if (this.barType == 8) {
            if (this.checkCharacter) {
                ++n2;
            }
            this.L = (double)n2 * (3.0 + 2.0 * this.N) * this.X + 7.0 * this.X;
        }
        if (this.barType == 5) {
            if (this.checkCharacter) {
                ++n2;
            }
            this.L = (double)n2 * (4.0 + 4.0 * this.N) * this.X + (1.0 + this.N) * this.X + (2.0 + this.N) * this.X;
        }
        if (this.barType == 4) {
            if (this.checkCharacter) {
                ++n2;
            }
            this.L = (double)(n2 + 2) * (4.0 + 3.0 * this.N) * this.X;
        }
        if (this.barType == 3) {
            if (this.checkCharacter || this.code.length() > 10) {
                ++n2;
            }
            this.L = (double)(n2 + 2 + 1) * (3.0 + 2.0 * this.N) * this.X;
        }
        if (this.barType == 15) {
            if (this.checkCharacter) {
                ++n2;
            }
            this.L = this.X * 10.0;
        }
        if (this.barType == 0) {
            if (this.checkCharacter) {
                ++n2;
            }
            this.L = (double)(n2 + 2) * (3.0 * this.N + 6.0) * this.X + (double)(n2 + 1) * this.I * this.X;
        }
        if (this.barType == 1) {
            n2 = 0;
            if (this.checkCharacter) {
                ++n2;
            }
            for (n = 0; n < this.code.length(); ++n) {
                by = (byte)this.code.charAt(n);
                if (by > 128) continue;
                string = this.set39Ext[by];
                n2 += string.length();
            }
            this.L = (double)(n2 + 2) * (3.0 * this.N + 6.0) * this.X + (double)(n2 + 1) * this.I * this.X;
        }
        if (this.barType == 9 || this.barType == 14) {
            n2 = 0;
            if (this.checkCharacter) {
                ++n2;
            }
            for (n = 0; n < this.code.length(); ++n) {
                by = (byte)this.code.charAt(n);
                if (by > 128) continue;
                string = this.set39Ext[by];
                if (string.length() == 1) {
                    ++n2;
                    continue;
                }
                n2 += 2;
            }
            this.L = (double)(n2 + 2) * (9.0 * this.X) + (double)(n2 + 1) * this.I * this.X;
        }
        if (this.barHeightCM == 0.0) {
            this.barHeightCM = this.L * this.H;
            if (this.barHeightCM < 0.625) {
                this.barHeightCM = 0.625;
            }
        }
        if (this.barHeightCM != 0.0) {
            this.barHeightPixels = (int)(this.barHeightCM * (double)this.resolution);
        }
        if (this.narrowBarCM != 0.0) {
            this.narrowBarPixels = (int)(this.narrowBarCM * (double)this.resolution);
        }
        if (this.widthBarCM != 0.0) {
            this.widthBarPixels = (int)(this.widthBarCM * (double)this.resolution);
        }
        if (this.narrowBarPixels <= 0) {
            this.narrowBarPixels = 1;
        }
        if (this.widthBarPixels <= 1) {
            this.widthBarPixels = 2;
        }
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        Image image = null;
        if (this.rotate != 0) {
            String string = System.getProperty("java.version");
            if (string.indexOf("1.2") == 0 || string.indexOf("1.3") == 0) {
                RImageCreator rImageCreator = new RImageCreator();
                image = rImageCreator.getImage(this.getSize().width, this.getSize().height);
                graphics2 = rImageCreator.getGraphics();
            } else {
                image = this.getSize().width > this.getSize().height ? this.createImage(this.getSize().width, this.getSize().width) : this.createImage(this.getSize().height, this.getSize().height);
                graphics2 = image.getGraphics();
            }
        }
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.paintBasis(graphics2);
        if (this.rotate != 0) {
            int n = this.currentX + this.leftMarginPixels;
            int n2 = this.currentY + this.topMarginPixels;
            Image image2 = this.rotate(image, this.rotate, n, n2);
            if (image2 == null) {
                graphics.drawImage(image, 0, 0, null);
            } else {
                graphics.drawImage(image2, 0, 0, null);
            }
        }
    }

    protected void paintBasis(Graphics graphics) {
        this.codeText = "";
        this.calculateSizes();
        this.topMarginPixels = (int)(this.topMarginCM * (double)this.resolution);
        this.currentX = this.leftMarginPixels = (int)(this.leftMarginCM * (double)this.resolution);
        graphics.setColor(this.backColor);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = n;
        if (n2 > n3) {
            n3 = n2;
        }
        graphics.fillRect(0, 0, n3, n3);
        this.endOfCode = 0;
        String string = this.code;
        if (this.processTilde) {
            this.code = this.applyTilde(this.code);
        }
        if (this.barType == 3) {
            this.paintCODE11(graphics);
        }
        if (this.barType == 5) {
            this.paintMSI(graphics);
        }
        if (this.barType == 4) {
            this.paintCODABAR(graphics);
        }
        if (this.barType == 0) {
            this.paintBAR39(graphics);
        }
        if (this.barType == 1) {
            this.paintBAR39Ext(graphics);
        }
        if (this.barType == 2) {
            this.paintInterleaved25(graphics);
        }
        if (this.barType == 9) {
            this.paintBAR93(graphics);
        }
        if (this.barType == 11) {
            this.paintEAN8(graphics);
        }
        if (this.barType == 10) {
            this.paintEAN13(graphics);
        }
        if (this.barType == 6) {
            this.paintUPCA(graphics);
        }
        if (this.barType == 12) {
            this.paintUPCE(graphics);
        }
        if (this.barType == 13) {
            this.paintCode128(graphics);
        }
        if (this.barType == 19) {
            this.paintEAN128(graphics);
        }
        if (this.barType == 18) {
            this.paintEAN128Old(graphics);
        }
        if (this.barType == 14) {
            this.paintBAR93Ext(graphics);
        }
        if (this.barType == 7) {
            this.paintIND25(graphics);
        }
        if (this.barType == 8) {
            this.paintMAT25(graphics);
        }
        if (this.barType == 15) {
            this.paintPOSTNET(graphics);
        }
        this.code = string;
        if (this.endOfCode == 0) {
            this.endOfCode = this.currentX;
        }
        if (this.codeText.length() == 0) {
            this.codeText = this.code;
        }
        this.currentY = this.barHeightPixels + this.topMarginPixels;
        if (this.textFont != null) {
            int n4;
            graphics.setColor(this.fontColor);
            graphics.setFont(this.textFont);
            int n5 = graphics.getFontMetrics().getHeight();
            int n6 = graphics.getFontMetrics().stringWidth("X");
            if ((this.UPCEANSupplement2 || this.UPCEANSupplement5) && (this.barType == 11 || this.barType == 6 || this.barType == 12 || this.barType == 10)) {
                n4 = (this.endSuplement - this.startSuplement - graphics.getFontMetrics().stringWidth(this.codeSup)) / 2;
                if (n4 < 0) {
                    n4 = 0;
                }
                graphics.drawString(this.codeSup, this.startSuplement + n4, this.topMarginPixels + this.suplementTopMargin - 2);
            }
            if (this.barType == 15) {
                n4 = (this.endOfCode - this.leftMarginPixels - graphics.getFontMetrics().stringWidth(this.codeText)) / 2;
                if (n4 < 0) {
                    n4 = 0;
                }
                graphics.drawString(this.codeText, this.leftMarginPixels + n4, (int)(this.postnetHeightTallBar * (double)this.resolution + (double)n5 + 1.0 + (double)this.topMarginPixels));
                this.currentY = this.barHeightPixels + n5 + 1 + this.topMarginPixels;
                return;
            }
            if (this.barType == 10 && this.guardBars && this.codeText.length() >= 13) {
                n4 = 0;
                graphics.drawString(this.codeText.substring(0, 1), this.leftMarginPixels - n6, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                n4 = (this.centerGuardBarStart - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(1, 7))) / 2;
                if (n4 < 0) {
                    n4 = 0;
                }
                graphics.drawString(this.codeText.substring(1, 7), this.leftGuardBar + n4, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                n4 = (this.rightGuardBar - this.centerGuardBarEnd - graphics.getFontMetrics().stringWidth(this.codeText.substring(7, 13))) / 2;
                if (n4 < 0) {
                    n4 = 0;
                }
                graphics.drawString(this.codeText.substring(7, 13), this.centerGuardBarEnd + n4, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                this.currentY = this.barHeightPixels + n5 + 1 + this.topMarginPixels;
                return;
            }
            if (this.barType == 6 && this.guardBars && this.codeText.length() >= 12) {
                n4 = 0;
                graphics.drawString(this.codeText.substring(0, 1), this.leftMarginPixels - n6, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                n4 = (this.centerGuardBarStart - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(1, 6))) / 2;
                if (n4 < 0) {
                    n4 = 0;
                }
                graphics.drawString(this.codeText.substring(1, 6), this.leftGuardBar + n4, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                n4 = (this.rightGuardBar - this.centerGuardBarEnd - graphics.getFontMetrics().stringWidth(this.codeText.substring(6, 11))) / 2;
                if (n4 < 0) {
                    n4 = 0;
                }
                graphics.drawString(this.codeText.substring(6, 11), this.centerGuardBarEnd + n4, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                graphics.drawString(this.codeText.substring(11, 12), this.endOfCode + 3, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                this.currentY = this.barHeightPixels + n5 + 1 + this.topMarginPixels;
                return;
            }
            if (this.barType == 11 && this.guardBars && this.codeText.length() >= 8) {
                n4 = 0;
                n4 = (this.centerGuardBarStart - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(0, 4))) / 2;
                if (n4 < 0) {
                    n4 = 0;
                }
                graphics.drawString(this.codeText.substring(0, 4), this.leftGuardBar + n4, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                n4 = (this.rightGuardBar - this.centerGuardBarEnd - graphics.getFontMetrics().stringWidth(this.codeText.substring(4, 8))) / 2;
                if (n4 < 0) {
                    n4 = 0;
                }
                graphics.drawString(this.codeText.substring(4, 8), this.centerGuardBarEnd + n4, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                this.currentY = this.barHeightPixels + n5 + 1 + this.topMarginPixels;
                return;
            }
            if (this.barType == 12 && this.guardBars) {
                n4 = 0;
                graphics.drawString(this.code.substring(0, 1), this.leftMarginPixels - n6, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                n4 = (this.rightGuardBar - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText)) / 2;
                if (n4 < 0) {
                    n4 = 0;
                }
                graphics.drawString(this.codeText, this.leftGuardBar + n4, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
                this.currentY = this.barHeightPixels + n5 + 1 + this.topMarginPixels;
                return;
            }
            n4 = (this.endOfCode - this.leftMarginPixels - graphics.getFontMetrics().stringWidth(this.codeText)) / 2;
            if (n4 < 0) {
                n4 = 0;
            }
            if (!this.textOnTop) {
                graphics.drawString(this.codeText, this.leftMarginPixels + n4, this.barHeightPixels + n5 + 1 + this.topMarginPixels);
            } else {
                graphics.drawString(this.codeText, this.leftMarginPixels + n4, n5 + 4);
            }
            this.currentY = this.barHeightPixels + n5 + 1 + this.topMarginPixels;
        }
    }

    protected Image rotate(Image image, int n, int n2, int n3) {
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (n2 > n4) {
            n2 = n4;
        }
        if (n3 > n5) {
            n3 = n5;
        }
        int[] nArray = new int[n4 * n5];
        int[] nArray2 = new int[n2 * n3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n4, n5, nArray, 0, n4);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        if (n == 90) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray2[n3 * (n2 - (i + 1)) + j] = nArray[j * n4 + i];
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n2, nArray2, 0, n3));
        }
        if (n == 180) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray2[(n3 - (j + 1)) * n2 + (n2 - (i + 1))] = nArray[j * n4 + i];
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray2, 0, n2));
        }
        if (n == 270) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray2[n3 * i + (n3 - (j + 1))] = nArray[j * n4 + i];
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n2, nArray2, 0, n3));
        }
        return null;
    }

    private String applyTilde(String string) {
        char c = '\u0000';
        int n = string.length();
        String string2 = "";
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c == '~') {
                if (i >= n - 1) continue;
                char c2 = string.charAt(i + 1);
                if (c2 == '~') {
                    string2 = string2 + '~';
                    ++i;
                    continue;
                }
                if (i >= n - 3) continue;
                String string3 = string.substring(i + 1, i + 4);
                int n2 = 0;
                try {
                    n2 = new Integer(string3);
                }
                catch (Exception exception) {
                    n2 = 0;
                }
                if (n2 > 255) {
                    n2 = 255;
                }
                string2 = string2 + (char)n2;
                i += 3;
                continue;
            }
            string2 = string2 + (char)c;
        }
        return string2;
    }
}

