/*
 * Decompiled with CFR 0.152.
 */
package com.aeat.pdfm;

import com.aeat.gcodbar.CodBarException;
import com.aeat.gcodbar.DimenPDF;
import com.aeat.gcodbar.EnumTipCodBar;
import com.aeat.gcodbar.EnumTipFichG;
import com.aeat.gcodbar.JCodBarras;
import com.aeat.gcodbar.myBarcodePng;
import com.java4less.rbarcode.BarCode;
import com.java4less.rbarcode.BarCode2D;
import com.java4less.rbarcode.barCodeEncoder;
import com.png.PngEncoderB;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class CodBarrWork
implements JCodBarras {
    public static final int MAX_CODEWORD = 927;
    private static final int FICH_UNICO = -1;
    private int vueltPDF = 0;
    private ArrayList dimenOld = new ArrayList();
    private boolean textEAN = false;
    private char tipoEAN = (char)67;
    private int ancho = 400;
    private int alto = 400;
    private int filas = 0;
    private int columnas = 17;
    private int nivelPdf = 6;
    private int resolucion = 4;
    private EnumTipCodBar tipCodBarras;
    private String datosS;
    private byte[] datosB;
    private boolean bBinario = true;
    private BarCode2D codBar2D = new BarCode2D();
    private BarCode codBar = new BarCode();

    public CodBarrWork() {
        this.codBar.textFont = null;
    }

    public CodBarrWork(EnumTipCodBar enumTipCodBar) {
        this.tipCodBarras = enumTipCodBar;
        this.codBar.textFont = null;
    }

    public int creaFichero(String string, EnumTipFichG enumTipFichG) throws CodBarException {
        int n = 0;
        this.cargaConfigura();
        if (this.tipCodBarras == EnumTipCodBar.B_PDF_MACRO) {
            int n2;
            int[] nArray = new int[]{97, 101, 97, 116, 46, 122, 105, 112};
            this.codBar2D.PDFMacroFileId = nArray;
            this.codBar2D.PDFMacroSegmentCount = 1;
            this.codBar2D.prepareMacroPDF();
            for (n2 = 0; n2 < this.codBar2D.PDFMacroSegmentCount; ++n2) {
                this.codBar2D.PDFMacroSegment = n2;
                if (this.codBar2D.PDFMacroSegmentCount == 1) {
                    this.codBar2D.PDFMacroSegment = -1;
                }
                this.creaFichAdecuando(string, enumTipFichG, n2);
            }
            n = n2;
        } else {
            this.creaFichAdecuando(string, enumTipFichG, -1);
            n = 1;
        }
        return n;
    }

    public byte[] getBufferIcono(EnumTipFichG enumTipFichG) throws CodBarException {
        byte[] byArray = null;
        this.cargaConfigura();
        if (this.tipCodBarras != EnumTipCodBar.B_PDF_MACRO) {
            byArray = this.creaBufferAdecuando(enumTipFichG);
        }
        return byArray;
    }

    public byte[] getBufferIconPdfM(EnumTipFichG enumTipFichG, DimenPDF dimenPDF) throws CodBarException {
        byte[] byArray = null;
        this.dimenOld.add(dimenPDF);
        this.setDimensiones(dimenPDF.getAncho(), dimenPDF.getAlto());
        this.setFilasColumnas(dimenPDF.getFilas(), dimenPDF.getColumnas());
        this.cargaConfigura();
        if (this.vueltPDF == 0) {
            int[] nArray = new int[]{97, 101, 97, 116, 46, 122, 105, 112};
            this.codBar2D.PDFMacroFileId = nArray;
            this.codBar2D.PDFMacroSegmentCount = 1;
            this.codBar2D.prepareMacroPDF();
        }
        if (this.vueltPDF < this.codBar2D.PDFMacroSegmentCount) {
            this.codBar2D.PDFMacroSegment = this.vueltPDF;
            if (this.codBar2D.PDFMacroSegmentCount == 1) {
                this.codBar2D.PDFMacroSegment = -1;
            }
            byArray = this.creaBufferAdecuando(enumTipFichG);
            ++this.vueltPDF;
        } else {
            this.vueltPDF = 0;
            this.dimenOld.clear();
            this.datosB = null;
        }
        return byArray;
    }

    public List getBufferIconos(EnumTipFichG enumTipFichG) throws CodBarException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        this.cargaConfigura();
        if (this.tipCodBarras == EnumTipCodBar.B_PDF_MACRO) {
            int[] nArray = new int[]{97, 101, 97, 116, 46, 122, 105, 112};
            this.codBar2D.PDFMacroFileId = nArray;
            this.codBar2D.PDFMacroSegmentCount = 1;
            this.codBar2D.prepareMacroPDF();
            for (int i = 0; i < this.codBar2D.PDFMacroSegmentCount; ++i) {
                this.codBar2D.PDFMacroSegment = i;
                if (this.codBar2D.PDFMacroSegmentCount == 1) {
                    this.codBar2D.PDFMacroSegment = -1;
                }
                arrayList.add(this.creaBufferAdecuando(enumTipFichG));
            }
        } else {
            arrayList.add(this.creaBufferAdecuando(enumTipFichG));
        }
        return arrayList;
    }

    public ImageIcon getIcono() throws CodBarException {
        ImageIcon imageIcon = null;
        this.cargaConfigura();
        if (this.tipCodBarras != EnumTipCodBar.B_PDF_MACRO) {
            imageIcon = new ImageIcon(this.creaBufferImage());
        }
        return imageIcon;
    }

    public List getIconos() throws CodBarException {
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>();
        this.cargaConfigura();
        if (this.tipCodBarras == EnumTipCodBar.B_PDF_MACRO) {
            int[] nArray = new int[]{97, 101, 97, 116, 46, 122, 105, 112};
            this.codBar2D.PDFMacroFileId = nArray;
            this.codBar2D.PDFMacroSegmentCount = 1;
            this.codBar2D.prepareMacroPDF();
            for (int i = 0; i < this.codBar2D.PDFMacroSegmentCount; ++i) {
                this.codBar2D.PDFMacroSegment = i;
                if (this.codBar2D.PDFMacroSegmentCount == 1) {
                    this.codBar2D.PDFMacroSegment = -1;
                }
                arrayList.add(new ImageIcon(this.creaBufferImage()));
            }
        } else {
            arrayList.add(new ImageIcon(this.creaBufferImage()));
        }
        return arrayList;
    }

    public void setDatos(String string) {
        this.datosS = string;
        this.bBinario = false;
    }

    public void setDatos(byte[] byArray) {
        this.datosB = byArray;
        this.bBinario = true;
    }

    public void setDimensiones(int n, int n2) {
        this.ancho = n;
        this.alto = n2;
    }

    public void setFilasColumnas(int n, int n2) {
        this.filas = n;
        this.columnas = n2;
    }

    public void setResolucion(int n) {
        this.resolucion = n;
    }

    public void setTipoCodBarr(EnumTipCodBar enumTipCodBar) {
        this.tipCodBarras = enumTipCodBar;
    }

    public void setTextoEnEAN(boolean bl) {
        this.codBar.textFont = bl ? new Font("Arial", 0, 11) : null;
    }

    public void setFontTextoEnEAN(Font font) {
        this.codBar.textFont = font;
    }

    public void setCode128(char c) {
        this.tipoEAN = c;
    }

    public void setOtrasDimen(double d, double d2, double d3) {
        this.codBar.X = d;
        this.codBar.N = d2;
        this.codBar.barHeightCM = d3;
    }

    private void cargaConfigura() {
        if (this.tipCodBarras == EnumTipCodBar.B_EAN_128) {
            this.codBar.Code128Set = this.tipoEAN;
            this.codBar.code = this.datosS;
            this.codBar.setSize(this.ancho, this.alto);
            this.codBar.barType = 18;
            this.codBar.checkCharacter = true;
        } else if (this.tipCodBarras == EnumTipCodBar.B_EAN_128ETI) {
            this.codBar.Code128Set = this.tipoEAN;
            this.codBar.code = this.datosS;
            this.codBar.setSize(this.ancho, this.alto);
            this.codBar.barType = 19;
            this.codBar.checkCharacter = true;
        } else if (this.tipCodBarras == EnumTipCodBar.B_PDF || this.tipCodBarras == EnumTipCodBar.B_PDF_MACRO) {
            if (this.bBinario) {
                this.codBar2D.codeBinary = this.datosB;
                this.codBar2D.PDFMode = 0;
            } else {
                this.codBar2D.code = this.datosS;
                this.codBar2D.PDFMode = 1;
            }
            this.codBar2D.resolution = this.resolucion;
            this.codBar2D.setSize(this.ancho, this.alto);
            if (this.vueltPDF == 0) {
                if (this.datosB.length < this.columnas * this.filas) {
                    this.filas = 0;
                }
            } else {
                int n = 0;
                for (int i = 0; i <= this.vueltPDF; ++i) {
                    DimenPDF dimenPDF = (DimenPDF)this.dimenOld.get(i);
                    n += dimenPDF.getColumnas() * dimenPDF.getFilas();
                }
                if (this.datosB.length < n) {
                    this.filas = 0;
                }
            }
            this.codBar2D.PDFRows = this.filas;
            this.codBar2D.PDFMaxRows = 927 / this.columnas;
            this.codBar2D.PDFColumns = this.columnas;
            this.codBar2D.PDFECLevel = this.nivelPdf;
            this.codBar2D.barType = 16;
        }
    }

    private String getExtensionF(EnumTipFichG enumTipFichG) {
        String string = null;
        if (enumTipFichG == EnumTipFichG.CREAR_GIF) {
            string = ".gif";
        } else if (enumTipFichG == EnumTipFichG.CREAR_JPG) {
            string = ".jpg";
        } else if (enumTipFichG == EnumTipFichG.CREAR_PNG) {
            string = ".png";
        }
        return string;
    }

    private void creaFichAdecuando(String string, EnumTipFichG enumTipFichG, int n) throws CodBarException {
        if (enumTipFichG == EnumTipFichG.CREAR_GIF) {
            this.creaFichGif(string, n);
        } else if (enumTipFichG == EnumTipFichG.CREAR_JPG) {
            this.creaFichJpg(string, n);
        } else if (enumTipFichG == EnumTipFichG.CREAR_PNG) {
            this.creaFichPng(string, n);
        }
    }

    private void creaFichJpg(String string, int n) throws CodBarException {
        String string2 = this.creaNomFich(string, n, ".jpg");
        this.creaEncoder("JPEG", string2);
    }

    private void creaFichGif(String string, int n) throws CodBarException {
        String string2 = this.creaNomFich(string, n, ".gif");
        this.creaEncoder("GIF", string2);
    }

    private void creaFichPng(String string, int n) throws CodBarException {
        String string2 = this.creaNomFich(string, n, ".png");
        this.creaEncoder("PNG", string2);
    }

    private String creaNomFich(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        stringBuffer.append(string);
        if (n != -1) {
            stringBuffer.append(n);
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private void creaEncoder(String string, String string2) throws CodBarException {
        if (string.equals("PNG")) {
            myBarcodePng myBarcodePng2 = this.tipCodBarras == EnumTipCodBar.B_EAN_128 ? new myBarcodePng(this.codBar, string2) : new myBarcodePng(this.codBar2D, string2);
            if (!myBarcodePng2.result) {
                throw new CodBarException("Error al crear c\u00f3digo de barras");
            }
        } else {
            barCodeEncoder barCodeEncoder2 = null;
            barCodeEncoder2 = this.tipCodBarras == EnumTipCodBar.B_EAN_128 ? new barCodeEncoder(this.codBar, string, string2) : new barCodeEncoder(this.codBar2D, string, string2);
            if (!barCodeEncoder2.result) {
                throw new CodBarException("Error al crear c\u00f3digo de barras");
            }
        }
    }

    private byte[] creaBufferAdecuando(EnumTipFichG enumTipFichG) throws CodBarException {
        byte[] byArray = null;
        if (enumTipFichG == EnumTipFichG.CREAR_GIF) {
            byArray = this.creaBufferGif();
        } else if (enumTipFichG == EnumTipFichG.CREAR_JPG) {
            byArray = this.creaBufferJpg();
        } else if (enumTipFichG == EnumTipFichG.CREAR_PNG) {
            byArray = this.creaBufferPng();
        }
        return byArray;
    }

    private byte[] creaBufferJpg() throws CodBarException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            BufferedImage bufferedImage = this.creaBufferImage();
            byteArrayOutputStream = new ByteArrayOutputStream();
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream);
            jPEGImageEncoder.encode(bufferedImage);
        }
        catch (Exception exception) {
            throw new CodBarException(exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] creaBufferGif() throws CodBarException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            BufferedImage bufferedImage = this.creaBufferImage();
            byteArrayOutputStream = new ByteArrayOutputStream();
            Class<?> clazz = Class.forName("Acme.JPM.Encoders.GifEncoder");
            Class[] classArray = new Class[]{Class.forName("java.awt.Image"), Class.forName("java.io.OutputStream")};
            Object[] objectArray = new Object[]{bufferedImage, byteArrayOutputStream};
            Object obj = clazz.getConstructor(classArray).newInstance(objectArray);
            Class[] classArray2 = new Class[]{};
            Object[] objectArray2 = new Object[]{};
            clazz.getMethod("encode", classArray2).invoke(obj, objectArray2);
        }
        catch (Exception exception) {
            throw new CodBarException(exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] creaBufferPng() throws CodBarException {
        byte[] byArray = null;
        try {
            BufferedImage bufferedImage = this.creaBufferImage();
            PngEncoderB pngEncoderB = new PngEncoderB(bufferedImage);
            byArray = pngEncoderB.pngEncode();
        }
        catch (Exception exception) {
            throw new CodBarException(exception);
        }
        return byArray;
    }

    private BufferedImage creaBufferImage() {
        BufferedImage bufferedImage = null;
        if (this.tipCodBarras == EnumTipCodBar.B_EAN_128 || this.tipCodBarras == EnumTipCodBar.B_EAN_128ETI) {
            bufferedImage = new BufferedImage(this.codBar.getSize().width, this.codBar.getSize().height, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.codBar.paint(graphics2D);
        } else {
            bufferedImage = new BufferedImage(this.codBar2D.getSize().width, this.codBar2D.getSize().height, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.codBar2D.paint(graphics2D);
        }
        return bufferedImage;
    }

    public int getNivelPdf() {
        return this.nivelPdf;
    }

    public void setNivelPdf(int n) {
        this.nivelPdf = n;
    }
}

