/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.resourcehandler;

import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import es.eucm.eadventure.engine.resourcehandler.zipurl.ZipURL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

class ResourceHandlerUnrestricted
extends ResourceHandler {
    private static ResourceHandlerUnrestricted instance;

    public static ResourceHandler getInstance() {
        return instance;
    }

    public static void create() {
        instance = new ResourceHandlerUnrestricted();
    }

    public static void delete() {
        if (instance != null && ResourceHandlerUnrestricted.instance.tempFiles != null) {
            for (ResourceHandler.TempFile tempFile : ResourceHandlerUnrestricted.instance.tempFiles) {
                tempFile.delete();
            }
        }
        instance = null;
    }

    private ResourceHandlerUnrestricted() {
    }

    public void setZipFile(String string) {
        try {
            ResourceHandler.zipPath = string;
            zipFile = new ZipFile(string);
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public OutputStream getOutputStream(String string) {
        FileOutputStream fileOutputStream = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileOutputStream = null;
        }
        return fileOutputStream;
    }

    public InputStream getResourceAsStream(String string) {
        FileInputStream fileInputStream = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileInputStream = null;
        }
        return fileInputStream;
    }

    public URL getResourceAsURLFromZip(String string) {
        try {
            return ZipURL.createAssetURL(zipPath, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public InputStream buildInputStream(String string) {
        return this.getResourceAsStreamFromZip(string);
    }

    public String[] listNames(String string) {
        File file = new File(zipPath, string);
        return file.list();
    }

    public URL getResourceAsURL(String string) {
        URL uRL = null;
        try {
            InputStream inputStream = this.getResourceAsStreamFromZip(string);
            String string2 = this.generateTempFileAbsolutePath(ResourceHandlerUnrestricted.getExtension(string));
            File file = new File(string2);
            if (this.writeFile(inputStream, file)) {
                uRL = file.toURI().toURL();
                ResourceHandler.TempFile tempFile = new ResourceHandler.TempFile(file.getAbsolutePath());
                tempFile.setOriginalAssetPath(string);
                this.tempFiles.add(tempFile);
            } else {
                uRL = null;
            }
        }
        catch (Exception exception) {
            uRL = null;
        }
        return uRL;
    }

    public boolean writeFile(InputStream inputStream, File file) {
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[512];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyFile(File file, File file2) {
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            FileWriter fileWriter = new FileWriter(file2);
            while ((n = fileReader.read()) != -1) {
                fileWriter.write(n);
            }
            fileReader.close();
            fileWriter.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

