/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.resourcehandler;

import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

class ResourceHandlerRestricted
extends ResourceHandler {
    private static ResourceHandlerRestricted instance;

    public static ResourceHandler getInstance() {
        return instance;
    }

    public static void create() {
        instance = new ResourceHandlerRestricted();
    }

    public static void delete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (instance != null && ResourceHandlerRestricted.instance.tempFiles != null) {
            for (ResourceHandler.TempFile tempFile : ResourceHandlerRestricted.instance.tempFiles) {
                try {
                    securityManager.checkDelete(tempFile.getPath());
                    tempFile.delete();
                }
                catch (Exception exception) {}
            }
        }
        instance = null;
    }

    private ResourceHandlerRestricted() {
    }

    public void setZipFile(String string) {
        try {
            ResourceHandler.zipPath = string;
            zipFile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OutputStream getOutputStream(String string) {
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        return inputStream;
    }

    public URL getResourceAsURL(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        byte[] byArray = new byte[1024];
        File file = new File(string.substring(string.lastIndexOf("/") + 1));
        boolean bl = true;
        for (ResourceHandler.TempFile tempFile : this.tempFiles) {
            if (!tempFile.getOriginalAssetPath().equals(string)) continue;
            bl = false;
            break;
        }
        if (bl) {
            ResourceHandler.TempFile tempFile;
            int n = 0;
            while (file.exists()) {
                file = new File(++n + "_" + string.substring(string.lastIndexOf("/") + 1));
            }
            tempFile = new ResourceHandler.TempFile(file.getAbsolutePath());
            tempFile.setOriginalAssetPath(string);
            this.tempFiles.add(tempFile);
        }
        try {
            if (bl) {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file.getAbsolutePath()));
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                inputStream.close();
            }
            return file.toURI().toURL();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public URL getResourceAsURLFromZip(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return this.getClass().getResource(string);
    }

    public InputStream buildInputStream(String string) {
        return this.getResourceAsStream(string);
    }

    public String[] listNames(String string) {
        return new String[0];
    }
}

