/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.resourcehandler;

import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandlerExternalSource;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandlerRestricted;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandlerUnrestricted;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public abstract class ResourceHandler
implements InputStreamCreator {
    public static final String DEFAULT_BACKGROUND = "gui/defaultassets/NRB_background.jpg";
    public static final String DEFAULT_SLIDES = "gui/defaultassets/NRB_slides_01.jpg";
    public static final String DEFAULT_ANIMATION = "gui/defaultassets/NRB_animation_01.png";
    public static final String DEFAULT_IMAGE = "gui/defaultassets/NRB_image.png";
    public static final String DEFAULT_ICON = "gui/defaultassets/NRB_icon.png";
    public static final String DEFAULT_FOREGROUND = "gui/defaultassets/NRB_foreground.png";
    public static final String DEFAULT_HARDMAP = "gui/defaultassets/NRB_hardmap.png";
    protected static boolean isRestrictedMode = false;
    protected static boolean extraRestriction = true;
    protected static ZipFile zipFile = null;
    protected static String zipPath = null;
    protected static boolean isExternalMode = false;
    private static Random random = new Random();
    private static int MAX_RANDOM = 100000;
    protected ArrayList<TempFile> tempFiles = new ArrayList();
    private static final String TEMP_FILE_NAME = "$temp_ead_";

    public static ResourceHandler getInstance() {
        ResourceHandler resourceHandler = null;
        resourceHandler = !isExternalMode && isRestrictedMode ? ResourceHandlerRestricted.getInstance() : (!isExternalMode ? ResourceHandlerUnrestricted.getInstance() : ResourceHandlerExternalSource.getInstance());
        return resourceHandler;
    }

    public static void setRestrictedMode(boolean bl, boolean bl2) {
        isRestrictedMode = bl;
        extraRestriction = bl2;
        if (bl) {
            ResourceHandlerRestricted.create();
        } else {
            ResourceHandlerUnrestricted.create();
        }
    }

    public static void setRestrictedMode(boolean bl) {
        ResourceHandler.setRestrictedMode(bl, true);
    }

    public static void setExternalMode(InputStreamCreator inputStreamCreator) {
        isExternalMode = true;
        ResourceHandlerExternalSource.create(inputStreamCreator);
    }

    public static void delete() {
        ResourceHandlerRestricted.delete();
        ResourceHandlerUnrestricted.delete();
    }

    public abstract void setZipFile(String var1);

    public void closeZipFile() {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isRestrictedMode() {
        return isRestrictedMode;
    }

    public abstract OutputStream getOutputStream(String var1);

    public abstract InputStream getResourceAsStream(String var1);

    public Image getResourceAsImage(String string) {
        BufferedImage bufferedImage = null;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        try {
            InputStream inputStream = this.getResourceAsStream(string);
            if (inputStream != null) {
                bufferedImage = ImageIO.read(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bufferedImage;
    }

    public InputStream getResourceAsStreamFromZip(String string) {
        InputStream inputStream = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        try {
            inputStream = zipFile != null && zipFile.getEntry(string) != null ? zipFile.getInputStream(zipFile.getEntry(string)) : this.getResourceAsStream(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return inputStream;
    }

    public Image getResourceAsImageFromZip(String string) {
        BufferedImage bufferedImage = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        try {
            InputStream inputStream = this.getResourceAsStreamFromZip(string);
            if (inputStream != null) {
                bufferedImage = ImageIO.read(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bufferedImage;
    }

    public abstract URL getResourceAsURLFromZip(String var1);

    public static String getExtension(String string) {
        return string.substring(string.lastIndexOf(46) + 1, string.length());
    }

    public abstract URL getResourceAsURL(String var1);

    protected String generateTempFileAbsolutePath(String string) {
        String string2 = null;
        string2 = System.getenv("TEMP") != null && !System.getenv("TEMP").equals("") ? System.getenv("TEMP") : (System.getenv("HOME") != null && !System.getenv("HOME").equals("") ? System.getenv("HOME") : (System.getenv("ROOT") != null && !System.getenv("ROOT").equals("") ? System.getenv("ROOT") : ""));
        String string3 = TEMP_FILE_NAME + random.nextInt(MAX_RANDOM) + "." + string;
        File file = new File(string2 + File.separatorChar + string3);
        while (file.exists()) {
            string3 = TEMP_FILE_NAME + random.nextInt(MAX_RANDOM) + "." + string;
            file = new File(string2 + File.separatorChar + string3);
        }
        return string2 + File.separatorChar + string3;
    }

    public boolean isExtraRestriction() {
        return extraRestriction;
    }

    public URL buildURL(String string) {
        return this.getResourceAsURLFromZip(string);
    }

    public class TempFile
    extends File {
        private String originalAssetPath;
        private static final long serialVersionUID = 896282044492374745L;

        public String getOriginalAssetPath() {
            return this.originalAssetPath;
        }

        public void setOriginalAssetPath(String string) {
            this.originalAssetPath = string;
        }

        public TempFile(String string) {
            super(string);
        }
    }
}

