/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.multimedia;

import es.eucm.eadventure.engine.multimedia.Sound;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class SoundMidi
extends Sound {
    private Sequencer sequencer;
    private Sequence sequence;

    public SoundMidi(String string, boolean bl) {
        super(bl);
        try {
            InputStream inputStream = ResourceHandler.getInstance().getResourceAsStreamFromZip(string);
            this.sequence = MidiSystem.getSequence(inputStream);
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequencer.setSequence(this.sequence);
            inputStream.close();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            this.sequencer = null;
        }
        catch (IOException iOException) {
            this.sequencer = null;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            this.sequencer = null;
        }
    }

    public void playOnce() {
        if (this.sequencer != null) {
            this.sequencer.setTickPosition(this.sequencer.getLoopStartPoint());
            this.sequencer.start();
            while (this.sequencer.isRunning()) {
                try {
                    SoundMidi.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.stopPlaying();
        }
    }

    public synchronized void stopPlaying() {
        super.stopPlaying();
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.stop();
            this.sequencer.close();
        }
    }

    public synchronized void finalize() {
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.stop();
            this.sequencer.close();
        }
        this.sequencer = null;
        this.sequence = null;
    }
}

