/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.multimedia;

import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.animations.FrameAnimation;
import es.eucm.eadventure.engine.core.control.animations.ImageAnimation;
import es.eucm.eadventure.engine.core.control.animations.ImageSet;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.Sound;
import es.eucm.eadventure.engine.multimedia.SoundMidi;
import es.eucm.eadventure.engine.multimedia.SoundMp3;
import es.eucm.eadventure.engine.resourcehandler.EngineImageLoader;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class MultimediaManager {
    public static final int MIDI = 0;
    public static final int MP3 = 1;
    public static final int IMAGE_SCENE = 0;
    public static final int IMAGE_MENU = 1;
    public static final int IMAGE_PLAYER = 2;
    private HashMap<String, Image>[] imageCache = new HashMap[3];
    private HashMap<String, Image>[] mirrorImageCache;
    private HashMap<Long, Sound> soundCache;
    private long musicSoundId;
    private static MultimediaManager instance = new MultimediaManager();
    private HashMap<String, Animation> animationCache;

    public static MultimediaManager getInstance() {
        return instance;
    }

    private MultimediaManager() {
        int n;
        for (n = 0; n < 3; ++n) {
            this.imageCache[n] = new HashMap();
        }
        this.mirrorImageCache = new HashMap[3];
        for (n = 0; n < 3; ++n) {
            this.mirrorImageCache[n] = new HashMap();
        }
        this.soundCache = new HashMap();
        this.animationCache = new HashMap();
        this.musicSoundId = -1L;
    }

    public Image loadImage(String string, int n) {
        Image image = this.imageCache[n].get(string);
        if (image == null && (image = this.getScaledImage(ResourceHandler.getInstance().getResourceAsImage(string), 1.0f, 1.0f)) != null) {
            this.imageCache[n].put(string, image);
        }
        return image;
    }

    public Image loadImageFromZip(String string, int n) {
        Image image = this.imageCache[n].get(string);
        if (image == null && (image = this.getScaledImage(ResourceHandler.getInstance().getResourceAsImageFromZip(string), 1.0f, 1.0f)) != null) {
            this.imageCache[n].put(string, image);
        }
        return image;
    }

    public Image loadMirroredImageFromZip(String string, int n) {
        Image image = this.mirrorImageCache[n].get(string);
        if (image == null && (image = this.getScaledImage(this.loadImageFromZip(string, n), -1.0f, 1.0f)) != null) {
            this.mirrorImageCache[n].put(string, image);
        }
        return image;
    }

    public void flushImagePool(int n) {
        this.imageCache[n].clear();
        this.mirrorImageCache[n].clear();
    }

    private Image getScaledImage(Image image, float f, float f2) {
        BufferedImage bufferedImage = null;
        if (image != null) {
            if (f != 1.0f || f2 != 1.0f) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(f, f2);
                affineTransform.translate((f - 1.0f) * (float)image.getWidth(null) / 2.0f, (f2 - 1.0f) * (float)image.getHeight(null) / 2.0f);
                bufferedImage = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(image.getWidth(null), image.getHeight(null), 3);
                Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
                graphics2D.drawImage(image, affineTransform, null);
                graphics2D.dispose();
            } else {
                return image;
            }
        }
        return bufferedImage;
    }

    private Image getFullscreenImage(Image image) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(800.0 / (double)image.getWidth(null), 600.0 / (double)image.getHeight(null));
        BufferedImage bufferedImage = GUI.getInstance().getGraphicsConfiguration().createCompatibleImage(800, 600, 3);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.drawImage(image, affineTransform, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public long loadSound(int n, String string, boolean bl) {
        Sound sound = null;
        long l = -1L;
        switch (n) {
            case 0: {
                sound = new SoundMidi(string, bl);
                break;
            }
            case 1: {
                sound = new SoundMp3(string, bl);
            }
        }
        if (sound != null) {
            this.soundCache.put(new Long(sound.getId()), sound);
            l = sound.getId();
        }
        return l;
    }

    public long loadSound(String string, boolean bl) {
        String string2 = string.substring(string.lastIndexOf(".") + 1).toLowerCase();
        int n = -1;
        if (string2.equals("mp3")) {
            n = 1;
        } else if (string2.equals("midi")) {
            n = 0;
        } else if (string2.equals("mid")) {
            n = 0;
        }
        return this.loadSound(n, string, bl);
    }

    public long loadMusic(int n, String string, boolean bl) {
        this.musicSoundId = this.loadSound(n, string, bl);
        return this.musicSoundId;
    }

    public long loadMusic(String string, boolean bl) {
        this.musicSoundId = this.loadSound(string, bl);
        return this.musicSoundId;
    }

    public void startPlaying(long l) {
        Sound sound;
        if (this.soundCache.containsKey(l) && (sound = this.soundCache.get(l)) != null) {
            sound.startPlaying();
        }
    }

    public void stopPlaying(long l) {
        Sound sound;
        if (this.soundCache.containsKey(l) && (sound = this.soundCache.get(l)) != null) {
            sound.stopPlaying();
        }
    }

    public void stopPlayingMusic() {
        Collection<Sound> collection = this.soundCache.values();
        for (Sound sound : collection) {
            if (sound.getId() != this.musicSoundId) continue;
            sound.stopPlaying();
        }
    }

    public void stopPlayingInmediately(long l) {
        Sound sound;
        if (this.soundCache.containsKey(l) && (sound = this.soundCache.get(l)) != null) {
            sound.stopPlaying();
            sound.finalize();
        }
    }

    public boolean isPlaying(long l) {
        Sound sound;
        boolean bl = false;
        if (l != -1L && this.soundCache.containsKey(l) && (sound = this.soundCache.get(l)) != null) {
            bl = sound.isPlaying();
        }
        return bl;
    }

    public void update() throws InterruptedException {
        Collection<Sound> collection = this.soundCache.values();
        ArrayList<Sound> arrayList = new ArrayList<Sound>();
        for (Sound sound : collection) {
            if (sound.getId() == this.musicSoundId || sound.isAlive()) continue;
            arrayList.add(sound);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Sound sound;
            sound = (Sound)arrayList.get(i);
            sound.join();
            collection.remove(sound);
        }
    }

    public void stopAllSounds() {
        Collection<Sound> collection = this.soundCache.values();
        ArrayList<Sound> arrayList = new ArrayList<Sound>();
        for (Sound sound : collection) {
            if (sound.getId() == this.musicSoundId) continue;
            arrayList.add(sound);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Sound sound;
            sound = (Sound)arrayList.get(i);
            try {
                sound.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            collection.remove(sound);
        }
    }

    public void deleteSounds() {
        Collection<Sound> collection = this.soundCache.values();
        for (Sound sound : collection) {
            if (sound.getId() == this.musicSoundId) continue;
            sound.stopPlaying();
            try {
                sound.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        collection.clear();
    }

    public Animation loadAnimation(String string, boolean bl, int n) {
        Animation animation = this.animationCache.get(string + (bl ? "t" : "f"));
        if (animation != null) {
            return animation;
        }
        if (string != null && string.endsWith(".eaa")) {
            FrameAnimation frameAnimation = new FrameAnimation(Loader.loadAnimation(ResourceHandler.getInstance(), string, new EngineImageLoader()));
            frameAnimation.setMirror(bl);
            animation = frameAnimation;
        } else {
            int n2 = 1;
            ArrayList<Image> arrayList = new ArrayList<Image>();
            Image image = null;
            boolean bl2 = false;
            while (!bl2) {
                image = bl ? this.loadMirroredImageFromZip(string + "_" + this.leadingZeros(n2) + ".png", n) : this.loadImageFromZip(string + "_" + this.leadingZeros(n2) + ".png", n);
                if (image != null) {
                    arrayList.add(image);
                    ++n2;
                    continue;
                }
                bl2 = true;
            }
            ImageAnimation imageAnimation = new ImageAnimation();
            imageAnimation.setImages(arrayList.toArray(new Image[0]));
            animation = imageAnimation;
        }
        this.animationCache.put(string + (bl ? "t" : "f"), animation);
        return animation;
    }

    public Animation loadSlides(String string, int n) {
        ImageSet imageSet = null;
        if (string.endsWith(".eaa")) {
            FrameAnimation frameAnimation = new FrameAnimation(Loader.loadAnimation(ResourceHandler.getInstance(), string, new EngineImageLoader()));
            frameAnimation.setFullscreen(true);
            return frameAnimation;
        }
        int n2 = 1;
        ArrayList<Image> arrayList = new ArrayList<Image>();
        Image image = null;
        boolean bl = false;
        while (!bl) {
            image = this.loadImageFromZip(string + "_" + this.leadingZeros(n2) + ".jpg", n);
            if (image != null) {
                arrayList.add(this.getFullscreenImage(image));
                ++n2;
                continue;
            }
            bl = true;
        }
        imageSet = new ImageSet();
        imageSet.setImages(arrayList.toArray(new Image[0]));
        return imageSet;
    }

    private String leadingZeros(int n) {
        String string = n < 10 ? "0" : "";
        string = string + n;
        return string;
    }

    public void flushAnimationPool() {
        this.animationCache.clear();
    }
}

