/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.gamelauncher;

import es.eucm.eadventure.common.auxiliar.ReleaseFolders;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.engine.EAdventure;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.config.ConfigData;
import es.eucm.eadventure.engine.gamelauncher.gameentry.GameEntry;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameLauncher
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 95641854718010553L;
    private static final int WINDOW_WIDTH = 690;
    private static final int WINDOW_HEIGHT = 620;
    private String adventureName;
    JFileChooser fileDialog;
    private String adventurePath;
    private JList lstGames;
    private DefaultListModel mdlGames;
    private JTextField txtCurrentDir;
    private JTextPane txtDescription;
    private JButton btnLoad;
    private JComboBox combo;
    private JButton btnRefresh;
    JPanel currentDirectoryPanel;
    JEditorPane aboutPanel;
    JPanel buttonsPanel;
    JPanel adventuresPanel;
    JPanel centralPanel;
    JTabbedPane tabbedPanel;
    JPanel global;
    JPanel globalTotal;
    JEditorPane aboutEditor;
    private boolean load;
    private boolean end;
    private boolean initGameLoad;

    public void init(File file) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(new ImageIcon("gui/Icono-Motor-16x16.png").getImage());
        arrayList.add(new ImageIcon("gui/Icono-Motor-32x32.png").getImage());
        arrayList.add(new ImageIcon("gui/Icono-Motor-64x64.png").getImage());
        arrayList.add(new ImageIcon("gui/Icono-Motor-128x128.png").getImage());
        this.setIconImages(arrayList);
        this.initGameLoad = false;
        this.setSize(690, 620);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - 690) / 2, (dimension.height - 620) / 2);
        this.setTitle(TC.get("MainWindow.GameLauncherTitle"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
            }

            public void windowClosing(WindowEvent windowEvent) {
                GameLauncher.this.end = true;
            }
        });
        this.currentDirectoryPanel = this.createCurrentDirectoryPanel(file);
        this.aboutPanel = this.createAboutPanel();
        this.buttonsPanel = this.createButtonsPanel();
        this.adventuresPanel = this.createAdventuresPanel();
        ImageIcon imageIcon = new ImageIcon("img/logo-engine.png");
        JLabel jLabel = new JLabel(imageIcon);
        this.centralPanel = new JPanel();
        this.centralPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        this.centralPanel.add((Component)jLabel, gridBagConstraints);
        this.global = new JPanel();
        this.global.setLayout(new BorderLayout());
        this.global.add((Component)this.currentDirectoryPanel, "Center");
        this.global.add((Component)this.buttonsPanel, "South");
        this.globalTotal = new JPanel();
        this.globalTotal.setLayout(new BorderLayout());
        this.globalTotal.add((Component)this.adventuresPanel, "Center");
        this.globalTotal.add((Component)this.global, "South");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.insertTab(TC.get("MainWindow.TabOpen"), null, this.globalTotal, "", 0);
        jTabbedPane.insertTab(TC.get("MainWindow.TabAbout"), null, this.aboutPanel, "", 1);
        this.add((Component)jTabbedPane, "Center");
        this.add((Component)this.centralPanel, "North");
        this.btnLoad.getRootPane().setDefaultButton(this.btnLoad);
        this.end = false;
        this.adventureName = "";
        boolean bl = false;
        bl = !ReleaseFolders.exportsFolder().exists() ? ReleaseFolders.exportsFolder().mkdirs() : true;
        if (bl) {
            this.loadDir(ReleaseFolders.exportsFolder());
        } else {
            this.loadDir(new File("."));
        }
        this.setVisible(true);
        try {
            if (file.getCanonicalPath() == "") {
                this.load = false;
            } else if (file.exists()) {
                this.lstGames.setSelectedIndex(1);
                this.lstGames.setSelectedValue(file, false);
                this.initGameLoad = true;
                this.loadIndividualFile(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private JEditorPane createAboutPanel() {
        this.aboutEditor = new JEditorPane();
        String string = "";
        String string2 = "";
        this.aboutEditor.setContentType("text/html");
        String string3 = "i18n/engine/" + ReleaseFolders.getAboutFilePath(ConfigData.getLanguage());
        File file = new File(string3);
        if (!file.exists()) {
            string3 = "i18n/engine/" + ReleaseFolders.getDefaultAboutFilePath();
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.aboutEditor.setText(string);
        this.aboutEditor.setEditable(false);
        return this.aboutEditor;
    }

    private JPanel createAdventuresPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 2, 10);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(this.getForeground());
        jTextPane.setText(TC.get("MainWindow.ListGamesText"));
        jPanel.add((Component)jTextPane, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.mdlGames = new DefaultListModel();
        this.lstGames = new JList(this.mdlGames);
        this.lstGames.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GameEntry gameEntry = (GameEntry)GameLauncher.this.lstGames.getSelectedValue();
                if (gameEntry != null) {
                    GameLauncher.this.txtDescription.setText(gameEntry.getDescription());
                    if (gameEntry.isValid()) {
                        GameLauncher.this.btnLoad.setText(TC.get("MainWindow.buttonLoad"));
                        GameLauncher.this.btnLoad.setEnabled(true);
                    } else {
                        GameLauncher.this.btnLoad.setText(TC.get("MainWindow.InvalidAdventure"));
                        GameLauncher.this.btnLoad.setEnabled(false);
                    }
                }
            }
        });
        this.lstGames.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    GameLauncher.this.load();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.lstGames, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(0, 0));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 2, 10);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setBackground(this.getForeground());
        jTextPane2.setText(TC.get("MainWindow.GameDescriptionText"));
        jPanel.add((Component)jTextPane2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.txtDescription = new JTextPane();
        this.txtDescription.setEditable(false);
        jScrollPane = new JScrollPane(this.txtDescription, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(0, 0));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private JPanel createCurrentDirectoryPanel(File file) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 10, 2, 10);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JLabel(TC.get("MainWindow.FolderText")), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 10, 3);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 8.0;
        gridBagConstraints.fill = 2;
        try {
            this.txtCurrentDir = new JTextField(new File(".").getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.txtCurrentDir.setEditable(false);
        jPanel.add((Component)this.txtCurrentDir, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 3, 10, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        JButton jButton = new JButton(TC.get("MainWindow.buttonExamine"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameLauncher.this.examine();
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel createButtonsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new FlowLayout());
        this.btnLoad = new JButton(TC.get("MainWindow.buttonLoad"));
        this.btnLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameLauncher.this.load();
            }
        });
        this.buttonsPanel.add(this.btnLoad);
        JButton jButton = new JButton(TC.get("MainWindow.buttonCancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameLauncher.this.end = true;
            }
        });
        this.buttonsPanel.add(jButton);
        this.btnRefresh = new JButton(TC.get("MainWindow.buttonRefresh"));
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameLauncher.this.refresh();
            }
        });
        this.buttonsPanel.add((Component)this.btnRefresh, gridBagConstraints);
        final List<String> list = ReleaseFolders.getLanguages("engine");
        String[] stringArray = new String[list.size() + 1];
        stringArray[0] = TC.get("MainWindow.SelectLanguage");
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i + 1] = ReleaseFolders.getLanguageName(list.get(i));
        }
        this.combo = new JComboBox<String>(stringArray);
        this.combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[2];
                stringArray[0] = "";
                if (GameLauncher.this.combo.getSelectedIndex() > 0) {
                    stringArray[1] = ReleaseFolders.getLanguageFilePath((String)list.get(GameLauncher.this.combo.getSelectedIndex() - 1));
                }
                EAdventure.main(stringArray);
                GameLauncher.this.setVisible(false);
                GameLauncher.this.dispose();
            }
        });
        ++gridBagConstraints.gridy;
        this.buttonsPanel.add((Component)this.combo, gridBagConstraints);
        return this.buttonsPanel;
    }

    @Override
    public void run() {
        while (!this.end) {
            try {
                if (this.load) {
                    this.load = false;
                    this.setVisible(false);
                    String string = this.getAdventurePath();
                    String string2 = this.getAdventureName();
                    if (string2.length() > 0) {
                        ResourceHandler.setRestrictedMode(false);
                        ResourceHandler.getInstance().setZipFile(string + string2 + ".ead");
                        Game.create();
                        Game.getInstance().setAdventurePath(string);
                        Game.getInstance().setAdventureName(string2);
                        Game.getInstance().run();
                        Game.delete();
                        ResourceHandler.getInstance().closeZipFile();
                        ResourceHandler.delete();
                        this.setVisible(!this.initGameLoad);
                    }
                    if (this.initGameLoad) {
                        System.exit(0);
                    }
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ConfigData.storeToXML();
        this.setEnabled(false);
        this.setVisible(false);
        this.setFocusable(false);
        if (!this.initGameLoad) {
            System.exit(0);
        }
    }

    public String getAdventurePath() {
        return this.adventurePath;
    }

    public String getAdventureName() {
        return this.adventureName;
    }

    private void load() {
        if (this.lstGames.getSelectedIndex() > -1) {
            this.adventureName = ((GameEntry)this.lstGames.getSelectedValue()).getFilename();
            this.adventureName = this.adventureName.replace("\\", "/");
            this.adventurePath = this.adventureName.substring(0, this.adventureName.lastIndexOf("/") + 1);
            this.adventureName = this.adventureName.substring(this.adventureName.lastIndexOf("/") + 1);
            this.adventureName = this.adventureName.substring(0, this.adventureName.lastIndexOf("."));
            this.load = true;
        }
    }

    private void loadIndividualFile(File file) {
        try {
            this.adventureName = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.adventureName = this.adventureName.replace("\\", "/");
        this.adventurePath = this.adventureName.substring(0, this.adventureName.lastIndexOf("/") + 1);
        this.adventureName = this.adventureName.substring(this.adventureName.lastIndexOf("/") + 1);
        this.adventureName = this.adventureName.substring(0, this.adventureName.indexOf("."));
        this.load = true;
    }

    private void refresh() {
        File file = new File(this.txtCurrentDir.getText());
        this.loadDir(file);
    }

    private void examine() {
        this.fileDialog = !ReleaseFolders.exportsFolder().exists() ? new JFileChooser(".") : new JFileChooser(ReleaseFolders.exportsFolder());
        this.fileDialog.setFileSelectionMode(2);
        this.fileDialog.setFileFilter(new FolderandEADFileFilter());
        if (this.fileDialog.showOpenDialog(this) == 0) {
            if (this.fileDialog.getSelectedFile().isFile()) {
                this.loadIndividualFile(this.fileDialog.getSelectedFile());
            } else {
                this.loadDir(this.fileDialog.getSelectedFile());
                this.load();
            }
        }
    }

    private void loadDir(File file) {
        try {
            this.mdlGames.removeAllElements();
            this.txtDescription.setText(TC.get("MainWindow.SelectGameText"));
            this.txtCurrentDir.setText(file.getCanonicalPath());
            List<GameEntry> list = this.scanDirectory(file);
            for (int i = 0; i < list.size(); ++i) {
                this.mdlGames.addElement(list.get(i));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private List<GameEntry> scanDirectory(File file) {
        ArrayList<GameEntry> arrayList = new ArrayList<GameEntry>();
        for (File file2 : file.listFiles()) {
            if (!file2.getAbsolutePath().toLowerCase().endsWith(".ead")) continue;
            ResourceHandler.setRestrictedMode(false);
            ResourceHandler.getInstance().setZipFile(file2.getAbsolutePath());
            try {
                DescriptorData descriptorData = Loader.loadDescriptorData(ResourceHandler.getInstance());
                if (descriptorData != null) {
                    GameEntry gameEntry = new GameEntry();
                    gameEntry.setDescription(descriptorData.getDescription());
                    gameEntry.setTitle(descriptorData.getTitle());
                    gameEntry.setValid(true);
                    gameEntry.setFilename(file2.getAbsolutePath());
                    arrayList.add(gameEntry);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ResourceHandler.getInstance().closeZipFile();
            ResourceHandler.delete();
        }
        return arrayList;
    }

    private class FolderandEADFileFilter
    extends FileFilter {
        private FolderandEADFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.isFile() && file.toString().toLowerCase().endsWith(".ead");
        }

        public String getDescription() {
            return "Folders and .ead files";
        }
    }
}

