/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui.hud.contextualhud;

import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.data.chapter.elements.Item;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.ActionManager;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalActiveArea;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalElement;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalItem;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalNPC;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalPlayer;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalScene;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.core.gui.hud.HUD;
import es.eucm.eadventure.engine.core.gui.hud.contextualhud.ActionButtons;
import es.eucm.eadventure.engine.core.gui.hud.contextualhud.Inventory;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.Hashtable;

public class ContextualHUD
extends HUD {
    private final int GAME_AREA_WIDTH = 800;
    private final int GAME_AREA_HEIGHT = 600;
    private static final int RESPONSE_TEXT_X = 10;
    private static final int UPPER_RESPONSE_TEXT_Y = 10;
    private static final int BOTTOM_RESPONSE_TEXT_Y = 480;
    private static final int RESPONSE_TEXT_NUMBER_LINES = 5;
    private static final int INVENTORY_OFF_OFFSET = 36;
    private static final int INVENTORY_ON_OFFSET = 12;
    private ActionButtons actionButtons;
    private Inventory inventory;
    private boolean showInventory;
    private boolean showActionButtons;
    private FunctionalElement elementAction;
    private FunctionalElement elementInCursor;
    private Cursor cursorOver;
    private Cursor cursorExit;
    private Cursor cursorAction;
    private MouseEvent lastMouseMoved;
    private long pressedTime = Long.MAX_VALUE;
    private int pressedX;
    private int pressedY;
    private FunctionalElement pressedElement;
    private FunctionalElement draggingElement;
    private float originalDragX;
    private float originalDragY;
    private boolean mouseReleased = false;
    private boolean pressed = false;
    private int lastSelectedAction = -1;
    private static int NUPDATES = 0;

    public void init() {
        super.init();
        DebugLog.general("Using contextual HUD");
        this.actionButtons = new ActionButtons(false);
        this.inventory = new Inventory();
        this.showInventory = false;
        this.showActionButtons = false;
        this.elementAction = null;
        this.lastMouseMoved = null;
        DescriptorData descriptorData = Game.getInstance().getGameDescriptor();
        this.cursorOver = this.getCursor(descriptorData, "over", "cursorOver", "gui/cursors/over.png");
        this.cursorExit = this.getCursor(descriptorData, "exit", "cursorExit", "gui/cursors/exit.png");
        this.cursorAction = this.getCursor(descriptorData, "action", "cursorAction", "gui/cursors/action.png");
    }

    private Cursor getCursor(DescriptorData descriptorData, String string, String string2, String string3) {
        Cursor cursor = null;
        if (descriptorData.getCursorPath(string) == null) {
            try {
                cursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage(string3, 1), new Point(5, 5), string2);
            }
            catch (Exception exception) {
                DebugLog.general("Cound't find default cursor " + string);
                cursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/nocursor.png", 1), new Point(5, 5), string2);
            }
        } else {
            try {
                cursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(descriptorData.getCursorPath(string), 1), new Point(5, 5), string2);
            }
            catch (Exception exception) {
                DebugLog.general("Cound't find custom cursor " + string);
                cursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/nocursor.png", 1), new Point(5, 5), string2);
            }
        }
        return cursor;
    }

    public int getGameAreaWidth() {
        return 800;
    }

    public int getGameAreaHeight() {
        return 600;
    }

    public int getResponseTextX() {
        return 10;
    }

    public int getResponseTextY() {
        FunctionalPlayer functionalPlayer = Game.getInstance().getFunctionalPlayer();
        int n = functionalPlayer.getY() - (float)functionalPlayer.getHeight() > 300.0f ? 10 : 480;
        return n;
    }

    public int getResponseTextNumberLines() {
        return 5;
    }

    public void newActionSelected() {
    }

    public boolean mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        if (!this.pressed) {
            bl = this.moved(mouseEvent);
        }
        if (this.pressed) {
            bl = this.dragged(mouseEvent);
        }
        this.lastMouseMoved = mouseEvent;
        return bl;
    }

    private boolean moved(MouseEvent mouseEvent) {
        boolean bl = false;
        this.actionButtons.mouseMoved(null);
        if (this.showActionButtons) {
            this.actionButtons.mouseMoved(mouseEvent);
            bl = this.actionButtons.getButtonOver() != null;
        } else if (this.showInventory) {
            bl = this.processInventoryMove(mouseEvent, bl);
        } else if (mouseEvent.getY() > 564 && Game.getInstance().showBottomInventory()) {
            this.inventory.setUpperInventory(false);
            this.showInventory = true;
        } else if (mouseEvent.getY() < 36 && Game.getInstance().showTopInventory()) {
            this.inventory.setUpperInventory(true);
            this.showInventory = true;
        }
        return bl;
    }

    private boolean processInventoryMove(MouseEvent mouseEvent, boolean bl) {
        if (this.inventory.isUpperInventory()) {
            if (mouseEvent.getY() < 48) {
                this.inventory.mouseMoved(mouseEvent);
                return true;
            }
            if (mouseEvent.getY() > 60) {
                this.showInventory = false;
            }
        } else {
            if (mouseEvent.getY() > 552) {
                this.inventory.mouseMoved(mouseEvent);
                return true;
            }
            if (mouseEvent.getY() < 540) {
                this.showInventory = false;
            }
        }
        return bl;
    }

    private boolean dragged(MouseEvent mouseEvent) {
        if (System.currentTimeMillis() - this.pressedTime >= 0L && System.currentTimeMillis() - this.pressedTime <= 60000L && Math.abs(this.pressedX - mouseEvent.getX()) < 10 && Math.abs(this.pressedY - mouseEvent.getY()) < 10) {
            return true;
        }
        if (this.pressedElement != null && this.pressedElement.canBeDragged()) {
            return this.startDragging(this.pressedElement);
        }
        this.gui.setDefaultCursor();
        return this.dragElement(mouseEvent);
    }

    public boolean startDragging(FunctionalElement functionalElement) {
        this.elementInCursor = this.elementAction = functionalElement;
        this.game.getActionManager().setActionSelected(11);
        this.game.getFunctionalPlayer().performActionInElement(this.elementAction);
        this.draggingElement = functionalElement;
        this.originalDragX = this.draggingElement.getX();
        this.originalDragY = this.draggingElement.getY();
        this.pressedElement = null;
        this.pressedTime = Long.MAX_VALUE;
        this.pressed = true;
        return true;
    }

    public boolean dragElement(MouseEvent mouseEvent) {
        FunctionalScene functionalScene = this.game.getFunctionalScene();
        if (functionalScene != null) {
            FunctionalElement functionalElement = functionalScene.getElementInside(mouseEvent.getX(), mouseEvent.getY(), this.draggingElement);
            this.game.getActionManager().setElementOver(functionalElement);
        }
        this.pressedTime = Long.MAX_VALUE;
        if (this.draggingElement != null) {
            this.draggingElement.setX(this.originalDragX - (float)this.pressedX + (float)mouseEvent.getX());
            this.draggingElement.setY(this.originalDragY - (float)this.pressedY + (float)mouseEvent.getY());
        }
        return true;
    }

    public boolean mouseClicked(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.mouseReleased) {
            this.mouseReleased = false;
            return true;
        }
        this.pressedTime = Long.MAX_VALUE;
        if (this.draggingElement != null && this.game.getFunctionalPlayer().getCurrentAction().getType() == 8) {
            return this.processDragTo(mouseEvent);
        }
        ActionManager actionManager = this.game.getActionManager();
        if (!this.game.isShowActions() && mouseEvent.getButton() != 1 && mouseEvent.getButton() != 3) {
            return false;
        }
        boolean bl2 = false;
        if (this.showActionButtons) {
            this.actionButtons.mouseClicked(mouseEvent);
            if (this.actionButtons.getButtonPressed() != null) {
                bl2 = true;
            }
        }
        Game game = Game.getInstance();
        FunctionalScene functionalScene = game.getFunctionalScene();
        FunctionalElement functionalElement = functionalScene.getElementInside(mouseEvent.getX(), mouseEvent.getY(), null);
        if (this.showInventory && functionalElement == null) {
            this.inventory.mouseMoved(mouseEvent);
            functionalElement = actionManager.getElementOver();
        }
        if (!bl2 && (mouseEvent.getButton() == 3 || game.isShowActions()) && this.elementInCursor == null || mouseEvent.getClickCount() == 2 && System.getProperty("os.name").contains("Windows") || !bl2 && functionalElement == null && this.elementInCursor != null) {
            System.out.println("RIGHT CLICK o similar");
            bl = this.processRightClickNoButton(this.pressedElement, mouseEvent);
            DebugLog.user("Mouse click, no action button. " + mouseEvent.getX() + " , " + mouseEvent.getY());
        } else if (this.showActionButtons) {
            this.actionButtons.mouseClicked(mouseEvent);
            if (this.actionButtons.getButtonPressed() != null) {
                DebugLog.user("Mouse click, inside action button: " + this.actionButtons.getButtonPressed().getName());
                bl = this.processButtonPressed(actionManager, mouseEvent);
                this.showActionButtons = false;
                this.elementAction = null;
            }
        } else if (this.showInventory && (mouseEvent.getY() > 552 || mouseEvent.getY() < 48)) {
            DebugLog.user("Mouse click in inventory");
            bl = this.processInventoryClick(actionManager, mouseEvent);
            this.showActionButtons = false;
            this.elementAction = null;
        } else if (this.pressedElement != null) {
            DebugLog.user("Mouse click over element at " + mouseEvent.getX() + " , " + mouseEvent.getY());
            bl = this.processElementClick(actionManager);
            System.out.println("INHUD = " + bl);
            this.showActionButtons = false;
            this.elementAction = null;
        }
        if (!bl) {
            this.showActionButtons = false;
            this.elementAction = null;
        }
        return bl;
    }

    public boolean mousePressed(MouseEvent mouseEvent) {
        this.pressed = true;
        ActionManager actionManager = this.game.getActionManager();
        this.pressedTime = System.currentTimeMillis();
        this.pressedX = mouseEvent.getX();
        this.pressedY = mouseEvent.getY();
        this.pressedElement = actionManager.getElementOver();
        DebugLog.user("Mouse pressed at " + mouseEvent.getX() + " , " + mouseEvent.getY());
        return true;
    }

    private void clearDraggingElement() {
        if (this.draggingElement != null && this.draggingElement.getElement() instanceof Item && ((Item)this.draggingElement.getElement()).isReturnsWhenDragged()) {
            this.draggingElement.setX(this.originalDragX);
            this.draggingElement.setY(this.originalDragY);
        }
        this.draggingElement = null;
    }

    public boolean mouseReleased(MouseEvent mouseEvent) {
        this.pressed = false;
        this.mouseReleased = true;
        if (this.pressedElement == null) {
            if (this.draggingElement != null && this.game.getFunctionalPlayer().getCurrentAction().getType() == 8) {
                return this.processDragTo(mouseEvent);
            }
            this.mouseReleased = false;
            return true;
        }
        this.pressedTime = System.currentTimeMillis() - this.pressedTime;
        System.out.println("" + this.pressedTime);
        DebugLog.user("Mouse released after " + this.pressedTime);
        if (this.pressedTime >= 800L && this.pressedTime < 60000L) {
            if (Math.abs(this.pressedX - mouseEvent.getX()) < 20 && Math.abs(this.pressedY - mouseEvent.getY()) < 20) {
                this.processRightClickNoButton(this.pressedElement, mouseEvent);
                this.pressedTime = Long.MAX_VALUE;
                return true;
            }
        } else if (this.pressedTime >= 0L && this.pressedTime < 600L && Math.abs(this.pressedX - mouseEvent.getX()) < 30 && Math.abs(this.pressedY - mouseEvent.getY()) < 30) {
            this.mouseReleased = false;
            this.pressedTime = Long.MAX_VALUE;
            if (this.pressedTime >= 80L && this.pressedX != mouseEvent.getX() && this.pressedY != mouseEvent.getY()) {
                System.out.println("Emulate left click");
                MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), this.pressedX, this.pressedY, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), 1, false, 1);
                return this.mouseClicked(mouseEvent2);
            }
            return true;
        }
        this.pressedTime = Long.MAX_VALUE;
        return false;
    }

    private boolean processDragTo(MouseEvent mouseEvent) {
        this.game.getActionManager().setActionSelected(11);
        FunctionalScene functionalScene = this.game.getFunctionalScene();
        if (functionalScene == null) {
            this.clearDraggingElement();
            return false;
        }
        FunctionalElement functionalElement = functionalScene.getElementInside(mouseEvent.getX(), mouseEvent.getY(), this.draggingElement);
        if (functionalElement == null) {
            this.game.getFunctionalPlayer().cancelActions();
        } else {
            this.game.getFunctionalPlayer().performActionInElement(functionalElement);
        }
        this.elementInCursor = null;
        this.gui.setDefaultCursor();
        this.pressedTime = Long.MAX_VALUE;
        this.clearDraggingElement();
        return true;
    }

    public boolean mouseDragged(MouseEvent mouseEvent) {
        return true;
    }

    public boolean keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            ActionManager actionManager = Game.getInstance().getActionManager();
            if (!this.showActionButtons && actionManager.getElementOver() == null && this.elementInCursor != null) {
                this.elementInCursor = null;
                this.gui.setDefaultCursor();
                this.elementAction = null;
                this.showActionButtons = false;
                return true;
            }
        }
        return false;
    }

    private boolean processElementClick(ActionManager actionManager) {
        if (this.elementInCursor != null) {
            if (this.game.getFunctionalPlayer().getCurrentAction().getType() == 6) {
                actionManager.setActionSelected(10);
            } else if (this.game.getFunctionalPlayer().getCurrentAction().getType() == 8) {
                actionManager.setActionSelected(11);
            } else if (this.pressedElement.canPerform(8)) {
                actionManager.setActionSelected(5);
                this.game.getFunctionalPlayer().performActionInElement(this.elementInCursor);
                actionManager.setActionSelected(8);
            } else {
                actionManager.setActionSelected(4);
                this.game.getFunctionalPlayer().performActionInElement(this.elementInCursor);
                actionManager.setActionSelected(7);
            }
            this.game.getFunctionalPlayer().performActionInElement(this.pressedElement);
            this.elementInCursor = null;
            this.gui.setDefaultCursor();
        } else {
            actionManager.setActionSelected(0);
            this.game.getFunctionalPlayer().performActionInElement(this.pressedElement);
        }
        return true;
    }

    private boolean processInventoryClick(ActionManager actionManager, MouseEvent mouseEvent) {
        FunctionalElement functionalElement = this.inventory.mouseClicked(mouseEvent);
        if (this.elementInCursor != null) {
            if (functionalElement != null) {
                actionManager.setActionSelected(4);
                this.game.getFunctionalPlayer().performActionInElement(this.elementInCursor);
                actionManager.setActionSelected(7);
                this.game.getFunctionalPlayer().performActionInElement(functionalElement);
                this.elementInCursor = null;
                this.gui.setDefaultCursor();
            }
        } else if (functionalElement != null) {
            actionManager.setActionSelected(0);
            this.game.getFunctionalPlayer().performActionInElement(functionalElement);
        }
        return true;
    }

    private boolean processButtonPressed(ActionManager actionManager, MouseEvent mouseEvent) {
        this.lastSelectedAction = -1;
        switch (this.actionButtons.getButtonPressed().getType()) {
            case 0: {
                this.elementInCursor = null;
                this.gui.setDefaultCursor();
                if (this.elementAction.canBeUsedAlone()) {
                    actionManager.setActionSelected(4);
                    this.game.getFunctionalPlayer().performActionInElement(this.elementAction);
                    break;
                }
                if (!this.elementAction.isInInventory()) {
                    actionManager.setActionSelected(1);
                    this.game.getFunctionalPlayer().performActionInElement(this.elementAction);
                    break;
                }
                this.lastSelectedAction = this.actionButtons.getButtonPressed().getName().equals(TC.get("ActionButton.GiveTo")) ? 8 : 7;
                this.elementInCursor = this.elementAction;
                Image image = null;
                image = ((FunctionalItem)this.elementInCursor).getIconImage() == null ? MultimediaManager.getInstance().loadImage("gui/hud/contextual/btnError.png", 1) : ((FunctionalItem)this.elementInCursor).getIconImage();
                this.gui.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(5, 5), "elementInCursor"));
                break;
            }
            case 1: {
                actionManager.setActionSelected(3);
                this.game.getFunctionalPlayer().performActionInElement(this.elementAction);
                break;
            }
            case 2: {
                actionManager.setActionSelected(2);
                this.game.getFunctionalPlayer().performActionInElement(this.elementAction);
                this.lastSelectedAction = 2;
                break;
            }
            case 3: {
                this.lastSelectedAction = 11;
                this.elementInCursor = this.elementAction;
                this.startDragging(this.elementInCursor);
                this.draggingElement.setX(this.pressedX);
                this.draggingElement.setY((float)this.pressedY + (float)this.draggingElement.getHeight() * this.draggingElement.getScale() / 2.0f);
                this.pressedX = (int)(this.originalDragX + (float)this.draggingElement.getWidth() * this.draggingElement.getScale() / 4.0f);
                this.pressedY = (int)(this.originalDragY - (float)this.draggingElement.getHeight() * this.draggingElement.getScale() / 2.0f);
                break;
            }
            case 4: {
                if (this.actionButtons.getButtonPressed().getCustomAction().getType() == 5) {
                    actionManager.setActionSelected(9);
                    actionManager.setCustomActionName(this.actionButtons.getButtonPressed().getName());
                    this.game.getFunctionalPlayer().performActionInElement(this.elementAction);
                    break;
                }
                this.lastSelectedAction = 10;
                this.elementInCursor = this.elementAction;
                Image image = null;
                image = ((FunctionalItem)this.elementInCursor).getIconImage() == null ? MultimediaManager.getInstance().loadImage("gui/hud/contextual/btnError.png", 1) : ((FunctionalItem)this.elementInCursor).getIconImage();
                this.gui.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(5, 5), "elementInCursor"));
                actionManager.setActionSelected(10);
                actionManager.setCustomActionName(this.actionButtons.getButtonPressed().getName());
                this.game.getFunctionalPlayer().performActionInElement(this.elementAction);
                break;
            }
        }
        actionManager.setActionSelected(6);
        return true;
    }

    private boolean processRightClickNoButton(FunctionalElement functionalElement, MouseEvent mouseEvent) {
        this.elementInCursor = null;
        this.gui.setDefaultCursor();
        System.out.println((functionalElement != null ? functionalElement.getElement().getId() : "") + " " + mouseEvent.getID() + " ");
        if (functionalElement != null) {
            this.elementAction = functionalElement;
            this.actionButtons.recreate(mouseEvent.getX(), mouseEvent.getY(), this.elementAction);
            this.showActionButtons = true;
            return true;
        }
        this.elementAction = null;
        this.showActionButtons = false;
        return false;
    }

    public void draw(Graphics2D graphics2D) {
        ActionManager actionManager = this.game.getActionManager();
        this.inventory.draw(graphics2D);
        if (this.showActionButtons) {
            this.actionButtons.draw(graphics2D);
        }
        graphics2D.setColor(Color.BLUE);
        if (System.currentTimeMillis() - this.pressedTime > 100L) {
            AlphaComposite alphaComposite;
            long l = System.currentTimeMillis() - this.pressedTime;
            if (l < 800L) {
                alphaComposite = AlphaComposite.getInstance(3, 0.4f);
                graphics2D.setComposite(alphaComposite);
                int n = 6 + (int)(8.0f * (float)l / 800.0f);
                graphics2D.fillArc(this.pressedX - n, this.pressedY - n, n * 2, n * 2, 0, -((int)(0.45 * (double)l)));
            } else {
                alphaComposite = AlphaComposite.getInstance(3, 0.4f + 0.5f * (float)Math.pow(1.0f - (float)(l % 600L) / 300.0f, 2.0));
                graphics2D.setComposite(alphaComposite);
                graphics2D.fillOval(this.pressedX - 16, this.pressedY - 16, 32, 32);
            }
            graphics2D.setComposite(AlphaComposite.DstAtop);
        }
        graphics2D.setFont(new Font(null, 1, 16));
        Hashtable<TextAttribute, Float> hashtable = new Hashtable<TextAttribute, Float>();
        hashtable.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
        graphics2D.setFont(graphics2D.getFont().deriveFont(hashtable));
        graphics2D.setColor(Color.WHITE);
        if (this.elementInCursor == null) {
            if (!actionManager.getExit().equals("")) {
                if (actionManager.getExitCursor() != null) {
                    this.gui.setCursor(actionManager.getExitCursor());
                } else {
                    this.gui.setCursor(this.cursorExit);
                }
                if (this.lastMouseMoved != null) {
                    GUI.drawStringOnto(graphics2D, new String[]{actionManager.getExit()}, this.lastMouseMoved.getX() + 16, this.lastMouseMoved.getY(), Color.WHITE, Color.BLACK);
                }
            } else if (actionManager.getElementOver() != null) {
                this.gui.setCursor(this.cursorOver);
                if (this.lastMouseMoved != null) {
                    GUI.drawStringOnto(graphics2D, new String[]{actionManager.getElementOver().getElement().getName()}, this.lastMouseMoved.getX() + 16, this.lastMouseMoved.getY(), Color.WHITE, Color.BLACK);
                }
            } else if (this.showActionButtons && this.actionButtons.getButtonOver() != null) {
                this.gui.setCursor(this.cursorAction);
            } else {
                this.gui.setDefaultCursor();
            }
        } else if (actionManager.getElementOver() != null && this.lastMouseMoved != null) {
            String string = "";
            boolean bl = false;
            if (this.lastSelectedAction == 10) {
                string = actionManager.getCustomActionName();
                bl = true;
            }
            if (this.lastSelectedAction == 8) {
                string = TC.get("ActionButton.GiveTo");
                bl = true;
            }
            if (this.lastSelectedAction == 7) {
                string = TC.get("ActionButton.UseWith");
                bl = true;
            }
            if (this.lastSelectedAction == 11) {
                string = TC.get("ActionButton.Drag");
                bl = true;
            }
            string = bl ? (actionManager.getElementOver().getElement().getName().equals("") ? string + " " + this.processElement() : string + " " + actionManager.getElementOver().getElement().getName()) : actionManager.getElementOver().getElement().getName();
            GUI.drawStringOnto(graphics2D, new String[]{string}, this.lastMouseMoved.getX() + 16, this.lastMouseMoved.getY(), Color.WHITE, Color.BLACK);
        }
    }

    private String processElement() {
        FunctionalElement functionalElement = this.game.getActionManager().getElementOver();
        if (functionalElement instanceof FunctionalNPC) {
            return TC.get("DefaultText.NPC");
        }
        if (functionalElement instanceof FunctionalActiveArea) {
            return TC.get("DefaultText.ActiveArea");
        }
        if (functionalElement instanceof FunctionalItem) {
            return TC.get("DefaultText.Item");
        }
        return "";
    }

    public void update(long l) {
        this.inventory.update(l);
        if (this.showHud && this.showInventory) {
            this.inventory.setDY(this.inventory.getDY() - (double)l / 10.0);
        } else {
            this.inventory.setDY(this.inventory.getDY() + (double)l / 10.0);
        }
        ++NUPDATES;
    }

    public void toggleHud(boolean bl) {
        this.showHud = bl;
        this.elementInCursor = null;
    }

    public void setLastMouseMove(MouseEvent mouseEvent) {
        this.lastMouseMoved = mouseEvent;
    }
}

