/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui.editorpane;

import es.eucm.eadventure.common.gui.BookEditorPane;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;

public class BookEditorPaneEngine
extends BookEditorPane {
    private static final long serialVersionUID = 5081543464254158693L;
    private String uri;

    public BookEditorPaneEngine(String string) {
        this.uri = string.substring(0, string.lastIndexOf("/") + 1);
        this.setEditorKit(new BookHTMLEditorKitEngine());
    }

    public void paint(Graphics graphics) {
    }

    private class EngineImageView
    extends ImageView {
        public EngineImageView(Element element) {
            super(element);
        }

        public URL getImageURL() {
            String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
            if (string == null) {
                return null;
            }
            String string2 = BookEditorPaneEngine.this.uri + string;
            return ResourceHandler.getInstance().getResourceAsURL(string2);
        }
    }

    private class BookHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        private BookHTMLFactory() {
        }

        public View create(Element element) {
            HTML.Tag tag;
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag && (tag = (HTML.Tag)object) == HTML.Tag.IMG) {
                return new EngineImageView(element);
            }
            return super.create(element);
        }
    }

    private class BookHTMLEditorKitEngine
    extends BookEditorPane.BookHTMLEditorKit {
        private static final long serialVersionUID = -8639564774418040491L;
        BookHTMLFactory f;

        private BookHTMLEditorKitEngine() {
            this.f = new BookHTMLFactory();
        }

        public HTMLEditorKit.HTMLFactory getViewFactory() {
            return this.f;
        }
    }
}

