/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.gui;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.DebugLog;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.gui.DebugLogPanel;
import es.eucm.eadventure.engine.core.gui.DebugValuesPanel;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.core.gui.hud.contextualhud.ContextualHUD;
import es.eucm.eadventure.engine.core.gui.hud.traditionalhud.TraditionalHUD;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusListener;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GUIFrame
extends GUI
implements FocusListener {
    private JFrame bkgFrame = new JFrame("eadventure"){
        private static final long serialVersionUID = 3648656167576771790L;

        public void paint(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (GUIFrame.this.component != null) {
                GUIFrame.this.component.repaint();
            }
        }
    };
    private GUILayout guiLayout;
    private static DisplayMode originalDisplayMode;

    public static void create() {
        instance = new GUIFrame();
    }

    public static void delete() {
        if (originalDisplayMode != null && instance != null && ((GUIFrame)GUIFrame.instance).bkgFrame != null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            graphicsDevice.setFullScreenWindow(((GUIFrame)GUIFrame.instance).bkgFrame);
            graphicsDevice.setDisplayMode(originalDisplayMode);
            originalDisplayMode = null;
        }
        if (instance != null && ((GUIFrame)GUIFrame.instance).bkgFrame != null) {
            ((GUIFrame)GUIFrame.instance).bkgFrame.setVisible(false);
            ((GUIFrame)GUIFrame.instance).bkgFrame.dispose();
        }
        instance = null;
    }

    protected GUIFrame() {
        Cloneable cloneable;
        try {
            cloneable = new ArrayList<Image>();
            cloneable.add(new ImageIcon("gui/Icono-Motor-16x16.png").getImage());
            cloneable.add(new ImageIcon("gui/Icono-Motor-32x32.png").getImage());
            cloneable.add(new ImageIcon("gui/Icono-Motor-64x64.png").getImage());
            cloneable.add(new ImageIcon("gui/Icono-Motor-128x128.png").getImage());
            this.bkgFrame.setIconImages((List<? extends Image>)((Object)cloneable));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.bkgFrame.setIconImage(new ImageIcon("gui/Icono-Motor-32x32.png").getImage());
        }
        this.bkgFrame.setUndecorated(true);
        cloneable = Toolkit.getDefaultToolkit().getScreenSize();
        if (graphicConfig == 1 && !Game.getInstance().isDebug() && !Game.getInstance().isAppletMode()) {
            this.bkgFrame.setSize(((Dimension)cloneable).width, ((Dimension)cloneable).height);
            this.bkgFrame.setLocation(0, 0);
        } else if (!Game.getInstance().isDebug()) {
            this.bkgFrame.setSize(800, 600);
            this.bkgFrame.setLocation((((Dimension)cloneable).width - 800) / 2, (((Dimension)cloneable).height - 600) / 2);
        } else {
            this.bkgFrame.setSize(((Dimension)cloneable).width, ((Dimension)cloneable).height);
            this.bkgFrame.setLocation(0, System.getProperty("os.name").contains("Mac") ? 15 : 0);
        }
        this.bkgFrame.setBackground(Color.BLACK);
        this.bkgFrame.setForeground(Color.BLACK);
        this.guiLayout = new GUILayout();
        this.bkgFrame.setLayout(this.guiLayout);
        this.gameFrame = new Canvas();
        this.background = null;
        this.elementsToDraw = new ArrayList();
        this.textToDraw = new ArrayList();
        this.gameFrame.setIgnoreRepaint(true);
        this.gameFrame.setFont(new Font("Dialog", 0, 18));
        Hashtable<TextAttribute, Float> hashtable = new Hashtable<TextAttribute, Float>();
        hashtable.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
        this.gameFrame.setFont(this.gameFrame.getFont().deriveFont(hashtable));
        this.gameFrame.setBackground(Color.black);
        this.gameFrame.setForeground(Color.white);
        this.gameFrame.setSize(new Dimension(800, 600));
        if (!Game.getInstance().isDebug()) {
            this.gameFrame.setLocation((((Dimension)cloneable).width - 800) / 2 - (int)this.bkgFrame.getLocation().getX(), (((Dimension)cloneable).height - 600) / 2 - (int)this.bkgFrame.getLocation().getY());
        } else {
            this.gameFrame.setLocation((int)this.bkgFrame.getLocation().getX(), (int)this.bkgFrame.getLocation().getY());
        }
        this.bkgFrame.setVisible(true);
        this.bkgFrame.setIgnoreRepaint(true);
        this.bkgFrame.add(this.gameFrame);
        String string = System.getProperty("os.name");
        if (string.contains("Mac")) {
            System.setProperty("apple.awt.rendering", "speed");
        }
        if (string.contains("Windows") && graphicConfig == 2 && !Game.getInstance().isDebug() && !Game.getInstance().isAppletMode()) {
            boolean bl;
            block16: {
                GraphicsDevice graphicsDevice = null;
                bl = false;
                try {
                    GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                    originalDisplayMode = graphicsDevice.getDisplayMode();
                    DisplayMode displayMode = new DisplayMode(800, 600, 32, 0);
                    DisplayMode[] displayModeArray = graphicsDevice.getDisplayModes();
                    for (int i = 0; i < displayModeArray.length && !bl; ++i) {
                        if (displayModeArray[i].getBitDepth() != displayMode.getBitDepth() || displayModeArray[i].getHeight() != displayMode.getHeight() || displayModeArray[i].getWidth() != displayMode.getWidth()) continue;
                        graphicsDevice.setFullScreenWindow(this.bkgFrame);
                        graphicsDevice.setDisplayMode(displayMode);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    if (graphicsDevice == null || originalDisplayMode == null) break block16;
                    graphicsDevice.setDisplayMode(originalDisplayMode);
                    originalDisplayMode = null;
                }
            }
            if (!bl) {
                originalDisplayMode = null;
                JOptionPane.showMessageDialog(this.bkgFrame, TC.get("GUI.NoFullscreenTitle"), TC.get("GUI.NoFullscreenContent"), 2);
            }
        } else if (!string.contains("Windows") && graphicConfig == 2) {
            JOptionPane.showMessageDialog(this.bkgFrame, TC.get("GUI.NoFullscreenTitle"), TC.get("GUI.NoFullscreenContent"), 2);
        }
    }

    public void initGUI(int n, boolean bl) {
        if (n == 0) {
            this.hud = new TraditionalHUD();
        } else if (n == 1) {
            this.hud = new ContextualHUD();
        }
        this.gameFrame.setEnabled(true);
        this.gameFrame.setVisible(true);
        this.gameFrame.setFocusable(true);
        this.bkgFrame.setAlwaysOnTop(graphicConfig != 0);
        this.gameFrame.createBufferStrategy(2);
        this.gameFrame.validate();
        this.gameFrame.addFocusListener(this);
        this.gameFrame.requestFocusInWindow();
        this.hud.init();
        if (Game.getInstance().getGameDescriptor().getCursorPath("default") != null) {
            try {
                this.defaultCursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImageFromZip(Game.getInstance().getGameDescriptor().getCursorPath("default"), 1), new Point(0, 0), "defaultCursor");
            }
            catch (Exception exception) {
                DebugLog.general("Cound't find default cursor ");
                this.defaultCursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/nocursor.png", 1), new Point(0, 0), "defaultCursor");
            }
        } else {
            try {
                this.defaultCursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/default.png", 1), new Point(0, 0), "defaultCursor");
            }
            catch (Exception exception) {
                DebugLog.general("Cound't find custom default cursor ");
                this.defaultCursor = Toolkit.getDefaultToolkit().createCustomCursor(MultimediaManager.getInstance().loadImage("gui/cursors/nocursor.png", 1), new Point(0, 0), "defaultCursor");
            }
        }
        this.gameFrame.setCursor(this.defaultCursor);
    }

    public JFrame showComponent(Component component) {
        this.gameFrame.setVisible(false);
        this.bkgFrame.setIgnoreRepaint(true);
        if (this.component != null) {
            this.bkgFrame.remove(this.component);
            this.guiLayout.setFixedSize(800, 600);
            this.guiLayout.setMode(0);
        }
        this.component = component;
        component.setBackground(Color.BLACK);
        component.setForeground(Color.BLACK);
        this.bkgFrame.add(component);
        this.bkgFrame.validate();
        component.repaint();
        return this.bkgFrame;
    }

    public void restoreFrame() {
        if (this.component != null) {
            this.bkgFrame.remove(this.component);
            this.guiLayout.setFixedSize(800, 600);
            this.guiLayout.setMode(0);
        }
        this.component = null;
        if (Game.getInstance().isDebug()) {
            this.gameFrame.setVisible(true);
            this.bkgFrame.validate();
            Game.getInstance().repaintDebug();
        } else {
            this.bkgFrame.setIgnoreRepaint(true);
            this.bkgFrame.repaint();
            this.gameFrame.setVisible(true);
            this.bkgFrame.validate();
        }
    }

    public Frame getJFrame() {
        return this.bkgFrame;
    }

    public JFrame showComponent(Component component, int n, int n2) {
        if (this.component != null) {
            this.bkgFrame.remove(this.component);
            this.component = null;
        }
        this.guiLayout.setFixedSize(n, n2);
        this.guiLayout.setMode(1);
        return this.showComponent(component);
    }

    private class GUILayout
    implements LayoutManager {
        public static final int MODE_USE_ALL_WINDOW = 0;
        public static final int MODE_RESPECT_WHRATIO = 1;
        private int mode = 0;
        private int fixedWidth;
        private int fixedHeight;

        public void setFixedSize(int n, int n2) {
            this.fixedHeight = n2;
            this.fixedWidth = n;
        }

        public void setMode(int n) {
            if (n == 0 || n == 1) {
                this.mode = n;
            }
        }

        public int getMode() {
            return this.mode;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                if (GUIFrame.this.bkgFrame != null) {
                    int n = (dimension.width - 800) / 2 - (int)GUIFrame.this.bkgFrame.getLocation().getX();
                    int n2 = (dimension.height - 600) / 2 - (int)GUIFrame.this.bkgFrame.getLocation().getY();
                    int n3 = 800;
                    int n4 = 600;
                    if (this.mode == 1) {
                        if (this.fixedWidth / this.fixedHeight >= n3 / n4) {
                            n3 = 800;
                            n4 = (int)((float)this.fixedHeight / (float)this.fixedWidth * 800.0f);
                        } else {
                            n4 = 600;
                            n3 = (int)((float)this.fixedWidth / (float)this.fixedHeight * 600.0f);
                        }
                        n = (dimension.width - n3) / 2 - (int)GUIFrame.this.bkgFrame.getLocation().getX();
                        n2 = (dimension.height - n4) / 2 - (int)GUIFrame.this.bkgFrame.getLocation().getY();
                    }
                    if (Game.getInstance().isDebug()) {
                        n = dimension.width - n3;
                        int n5 = n2 = System.getProperty("os.name").contains("Mac") ? 15 : 0;
                    }
                    if (componentArray[i] instanceof DebugLogPanel) {
                        componentArray[i].setBounds(0, n4 + (System.getProperty("os.name").contains("Mac") ? 15 : 0), dimension.width, dimension.height - n4 - (System.getProperty("os.name").contains("Mac") ? 15 : 0));
                        continue;
                    }
                    if (componentArray[i] instanceof DebugValuesPanel) {
                        componentArray[i].setBounds(0, System.getProperty("os.name").contains("Mac") ? 15 : 0, dimension.width - n3, n4);
                        continue;
                    }
                    componentArray[i].setBounds(n, n2, n3, n4);
                    continue;
                }
                componentArray[i].setLocation(0, 0);
                componentArray[i].setSize(800, 600);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return container.getSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

