/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.core.control.gamestate;

import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.resources.Asset;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.data.chapter.scenes.Slidescene;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.engine.core.control.Game;
import es.eucm.eadventure.engine.core.control.animations.Animation;
import es.eucm.eadventure.engine.core.control.functionaldata.FunctionalConditions;
import es.eucm.eadventure.engine.core.control.functionaldata.functionaleffects.FunctionalEffects;
import es.eucm.eadventure.engine.core.control.gamestate.GameState;
import es.eucm.eadventure.engine.core.gui.GUI;
import es.eucm.eadventure.engine.multimedia.MultimediaManager;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class GameStateSlidescene
extends GameState {
    private Animation slides;
    private Slidescene slidescene = (Slidescene)this.game.getCurrentChapterData().getGeneralScene(this.game.getNextScene().getNextSceneId());
    private boolean yetSkipped = false;

    public GameStateSlidescene() {
        Resources resources = this.createResourcesBlock();
        long l = -1L;
        if (this.game.getFunctionalScene() != null) {
            String string = null;
            for (int i = 0; i < this.game.getFunctionalScene().getScene().getResources().size() && string == null; ++i) {
                if (!new FunctionalConditions(this.game.getFunctionalScene().getScene().getResources().get(i).getConditions()).allConditionsOk()) continue;
                string = this.game.getFunctionalScene().getScene().getResources().get(i).getAssetPath("bgmusic");
            }
            String string2 = null;
            for (int i = 0; i < this.slidescene.getResources().size() && string2 == null; ++i) {
                if (!new FunctionalConditions(this.slidescene.getResources().get(i).getConditions()).allConditionsOk()) continue;
                string2 = this.slidescene.getResources().get(i).getAssetPath("bgmusic");
            }
            if (string != null && string2 != null && string.equals(string2)) {
                l = this.game.getFunctionalScene().getBackgroundMusicId();
            } else {
                this.game.getFunctionalScene().stopBackgroundMusic();
            }
        }
        if (Game.getInstance().getOptions().isMusicActive()) {
            if (l != -1L) {
                if (!MultimediaManager.getInstance().isPlaying(l)) {
                    l = MultimediaManager.getInstance().loadMusic(resources.getAssetPath("bgmusic"), true);
                    MultimediaManager.getInstance().startPlaying(l);
                }
            } else if (resources.existAsset("bgmusic")) {
                l = MultimediaManager.getInstance().loadMusic(resources.getAssetPath("bgmusic"), true);
                MultimediaManager.getInstance().startPlaying(l);
            }
        }
        this.slides = MultimediaManager.getInstance().loadSlides(resources.getAssetPath("slides"), 0);
        this.slides.start();
    }

    public void mainLoop(long l, int n) {
        this.slides.update(l);
        if (!this.slides.isPlayingForFirstTime()) {
            this.finishedSlides();
        }
        GUI.getInstance().addBackgroundToDraw(this.slides.getImage(), 0);
        GUI.getInstance().endDraw();
        GUI.getInstance().drawScene(GUI.getInstance().getGraphics(), l);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl = this.slides.nextImage();
        if (bl) {
            this.finishedSlides();
        }
    }

    private void finishedSlides() {
        if (!this.yetSkipped && this.slidescene.getNext() == 1) {
            this.yetSkipped = true;
            this.game.goToNextChapter();
        } else if (this.slidescene.getNext() == 2) {
            Exit exit = new Exit(this.slidescene.getTargetId());
            exit.setDestinyX(this.slidescene.getPositionX());
            exit.setDestinyY(this.slidescene.getPositionY());
            exit.setPostEffects(this.slidescene.getEffects());
            exit.setTransitionTime(this.slidescene.getTransitionTime());
            exit.setTransitionType(this.slidescene.getTransitionType());
            this.game.setNextScene(exit);
            this.game.setState(3);
        } else {
            if (this.game.getFunctionalScene() == null) {
                JOptionPane.showMessageDialog(null, TC.get("DesignError.Message"), TC.get("DesignError.Title"), 0);
                this.yetSkipped = true;
                this.game.goToNextChapter();
            }
            FunctionalEffects.storeAllEffects(new Effects());
        }
    }

    private Resources createResourcesBlock() {
        Resources resources = null;
        for (int i = 0; i < this.slidescene.getResources().size() && resources == null; ++i) {
            if (!new FunctionalConditions(this.slidescene.getResources().get(i).getConditions()).allConditionsOk()) continue;
            resources = this.slidescene.getResources().get(i);
        }
        if (resources == null) {
            resources = new Resources();
            resources.addAsset(new Asset("slides", "gui/defaultassets/NRB_slides_01.jpg"));
        }
        return resources;
    }
}

